/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.importer.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.importer.source.AbstractMatrixStreamImportSource;
import org.ujmp.core.intmatrix.impl.ImageMatrix;
import org.ujmp.core.stringmatrix.impl.DenseCSVStringMatrix2D;

public class DefaultMatrixStreamImportSource
extends AbstractMatrixStreamImportSource {
    public DefaultMatrixStreamImportSource(Matrix matrix, InputStream stream) {
        super(matrix, stream);
    }

    public Matrix asDenseCSV() throws IOException {
        return this.asDenseCSV('\u0000');
    }

    public Matrix asDenseCSV(char columnSeparator) throws IOException {
        return this.asDenseCSV(columnSeparator, '\u0000');
    }

    public Matrix asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        byte[] buffer = new byte[65536];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = -1;
        while ((length = this.getStream().read(buffer)) != -1) {
            bos.write(buffer, 0, length);
        }
        DenseCSVStringMatrix2D m = new DenseCSVStringMatrix2D(columnSeparator, enclosingCharacter, bos.toByteArray());
        if (this.getTargetMatrix() != null) {
            this.getTargetMatrix().setContent(Calculation.Ret.ORIG, m, 0L, 0L);
            return this.getTargetMatrix();
        }
        return m;
    }

    public Matrix asPDF() throws IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.pdfbox.ImportMatrixPDF");
            Method m = c.getMethod("fromStream", InputStream.class);
            Matrix matrix = (Matrix)m.invoke(null, this.getStream());
            return matrix;
        }
        catch (Exception e) {
            throw new IOException("could not import PDF", e);
        }
    }

    public Matrix asJPG() throws IOException {
        return new ImageMatrix(this.getStream());
    }

    public Matrix asGIF() throws IOException {
        return new ImageMatrix(this.getStream());
    }

    public Matrix asBMP() throws IOException {
        return new ImageMatrix(this.getStream());
    }

    public Matrix asPNG() throws IOException {
        return new ImageMatrix(this.getStream());
    }

    public Matrix asTIFF() throws IOException {
        return new ImageMatrix(this.getStream());
    }
}

