/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.commonsmath;

import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.ujmp.commonsmath.CommonsMathDenseDoubleMatrix2DFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommonsMathDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<RealMatrix> {
    private static final long serialVersionUID = -1161807620507675926L;
    private final RealMatrix matrix;

    public AbstractCommonsMathDenseDoubleMatrix2D(RealMatrix matrix) {
        super((long)matrix.getRowDimension(), (long)matrix.getColumnDimension());
        this.matrix = matrix;
    }

    @Override
    public RealMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getEntry(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getEntry(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setEntry(MathUtil.longToInt(row), MathUtil.longToInt(column), value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setEntry(row, column, value);
    }

    @Override
    public Matrix transpose() {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.transpose());
    }

    @Override
    public Matrix inv() {
        return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(new LUDecomposition(this.matrix).getSolver().getInverse());
    }

    @Override
    public Matrix invSPD() {
        try {
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(new CholeskyDecomposition(this.matrix).getSolver().getInverse());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Matrix[] lu() {
        LUDecomposition lu = new LUDecomposition(this.matrix);
        Matrix l = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(lu.getL());
        Matrix u = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(lu.getU());
        Matrix p = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(lu.getP());
        return new Matrix[]{l, u, p};
    }

    @Override
    public Matrix[] qr() {
        QRDecomposition qr = new QRDecomposition(this.matrix);
        Matrix q = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(qr.getQ());
        Matrix r = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(qr.getR());
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] svd() {
        SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix);
        Matrix u = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getU());
        Matrix s = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getS());
        Matrix v = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] eig() {
        EigenDecomposition evd = new EigenDecomposition(this.matrix);
        Matrix v = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(evd.getV());
        Matrix d = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(evd.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix chol() {
        try {
            CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
            Matrix l = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(chol.getL());
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.multiply(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
        }
        return super.mtimes(m2);
    }

    @Override
    public Matrix plus(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.add(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m2);
    }

    @Override
    public Matrix minus(Matrix m2) {
        if (m2 instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.subtract(((AbstractCommonsMathDenseDoubleMatrix2D)m2).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m2);
    }

    @Override
    public Matrix times(double value) {
        Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarMultiply(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix divide(double value) {
        Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarMultiply(1.0 / value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix plus(double value) {
        Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarAdd(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix minus(double value) {
        Matrix result = CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(this.matrix.scalarAdd(-value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
            AbstractCommonsMathDenseDoubleMatrix2D b2 = (AbstractCommonsMathDenseDoubleMatrix2D)b;
            if (this.isSquare()) {
                RealMatrix ret = new LUDecomposition(this.matrix).getSolver().solve(b2.matrix);
                return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(ret);
            }
            RealMatrix ret = new QRDecomposition(this.matrix).getSolver().solve(b2.matrix);
            return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(ret);
        }
        return super.solve(b);
    }

    @Override
    public Matrix solveSPD(Matrix b) {
        try {
            if (b instanceof AbstractCommonsMathDenseDoubleMatrix2D) {
                AbstractCommonsMathDenseDoubleMatrix2D b2 = (AbstractCommonsMathDenseDoubleMatrix2D)b;
                RealMatrix ret = new CholeskyDecomposition(this.matrix).getSolver().solve(b2.matrix);
                return CommonsMathDenseDoubleMatrix2DFactory.INSTANCE.dense(ret);
            }
            return super.solve(b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

