/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.alg.gsea.KSTests;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import xtools.api.param.BooleanParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.MetricParam;
import xtools.api.param.OrderParam;
import xtools.api.param.PermuteTypeChooserParam;
import xtools.api.param.SortParam;
import xtools.api.param.TemplateRandomizerTypeParam;
import xtools.api.param.TemplateSingleChooserParam;
import xtools.gsea.AbstractGseaTool;

public abstract class AbstractGsea2Tool
extends AbstractGseaTool {
    protected final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    protected final TemplateSingleChooserParam fTemplateParam = new TemplateSingleChooserParam("cls", "Phenotype labels", TemplateMode.CATEGORICAL_2_CLASS_AND_NUMERIC, true);
    protected final MetricParam fMetricParam = new MetricParam(Metrics.METRICS_FOR_GSEA, false);
    protected final OrderParam fOrderParam = new OrderParam(false);
    protected final SortParam fSortParam = new SortParam(false);
    protected final PermuteTypeChooserParam fPermuteTypeParamType = PermuteTypeChooserParam.createTemplateOrGeneSet(true);
    protected final BooleanParam fMedianParam = new BooleanParam("median", "Median for class  metrics", "Use the median of each class instead of the mean for the class seperation metrics", XPreferencesFactory.kMedian.getBoolean(), false);
    protected final IntegerParam fNumMarkersParam = new IntegerParam("num", "Number of markers", "Number of markers", 100, false);
    protected final BooleanParam fSaveRndRankedListsParam = new BooleanParam("save_rnd_lists", "Save random ranked lists", "Save random ranked lists (might be very large)", false, false);
    protected final TemplateRandomizerTypeParam fRndTypeParam = new TemplateRandomizerTypeParam(TemplateRandomizerType.NO_BALANCE, new TemplateRandomizerType[]{TemplateRandomizerType.NO_BALANCE, TemplateRandomizerType.EQUALIZE_AND_BALANCE}, true);

    protected AbstractGsea2Tool(String defCollapseMode) {
        super(defCollapseMode, "Max_probe");
    }

    @Override
    protected void doAdditionalParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParamPseudoReqd(this.fTemplateParam);
        this.fParamSet.addParamBasic(this.fMetricParam);
        this.fParamSet.addParamBasic(this.fOrderParam);
        this.fParamSet.addParamBasic(this.fSortParam);
        this.fParamSet.addParamPseudoReqd(this.fPermuteTypeParamType);
        this.fParamSet.addParamAdv(this.fMedianParam);
        this.fParamSet.addParamAdv(this.fNumMarkersParam);
        this.fParamSet.addParamAdv(this.fSaveRndRankedListsParam);
        this.fParamSet.addParamAdv(this.fRndTypeParam);
    }

    private EnrichmentDb execute_one(CollapsedDetails.Data fullCd, Template template, GeneSet[] origGeneSets, List<RankedList> store_rnd_ranked_lists_here_opt) throws Exception {
        RandomSeedGenerator rst = this.fRndSeedTypeParam.createSeed();
        DatasetTemplate dt = new DatasetGenerators().extract(fullCd.getDataset(), template);
        if (this.log.isDebugEnabled()) {
            this.log.debug(">>>>> Using samples: {}", dt.getDataset().getColumnNames());
        }
        KSTests tests = new KSTests(this.getOutputStream());
        if (rst instanceof RandomSeedGenerators.Timestamp) {
            this.fReport.addComment("Timestamp used as random seed: " + ((RandomSeedGenerators.Timestamp)rst).getTimestamp());
        }
        return tests.executeGsea(dt, origGeneSets, this.fNumPermParam.getIValue(), this.fMetricParam.getMetric(), this.fSortParam.getMode(), this.fOrderParam.getOrder(), rst, this.fRndTypeParam.getRandomizerType(), this.getMetricParams(this.fMedianParam), this.fGcohGenReqdParam.createGeneSetCohortGenerator(this.fGeneSetMinSizeParam.getIValue(), this.fGeneSetMaxSizeParam.getIValue()), this.fPermuteTypeParamType.permuteTemplate(), this.fNumMarkersParam.getIValue(), store_rnd_ranked_lists_here_opt);
    }

    protected void execute_one_with_reporting(CollapsedDetails.Data fullCd, Template template, GeneSet[] origGeneSets, int showDetailsForTopXSets, boolean makeZippedReport, boolean makeGeneSetReports, boolean createSvgs, boolean createGcts) throws Exception {
        ArrayList<RankedList> store_rnd_ranked_lists_here_opt = this.fSaveRndRankedListsParam.isTrue() ? new ArrayList<RankedList>() : null;
        EnrichmentDb edb = this.execute_one(fullCd, template, origGeneSets, store_rnd_ranked_lists_here_opt);
        Metric metric = this.fMetricParam.getMetric();
        int minSize = this.fGeneSetMinSizeParam.getIValue();
        int maxSize = this.fGeneSetMaxSizeParam.getIValue();
        DatasetTemplate dt = new DatasetGenerators().extract(fullCd.getDataset(), template);
        HtmlReportIndexPage reportIndexPage = this.fReport.getIndexPage();
        EnrichmentReports.Ret ret = EnrichmentReports.createGseaLikeReport(edb, this.getOutputStream(), (CollapsedDetails)fullCd, (HtmlPage)reportIndexPage, this.fReport, showDetailsForTopXSets, minSize, maxSize, makeGeneSetReports, makeZippedReport, createSvgs, createGcts, origGeneSets, metric.getName(), this.fNormModeParam.getNormModeName());
        if (store_rnd_ranked_lists_here_opt != null && !store_rnd_ranked_lists_here_opt.isEmpty()) {
            File dir = this.fReport.createSubDir("random_ranked_lists");
            for (int r = 0; r < store_rnd_ranked_lists_here_opt.size(); ++r) {
                RankedList rl = (RankedList)store_rnd_ranked_lists_here_opt.get(r);
                String name = r + "_" + rl.getName();
                if (!StringUtils.endsWith((CharSequence)name, (CharSequence)".rnk")) {
                    name = name + ".rnk";
                }
                File file = new File(dir, name);
                ParserFactory.save(rl, file);
            }
        }
        if (this.fPermuteTypeParamType.permuteTemplate()) {
            if (dt.getTemplate().isCategorical()) {
                if (dt.getTemplate().getClass(0).getSize() < 7) {
                    this.fReport.addWarning("Phenotype permutation was performed but the number of samples in class A is < 7, phenotype: " + dt.getTemplateName());
                }
                if (dt.getTemplate().getClass(1).getSize() < 7) {
                    this.fReport.addWarning("Phenotype permutation was performed but the number of samples in class B is < 7, phenotype: " + dt.getTemplateName());
                }
                if (dt.getTemplate().getNumItems() < 14) {
                    this.fReport.addWarning("With small datasets, there might not be enough random permutations of sample labels to generate a sufficient null distribution. In such cases, gene_set randomization might be a better choice.");
                }
            } else if (dt.getTemplate().isContinuous() && dt.getDataset().getNumCol() < 7) {
                this.fReport.addWarning("Phenotype permutation was performed but the number of samples in dataset is < 7");
                this.fReport.addWarning("With small datasets, there might not be enough random permutations of sample labels to generate a sufficient null distribution. In such cases, gene_set randomization might be a better choice.");
            }
        }
        new EdbFolderParser().export((PersistentObject)ret.edb, ret.savedInDir);
    }

    public Map<String, Boolean> getMetricParams(BooleanParam medianParam) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("USE_MEDIAN", XPreferencesFactory.kMedian.getBooleanO());
        params.put("FIX_LOW", XPreferencesFactory.kFixLowVar.getBooleanO());
        params.put("USE_BIASED", XPreferencesFactory.kBiasedVar.getBooleanO());
        params.put("USE_MEDIAN", (Boolean)medianParam.getValue());
        return Collections.unmodifiableMap(params);
    }
}

