/*
 * Decompiled with CFR 0.152.
 */
package xapps.api.frameworks.fiji;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.status.TimeStatusBarItem;
import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.viewers.SystemConsoleViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class StatusBarAppender {
    private StatusBar fJideStatusBar = new StatusBar();
    private LabelStatusBarItem fStatusBarLabelItem;
    private SystemConsoleViewer fSystemConsoleComp = new SystemConsoleViewer();

    public StatusBarAppender(String name) {
        this.fSystemConsoleComp.setBorder(BorderFactory.createTitledBorder("Application messages"));
        this.fJideStatusBar.add((Component)new TimeStatusBarItem(), (Object)"fix");
        this.fStatusBarLabelItem = new LabelStatusBarItem();
        this.fStatusBarLabelItem.setIcon(JarResources.getIcon("expandall.png"));
        this.fStatusBarLabelItem.setToolTipText("Click for application messages (such as # of permutations complete)");
        LabelStatusBarLoggingHandler handler = new LabelStatusBarLoggingHandler(this.fStatusBarLabelItem);
        LogManager.getLogManager().getLogger("").addHandler(handler);
        this.fJideStatusBar.add((Component)this.fStatusBarLabelItem, (Object)"flexible");
        MemoryStatusBarItem gc = new MemoryStatusBarItem();
        gc.setPreferredWidth(75);
        this.fJideStatusBar.add((Component)gc, (Object)"fix");
        ResizeStatusBarItem resize = new ResizeStatusBarItem();
        resize.setPreferredWidth(20);
        resize.setBorder(BorderFactory.createEmptyBorder());
        this.fJideStatusBar.add((Component)resize, (Object)"fix");
        this.fStatusBarLabelItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatusBarAppender.this.showPopup((JComponent)StatusBarAppender.this.fStatusBarLabelItem);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabelItem.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabelItem.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public JComponent getAsComponent() {
        return this.fJideStatusBar;
    }

    private void showPopup(JComponent owner) {
        JidePopup popup = new JidePopup();
        popup.setMovable(true);
        popup.getContentPane().setLayout(new BorderLayout());
        this.fSystemConsoleComp.setPreferredSize(new Dimension(700, 350));
        popup.getContentPane().add(this.fSystemConsoleComp);
        popup.setDefaultFocusComponent((Component)this.fSystemConsoleComp);
        popup.setOwner((Component)owner);
        popup.setResizable(true);
        popup.setMovable(true);
        if (popup.isPopupVisible()) {
            popup.hidePopup();
        } else {
            popup.showPopup();
        }
    }

    private class LabelStatusBarLoggingHandler
    extends Handler {
        final LabelStatusBarItem labelStatusBarItem;

        public LabelStatusBarLoggingHandler(LabelStatusBarItem labelStatusBarItem) {
            this.labelStatusBarItem = labelStatusBarItem;
            this.setLevel(Conf.isDebugMode() ? Level.FINE : Level.INFO);
            this.setFormatter(new SimpleFormatter());
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                String message = this.getFormatter().format(record);
                Level level = record.getLevel();
                StatusBarAppender.this.fStatusBarLabelItem.setForeground(Color.BLACK);
                if (level == Level.WARNING) {
                    StatusBarAppender.this.fStatusBarLabelItem.setForeground(Color.MAGENTA);
                }
                this.labelStatusBarItem.setText(message);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
            }
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return this.labelStatusBarItem != null && super.isLoggable(record);
        }
    }
}

