/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.charts.XChartUtils;
import edu.mit.broad.genome.charts.XComboChart;
import edu.mit.broad.genome.reports.EnrichmentReports;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleInsets;

public class XComboRangeChart
implements XComboChart {
    private CombinedRangeXYPlot fCombinedXYPlot;
    private XChart fCombinedChart;
    private JFreeChart fCombinedFreeChart;
    private String fComboCaption;
    private List fSubCharts;

    public XComboRangeChart(String name, String comboTitle, String comboCaption, String domainAxisLabel, XChart[] charts, int[] weights) {
        int i;
        XYPlot[] xyplots = new XYPlot[charts.length];
        String[] subplotTitles = new String[charts.length];
        for (i = 0; i < charts.length; ++i) {
            Plot plot = charts[i].getFreeChart().getPlot();
            if (!(plot instanceof XYPlot)) {
                throw new IllegalArgumentException("Only XYPlots allowed. Found: " + plot.getClass() + " at: " + i);
            }
            xyplots[i] = (XYPlot)plot;
            subplotTitles[i] = charts[i].getName();
        }
        this.init(name, comboTitle, comboCaption, domainAxisLabel, xyplots, weights);
        for (i = 0; i < this.getNumSubPlots(); ++i) {
            this.fSubCharts.add(charts[i]);
        }
    }

    private void init(String name, String comboTitle, String comboCaption, String rangeAxisLabel, XYPlot[] xyplots, int[] weights) {
        if (xyplots == null) {
            throw new IllegalArgumentException("Param xyplots cannot be null");
        }
        this.fCombinedXYPlot = new CombinedRangeXYPlot((ValueAxis)new NumberAxis(rangeAxisLabel));
        this.fCombinedXYPlot.setOrientation(PlotOrientation.VERTICAL);
        this.fCombinedXYPlot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        for (int i = 0; i < xyplots.length; ++i) {
            this.fCombinedXYPlot.add(xyplots[i], weights[i]);
            xyplots[i].setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        }
        this.fComboCaption = comboCaption;
        this.fCombinedFreeChart = new JFreeChart(comboTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.fCombinedXYPlot, false);
        this.fCombinedFreeChart.setBackgroundPaint((Paint)EnrichmentReports.CHART_FRAME_COLOR);
        this.fCombinedFreeChart.getLegend().setBorder(1.0, 1.0, 1.0, 1.0);
        this.fCombinedChart = new XChartImpl(name, this.fComboCaption, this.fCombinedFreeChart);
        this.fSubCharts = new ArrayList();
    }

    public CombinedRangeXYPlot getCombinedXYPlot() {
        return this.fCombinedXYPlot;
    }

    @Override
    public XChart getCombinedChart() {
        return this.fCombinedChart;
    }

    public int getNumSubPlots() {
        return this.fCombinedXYPlot.getSubplots().size();
    }

    @Override
    public void saveAsSVG(File toFile, int width, int height) throws IOException {
        XChartUtils.saveAsSVG(this.getCombinedChart(), toFile, width, height, true);
    }
}

