/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class KMC
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private boolean calculateMeans;
    private int iterations;
    private boolean converged;
    private boolean kmcGenes;
    private int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        KMCluster[] kMClusterArray;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.calculateMeans = algorithmParameters.getBoolean("calculate-means", true);
        this.kmcGenes = algorithmParameters.getBoolean("kmc-cluster-genes", true);
        int n = algorithmParameters.getInt("number-of-iterations", 0);
        int n2 = algorithmParameters.getInt("number-of-clusters", 0);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n3 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        FloatMatrix floatMatrix = null;
        FloatMatrix floatMatrix2 = null;
        FloatMatrix floatMatrix3 = null;
        if (this.calculateMeans) {
            kMClusterArray = this.calculate(this.number_of_genes, n2, n);
            floatMatrix = this.getMeans(kMClusterArray);
            floatMatrix3 = this.getVariances(kMClusterArray, floatMatrix);
        } else {
            kMClusterArray = this.calculateMedians(this.number_of_genes, n2, n);
            floatMatrix2 = this.getMedians(kMClusterArray);
            floatMatrix3 = this.getVariances(kMClusterArray, floatMatrix2);
        }
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, kMClusterArray.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < kMClusterArray.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(kMClusterArray[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n3, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        if (this.calculateMeans) {
            algorithmData2.addMatrix("clusters_means", floatMatrix);
        } else {
            algorithmData2.addMatrix("clusters_means", floatMatrix2);
        }
        algorithmData2.addMatrix("clusters_variances", floatMatrix3);
        algorithmData2.addParam("iterations", String.valueOf(this.getIterations()));
        algorithmData2.addParam("converged", String.valueOf(this.getConverged()));
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.kmcGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((Float)arrayList.get(i)).floatValue();
        }
        return nArray;
    }

    private KMCluster[] calculate(int n, int n2, int n3) throws AlgorithmException {
        int n4;
        int n5 = 0;
        int n6 = 0;
        float[] fArray = new float[n2];
        int[] nArray = new int[n];
        Float[] floatArray = new Float[n];
        KMCluster[] kMClusterArray = new KMCluster[n2];
        for (n4 = 0; n4 < kMClusterArray.length; ++n4) {
            kMClusterArray[n4] = new KMCluster();
        }
        int n7 = 0;
        Random random = new Random();
        for (n4 = 0; n4 < n; ++n4) {
            n7 = (int)Math.floor(random.nextFloat() * (float)n2);
            n7 = Math.min(n7, n2 - 1);
            floatArray[n4] = new Float(n4);
            nArray[n4] = n7;
            kMClusterArray[n7].add(floatArray[n4]);
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, 200);
        this.fireValueChanged(algorithmEvent);
        int n8 = 0;
        int n9 = 0;
        double d = 200.0 / (double)(n * n3);
        for (n4 = 0; n4 < n2; ++n4) {
            kMClusterArray[n4].calculateMean();
        }
        int n10 = 0;
        int n11 = 0;
        boolean bl = false;
        int n12 = 0;
        while (n6 != n * n3) {
            if (this.stop) {
                throw new AbortException();
            }
            n8 = (int)((double)n6 * d);
            if (n8 > n9) {
                algorithmEvent.setId(2);
                algorithmEvent.setIntValue(n8);
                this.fireValueChanged(algorithmEvent);
                n9 = n8;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                fArray[n4] = ExperimentUtil.geneDistance(this.expMatrix, kMClusterArray[n4].getMean(), n10, 0, this.function, this.factor, this.absolute);
            }
            n5 = this.findNearest(fArray);
            if (n5 != nArray[n10]) {
                ++n12;
                kMClusterArray[nArray[n10]].remove(floatArray[n10]);
                kMClusterArray[n5].add(floatArray[n10]);
                kMClusterArray[nArray[n10]].calculateMean();
                kMClusterArray[n5].calculateMean();
                nArray[n10] = n5;
            }
            if (++n10 == n) {
                n10 = 0;
            }
            if (++n6 % n != 0) continue;
            ++n11;
            if (n12 == 0) {
                bl = true;
                break;
            }
            algorithmEvent.setId(3);
            algorithmEvent.setIntValue(n12);
            this.fireValueChanged(algorithmEvent);
            n12 = 0;
        }
        algorithmEvent.setId(3);
        algorithmEvent.setIntValue(-1);
        this.fireValueChanged(algorithmEvent);
        this.setIterations(n11);
        this.setConverged(bl);
        return kMClusterArray;
    }

    private KMCluster[] calculateMedians(int n, int n2, int n3) throws AlgorithmException {
        int n4;
        int n5 = 0;
        int n6 = 0;
        float[] fArray = new float[n2];
        int[] nArray = new int[n];
        Float[] floatArray = new Float[n];
        KMCluster[] kMClusterArray = new KMCluster[n2];
        for (n4 = 0; n4 < kMClusterArray.length; ++n4) {
            kMClusterArray[n4] = new KMCluster();
        }
        int n7 = 0;
        Random random = new Random();
        for (n4 = 0; n4 < n; ++n4) {
            n7 = (int)Math.floor(random.nextFloat() * (float)n2);
            n7 = Math.min(n7, n2 - 1);
            floatArray[n4] = new Float(n4);
            nArray[n4] = n7;
            kMClusterArray[n7].add(floatArray[n4]);
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, 200);
        this.fireValueChanged(algorithmEvent);
        int n8 = 0;
        int n9 = 0;
        double d = 200.0 / (double)(n * n3);
        for (n4 = 0; n4 < n2; ++n4) {
            kMClusterArray[n4].calculateMedian();
        }
        int n10 = 0;
        int n11 = 0;
        boolean bl = false;
        int n12 = 0;
        while (n6 != n * n3) {
            if (this.stop) {
                throw new AbortException();
            }
            n8 = (int)((double)n6 * d);
            if (n8 > n9) {
                algorithmEvent.setId(2);
                algorithmEvent.setIntValue(n8);
                this.fireValueChanged(algorithmEvent);
                n9 = n8;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                fArray[n4] = ExperimentUtil.geneDistance(this.expMatrix, kMClusterArray[n4].getMedian(), n10, 0, this.function, this.factor, this.absolute);
            }
            n5 = this.findNearest(fArray);
            if (n5 != nArray[n10]) {
                ++n12;
                kMClusterArray[nArray[n10]].remove(floatArray[n10]);
                kMClusterArray[n5].add(floatArray[n10]);
                kMClusterArray[nArray[n10]].calculateMedian();
                kMClusterArray[n5].calculateMedian();
                nArray[n10] = n5;
            }
            if (++n10 == n) {
                n10 = 0;
            }
            if (++n6 % n != 0) continue;
            ++n11;
            if (n12 == 0) {
                bl = true;
                break;
            }
            algorithmEvent.setId(3);
            algorithmEvent.setIntValue(n12);
            this.fireValueChanged(algorithmEvent);
            n12 = 0;
        }
        algorithmEvent.setId(3);
        algorithmEvent.setIntValue(-1);
        this.fireValueChanged(algorithmEvent);
        this.setIterations(n11);
        this.setConverged(bl);
        return kMClusterArray;
    }

    private void setIterations(int n) {
        this.iterations = n;
    }

    private int getIterations() {
        return this.iterations;
    }

    private void setConverged(boolean bl) {
        this.converged = bl;
    }

    private boolean getConverged() {
        return this.converged;
    }

    private int findNearest(float[] fArray) {
        int n = 0;
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
            n = i;
        }
        return n;
    }

    public void abort() {
        this.stop = true;
    }

    private FloatMatrix getMeans(KMCluster[] kMClusterArray) {
        FloatMatrix floatMatrix = new FloatMatrix(kMClusterArray.length, this.number_of_samples);
        for (int i = 0; i < kMClusterArray.length; ++i) {
            FloatMatrix floatMatrix2 = kMClusterArray[i].getMean();
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMedians(KMCluster[] kMClusterArray) {
        FloatMatrix floatMatrix = new FloatMatrix(kMClusterArray.length, this.number_of_samples);
        for (int i = 0; i < kMClusterArray.length; ++i) {
            FloatMatrix floatMatrix2 = kMClusterArray[i].getMedian();
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(KMCluster[] kMClusterArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(kMClusterArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(KMCluster kMCluster, int n, float f) {
        int n2 = kMCluster.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Float)kMCluster.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(KMCluster kMCluster, int n, float f) {
        if (this.validN > 1) {
            return (float)Math.sqrt(this.getSampleNormalizedSum(kMCluster, n, f) / (float)(this.validN - 1));
        }
        return 0.0f;
    }

    private class KMCluster
    extends ArrayList {
        private FloatMatrix mean;
        private FloatMatrix median;

        public KMCluster() {
            this.mean = new FloatMatrix(1, KMC.this.number_of_samples);
            this.median = new FloatMatrix(1, KMC.this.number_of_samples);
        }

        public void calculateMean() {
            int n = this.size();
            for (int i = 0; i < KMC.this.number_of_samples; ++i) {
                float f = 0.0f;
                KMC.this.validN = 0;
                for (int j = 0; j < n; ++j) {
                    float f2 = KMC.this.expMatrix.get(((Float)this.get(j)).intValue(), i);
                    if (Float.isNaN(f2)) continue;
                    f += f2;
                    KMC.this.validN++;
                }
                this.mean.set(0, i, f / (float)KMC.this.validN);
            }
        }

        public FloatMatrix getMean() {
            return this.mean;
        }

        private void calculateMedian() {
            float[] fArray;
            int n;
            for (int i = 0; i < KMC.this.number_of_samples && (n = this.getValues(fArray = new float[this.size()], i)) != 0; ++i) {
                this.median.set(0, i, this.computeMedian(fArray));
            }
        }

        private float computeMedian(float[] fArray) {
            float f;
            Arrays.sort(fArray);
            int n = fArray.length;
            if (n % 2 == 1) {
                f = fArray[n / 2];
            } else {
                f = fArray[n / 2 - 1];
                f += fArray[n / 2];
                f = (float)((double)f / 2.0);
            }
            return f;
        }

        private int getValues(float[] fArray, int n) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < fArray.length; ++i) {
                float f = KMC.this.expMatrix.get(((Float)this.get(i)).intValue(), n);
                if (Float.isNaN(f)) continue;
                fArray[n2] = f;
                ++n3;
                ++n2;
            }
            return n3;
        }

        public float getElementMedian(float[] fArray, int n, int n2, int n3) {
            if (n == n2) {
                return fArray[n];
            }
            int n4 = this.randomPartition(fArray, n, n2);
            int n5 = n4 - n + 1;
            if (n3 <= n5) {
                return this.getElementMedian(fArray, n, n4, n3);
            }
            return this.getElementMedian(fArray, n4 + 1, n2, n3 - n5);
        }

        private int randomPartition(float[] fArray, int n, int n2) {
            int n3 = (int)((double)(n2 - n + 1) * Math.random()) + n;
            this.swap(fArray, n3, n);
            return this.partition(fArray, n, n2);
        }

        private void swap(float[] fArray, int n, int n2) {
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
        }

        public int partition(float[] fArray, int n, int n2) {
            float f = fArray[n];
            int n3 = n - 1;
            int n4 = n2 + 1;
            boolean bl = false;
            while (true) {
                if (fArray[--n4] > f) {
                    continue;
                }
                while (fArray[++n3] < f) {
                }
                if (n3 >= n4) break;
                this.swap(fArray, n3, n4);
            }
            return n4;
        }

        public FloatMatrix getMedian() {
            return this.median;
        }
    }
}

