/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mtj;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import no.uib.cipr.matrix.DenseCholesky;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.QR;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.mtj.MTJDenseDoubleMatrix2DFactory;
import org.ujmp.mtj.calculation.Inv;
import org.ujmp.mtj.calculation.SVD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseMatrix> {
    private static final long serialVersionUID = -2386081646062313108L;
    public static final MTJDenseDoubleMatrix2DFactory Factory = new MTJDenseDoubleMatrix2DFactory();
    private transient DenseMatrix matrix;

    public MTJDenseDoubleMatrix2D(DenseMatrix m) {
        super((long)m.numRows(), (long)m.numColumns());
        this.matrix = m;
    }

    public MTJDenseDoubleMatrix2D(no.uib.cipr.matrix.Matrix m) {
        super((long)m.numRows(), (long)m.numColumns());
        this.matrix = new DenseMatrix(m);
    }

    public MTJDenseDoubleMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.matrix = m instanceof MTJDenseDoubleMatrix2D ? ((MTJDenseDoubleMatrix2D)m).matrix.copy() : new DenseMatrix(m.toDoubleArray());
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    public MTJDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new DenseMatrix(rows, columns);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] qr() {
        if (this.getRowCount() >= this.getColumnCount()) {
            try {
                QR qr = QR.factorize((no.uib.cipr.matrix.Matrix)this.getWrappedObject());
                MTJDenseDoubleMatrix2D q = new MTJDenseDoubleMatrix2D(qr.getQ());
                MTJDenseDoubleMatrix2D r = new MTJDenseDoubleMatrix2D((no.uib.cipr.matrix.Matrix)qr.getR());
                return new Matrix[]{q, r};
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("only allowed for matrices m>=n");
    }

    @Override
    public Matrix[] lu() {
        try {
            DenseLU lu = DenseLU.factorize((no.uib.cipr.matrix.Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D l = new MTJDenseDoubleMatrix2D((no.uib.cipr.matrix.Matrix)lu.getL());
            MTJDenseDoubleMatrix2D u = new MTJDenseDoubleMatrix2D((no.uib.cipr.matrix.Matrix)lu.getU());
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivots();
            MTJDenseDoubleMatrix2D p = new MTJDenseDoubleMatrix2D(m, m);
            for (int i = 0; i < m; ++i) {
                p.setAsDouble(1.0, new long[]{i, piv[i]});
            }
            p.eye(Calculation.Ret.ORIG);
            return new Matrix[]{l, u, p};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Matrix chol() {
        try {
            DenseCholesky chol = DenseCholesky.factorize((no.uib.cipr.matrix.Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D l = new MTJDenseDoubleMatrix2D((no.uib.cipr.matrix.Matrix)chol.getL());
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Matrix[] eig() {
        try {
            EVD evd = EVD.factorize((no.uib.cipr.matrix.Matrix)this.getWrappedObject());
            MTJDenseDoubleMatrix2D v = new MTJDenseDoubleMatrix2D(evd.getRightEigenvectors());
            int m = (int)this.getRowCount();
            double[] evds = evd.getRealEigenvalues();
            MTJDenseDoubleMatrix2D d = new MTJDenseDoubleMatrix2D(m, m);
            for (int i = 0; i < m; ++i) {
                d.setAsDouble(evds[i], new long[]{i, i});
            }
            return new Matrix[]{v, d};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getData()[(int)(row + column * (long)this.matrix.numRows())];
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getData()[row + column * this.matrix.numRows()];
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.getData()[(int)(row + column * (long)this.matrix.numRows())] = value;
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.getData()[row + column * this.matrix.numRows()] = value;
    }

    @Override
    public Matrix transpose() {
        DenseMatrix ret = new DenseMatrix((int)this.getColumnCount(), (int)this.getRowCount());
        return new MTJDenseDoubleMatrix2D((DenseMatrix)this.matrix.transpose((no.uib.cipr.matrix.Matrix)ret));
    }

    @Override
    public Matrix inv() {
        return new Inv((Matrix)this).calcNew();
    }

    @Override
    public DenseMatrix getWrappedObject() {
        return this.matrix;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = new DenseMatrix(values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof MTJDenseDoubleMatrix2D) {
            DenseMatrix a = this.matrix;
            DenseMatrix b = ((MTJDenseDoubleMatrix2D)m2).getWrappedObject();
            DenseMatrix c = new DenseMatrix(a.numRows(), b.numColumns());
            a.mult((no.uib.cipr.matrix.Matrix)b, (no.uib.cipr.matrix.Matrix)c);
            return new MTJDenseDoubleMatrix2D(c);
        }
        return super.mtimes(m2);
    }

    @Override
    public Matrix plus(Matrix m2) {
        if (m2 instanceof MTJDenseDoubleMatrix2D) {
            DenseMatrix ret = this.matrix.copy();
            ret.add((no.uib.cipr.matrix.Matrix)((MTJDenseDoubleMatrix2D)m2).getWrappedObject());
            MTJDenseDoubleMatrix2D result = new MTJDenseDoubleMatrix2D(ret);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m2);
    }

    @Override
    public Matrix times(double f) {
        DenseMatrix ret = this.matrix.copy();
        ret.scale(f);
        MTJDenseDoubleMatrix2D result = new MTJDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix divide(double f) {
        DenseMatrix ret = this.matrix.copy();
        ret.scale(1.0 / f);
        MTJDenseDoubleMatrix2D result = new MTJDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public Matrix copy() {
        MTJDenseDoubleMatrix2D m = new MTJDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof MTJDenseDoubleMatrix2D) {
            MTJDenseDoubleMatrix2D b2 = (MTJDenseDoubleMatrix2D)b;
            DenseMatrix x = new DenseMatrix((int)this.getColumnCount(), (int)b2.getColumnCount());
            this.matrix.solve((no.uib.cipr.matrix.Matrix)b2.matrix, (no.uib.cipr.matrix.Matrix)x);
            return new MTJDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }

    @Override
    public Matrix invSPD() {
        DenseCholesky chol = DenseCholesky.factorize((no.uib.cipr.matrix.Matrix)this.getWrappedObject());
        return new MTJDenseDoubleMatrix2D(chol.solve(Matrices.identity((int)this.matrix.numRows())));
    }

    public MTJDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

