/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import java.util.Collection;
import java.util.Iterator;
import org.ujmp.core.collections.AbstractCollection;
import org.ujmp.core.graphmatrix.GraphMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.jung.EdgeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeWrapperCollection<E>
extends AbstractCollection<EdgeWrapper<E>> {
    private static final long serialVersionUID = 5767878887189116726L;
    private final GraphMatrix<?, E> graphMatrix;

    public EdgeWrapperCollection(GraphMatrix<?, E> graphMatrix) {
        this.graphMatrix = graphMatrix;
    }

    @Override
    public boolean add(EdgeWrapper<E> e) {
        throw new UnsupportedOperationException("not allowed");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("not allowed");
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof EdgeWrapper) {
            return this.graphMatrix.containsCoordinates(((EdgeWrapper)o).getCoordinates().getLongCoordinates());
        }
        return false;
    }

    @Override
    public Iterator<EdgeWrapper<E>> iterator() {
        Iterator iterator = new Iterator<EdgeWrapper<E>>(){
            Iterator<long[]> coordinates;
            {
                this.coordinates = EdgeWrapperCollection.this.graphMatrix.availableCoordinates().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.coordinates.hasNext();
            }

            @Override
            public EdgeWrapper<E> next() {
                long[] c = this.coordinates.next();
                Object edge = EdgeWrapperCollection.this.graphMatrix.getEdge(c[0], c[1]);
                return new EdgeWrapper(c[0], c[1], edge);
            }

            @Override
            public void remove() {
                this.coordinates.remove();
            }
        };
        return iterator;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("not allowed");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("not allowed");
    }

    @Override
    public int size() {
        return MathUtil.longToInt(this.graphMatrix.getValueCount());
    }
}

