/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.util.Octave;
import org.ujmp.gui.MatrixGUIObject;

public class OctavePanel
extends JPanel {
    private static final long serialVersionUID = -894693635404746973L;
    private MatrixGUIObject matrix = null;

    public OctavePanel(MatrixGUIObject m) {
        this.matrix = m;
        this.setLayout(new FlowLayout());
        this.add(new JButton(new MatrixPlotAction()));
        this.add(new JButton(new XYPlotAction()));
        this.add(new JButton(new ScatterPlotAction()));
        this.add(new JButton(new HistogramPlotAction()));
    }

    class HistogramPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = -1396238157254507002L;

        public HistogramPlotAction() {
            super("Histogram");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Octave.getInstance().hist(OctavePanel.this.matrix.getMatrix(), new String[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class ScatterPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = 4837137928213709856L;

        public ScatterPlotAction() {
            super("Scatter Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Octave.getInstance().plot(OctavePanel.this.matrix.getMatrix().selectColumns(Calculation.Ret.NEW, 0L), OctavePanel.this.matrix.getMatrix().selectColumns(Calculation.Ret.NEW, 1L), "x");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class XYPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = 4954900597400686518L;

        public XYPlotAction() {
            super("XY Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Octave.getInstance().plot(OctavePanel.this.matrix.getMatrix().selectColumns(Calculation.Ret.NEW, 0L), OctavePanel.this.matrix.getMatrix().selectColumns(Calculation.Ret.NEW, 1L), new String[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class MatrixPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = -4928348084073744818L;

        public MatrixPlotAction() {
            super("Matrix Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Octave.getInstance().plot(OctavePanel.this.matrix.getMatrix(), new String[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

