/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class BackgroundTask {
    private final Object[] objects;
    private final Future<?> future;
    private final ExecutorService es = Executors.newSingleThreadExecutor();

    public BackgroundTask(Object ... objects) {
        this.objects = objects;
        this.future = this.es.submit(new BackgroundTaskCallable());
    }

    public abstract Object run();

    public Object getResult() throws InterruptedException, ExecutionException {
        Object result = this.future.get();
        this.es.shutdown();
        return result;
    }

    public final Object getObject(int i) {
        return this.objects[i];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BackgroundTaskCallable
    implements Callable<Object> {
        @Override
        public final Void call() throws Exception {
            try {
                BackgroundTask.this.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

