/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.util.CompressionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZIPCompressionMap
extends AbstractMap<String, byte[]> {
    private static final long serialVersionUID = 6030730020161656575L;
    private final int compressionLevel;
    private final Map<String, byte[]> map;

    public ZIPCompressionMap(Map<String, byte[]> map) {
        this.map = map;
        this.compressionLevel = -1;
    }

    public ZIPCompressionMap(Map<String, byte[]> map, int compressionLevel) {
        this.map = map;
        this.compressionLevel = compressionLevel;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public byte[] get(Object key) {
        try {
            byte[] data = this.map.get(key);
            return data == null ? null : CompressionUtil.zipDecompress(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public byte[] put(String key, byte[] value) {
        byte[] oldValue = this.get(key);
        this.map.put(key, CompressionUtil.zipCompress(value, this.compressionLevel));
        return oldValue;
    }

    @Override
    public byte[] remove(Object key) {
        byte[] oldValue = this.get(key);
        this.map.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

