/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.apache.commons.collections15.Transformer;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.gui.util.UIDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexIconTransformer<N>
implements Transformer<N, Icon> {
    private final PickedState<N> pickedVertexState;

    public VertexIconTransformer(PickedState<N> pickedVertexState) {
        this.pickedVertexState = pickedVertexState;
    }

    public Icon transform(final N v) {
        return new Icon(){

            public int getIconHeight() {
                return 10;
            }

            public int getIconWidth() {
                return 10;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                if (VertexIconTransformer.this.pickedVertexState.isPicked(v)) {
                    g2d.setColor(UIDefaults.SELECTEDCOLOR);
                } else {
                    g2d.setColor(ColorUtil.fromObject(v));
                }
                g2d.fillOval(x, y, 10, 10);
                g2d.setColor(new Color(150, 150, 150, 150));
                g2d.drawOval(x, y, 10, 10);
            }
        };
    }
}

