/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.UJMPContentHandler;
import org.ujmp.core.util.VerifyUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLUtil {
    private static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public static Matrix parse(File file) throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        Matrix m = XMLUtil.parse(bis);
        ((InputStream)bis).close();
        ((InputStream)fis).close();
        return m;
    }

    public static Matrix parse(InputStream is) throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        UJMPContentHandler contentHandler = new UJMPContentHandler();
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse(new InputSource(is));
        return contentHandler.getResult();
    }

    public static void write(File file, Matrix matrix) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        XMLUtil.write(bos, matrix);
        ((OutputStream)bos).close();
        ((OutputStream)fos).close();
    }

    public static void write(OutputStream out, Matrix matrix) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        XMLUtil.write(pw, matrix);
        pw.close();
    }

    public static void write(Writer pw, Matrix matrix) throws IOException {
        VerifyUtil.verifyNotNull(matrix, "matrix is null");
        String EOL = System.getProperty("line.separator");
        pw.write(XMLHEADER);
        pw.write(EOL);
        if (matrix == null) {
            pw.write("<emptyMatrix>");
            pw.write(EOL);
            pw.write("</emptyMatrix>");
            pw.write(EOL);
        } else if (matrix instanceof Map) {
            pw.write("<map>");
            pw.write(EOL);
            Map map = (Map)((Object)matrix);
            for (Map.Entry e : map.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                pw.write("<" + key + ">");
                pw.write(String.valueOf(value));
                pw.write("</" + key + ">");
                pw.write(EOL);
            }
            pw.write("</map>");
            pw.write(EOL);
        }
    }
}

