/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.impl.EmptyObject;
import org.ujmp.core.objectmatrix.impl.VolatileSparseObjectMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedObjectMatrix
extends AbstractSparseObjectMatrix
implements Flushable {
    private static final long serialVersionUID = 7750549087897737457L;
    private boolean lazy = true;
    private Matrix inputBuffer = null;
    private SortedSet<Coordinates> outputToDoBuffer = Collections.synchronizedSortedSet(new TreeSet());
    private SortedSet<Coordinates> inputToDoBuffer = Collections.synchronizedSortedSet(new TreeSet());
    private int outputBufferSize = Integer.MAX_VALUE;
    private Matrix original = null;
    private Thread writeThread = null;
    private Thread readThread = null;
    private static final EmptyObject EMPTYOBJECT = new EmptyObject();

    public BufferedObjectMatrix(Matrix original) {
        super(original.getSize());
        this.original = original;
        this.inputBuffer = new DefaultSparseObjectMatrix(original.getSize());
        this.setInputBufferSize(0);
        this.setOutputBufferSize(Integer.MAX_VALUE);
        this.writeThread = new WriteThread();
        this.writeThread.start();
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    public BufferedObjectMatrix(Matrix original, int outputBufferSize) {
        super(original.getSize());
        this.original = original;
        this.setInputBufferSize(0);
        this.setOutputBufferSize(outputBufferSize);
    }

    public BufferedObjectMatrix(Matrix original, int outputBufferSize, int inputBufferSize) {
        super(original.getSize());
        this.original = original;
        this.setInputBufferSize(inputBufferSize);
        this.setOutputBufferSize(outputBufferSize);
    }

    @Override
    public final void clear() {
        this.original.clear();
        this.inputBuffer.clear();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public synchronized long[] getSize() {
        this.size = this.inputBuffer.getSize();
        return this.size;
    }

    @Override
    public synchronized Object getObject(long ... coordinates) {
        Object o = null;
        o = this.inputBuffer.getAsObject(coordinates);
        if (o == null) {
            if (this.lazy) {
                Coordinates c = Coordinates.wrap(coordinates);
                if (!this.inputToDoBuffer.contains(c)) {
                    this.inputToDoBuffer.add(c.clone());
                }
            } else {
                o = this.original.getAsObject(coordinates);
                if (o == null) {
                    this.inputBuffer.setAsObject(EMPTYOBJECT, coordinates);
                } else {
                    this.inputBuffer.setAsObject(o, coordinates);
                }
            }
        } else if (o == EMPTYOBJECT) {
            return null;
        }
        return o;
    }

    @Override
    public synchronized long getValueCount() {
        return this.original.getValueCount();
    }

    @Override
    public synchronized void setObject(Object value, long ... coordinates) {
        this.inputBuffer.setAsObject(value, coordinates);
        this.outputToDoBuffer.add(Coordinates.wrap(coordinates).clone());
    }

    public synchronized void setInputBufferSize(int numElements) {
        this.inputBuffer = numElements < 1 ? new VolatileSparseObjectMatrix(this.original.getSize()) : new DefaultSparseObjectMatrix(this.original.getSize());
    }

    public synchronized void setOutputBufferSize(int numElements) {
        try {
            this.flush();
            this.outputToDoBuffer = Collections.synchronizedSortedSet(new TreeSet());
            this.outputBufferSize = numElements;
        }
        catch (IOException e) {
            throw new RuntimeException("could not set output buffer", e);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        while (this.outputToDoBuffer != null && this.outputToDoBuffer.size() != 0) {
            try {
                this.outputToDoBuffer.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("could not flush buffer", e);
            }
        }
    }

    public synchronized int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.inputBuffer.containsCoordinates(coordinates) || this.original.containsCoordinates(coordinates);
    }

    @Override
    public boolean isReadOnly() {
        return this.original.isReadOnly();
    }

    class ReadThread
    extends Thread {
        ReadThread() {
        }

        public void run() {
            long t = System.currentTimeMillis();
            boolean update = false;
            while (true) {
                try {
                    while (true) {
                        if (BufferedObjectMatrix.this.inputToDoBuffer != null && !BufferedObjectMatrix.this.inputToDoBuffer.isEmpty()) {
                            update = true;
                            Coordinates c = (Coordinates)BufferedObjectMatrix.this.inputToDoBuffer.first();
                            BufferedObjectMatrix.this.inputToDoBuffer.remove(c);
                            Object value = BufferedObjectMatrix.this.original.getAsObject(c.getLongCoordinates());
                            BufferedObjectMatrix.this.inputBuffer.setAsObject(value, c.getLongCoordinates());
                            if (System.currentTimeMillis() - t <= 500L) continue;
                            t = System.currentTimeMillis();
                            BufferedObjectMatrix.this.fireValueChanged();
                            continue;
                        }
                        if (update) {
                            update = false;
                            BufferedObjectMatrix.this.fireValueChanged();
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class WriteThread
    extends Thread {
        WriteThread() {
        }

        public void run() {
            try {
                while (true) {
                    if (BufferedObjectMatrix.this.outputToDoBuffer != null && !BufferedObjectMatrix.this.outputToDoBuffer.isEmpty()) {
                        Coordinates c = (Coordinates)BufferedObjectMatrix.this.outputToDoBuffer.first();
                        BufferedObjectMatrix.this.outputToDoBuffer.remove(c);
                        Object value = BufferedObjectMatrix.this.inputBuffer.getAsObject(c.getLongCoordinates());
                        BufferedObjectMatrix.this.original.setAsObject(value, c.getLongCoordinates());
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("error writing to matrix", e);
            }
        }
    }
}

