/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.io.UJMPContentHandler;
import org.ujmp.core.util.io.IntelligentFileReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ImportMatrixXML {
    public static final Matrix fromString(String string, Object ... parameters) throws ParserConfigurationException, SAXException, IOException {
        StringReader sr = new StringReader(string);
        IntelligentFileReader r = new IntelligentFileReader(sr);
        Matrix m = ImportMatrixXML.fromReader(r, parameters);
        r.close();
        return m;
    }

    public static final Matrix fromStream(InputStream stream, Object ... parameters) throws IOException, ParserConfigurationException, SAXException {
        InputStreamReader r = new InputStreamReader(stream);
        Matrix m = ImportMatrixXML.fromReader(r, parameters);
        r.close();
        return m;
    }

    public static final Matrix fromFile(File file, Object ... parameters) throws IOException, ParserConfigurationException, SAXException {
        FileReader lr = new FileReader(file);
        Matrix m = ImportMatrixXML.fromReader(lr, parameters);
        lr.close();
        return m;
    }

    public Matrix read(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        UJMPContentHandler contentHandler = new UJMPContentHandler();
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse(new InputSource(reader));
        return contentHandler.getResult();
    }

    public static final Matrix fromReader(Reader reader, Object ... parameters) throws ParserConfigurationException, SAXException, IOException {
        return new ImportMatrixXML().read(reader);
    }
}

