/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.destination;

import java.io.IOException;
import java.io.StringWriter;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.DBType;
import org.ujmp.core.export.destination.AbstractMatrixStringExportDestination;
import org.ujmp.core.export.exporter.DefaultMatrixWriterCSVExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterHtmlExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterLatexExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterMatlabScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterRScriptExporter;
import org.ujmp.core.export.exporter.DefaultMatrixWriterSQLExporter;

public class DefaultMatrixStringExportDestination
extends AbstractMatrixStringExportDestination {
    public DefaultMatrixStringExportDestination(Matrix matrix) {
        super(matrix);
    }

    public String asDenseCSV(char columnSeparator, char enclosingCharacter) throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterCSVExporter(this.getMatrix(), writer).asDenseCSV(columnSeparator, enclosingCharacter);
        writer.close();
        return writer.toString();
    }

    public String asDenseCSV(char columnSeparator) throws IOException {
        return this.asDenseCSV(columnSeparator, '\u0000');
    }

    public String asDenseCSV() throws IOException {
        return this.asDenseCSV('\t');
    }

    public String asSQL(DBType db, String databaseName, String tableName) throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterSQLExporter(this.getMatrix(), writer).asSQL(db, databaseName, tableName);
        writer.close();
        return writer.toString();
    }

    public String asMatlabScript(String variableName) throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterMatlabScriptExporter(this.getMatrix(), writer).asMatlabScript(variableName);
        writer.close();
        return writer.toString();
    }

    public String asRScript(String variableName) throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterRScriptExporter(this.getMatrix(), writer).asRScript(variableName);
        writer.close();
        return writer.toString();
    }

    public String asLatex() throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterLatexExporter(this.getMatrix(), writer).asLatex();
        writer.close();
        return writer.toString();
    }

    public String asHtml() throws IOException {
        StringWriter writer = new StringWriter();
        new DefaultMatrixWriterHtmlExporter(this.getMatrix(), writer).asHtml();
        writer.close();
        return writer.toString();
    }
}

