/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;

public class Var
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -6376910948253374396L;
    private Matrix mean = null;
    private boolean ignoreNaN = false;
    private boolean besselsCorrection = false;

    public Var(int dimension, boolean ignoreNaN, Matrix matrix, boolean besselsCorrection) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        this.besselsCorrection = besselsCorrection;
        MapMatrix<String, Object> aold = matrix.getMetaData();
        if (aold != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>();
            a.put("Label", aold.get("Label"));
            if (dimension == 0 || dimension == 1) {
                // empty if block
            }
            this.setMetaData(a);
        }
    }

    public double getDouble(long ... coordinates) {
        if (this.mean == null) {
            this.mean = new Mean(this.getDimension(), this.ignoreNaN, this.getSource()).calcNew();
        }
        double sum = 0.0;
        if (this.ignoreNaN) {
            double count = 0.0;
            double m = 0.0;
            double v = 0.0;
            switch (this.getDimension()) {
                case 0: {
                    m = this.mean.getAsDouble(0L, coordinates[1]);
                    for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                        v = this.getSource().getAsDouble(r, coordinates[1]);
                        if (MathUtil.isNaNOrInfinite(v)) continue;
                        sum += Math.pow(v - m, 2.0);
                        count += 1.0;
                    }
                    count = this.besselsCorrection ? count - 1.0 : count;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
                case 1: {
                    m = this.mean.getAsDouble(coordinates[0], 0L);
                    for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                        v = this.getSource().getAsDouble(coordinates[0], c);
                        if (MathUtil.isNaNOrInfinite(v)) continue;
                        sum += Math.pow(v - m, 2.0);
                        count += 1.0;
                    }
                    count = this.besselsCorrection ? count - 1.0 : count;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
                case 0x7FFFFFFF: {
                    m = this.mean.getAsDouble(0L, 0L);
                    for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                        for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                            v = this.getSource().getAsDouble(r, c);
                            if (MathUtil.isNaNOrInfinite(v)) continue;
                            sum += Math.pow(v - m, 2.0);
                            count += 1.0;
                        }
                    }
                    count = this.besselsCorrection ? count - 1.0 : count;
                    count = count == 0.0 ? 1.0 : count;
                    return sum / count;
                }
            }
            return 0.0;
        }
        double count = 0.0;
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    sum += Math.pow(this.getSource().getAsDouble(r--, coordinates[1]) - this.mean.getAsDouble(0L, coordinates[1]), 2.0);
                    count += 1.0;
                }
                count = this.besselsCorrection ? count - 1.0 : count;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    sum += Math.pow(this.getSource().getAsDouble(coordinates[0], c--) - this.mean.getAsDouble(coordinates[0], 0L), 2.0);
                    count += 1.0;
                }
                count = this.besselsCorrection ? count - 1.0 : count;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
            case 0x7FFFFFFF: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    long c = this.getSource().getSize()[1] - 1L;
                    while (c != -1L) {
                        sum += Math.pow(this.getSource().getAsDouble(r, c--) - this.mean.getAsDouble(0L, 0L), 2.0);
                        count += 1.0;
                    }
                }
                count = this.besselsCorrection ? count - 1.0 : count;
                count = count == 0.0 ? 1.0 : count;
                return sum / count;
            }
        }
        return 0.0;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }
}

