/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.ujmp.core.collections.map.AbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMap<K, V>
extends AbstractMap<K, V> {
    private static final long serialVersionUID = -5970508001189550492L;
    private transient Map<K, Callable<V>> map = null;
    private boolean useCache = true;

    private Map<K, Callable<V>> getMap() {
        if (this.map == null) {
            this.map = new HashMap<K, Callable<V>>();
        }
        return this.map;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public V get(Object key) {
        Callable<V> cv = this.getMap().get(key);
        if (cv == null) {
            return null;
        }
        try {
            final V v = cv.call();
            if (this.useCache) {
                Callable c = new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        return v;
                    }
                };
                this.getMap().put(key, c);
            }
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public void put(K key, Callable<V> value) {
        this.getMap().put(key, value);
    }

    @Override
    public V put(K key, final V value) {
        this.put(key, (V)new Callable<V>(){

            @Override
            public V call() throws Exception {
                return value;
            }
        });
        return null;
    }

    @Override
    public V remove(Object key) {
        this.getMap().remove(key);
        return null;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }
}

