/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import java.awt.Toolkit;
import java.text.Format;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ChangeValidatedDocument
extends PlainDocument {
    private final Format format;
    private final ParsePosition status = new ParsePosition(0);

    public ChangeValidatedDocument(Format f) {
        if (f == null) {
            throw new NullPointerException("Format cannot be null");
        }
        this.format = f;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String afterOffset;
        if (str == null) {
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String proposedResult = beforeOffset + str + (afterOffset = currentText.substring(offs, currentText.length()));
        if (this.isResultOK(proposedResult)) {
            super.insertString(offs, str, a);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        String afterOffset;
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String proposedResult = beforeOffset + (afterOffset = currentText.substring(len + offs, currentText.length()));
        if (proposedResult.length() == 0 || this.isResultOK(proposedResult)) {
            super.remove(offs, len);
        }
    }

    protected boolean isResultOK(String proposedResult) {
        boolean ok;
        this.status.setErrorIndex(-1);
        this.status.setIndex(0);
        Object result = this.format.parseObject(proposedResult, this.status);
        boolean bl = ok = result != null && this.status.getIndex() == proposedResult.length() && this.status.getErrorIndex() < 0;
        if (!ok) {
            Toolkit.getDefaultToolkit().beep();
        }
        return ok;
    }
}

