/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BitSetDataset
extends AbstractObject {
    private BitSet[] fBitSets;
    private List<String> fcBitNames;
    private List<String> frBitSetNames;

    public BitSetDataset(GeneSetMatrix gm) {
        int i;
        ArrayList<String> bitNames = new ArrayList<String>(gm.getAllMemberNamesOnlyOnceS());
        BitSet[] bss = new BitSet[gm.getNumGeneSets()];
        ArrayList<String> bitSetNames = new ArrayList<String>(gm.getNumGeneSets());
        for (i = 0; i < gm.getNumGeneSets(); ++i) {
            bss[i] = new BitSet(bitNames.size());
            bitSetNames.add(AuxUtils.getAuxNameOnlyNoHash(gm.getGeneSetName(i)));
        }
        for (i = 0; i < bitNames.size(); ++i) {
            String name = ((String)bitNames.get(i)).toString();
            for (int g = 0; g < gm.getNumGeneSets(); ++g) {
                GeneSet gset = gm.getGeneSet(g);
                if (!gset.isMember(name)) continue;
                bss[g].set(i);
            }
        }
        String name = NamingConventions.generateName(gm);
        name = NamingConventions.removeExtension(name);
        this.init(name, bss, bitSetNames, bitNames, true);
    }

    private void init(String bsname, BitSet[] bss, List<String> bitSetNames, List<String> bitNames, boolean shareBitSets) {
        super.initialize(bsname);
        if (bss == null) {
            throw new IllegalArgumentException("Param bss cannot be null");
        }
        if (bitSetNames == null) {
            throw new IllegalArgumentException("bitSetNames cannot be null");
        }
        if (bitNames == null) {
            throw new IllegalArgumentException("Param bitNames cannot be null");
        }
        if (bss.length != bitSetNames.size()) {
            throw new IllegalArgumentException("BitSet length: " + bss.length + " and bitSetNames (row names): " + bitSetNames.size() + " do not match in size");
        }
        if (bss.length > 0) {
            int size = bss[0].size();
            for (int i = 0; i < bss.length; ++i) {
                if (bss[i] == null) {
                    throw new IllegalArgumentException("BitSet cannot be null at: " + i);
                }
                if (bss[i].size() == size) continue;
                throw new IllegalArgumentException("BitSets are not of equal length, expected: " + size + " but at: " + i + " got size: " + bss[i].size());
            }
        }
        if (shareBitSets) {
            this.fBitSets = bss;
        } else {
            this.log.debug("NON-sharing mode, so making deep copy of bitsets: {}", (Object)bss.length);
            this.fBitSets = new BitSet[bss.length];
            for (int i = 0; i < bss.length; ++i) {
                this.fBitSets[i] = (BitSet)bss[i].clone();
            }
        }
        this.fcBitNames = Collections.unmodifiableList(bitNames);
        this.frBitSetNames = Collections.unmodifiableList(bitSetNames);
        BitSetDataset.ensureAllUniqueValues(this.frBitSetNames);
    }

    private static void ensureAllUniqueValues(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter list cannot be null");
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            String item = list.get(i);
            if (set.contains(item)) {
                throw new IllegalArgumentException("Duplicate COL names are NOT allowed in Datasets. The offending entry was: " + item + " at pos: " + i + "\n" + set);
            }
            set.add(item);
        }
        set.clear();
    }

    public Dataset toDataset() {
        ArrayList<String> rowNames = new ArrayList<String>(this.frBitSetNames);
        ArrayList<String> colNames = new ArrayList<String>(this.fcBitNames);
        return new DefaultDataset(this.getName(), this.toMatrix(), rowNames, colNames, null);
    }

    public BitSet getBitSet(int rown) {
        return (BitSet)this.fBitSets[rown].clone();
    }

    public int getNumBitSets() {
        return this.fBitSets.length;
    }

    public int getNumBits() {
        return this.fcBitNames.size();
    }

    @Override
    public String getQuickInfo() {
        return this.fBitSets.length + "x" + this.fcBitNames.size();
    }

    public Matrix orMatrix() {
        Matrix matrix = new Matrix(this.getNumBitSets(), this.getNumBitSets());
        for (int r = 0; r < this.getNumBitSets(); ++r) {
            for (int c = 0; c < this.getNumBitSets(); ++c) {
                BitSet bs = this.getBitSet(r);
                bs.or(this.fBitSets[c]);
                matrix.setElement(r, c, bs.cardinality());
            }
        }
        return matrix;
    }

    public Matrix andMatrix(boolean fractionalize) {
        Matrix matrix = new Matrix(this.getNumBitSets(), this.getNumBitSets());
        for (int r = 0; r < this.getNumBitSets(); ++r) {
            for (int c = 0; c < this.getNumBitSets(); ++c) {
                BitSet bs = this.getBitSet(r);
                float size = bs.cardinality();
                bs.and(this.fBitSets[c]);
                float num = bs.cardinality();
                if (fractionalize) {
                    num /= size;
                }
                matrix.setElement(r, c, num);
            }
        }
        return matrix;
    }

    public Dataset and_by_or() {
        this.log.debug("Doing and_by_or");
        return this.and_by_or(this.getName() + "AND_BY_OR");
    }

    public Dataset and_by_or(String name) {
        return new DefaultDataset(name, this.and_by_orMatrix(), this.frBitSetNames, this.frBitSetNames, null);
    }

    public Matrix and_by_orMatrix() {
        Matrix mOr = this.orMatrix();
        Matrix mAnd = new Matrix(this.andMatrix(false));
        mAnd.divide(mOr, true);
        return mAnd;
    }

    private Matrix toMatrix() {
        int numCols = this.getNumBits();
        Matrix m = new Matrix(this.getNumBitSets(), numCols);
        for (int r = 0; r < this.getNumBitSets(); ++r) {
            for (int c = 0; c < this.getNumBits(); ++c) {
                if (this.fBitSets[r].get(c)) {
                    m.setElement(r, c, 1.0f);
                    continue;
                }
                m.setElement(r, c, 0.0f);
            }
        }
        return m;
    }
}

