/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractTemplate
extends AbstractObject
implements Template {
    private Vector fTemplateAsVector;
    private TIntObjectHashMap fProfilePosItemMap;

    AbstractTemplate(String name) {
        super(name);
    }

    protected AbstractTemplate() {
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer();
        if (this.isContinuous()) {
            buf.append(this.getNumItems()).append("=>numeric");
        } else if (this.getNumClasses() == 2) {
            buf.append(this.getNumItems()).append(" samples").append('(').append(this.getClass(0).getSize()).append(',').append(this.getClass(1).getSize()).append(')').append("=>").append(this.getNumClasses()).append(" classes");
        } else if (this.getNumClasses() == 1) {
            buf.append(this.getNumItems()).append(" samples").append("=>").append(this.getNumClasses()).append(" class");
        } else {
            buf.append(this.getNumItems()).append(" samples").append("=>").append(this.getNumClasses()).append(" classes");
        }
        return buf.toString();
    }

    protected abstract Template.Item _getItemAsIs(int var1);

    protected abstract Template.Item[] _getItems();

    private String[] _getClassNamesOrderedByProfilePos_CAREFUL() {
        ArrayList<String> classNames = new ArrayList<String>();
        int[] ordered_profile_pos = this.getProfilePositionsOrdered();
        for (int i = 0; i < ordered_profile_pos.length; ++i) {
            String cn = this.getItemByProfilePos(ordered_profile_pos[i]).getId();
            if (classNames.contains(cn)) continue;
            classNames.add(cn);
        }
        if (classNames.size() != this.getNumClasses()) {
            throw new IllegalStateException("Odd: className.length: " + classNames.size() + " getNumClasses: " + this.getNumClasses() + " " + classNames);
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    @Override
    public Template.Class getClass(Template.Item item) {
        for (int i = 0; i < this.getNumClasses(); ++i) {
            Template.Class cl = this.getClass(i);
            for (int c = 0; c < cl.getSize(); ++c) {
                if (!item.equals(cl.getItem(c))) continue;
                return cl;
            }
        }
        throw new IllegalArgumentException("No membership for item in any of the classes: " + item.getId() + " " + item.getProfilePosition());
    }

    @Override
    public Vector toVector() {
        if (this.fTemplateAsVector == null) {
            Vector v = new Vector(this.getNumItems());
            if (this.isContinuous()) {
                for (int i = 0; i < this.getNumItems(); ++i) {
                    v.setElement(i, this._getItemAsIs(i).floatValue());
                }
            } else {
                for (int i = 0; i < this.getNumItems(); ++i) {
                    v.setElement(i, this._getItemAsIs(i).floatValue());
                }
            }
            this.fTemplateAsVector = v;
            this.fTemplateAsVector.setImmutable();
        }
        return this.fTemplateAsVector;
    }

    @Override
    public Vector[] splitByTemplateClass(Vector profile) {
        int numClasses = this.getNumClasses();
        Vector[] vectors = new Vector[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            Template.Class cl = this.getClass(i);
            int classSize = cl.getSize();
            Vector v = new Vector(classSize);
            for (int p = 0; p < classSize; ++p) {
                int pos = cl.getItem(p).getProfilePosition();
                v.setElement(p, profile.getElement(pos));
            }
            vectors[i] = v;
        }
        return vectors;
    }

    @Override
    public String getAsString(boolean gcFormat) {
        if (this.isContinuous()) {
            return this._getAsString_cont();
        }
        return this._getAsString_cat(gcFormat);
    }

    private String _getAsString_cont() {
        StringBuffer s = new StringBuffer();
        s.append("#numeric").append('\n');
        s.append('\n');
        s.append('#').append(this.getName()).append('\n');
        Template.Item[] items = this.getItemsOrderedByProfilePos();
        for (int i = 0; i < items.length; ++i) {
            s.append(items[i].floatValue());
            if (i == this.getNumItems() - 1) continue;
            s.append(" ");
        }
        s.append('\n');
        return s.toString();
    }

    private String _getAsString_cat(boolean gcFormat) {
        StringBuffer s = new StringBuffer();
        s.append(this.getNumItems());
        s.append(" ");
        s.append(this.getNumClasses());
        s.append(" ");
        s.append("1");
        s.append("\n");
        s.append("# ");
        String[] classNames = this._getClassNamesOrderedByProfilePos_CAREFUL();
        for (int i = 0; i < classNames.length; ++i) {
            s.append(classNames[i]);
            if (i == classNames.length - 1) continue;
            s.append(" ");
        }
        s.append("\n");
        Template.Item[] items_ordered = this.getItemsOrderedByProfilePos();
        if (gcFormat) {
            int i;
            TObjectIntHashMap idCntMap = new TObjectIntHashMap();
            int classCnt = 0;
            for (i = 0; i < items_ordered.length; ++i) {
                Template.Item item = items_ordered[i];
                if (idCntMap.containsKey((Object)item.getId())) continue;
                idCntMap.put((Object)item.getId(), classCnt);
                ++classCnt;
            }
            for (i = 0; i < items_ordered.length; ++i) {
                int cnt = idCntMap.get((Object)items_ordered[i].getId());
                s.append(cnt);
                if (i == items_ordered.length - 1) continue;
                s.append(" ");
            }
        } else {
            for (int i = 0; i < items_ordered.length; ++i) {
                s.append(items_ordered[i].getId());
                if (i == items_ordered.length - 1) continue;
                s.append(" ");
            }
        }
        s.append("\n");
        return s.toString();
    }

    @Override
    public boolean isAscendingProfilePositions() {
        int[] profilePositions_as_is = new int[this.getNumItems()];
        for (int i = 0; i < this.getNumItems(); ++i) {
            Template.Item item = this._getItemAsIs(i);
            profilePositions_as_is[i] = item.getProfilePosition();
        }
        return XMath.isAscending(profilePositions_as_is);
    }

    @Override
    public Vector synchProfile(Vector profile) {
        Vector synched = new Vector(this.getNumItems());
        for (int i = 0; i < this.getNumItems(); ++i) {
            int pos = this._getItemAsIs(i).getProfilePosition();
            synched.setElement(i, profile.getElement(pos));
        }
        return synched;
    }

    @Override
    public Template.Item[] getItemsOrderedByProfilePos() {
        int[] sorted_profile_positions = this.getProfilePositionsOrdered();
        ArrayList<Template.Item> list = new ArrayList<Template.Item>();
        for (int i = 0; i < sorted_profile_positions.length; ++i) {
            list.add(this.getItemByProfilePos(sorted_profile_positions[i]));
        }
        return list.toArray(new Template.Item[list.size()]);
    }

    @Override
    public Template.Item[] getItemsOrderedByClassFirstAndThenProfilePos() {
        ArrayList<Template.Item> list = new ArrayList<Template.Item>();
        for (int c = 0; c < this.getNumClasses(); ++c) {
            Template.Class cl = this.getClass(c);
            Template.Item[] items = cl.getItemsOrderedByProfilePos();
            for (int i = 0; i < items.length; ++i) {
                list.add(items[i]);
            }
        }
        return list.toArray(new Template.Item[list.size()]);
    }

    @Override
    public Template.Item getItemByProfilePos(int profilePos) {
        this._initProfilePosItemMap();
        Object obj = this.fProfilePosItemMap.get(profilePos);
        if (obj == null) {
            Printf.out(this.fProfilePosItemMap.keys());
            throw new IllegalArgumentException("No such profile pos: " + profilePos + " # points: " + this.getNumItems());
        }
        return (Template.Item)obj;
    }

    @Override
    public int[] getProfilePositionsOrdered() {
        this._initProfilePosItemMap();
        return AbstractTemplate.getProfilePositionsSorted(this.fProfilePosItemMap);
    }

    protected static TIntObjectHashMap hashProfilePosItemMap(Template.Item[] items) {
        TIntObjectHashMap profilePosItemMap = new TIntObjectHashMap();
        for (int i = 0; i < items.length; ++i) {
            if (profilePosItemMap.containsKey(items[i].getProfilePosition())) {
                throw new IllegalStateException("Duplicate profile positions: " + items[i].getProfilePosition());
            }
            if (profilePosItemMap.get(items[i].getProfilePosition()) != null) {
                throw new IllegalStateException("Multiple items at same profile position in template: " + items[i].getProfilePosition());
            }
            profilePosItemMap.put(items[i].getProfilePosition(), (Object)items[i]);
        }
        return profilePosItemMap;
    }

    protected static Template.Item[] getProfilePositionsSorted(Template.Item[] items) {
        TIntObjectHashMap map = AbstractTemplate.hashProfilePosItemMap(items);
        Template.Item[] sorted_items = new Template.Item[items.length];
        int[] sorted_profile_positons = AbstractTemplate.getProfilePositionsSorted(map);
        for (int i = 0; i < sorted_profile_positons.length; ++i) {
            sorted_items[i] = (Template.Item)map.get(sorted_profile_positons[i]);
        }
        return sorted_items;
    }

    protected static int[] getProfilePositionsSorted(TIntObjectHashMap profilePosItemMap) {
        int[] sorted_profile_positions = profilePosItemMap.keys();
        Arrays.sort(sorted_profile_positions);
        return sorted_profile_positions;
    }

    private void _initProfilePosItemMap() {
        if (this.fProfilePosItemMap == null) {
            this.fProfilePosItemMap = AbstractTemplate.hashProfilePosItemMap(this._getItems());
        }
    }
}

