/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TFloatArrayList;
import java.util.Arrays;
import java.util.List;

public class Vector {
    private int elementCount;
    protected float[] elementData;
    public transient ComputeSet computeset = new ComputeSet();
    private boolean fImmuted;
    private Vector fNaNless;

    public static final Vector infinityAdjustRankedScoreVector(Vector vec) {
        float score;
        if (vec.elementCount == 0) {
            return vec;
        }
        boolean finiteHead = false;
        float startVal = vec.elementData[0];
        if (Float.isNaN(startVal)) {
            startVal = 1.0E-6f;
        } else if (Float.isInfinite(startVal)) {
            startVal = startVal < 0.0f ? -1.0E-6f : 1.0E-6f;
        } else {
            finiteHead = true;
        }
        int end = vec.elementCount - 1;
        float endVal = vec.elementData[end];
        if (Float.isNaN(endVal)) {
            endVal = 1.0E-6f;
        } else if (Float.isInfinite(endVal)) {
            endVal = endVal < 0.0f ? -1.0E-6f : 1.0E-6f;
        } else if (finiteHead) {
            return vec;
        }
        if (vec.fImmuted) {
            vec = new Vector(vec);
        }
        vec.elementData[0] = startVal;
        vec.elementData[end] = endVal;
        for (int fwdPtr = 1; fwdPtr < end; ++fwdPtr) {
            score = vec.elementData[fwdPtr];
            if (Float.isNaN(score)) {
                vec.elementData[fwdPtr] = 1.0E-6f;
                continue;
            }
            if (!Float.isInfinite(score)) break;
            vec.elementData[fwdPtr] = score < 0.0f ? -1.0E-6f : 1.0E-6f;
        }
        for (int bkwdPtr = end - 1; bkwdPtr > 1; --bkwdPtr) {
            score = vec.elementData[bkwdPtr];
            if (Float.isNaN(score)) {
                vec.elementData[bkwdPtr] = 1.0E-6f;
                continue;
            }
            if (!Float.isInfinite(score)) break;
            vec.elementData[bkwdPtr] = score < 0.0f ? -1.0E-6f : 1.0E-6f;
        }
        return vec;
    }

    public Vector(int length) {
        this.elementCount = length;
        this.elementData = new float[length];
        if (this.computeset == null) {
            this.computeset = new ComputeSet();
        }
    }

    public Vector(float[] values, boolean share) {
        this.elementCount = values.length;
        if (share) {
            this.elementData = values;
        } else {
            this.elementData = new float[this.elementCount];
            System.arraycopy(values, 0, this.elementData, 0, this.elementCount);
        }
        if (this.computeset == null) {
            this.computeset = new ComputeSet();
        }
    }

    public Vector(Vector[] vectors) {
        if (vectors == null) {
            throw new IllegalArgumentException("Param vectors cannot be null");
        }
        int length = 0;
        for (int i = 0; i < vectors.length; ++i) {
            length += vectors[i].getSize();
        }
        this.elementCount = length;
        this.elementData = new float[length];
        int pos = 0;
        for (int i = 0; i < vectors.length; ++i) {
            System.arraycopy(vectors[i].elementData, 0, this.elementData, pos, vectors[i].elementCount);
            pos += vectors[i].elementCount;
        }
        if (this.computeset == null) {
            this.computeset = new ComputeSet();
        }
    }

    public Vector(float[] values) {
        this(values, false);
    }

    public Vector(List<DoubleElement> dels) {
        this(DoubleElement.toFloats(dels));
    }

    public Vector(Vector v, boolean share) {
        this(v.elementData, share);
    }

    public Vector(double[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.elementData[i] = (float)values[i];
        }
    }

    public Vector(TFloatArrayList f) {
        this(f.toNativeArray());
    }

    public Vector(Vector vector) {
        this(vector.elementCount, vector);
    }

    public Vector(int numelementstouse, Vector vector) {
        this(numelementstouse);
        System.arraycopy(vector.elementData, 0, this.elementData, 0, numelementstouse);
    }

    public double sum() {
        if (this.elementCount == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (int i = 0; i < this.elementCount; ++i) {
            sum += (double)this.elementData[i];
        }
        return sum;
    }

    public double sumNaNsafe() {
        return XMath.sum(this.elementData);
    }

    public double sum(int startIndexInclusive, int stopIndexEXclusive) {
        double sum = 0.0;
        for (int i = startIndexInclusive; i < stopIndexEXclusive; ++i) {
            sum += (double)this.elementData[i];
        }
        return sum;
    }

    public double squaresum() {
        if (this.elementCount == 0) {
            return Double.NaN;
        }
        double squaresum = 0.0;
        for (int i = 0; i < this.elementCount; ++i) {
            float value = this.elementData[i];
            squaresum += (double)(value * value);
        }
        return squaresum;
    }

    public double mean() {
        this.computeset.mean = this.sum() / (double)this.elementCount;
        return this.computeset.mean;
    }

    public double meanNaNsafe() {
        return XMath.mean(this.elementData);
    }

    public double meanOrMedian(boolean useMean) {
        if (useMean) {
            return this.mean();
        }
        return this.median();
    }

    public double mean(int startIndexInclusive, int stopIndexEXclusive) {
        return this.sum(startIndexInclusive, stopIndexEXclusive) / (double)(stopIndexEXclusive - startIndexInclusive);
    }

    public double median() {
        return XMath.median(this.elementData);
    }

    public Vector toVectorNaNless() {
        if (this.fNaNless == null) {
            int size = this.getSize();
            float[] nanlessArr = new float[size];
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                float val = this.elementData[i];
                if (Float.isNaN(val)) continue;
                nanlessArr[pos++] = val;
            }
            if (pos == size) {
                this.fNaNless = this;
            } else {
                this.fNaNless = new Vector(Arrays.copyOf(nanlessArr, pos));
                this.fNaNless.setImmutable();
            }
        }
        return this.fNaNless;
    }

    public Vector synchVectorNaNless(Vector other) {
        if (this.elementCount != other.elementCount) {
            throw new IllegalArgumentException("Other vector must be equal length to synch NaNless values");
        }
        this.toVectorNaNless();
        if (this == this.fNaNless) {
            return other;
        }
        float[] otherNaNless = new float[this.fNaNless.elementCount];
        int pos = 0;
        for (int i = 0; i < other.elementCount; ++i) {
            if (Float.isNaN(this.elementData[i])) continue;
            otherNaNless[pos++] = other.elementData[i];
        }
        return new Vector(otherNaNless, true);
    }

    public double var(boolean biased, boolean fixlow) {
        if (fixlow) {
            double var;
            this.stddev(biased, fixlow);
            this.computeset.var = var = this.computeset.stddev * this.computeset.stddev;
            return var;
        }
        return this._var(biased);
    }

    private double _var(boolean biased) {
        double mean;
        double oldvar = 0.0;
        int len = this.elementCount;
        if (!biased) {
            --len;
        }
        if (len <= 0) {
            return oldvar;
        }
        this.computeset.mean = mean = this.mean();
        for (int i = 0; i < this.elementCount; ++i) {
            double tmp = (double)this.elementData[i] - mean;
            oldvar += tmp * tmp;
        }
        return oldvar / (double)len;
    }

    public double stddev(boolean biased, boolean fixlow) {
        double stddev = Math.sqrt(this._var(biased));
        double mean = this.computeset.mean;
        if (fixlow) {
            double minallowed = XMath.isNearlyZero(mean) ? 0.2 : 0.2 * Math.abs(mean);
            stddev = Math.max(stddev, minallowed);
        }
        this.computeset.stddev = stddev;
        return this.computeset.stddev;
    }

    public float max() {
        float max = Float.NEGATIVE_INFINITY;
        int maxat = -1;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(this.elementData[i] > max)) continue;
            max = this.elementData[i];
            maxat = i;
        }
        if (this.computeset == null) {
            this.computeset = new ComputeSet();
        }
        this.computeset.max = max;
        this.computeset.maxindex = maxat;
        if (maxat == -1) {
            System.out.println("WARNING: could not find max for: " + this.toString(','));
            max = Float.NaN;
        }
        return max;
    }

    public int maxAtIndex() {
        float max = Float.NEGATIVE_INFINITY;
        int maxat = -1;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(this.elementData[i] > max)) continue;
            max = this.elementData[i];
            maxat = i;
        }
        if (maxat == -1) {
            throw new IllegalStateException("No max found. Values are:\n" + Printf.outs(this.elementData));
        }
        this.computeset.max = max;
        this.computeset.maxindex = maxat;
        return maxat;
    }

    public float maxDevFrom0() {
        float maxPositive = this.max();
        float minNegative = this.min();
        if (Math.abs(minNegative) > maxPositive) {
            return minNegative;
        }
        return maxPositive;
    }

    public int maxDevFrom0Index() {
        float maxPositive = this.max();
        float minNegative = this.min();
        if (Math.abs(minNegative) > maxPositive) {
            return this.minAtIndex();
        }
        return this.maxAtIndex();
    }

    public float min() {
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(this.elementData[i] < min)) continue;
            min = this.elementData[i];
        }
        this.computeset.min = min;
        return min;
    }

    public int minAtIndex() {
        float min = Float.POSITIVE_INFINITY;
        int minat = -1;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(this.elementData[i] < min)) continue;
            min = this.elementData[i];
            minat = i;
        }
        if (minat == -1) {
            throw new IllegalStateException("No max found. Values are:\n" + Printf.outs(this.elementData));
        }
        this.computeset.min = min;
        this.computeset.minindex = minat;
        return minat;
    }

    public double sumprod(Vector y) {
        int xSize = this.elementCount;
        if (xSize != y.getSize()) {
            throw new RuntimeException("Unequal vector sizes x: " + xSize + " y: " + y.getSize());
        }
        double prodsum = 0.0;
        for (int i = 0; i < xSize; ++i) {
            float xVal = this.getElement(i);
            float yVal = y.getElement(i);
            prodsum += (double)(xVal * yVal);
        }
        return prodsum;
    }

    public void sort() {
        this.checkImmutable();
        Arrays.sort(this.elementData);
    }

    public void revsort() {
        this.checkImmutable();
        Arrays.sort(this.elementData);
        this.reverse();
    }

    public void abs() {
        this.checkImmutable();
        for (int i = 0; i < this.elementData.length; ++i) {
            this.elementData[i] = Math.abs(this.elementData[i]);
        }
    }

    public void sort(SortMode mode, Order order) {
        this.checkImmutable();
        if (mode.isAbsolute()) {
            this.abs();
        }
        if (order.isAscending()) {
            this.sort();
        } else {
            this.revsort();
        }
    }

    public void reverse() {
        this.checkImmutable();
        float[] tmp = new float[this.elementData.length];
        int start = this.elementCount - 1;
        for (int i = 0; i < this.elementCount; ++i) {
            tmp[start - i] = this.elementData[i];
        }
        this.elementData = tmp;
    }

    public int getSize() {
        return this.elementCount;
    }

    public int getSize(ScoreMode smode) {
        if (smode.isPostiveAndNegTogether()) {
            return this.getSize();
        }
        if (smode.isPostiveAndNegSeperately()) {
            throw new IllegalArgumentException("Not a valid score mode");
        }
        if (smode.isPostiveOnly()) {
            int cnt = 0;
            for (int i = 0; i < this.getSize(); ++i) {
                if (!XMath.isPositive(this.getElement(i))) continue;
                ++cnt;
            }
            return cnt;
        }
        if (smode.isNegativeOnly()) {
            int cnt = 0;
            for (int i = 0; i < this.getSize(); ++i) {
                if (!XMath.isNegative(this.getElement(i))) continue;
                ++cnt;
            }
            return cnt;
        }
        throw new IllegalArgumentException("Unknown score mode: " + smode);
    }

    public float getElement(int index) {
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public void setElement(int index, float value) {
        this.checkImmutable();
        try {
            this.elementData[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public void setElement(int index, double value) {
        this.setElement(index, (float)value);
    }

    public String toString() {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.elementCount - 1; ++i) {
            buf.append(this.elementData[i]);
            buf.append(",");
        }
        buf.append(this.elementData[this.elementCount - 1]);
        buf.append(")");
        return buf.toString();
    }

    public String toString(char delim) {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.elementCount - 1; ++i) {
            if (!Float.isNaN(this.elementData[i])) {
                buf.append(this.elementData[i]);
            }
            buf.append(delim);
        }
        if (!Float.isNaN(this.elementData[this.elementCount - 1])) {
            buf.append(this.elementData[this.elementCount - 1]);
        } else {
            buf.append(delim);
        }
        return buf.toString();
    }

    public double[] toArrayDouble() {
        double[] dest = new double[this.elementData.length];
        for (int i = 0; i < this.elementData.length; ++i) {
            dest[i] = this.elementData[i];
        }
        return dest;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.elementCount; ++i) {
            long bits = Double.doubleToLongBits(this.elementData[i]);
            hash ^= (int)(bits ^ bits >> 32);
        }
        return hash;
    }

    public boolean equals(Vector vector1) {
        if (vector1 == null) {
            return false;
        }
        if (this.elementCount != vector1.elementCount) {
            return false;
        }
        float[] v1data = vector1.elementData;
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] == v1data[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o1) {
        return o1 != null && o1 instanceof Vector && this.equals((Vector)o1);
    }

    public void setImmutable() {
        this.fImmuted = true;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }

    public Vector extract(float someScoreThatDecidesMode, ScoreMode smode) {
        if (smode.isPostiveAndNegSeperately()) {
            if (XMath.isPositive(someScoreThatDecidesMode)) {
                return this.extract(ScoreMode.POS_ONLY);
            }
            return this.extract(ScoreMode.NEG_ONLY);
        }
        return this.extract(smode);
    }

    public Vector extract(ScoreMode smode) {
        TFloatArrayList floats;
        if (smode.isPostiveAndNegTogether()) {
            return this;
        }
        if (smode.isPostiveOnly()) {
            floats = new TFloatArrayList();
            for (int i = 0; i < this.getSize(); ++i) {
                float elem = this.getElement(i);
                if (!XMath.isPositive(elem)) continue;
                floats.add(elem);
            }
        } else if (smode.isNegativeOnly()) {
            floats = new TFloatArrayList();
            for (int i = 0; i < this.getSize(); ++i) {
                float elem = this.getElement(i);
                if (!XMath.isNegative(elem)) continue;
                floats.add(elem);
            }
        } else {
            throw new IllegalArgumentException("Unknown smode: " + smode.getName());
        }
        return new Vector(floats.toNativeArray(), true);
    }

    public class ComputeSet {
        public double mean = Double.NaN;
        public final double median = Double.NaN;
        public double stddev = Double.NaN;
        public double max = Double.NaN;
        public double min = Double.NaN;
        public double var = Double.NaN;
        public int maxindex = -1;
        public int minindex = -1;
    }
}

