/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rc_phrase_th.lex
Dates:		  23 Mar 2004
Purpose:	  parse raw-char-symbols phrase
              Rc_phrase keeps its own local symbol table: map and list.
              The term_def_ph adds symbol to Yacco2's
              global symbol table.
Output:       rc_phrase
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rc_phrase_th| Thread.\fbreak
Parse raw-char-symbols phrase.
The |Rc_phrase| terminal keeps its own local symbol table: 
map and list.
It calls the common backend |term_def_ph| thread
extractor of symbol definition.
 \fbreak
Example of a raw chaacter vocabulary to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/rcsym.txt"}

@/
fsm	
(fsm-id "rc_phrase_th.lex"
,fsm-filename rc_phrase_th
,fsm-namespace NS_rc_phrase_th
,fsm-class Crc_phrase_th{
  user-prefix-declaration
#include "lint_balls.h"
#include "identifier.h"
#include "term_def_ph.h"
#include "c_string.h"
 ***
  user-declaration
    public:
    T_rc_phrase* rc_phrase_;
  ***
  constructor
    rc_phrase_ = 0;
  ***
  op
    if(rc_phrase_ != 0){
      delete rc_phrase_;
      rc_phrase_ = 0;
    }
    rc_phrase_ = new T_rc_phrase;
    rc_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*rc_phrase_);
    rc_phrase_->phrase_tree(t);
  ***
}
,fsm-version "1.0",fsm-date "22 mar 2004",fsm-debug "false"
,fsm-comments "Raw character vocabulary parser.")
parallel-parser	
(	
  parallel-thread-function
    TH_rc_phrase_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rrc_phrase  (){
  -> Rlint 
     Ropen_par Rlint 
       Rparameters Rlint 
     Rclose_par
     Rlint 
     Rsym_defs_phrase
     Rlint  {
    op
      Crc_phrase_th* fsm = (Crc_phrase_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->rc_phrase_);
      fsm->rc_phrase_ = 0;
    ***
    }	
}

Ropen_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}
//
Rparameters  (){
  -> Rfilename_phrase Rlint
     Rnamespace_phrase
}

Rfilename_phrase  (){
  -> Rfilename Rlint Rfilename_id 
}

Rfilename  (){
  ->  ||| "#file-name" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
      sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfilename_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        Crc_phrase_th* fsm = (Crc_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->rc_phrase_->filename_id(sf->p2__);
      ***
      } 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_phrase  (){
  -> "," Rlint Rnamespace Rlint Rnamespace_id 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace  (){
  ->  ||| "#name-space" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
      sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        Crc_phrase_th* fsm = (Crc_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->rc_phrase_->namespace_id(sf->p2__);
      ***
      } 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rsym_defs_phrase  (){
  -> Ropen_brace Rlint
         Rsym_defs 
     Rclose_brace
}

Rsym_defs  (){
  ->  Rsym_def Rlint
  ->  Rsym_defs Rsym_def1 Rlint
}

Rsym_def  (){
  ->  ||| "terminal-def" NS_term_def_ph::TH_term_def_ph {
    op
      Crc_phrase_th* fsm = (Crc_phrase_th*)rule_info__.parser__->fsm_tbl__;
	  sf->p2__->classification(T_terminal_def::rc);
      CAbs_lr1_sym* r = 
	fsm->rc_phrase_->add_t_to_alphabet(sf->p2__,rule_info__.parser__);
      if(r == 0) return;
      RSVP(r);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ||| "#lrk-sufx" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-refs" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-sufx" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  |?| {
    op
        CAbs_lr1_sym* sym = new Err_no_sym_defs_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rsym_def1  (){
  ->  ||| "terminal-def" NS_term_def_ph::TH_term_def_ph {
    op
      Crc_phrase_th* fsm = (Crc_phrase_th*)rule_info__.parser__->fsm_tbl__;
	  sf->p2__->classification(T_terminal_def::rc);
      CAbs_lr1_sym* r = 
	fsm->rc_phrase_->add_t_to_alphabet(sf->p2__,rule_info__.parser__);
      if(r == 0) return;
      RSVP(r);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  ||| |+| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ||| "#lrk-sufx" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-refs" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-sufx" NULL {
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
}

Ropen_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "{"
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

}// end of rules
