/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  cweave_sdc.lex
Dates:		  5 Jan. 2006
Purpose:	  write out cweave sentence for 
				syntax directed directives
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |cweave_sdc| grammar.\fbreak
Write out cweave subrule's syntax directed directives sentences.
@/
fsm	
(fsm-id "cweave_sdc.lex"
,fsm-filename cweave_sdc
,fsm-namespace NS_cweave_sdc
,fsm-class Ccweave_sdc{
   user-prefix-declaration
#include "o2_externs.h"
  ***
 user-declaration
    public:
    std::ofstream* cweave_file_;
	T_subrule_def* subrule_def_;
	int subrule_no_;
	void initialize
		(std::ofstream* Cweave_file
		,T_subrule_def* Subrule_def
		,int Subrule_no);
    void output_sr_sdcode(const char* Directive);
    void output_sr_sdcode_title(const char* Directive);
    void wrt_directive(const char* Directive,T_syntax_code* Sdc);
    void deal_with_cweave_atsign(const char* Directive,T_syntax_code* Sdc);
  ***
  user-implementation
 	void Ccweave_sdc::initialize
		(std::ofstream* Cweave_file
		,T_subrule_def* Subrule_def
		,int Subrule_no){
			cweave_file_ = Cweave_file;
			subrule_def_ = Subrule_def;
			subrule_no_ = Subrule_no;
		}
/@
@*3 |wrt_directive|.
@/
    void Ccweave_sdc::wrt_directive(const char* Directive,T_syntax_code* Sdc){
      if(Sdc == 0){
        output_sr_sdcode(Directive);
        (*cweave_file_) << "/";
        (*cweave_file_) << "/ no sdcode" << endl;
        return;
      }      
      if(Sdc->cweb_marker() != 0){
        WRT_CWEB_MARKER(cweave_file_,Sdc->cweb_marker());   
      }
      output_sr_sdcode(Directive);
      string xlate;
      int len = Sdc->syntax_code()->length();
      string& sdc=*Sdc->syntax_code();
       // prescan @ due to cweave reqmts
      for(int x=0;x<len;++x){
        char nc = sdc[x];
        if(nc=='@'){
          // check next char for cweave type directives
          char nnc = sdc[x+1];
          if((nnc == '*') || (nnc == '<') || (nnc == '>')){
            xlate += nc;
             continue;
          }else{
            xlate += "@@";
            continue;
          }			
	}else{
            xlate += nc;
            continue;
	}
      }
      (*cweave_file_) << xlate.c_str() << endl;
    }
/@
@*3 |output_sr_sdcode|.
@/
   void Ccweave_sdc::output_sr_sdcode(const char* Directive){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (subrule_def_->its_rule_def()->rule_name()->c_str()
      ,xa);
      KCHARP cweave_sentence =
        "@<%s subrule %i %s directive@>=\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,subrule_no_
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }
/@
@*3 |output_sr_sdcode_title|.
@/
   void Ccweave_sdc::output_sr_sdcode_title(const char* Directive){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (subrule_def_->its_rule_def()->rule_name()->c_str()
      ,xa);
      KCHARP cweave_sentence =
        "@*4 %s subrule %i %s directive.\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,subrule_no_
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }
  ***
}
,fsm-version "1.0",fsm-date "5 Jan. 2006",fsm-debug "false"
,fsm-comments "Write out cweave subrule's sdc irectives sentences")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
//
rules{
Rweave_sdc  (){
  -> Rdirectives eog 
}

Rdirectives  (){ 
  ->  Rdirective 
  ->  Rdirectives Rdirective 
}

Rdirective  (){ 
  ->  "#op"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "op";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#arbitrator-code"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "arbitrator-code";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-declaration"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-prefix-declaration"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-prefix-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-suffix-declaration"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-suffix-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#constructor"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "constructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#destructor"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "destructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-implementation"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-implementation";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-imp-tbl"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-imp-tbl";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-imp-sym"  { 
    op
      Ccweave_sdc* fsm = (Ccweave_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-imp-sym";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
}
}// end of rules
