/* TeXset.bat
Copyright (C) Z. Wagner -- Ice Bear Soft, 28 Dec 1995

This is a sample configuration batch for emTeX. Its argument is the TeX format. You can do
anything in the batch but if it exists in the current directory or somewhere in the path,
it must do all what may be needed by any file.

This sample sets the TEXINPUT variable. Other settings are left for optional "prolog.cmd".
*/

texinput = '%emtexdir%\texinput'        /* base input */

plain = ''                              /* plain subdirectory */
csplain = plain                         /* csplain subdirectory */
lplain = 'latex209'                     /* LaTeX2.09 subdirectory */
latex = 'latex2e'                       /* LaTeX2e subdirectory */
cslatex = latex                         /* CS LaTeX2e subdirectory */

addx = ';'texinput'!!'                  /* To be added at the end of TEXINPUT */

parse arg format
fmt = translate(format)
select
when fmt == 'PLAIN' then dir = plain
when fmt == 'CSPLAIN' then dir = csplain
when fmt == 'LPLAIN' then dir = lplain
when fmt == 'LATEX' then dir = latex2e
when fmt == 'CSLATEX' then dir = cslatex
otherwise dir = format
end

if dir == '' then 'SET TEXINPUT='texinput'!!'
else 'SET TEXINPUT='texinput'\'dir'!!'addx
