##############################################################################
##############################################################################
##
##  ARCHIVE HEADER INFORMATION
##
##  @Make-file{
##	FILENAME    = "unix.mak",
##	VERSION     = "1.00",
##	DATE	    = "",
##	TIME	    = "",
##
##	AUTHOR	    = "Niel Kempson",
##	ADDRESS     = "25 Whitethorn Drive
##		       Cheltenham
##		       GL52 5LL
##		       England",
##	TELEPHONE   = "+44-242 579105",
##	EMAIL	    = "kempson@tex.ac.uk (Internet)",
##
##	SUPPORTED   = "yes",
##	ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
##	KEYWORDS    = "VVcode, Unix",
##
##	CODETABLE   = "ISO/ASCII",
##	CHECKSUM    = "51492 1481 5732 57976",
##
##	DOCSTRING   = { This is the VVCODE makefile for different versions
##			of UNIX.  Below is a list of the environments on
##			which VVCODE has been tested and found to work.	Each
##			entry is preceded by a status character:
##
##			+   tested and believed to work
##			-   tested but not all features available 
##			    (e.g. file timestamping)
##			?   not tested but should work
##			X   believed not to work.
##
##			If you port VVCODE to a new environment or find that
##			it works unchanged, please report back to the author
##			so that this file can be updated for everyone else.
##	
##			+ DEC MIPS, Ultrix 4.2, native cc:
##	    	    	    	"make bsd43"
##			+ HP 730, SysV, native cc:
##	    	    	    	"make sysv"
##			+ HP 9000/827, SysV, native cc:
##	    	    	    	"make sysv"
##			+ IBM RS6000, AIX 3.2, native cc:
##	    	    	    	"make aix32"
##			+ SCO Unix V.3.2, MSC compiler:
##	    	    	    	"make scosysv"
##			+ Sequent Symmetry, Dynix v3.1.2, native cc:
##			    	"make sequent"
##			+ SUN, SunOS 3.x & 4.1.x, native cc:
##	    	    	    	"make sunos"
##			+ SUN, SunOS 3.x & 4.1.x, GNU cc:
##	    	    	    	"make sunos-gcc"
##		    }
##  }
##
##  MODULE CONTENTS
##
##	[tbs]
##
##  COPYRIGHT
##
##	Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
##	no copyright over this program - you are free to use it as you wish.
##
##  CHANGE LOG
##
##############################################################################
##############################################################################


##############################################################################
#
# Local definitions for file types and compilation / linking.
#
# If your system is already supported it should not be necessary to modify
# any part of the Makefile except the local definitions below.	 
#
# COMPILER/LINKER
#
#   CC		    the command used to invoke the C compiler
#   CFLAGS	    compiler command line flags to be used
#   CCDEFINES	    symbols to be #defined when compiling
#
#   LD		    the command used to invoke the linker
#   LDFLAGS	    linker command line flags to be used
#   LDLIBS	    linker command line option to search the specified
#		    library files
#
#   MAKE    	    the command used to invoke Make to process this file.
#	    	    As distributed, it is defined as "make -f unix.mak"
#
# The definitions are used to compile and link as shown below:
#
#   Compiling C programs (e.g. xx.c)
#
#	$(CC)  -c  $(CFLAGS)  $(CCDEFINES)  xx.c
#
#   Linking object files (e.g. xx.o, yy.o & zz.o)
#
#	$(LD)  -o $@ $(LDFLAGS)  xx.o  yy.o  zz.o  $(LDLIBS)
#
# The 'vanilla' settings should usually be:
#
#	CC	    = cc
#	CFLAGS	    = -g
#	LD	    = cc
#	LDFLAGS     = -g
#
# For GNU C, the following settings are recommended:
#
#	CC	    = gcc
#	CFLAGS	    = -g -Wall -Wmissing-prototypes -Wconversion
#	LD	    = gcc
#	LDFLAGS     = -g
#
##############################################################################
# Start of local definitions.
#
# NOTE: do not define CCDEFINES and LDLIBS below - they will be set by
#	the system-specific target selected.
##############################################################################
CC	    = cc
CFLAGS	    = -g
LD	    = cc
LDFLAGS     = -g
MAKE	    = make -f unix.mak
##############################################################################
# End of local definitions.
##############################################################################


##############################################################################
# File types and default rule for compilation
##############################################################################
EXE		= 
OBJ		= .o

.SUFFIXES:	.c .h $(OBJ) $(EXE)

.c.o:
	$(CC)  -c  $(CFLAGS)  $(CCDEFINES)  $*.c    	


##############################################################################
# Target Groupings
##############################################################################
HDRFILES	= checkos.h machine.h local.h globals.h specific.h vvutils.h

OBJFILES	= vvencode$(OBJ) vvdecode$(OBJ) vveparse$(OBJ) \
		  vvutils$(OBJ) unix$(OBJ)

EXEFILES	= vvencode$(EXE) vvdecode$(EXE)

##############################################################################
# Top level targets
##############################################################################
make:
	@ echo 'You must specify the system for which VVCODE should be made.'
	@ echo ''
	@ echo 'For example: $(MAKE) bsd42'
	@ echo ''
	@ echo 'Valid system targets are:'
	@ echo ''
	@ echo '    clean,  veryclean'
	@ echo '    aix32,  bsd41,  bsd42,  bsd43'
	@ echo '    sequent,  scosysv,	sunos,	sunos-gcc,  sysv'

vvcode: $(EXEFILES)

clean:
	@ echo 'Cleaning up ... '
	-rm -f	$(OBJFILES)

veryclean:
	@ echo 'Cleaning up ... '
	-rm -f	$(OBJFILES)
	-rm -f	$(EXEFILES)


##############################################################################
# Dependencies for executables
##############################################################################
vvencode$(EXE): vvencode$(OBJ) vvutils$(OBJ) unix$(OBJ)
	$(LD)  -o $@  $(LDFLAGS) vvencode$(OBJ) vvutils$(OBJ) unix$(OBJ) \
	       $(LDLIBS)

vvdecode$(EXE):	vvdecode$(OBJ) vveparse$(OBJ) vvutils$(OBJ) unix$(OBJ)
	$(LD)  -o $@  $(LDFLAGS) vvdecode$(OBJ) vveparse$(OBJ) \
	       vvutils$(OBJ) unix$(OBJ) $(LDLIBS)

##############################################################################
# Dependencies for object files
##############################################################################
vvencode$(OBJ): vvencode.c $(HDRFILES)

vvdecode$(OBJ): vvdecode.c $(HDRFILES) vveparse.h

vveparse$(OBJ):	vveparse.c $(HDRFILES) vveparse.h

vvutils$(OBJ):	vvutils.c $(HDRFILES)

unix$(OBJ):	unix.c $(HDRFILES)


##############################################################################
##############################################################################
##
## ENVIRONMENT SPECIFIC TARGETS
##
##  The following symbols may be defined using "-D" to affect the 
##  compilation:
##
##  BSD41		    -	BSD 4.1 target
##  BSD42		    -	BSD 4.2 target
##  BSD43		    -	BSD 4.3 target
##  MSC	    	    	    -	A Microsoft C compiler is being used
##  SYSV		    -	System V target
##  HAS_STRINGS_H	    -	The header file for string functions is 
##				<strings.h> rather than <string.h>
##  HAS_SYSUTIME_H	    -	The function utime() is defined in
##				<sys/utime.h>.	This is the default 
##				assumption for BSD targets.
##  HAS_UTIME_H 	    -	The function utime() is defined in
##				<utime.h>.  This is the default assumption
##				for SYSV targets.
##############################################################################
##############################################################################


##############################################################################
# IBM RS6000, AIX 3.2 BSD environment
#
#   Normal BSD, as long as the BSD support library is linked in.
##############################################################################
aix32:
	@ echo 'Making VVcode for IBM AIX 3.2 ... '
	$(MAKE)  vvcode "CCDEFINES=-DBSD42" "LDLIBS=-lbsd"
		       

##############################################################################
# BSD 4.1 environment
#
##############################################################################
bsd41:
	@ echo 'Making VVcode for BSD 4.1 Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DBSD41"


##############################################################################
# BSD 4.2 environment
#
##############################################################################
bsd42:
	@ echo 'Making VVcode for BSD 4.2 Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DBSD42"


##############################################################################
# BSD 4.3 environment
#
##############################################################################
bsd43:
	@ echo 'Making VVcode for BSD 4.3 Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DBSD43"


##############################################################################
# Sequent Symmetry Dynix V3.1 BSD environment
#
#   Normal BSD, except that it has <strings.h> rather than the usual 
#   <string.h>
##############################################################################
sequent:
	@ echo 'Making VVcode for Sequent Symmetry DYNIX ... '
	$(MAKE)  vvcode "CCDEFINES=-DSTRINGS_H -DBSD42"


##############################################################################
# SCO Unix System V.3.2 environment, Microsoft C compiler
#
#   Fairly normal SYSV, except for the non Unix-like compiler syntax.
##############################################################################
scosysv:
	@ echo 'Making VVcode for SCO System V Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DSYSV -DMSC" \
		    	"CFLAGS=-M3 -Od -Zd -Zi -W3" \
			"LDFLAGS=-M3 -Od -Zd"


##############################################################################
# SunOS 4.1.x Unix BSD environment, native compiler
#
#   Normal BSD, except that it has <utime.h> rather than the usual 
#   <sys/utime.h>
##############################################################################
sunos:
	@ echo 'Making VVcode for SunOS BSD Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DHAS_UTIME_H -DBSD42"


##############################################################################
# SunOS 4.1.x Unix BSD environment, GNU C compiler
#
#   Normal BSD, except that it has <utime.h> rather than the usual 
#   <sys/utime.h>
##############################################################################
sunos-gcc:
	@ echo 'Making VVcode for SunOS BSD Unix using GNU C ... '
	$(MAKE)  vvcode "CCDEFINES=-DHAS_UTIME_H -DBSD42" \
			"CC=gcc" \
			"LD=gcc"

##############################################################################
# System V environment
#
##############################################################################
sysv:
	@ echo 'Making VVcode for System V Unix ... '
	$(MAKE)  vvcode "CCDEFINES=-DSYSV"
