#
#	Makefile for RSX
#	Rainer Schnitker
#

# This Makefile was written for ndmake
# Change VPATH statements for dmake

# vpath: your make uses ';' or ':' between directories
VPATH = $(BLD);$(SOURCEASM);.
# VPATH = $(BLD):$(SOURCEASM):.

# not supported by borland
# .SUFFIXES : .exe .emx .o .c .s .S

# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# needed ndmake

CC = wcc.exe
AS = \borlandc\bin\tasm.exe
LD = wcl.exe
CFLAGS = -bt=dos -w4 -2 -zq -d2 #-ox
AFLAGS = -mx -jlocals -dHAVE386 -w2 -I$(SOURCEASM) -D__WASM__

RSX=\rsx\bin\rsx16
BLD=build
SOURCEASM=asm16

.c.obj:
	$(CC) $(CFLAGS) -fo$(BLD)\$*.obj $<
.asm.obj:
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj

AOBJS = dpmi16.obj \
	dpmi10.obj \
	excep32.obj \
	adosx32.obj \
	copy32.obj \
	fpu.obj \
	switch.obj

OBJS =	rsx.obj \
	start32.obj \
	process.obj \
	signals.obj \
	ptrace.obj \
	termio.obj \
	doserrno.obj \
	sysemx.obj \
	sysdj.obj \
	cdosx32.obj \
	loadprg.obj \
	timedos.obj \
	rmlib.obj \
	statemx.obj \
	djio.obj \
	sysdep.obj \
	fs.obj \


all : $(RSX).exe
	@echo Make for msc ready!

$(RSX).exe : $(OBJS) $(AOBJS)
	$(LD) -d2 -bt=dos -k32768 -fe=\rsx\bin\rsx.exe build\*.obj

#deps

dpmi16.obj:  $(SOURCEASM)\dpmi16.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
dpmi10.obj:  $(SOURCEASM)\dpmi10.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
excep32.obj: $(SOURCEASM)\excep32.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
adosx32.obj: $(SOURCEASM)\adosx32.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
copy32.obj:  $(SOURCEASM)\copy32.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
fpu.obj:     $(SOURCEASM)\fpu.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
switch.obj:  $(SOURCEASM)\switch.asm
	$(AS) $(AFLAGS) $(SOURCEASM)\$*.asm, $(BLD)\$*.obj
