/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_data_members.cc"
 *                                    created: 21/10/97 {2:15:28 pm} 
 *                                last update: 05/08/98 {09:44:41 AM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "cpptcl_data_members.h"

Cpptcl_IBaseClass(cpp_data_mem,"datamember",cpp_config_mem);

void cpp_data_mem::conversion_error(tcl_args& arg) const {
	tcl_obj obuf;
	if(read_only()) {
		obuf << " - item is read-only";
	} else {
		if(is_itemised()) {
			obuf << " to type '" << data_type() << "' or any of: ";
		} else {
			obuf << " to type '" << data_type() << "' or the range: ";
		}
		list_items(obuf);
	}			
	arg.set_conversion_type(obuf);
	arg.syntax("value");
}

void cpp_data_mem::list_items(tcl_obj& obuf) const {
	if(is_itemised()) {
		// the syntax isn't just 'value', but rather one of a 
		// specific set of strings:
		for(const char* i = items();*i;i+= strlen(i)+1) {
			for(unsigned int c=0;c<strlen(i);c++) {
				obuf << (i[c] == ' ' ? '_' : i[c] );
			}
			obuf << ' ';
		}
	} else {
		obuf << '[';
		tcl_get_min(obuf);
		obuf << ',';
		tcl_get_max(obuf);
		obuf << ']';
	}
}

void cpp_data_mem::get_syntax(tcl_args& arg) const {
	if(is_itemised()) {
		// the syntax isn't just 'value', but rather one of a 
		// specific set of strings:
		tcl_obj item_buf;
		item_buf << "value (any of: ";
		list_items(item_buf);
		item_buf << ')' << ends;
		arg.syntax((Tcl_Obj*)item_buf);
		arg.help("set this data member to the given value");
	} else {
		arg("value","set this data member to the given value");
	}
	
}

int cpp_data_mem::parse_meta_commands(tcl_obj& tcl_, tcl_args& arg) {
	if(arg("","is this item itemised")=="itemised") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_ << is_itemised() << result;
		return tcl_;
	} else if(arg("","range of values allowed by this item")=="range") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		list_items(tcl_);
		tcl_ << result;
		return tcl_;
	} else if (arg("","returns itemised list of possible values")=="items") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		if(is_itemised()){
			for(const char* i = items();*i; i += strlen(i)+1) {
				tcl_ << i << lappend;
			}
			tcl_ << result;
			return TCL_OK;
		} else {
		  tcl_ << ":I'm not itemised."<< tcl_error;
		  return TCL_ERROR;
		}
	} else if (arg("","find lower limit on this variable")=="min") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_get_min(tcl_);
		tcl_ << result;
		return TCL_OK;
	} else if (arg("","find upper limit on this variable")=="max") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_get_max(tcl_);
		tcl_ << result;
		return TCL_OK;
	} else {
		return cpp_config_mem::parse_meta_commands(tcl_,arg);
	}
}
 
  cppMemType(bool);
  cppMemType(int);
  cppMemType(long);
  cppMemType(float);
  cppMemType(double);
 
/*
template <class T>
void cpp_member<T>::conversion_error(tcl_args& arg) {
	 tcl_obj obuf;
	 if(is_itemised()) {
		 obuf << "to any of: ";
	 } else {
		 obuf << "to the range: ";
	 }
	 list_items(obuf);
	 obuf << ends;
	 arg.set_conversion_type(obuf);
	 arg.syntax("value");
}
*/

void cpp_member_t<bool>::tcl_get(tcl_object* o, tcl_obj& tcl) const {
	tcl << get(o);
}


template <class T>
void cpp_member_t<T>::tcl_get(tcl_object* o, tcl_obj& tcl) const {
	T tt = get(o);
	if(is_itemised()) {
		// Check so our C++ class didn't screw us
		const char* i;
		// items start at 1, not zero.
		for(i = items();tt>1;) {
			int j = strlen(i);
			// test if we ran out of items
			if(j == 0) {
				// if so then reset to the first one
				i = items();
				// we also actually set the member correctly now
				set(o,1);
				break;
			}
			i+= j+1;
			tt--;
		}
		tcl << i;
	} else {
		tcl << tt;
	}
}
template <class T>
void cpp_member_t<T>::tcl_set(tcl_object* o, tcl_args_reader& istr) const {
	if(read_only()) {
		istr.setstate(tcl_args_reader::Fail);
		return;
	}
	if(is_itemised()) {
		char buf[64];
		istr.copy_arg_into(buf);
		// we start the count from 1
		T item_count = 0;
		// try to find it directly
		for(const char* i = items();*i;i+= strlen(i)+1) {
		    ++item_count;
			if(!strcmp(i,buf)) {
				// got match;
				set(o,item_count);
				return;
			}
		}
		// try to find it with underscores->spaces
		for(unsigned int ii=0;ii<strlen(buf);ii++) {
			buf[ii] = (buf[ii] == '_' ? ' ' : buf[ii] );
		}
		item_count = 0;
		for(const char* i = items();*i;i+= strlen(i)+1) {
		    ++item_count;
			if(!strcmp(i,buf)) {
				// got match;
				set(o,item_count);
				return;
			}
		}
		istr.setstate(tcl_args_reader::Fail);
#if 0
		// BACKWARDS COMPATIBILITY: code may vanish
		// maybe it was a number, (that's bad really),
		// but we do this for backwards compatibility.
		// For best use we pull from a stream.
		tcl_obj s;
		s << buf << ends;
		T t;
		s >> t;
		if(s.fail()) {
			// set the real input stream to a failed state
			// We didn't convert what we were given either
		    // to a given item or to an integer.
			istr.setstate(tcl_args_reader::Fail);
		} else {
			operator=(t);
		}
#endif
	} else {
		T t;
		istr >> t;
		if(in_range(t)) {
			set(o,t);
		} else {
		    istr.setstate(tcl_args_reader::Fail);			
		}
	}	
}

#define instantiate_some(T) \
template class cpp_member_t<T>; \
template class cpp_member<T>; \
template class cpp_member_fnv<T>; \
template class cpp_member_fnr<T>

 instantiate_some(bool);
 instantiate_some(int);
 instantiate_some(float);
 instantiate_some(long);
 instantiate_some(double);
