## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "smartPaste.tcl"
 #                                    created: 7/10/97 {2:50:59 pm} 
 #                                last update: 7/8/1999 {1:33:00 pm} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Copyright (c) 1997-1999  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

# extension declaration
alpha::feature smartPaste 0.4.2 global {
    namespace eval smartPaste {}
} {
    smartPaste::onoff 1
} {
    smartPaste::onoff 0
} maintainer {
    {Vince Darley} <vince@santafe.edu> \
      <http://www.santafe.edu/~vince/>
} help {
    When pasting into supported modes, the pasted text is automatically
    indented to the correct indentation level.  Your mode needs a 
    '<mode>::correctIndentation' procedure to use this feature.
} uninstall this-file

if {[info tclversion] < 8.0} {
proc smartPaste::onoff {on} {
    if {$on} {
	if {[info commands alpha::_paste] != ""} {return}
	if {[info commands copyringPaste] == ""} {
	    rename paste alpha::_paste
	    ;proc paste {} "smartPaste::paste"
	} else {
# Fix the loading problem when using at the same time 'copyRing.tcl'
# and 'smartPaste.tcl'.
	    rename copyringPaste alpha::_paste
	    ;proc copyringPaste {} "smartPaste::paste"
	    rename copyringReplace alpha::_replaceText
	    ;proc copyringReplace {} "smartPaste::replace"
	}
    } else {
	if {[info commands alpha::_paste] == ""} {return}
	if {[info commands copyringPaste] == ""} {
	    rename paste {}
	    rename alpha::_paste paste
	} else {
	    rename copyringPaste {}
	    rename alpha::_paste copyringPaste
	    rename copyringReplace {}
	    rename alpha::_replaceText copyringReplace
	}
    }
}
} else {
proc smartPaste::onoff {on} {
    if {$on} {
	if {[info commands ::alpha::_paste] != ""} {return}
	if {[info commands ::copyringPaste] == ""} {
	    rename ::paste ::alpha::_paste
	    ;proc ::paste {} "smartPaste::paste"
	} else {
# Fix the loading problem when using at the same time 'copyRing.tcl'
# and 'smartPaste.tcl'.
	    rename ::copyringPaste ::alpha::_paste
	    ;proc ::copyringPaste {} "smartPaste::paste"
	    rename ::copyringReplace alpha::_replaceText
	    ;proc ::copyringReplace {} "smartPaste::replace"
	}
    } else {
	if {[info commands ::alpha::_paste] == ""} {return}
	if {[info commands ::copyringPaste] == ""} {
	    rename ::paste {}
	    rename ::alpha::_paste ::paste
	} else {
	    rename ::copyringPaste {}
	    rename ::alpha::_paste ::copyringPaste
	    rename ::copyringReplace {}
	    rename ::alpha::_replaceText ::copyringReplace
	}
    }
}
}
    

## 
 # -------------------------------------------------------------------------
 # 
 # "smartPaste::paste" --
 # 
 #  If a mode has the <mode>::correctIndentation proc, then give that proc
 #  a position in the current file (where pasting will occur) together with
 #  the first non-whitespace characters to be pasted.  That proc should
 #  return a number indicating the number of characters to indent.
 # 
 # Results:
 #  none
 # 
 # Side effects:
 #  text is pasted into the window.  IF THE mode::correctIndentation proc
 #  fails with an error, this proc will DO NOTHING AT ALL.  That is a bug
 #  in the mode procedure, not in this one.
 # 
 # Notes:
 # --Version--Author------------------Changes-------------------------------
 #    1.0.2   <vince@santafe.edu> original
 # -------------------------------------------------------------------------
 ##
proc smartPaste::paste {} {
    if {[set p [mode::getProc correctIndentation]] == ""} {
	return [alpha::_paste]
    }
    if {![regexp -- "^(\[ \t\r\n\]*)(\[^ \t\r\n\]+)" \
      [getScrap] "" white next]} {
	return [alpha::_paste]
    }
    if {[string trim [getText [lineStart [getPos]] [getPos]]] != ""} {
	return [alpha::_paste]
    }
    # find correct indentation of line to be pasted
    # this requires <mode>::correctIndentation
    set lwhite [$p [getPos] $next]
    # turn scrap indentation into spaces
    set white [string length [text::maxSpaceForm \
      [lindex [split $white "\r\n"] end]]]
    # if it's the same level as what should be there, let alpha handle it
    set end [selEnd]
    if {$white == $lwhite} { 
	if {[pos::compare [set p [lineStart [getPos]]] != [getPos]]} {
	    set diff [string length [getText $p [getPos]]]
	    deleteText $p [getPos]
	    set end [pos::math $end - $diff]
	}
    }
    set scrap [text::indentBy [getScrap] [expr {$lwhite - $white}]]
    replaceText [set p [lineStart [getPos]]] $end $scrap
    # goto [pos::math $p + [string length $scrap]]
}

# Fix the loading problem when using at the same time 'copyRing.tcl'
# and 'smartPaste.tcl'.

proc smartPaste::replace {} {
    global pasteFinish pasteStart pasteScrap
    set scrap $pasteScrap
    set pos $pasteStart
    if {[set p [mode::getProc correctIndentation]] == ""} {
	return [alpha::_replaceText]
    }
    if {![regexp -- "^(\[ \t\r\n\]*)(\[^ \t\r\n\]+)" $scrap "" white next]} {
	return [alpha::_replaceText]
    }
    if {[string trim [getText [lineStart $pos] $pos]] != ""} {
	return [alpha::_replaceText]
    }
    # find correct indentation of line to be pasted
    # this requires <mode>::correctIndentation
    set lwhite [$p $pos $next]
    # turn scrap indentation into spaces
    set white [string length [text::maxSpaceForm \
      [lindex [split $white "\r\n"] end]]]
    # if it's the same level as what should be there, let alpha handle it
    if {$white == $lwhite} { 
	if {[pos::compare [set p [lineStart $pos]] != $pos]} {
	    deleteText $p [getPos]
	}
    }
    set scrap [text::indentBy $scrap [expr {$lwhite - $white}]]
    replaceText [set p [lineStart $pos]] $pasteFinish $scrap
}
