## -*-Tcl-*- (install)
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "fileUtils.tcl"
 #					created: 26/3/96 {2:10:38 pm}	
 #				    last update: 30/1/1999 {12:33:29 am}	
 #	Author:	Vince Darley
 #	E-mail:	<darley@fas.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 # ###################################################################
 ##

alpha::extension fileUtils 1.2 {
    menu::insert winUtils items end \
      {Menu -n moreUtils -p menu::fileUtils { 
	sortAndReplace 
	removeDuplicateLines
	insertModeLine 
	stuffFile 
	stuffOpenWindows
	"<E<Stabs8To4" 
	"<Stabs4To8" 
    }}
} uninstall this-file maintainer {
    "Vince Darley" darley@fas.harvard.edu <http://www.fas.harvard.edu/~darley/>
}

proc file::Utils::insertModeLine {} {
    global mode 
    pushPosition
    goto [minPos]
    file::notTextMode
    
    insertText "-*-${mode}-*-\n"
    goto [minPos]
    commentLine
    popPosition
}

proc file::Utils::sortAndReplace {} {
    balance
    set epts [getEndpts]
    set start [lindex $epts 0]
    set end [lindex $epts 1]
    set start [pos::math $start + 1]
    set end [pos::math $end - 1]
    replaceText $start $end [lsort [getText $start $end]]
    wrapText [lineStart $start] [pos::math [nextLineStart $end] - 1]
}

proc file::Utils::removeDuplicateLines {} {
    set pos [minPos]
    set otext [getText $pos [nextLineStart $pos]]
    while {[pos::compare $pos < [maxPos]]} {
	set ntext [getText $pos [nextLineStart $pos]]
	if { $otext == $ntext } { 
	    deleteText $pos [nextLineStart $pos] 
	} else {
	    set pos [nextLineStart $pos]
	    set otext $ntext
	}
    }	
}

## 
 # -------------------------------------------------------------------------
 #   
 # "file::Utils::getAllFileWindows" --
 #  
 #  Doesn't yet cope with file-names which are duplicate 
 #  (ending in <2>, for instance).
 # -------------------------------------------------------------------------
 ##
proc file::Utils::getAllFileWindows {} {
    set files {}
    foreach f [winNames -f] {
	if {[file exists $f]} { lappend files $f }
    }
    return $files
}

proc file::Utils::stuffFile {} {
    app::launchBack DStf
    sendOpenEvent noReply 'DStf' [win::Current]
    sendQuitEvent 'DStf'
} 

proc file::Utils::stuffOpenWindows {} {
    app::launchFore DStf
    eval sendOpenEvents 'DStf' [file::Utils::getAllFileWindows]
    sendQuitEvent 'DStf'
}

proc file::Utils::tabs8To4 {} {
    set fname [win::Current]
    setWinInfo tabsize 8
    select [minPos] [maxPos]
    tabsToSpaces
    setWinInfo tabsize 4
    select [minPos] [maxPos]
    spacesToTabs		
    
}

proc file::Utils::tabs4To8 {} {
    set fname [win::Current]
    setWinInfo tabsize 4
    select [minPos] [maxPos]
    tabsToSpaces
    setWinInfo tabsize 8
    select [minPos] [maxPos]
    spacesToTabs		
    
}


