## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "TclCompletions.tcl"
 #                                    created: 31/7/97 {3:01:54 pm} 
 #                                last update: 16/4/98 {10:47:34 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # ###################################################################
 ##

ensureset completions(Tcl) {contraction Proc Vvar completion::cmd Ensemble completion::electric Var}
ensureset completions(Shel) {Globalvar Proc completion::cmd Ensemble completion::electric Filename Var}

lunion TclTemplates "createNewClass"

#  Completions  #

proc Tcl::Completion::Globalvar {dummy} {
	set lastword [completion::lastWord]
	if {[string length $lastword] < 3} { return 0 }
	if {[string index $lastword 0] != "\$"} { return 0 }
	set lastword [string range $lastword 1 end]
	set matches [lsort [info globals ${lastword}*]]
	return [completion::matchUtil Tcl::Completion::Globalvar $lastword $matches]
}

proc Tcl::Completion::Proc {dummy} {
	set lastword [completion::lastWord p]
	if {[string length $lastword] < 3} { return 0 }
	if {[lookAt [pos::math $p - 1]] != "\["} { return 0 }
	set matches [lsort [info commands ${lastword}*]]
	return [completion::matchUtil Tcl::Completion::Proc $lastword $matches]
}


## 
 # -------------------------------------------------------------------------
 #   
 #  "Tcl::Completion::Var" --
 #  
 #   A mildly adaptive call of completion::word, in which we realise we 
 #   should complete '$abc...' if we can only see 'abc...'.  The standard
 #   procedure considers '$' to be part of a word so that would otherwise
 #   fail.
 # -------------------------------------------------------------------------
 ##
proc Tcl::Completion::Var {dummy} {
	global completion::in_progress_pos completion_got completion_looking
	
	# cursor changed place?
	set pos [getPos]
	if {$pos==${completion::in_progress_pos}} {
		return [completion::update Tcl::Completion::Var $completion_got $completion_looking]
	}

	set lastword [completion::lastWord]
	if { [string index $lastword 0] == "\$" } {
		set completion_got [string range $lastword 1 end]
		set completion_looking $completion_got
		return [completion::update Tcl::Completion::Var $completion_got $completion_looking]
	} else {
		return [completion::update completion::word]
	}
}

## 
 # -------------------------------------------------------------------------
 # 
 # "Tcl::Completion::Vvar" --
 # 
 #  Try to complete a variable, provided it seems to be a variable name.
 #  This means it is preceded by '$' or by 'set ' or 'arrayname(',...
 #  
 #  This allows us to complete variable names which begin 'str', 'li'
 #  etc. preferentially, since they would otherwise be expanded into
 #  'string', 'lindex' etc before they had a chance to be completed
 #  as variables.
 # -------------------------------------------------------------------------
 ##
proc Tcl::Completion::Vvar {dummy} {
	global completion_got completion_looking
	set lastword [completion::lastTwoWords prev]
	if { [string index $lastword 0] == "\$" } {
		set completion_got [string range $lastword 1 end]
		set completion_looking $completion_got
		return [completion::update Tcl::Completion::Vvar $completion_got $completion_looking]
	} elseif {[regexp {\($} $prev] \
	  || ([regexp "^(set|global|variable|get)\[ \t\]+\$" $prev])} {
		return [completion::update completion::word]
	} else {
		return 0
	}
}

set Tclstringcmds { 
	compare first index last length match range tolower toupper trim 
	trimleft trimright wordend wordstart
}
set Tclfilecmds { 
	atime copy delete dirname executable exists extension isdirectory 
	isfile join lstat mtime mkdir owned pathtype readable readlink rename 
	root rootname size split stat tail type writable
}
set Tcltracecmds {
	variable vdelete vinfo
}

set "Tclelectrics(trace variable)" " name ops command"
set "Tclelectrics(trace vdelete)" " name ops command"
set "Tclelectrics(trace vinfo)" " name"
set "Tclelectrics(string compare)" " is-bigger compared-with"
set "Tclelectrics(string first)" " search-for search-in"
set "Tclelectrics(string index)" " string charIndex"
set "Tclelectrics(string last)" " search-for search-in"
set "Tclelectrics(string length)" " string"
set "Tclelectrics(string match)" " pattern string"
set "Tclelectrics(string range)" " string first last"
set "Tclelectrics(string tolower)" " string"
set "Tclelectrics(string toupper)" " string"
set "Tclelectrics(string trim)" " string ?chars?"
set "Tclelectrics(string trimleft)" " string ?chars?"
set "Tclelectrics(string trimright)" " string ?chars?"
set "Tclelectrics(string wordend)" " string index"
set "Tclelectrics(string wordstart)" " string index"
set "Tclelectrics(file atime)" " name"
set "Tclelectrics(file copy)" " -force? source...source target"
set "Tclelectrics(file delete)" " name"
set "Tclelectrics(file dirname)" " name"
set "Tclelectrics(file executable)" " name"
set "Tclelectrics(file exists)" " name"
set "Tclelectrics(file extension)" " name"
set "Tclelectrics(file isdirectory)" " name"
set "Tclelectrics(file isfile)" " name"
set "Tclelectrics(file join)" " name name ... name"
set "Tclelectrics(file lstat)" " name varName"
set "Tclelectrics(file mkdir)" " name"
set "Tclelectrics(file mtime)" " name"
set "Tclelectrics(file owned)" " name"
set "Tclelectrics(file readable)" " name"
set "Tclelectrics(file readlink)" " name"
set "Tclelectrics(file root)" " name"
set "Tclelectrics(file rootname)" " name"
set "Tclelectrics(file size)" " name"
set "Tclelectrics(file split)" " name"
set "Tclelectrics(file stat)" " name varName"
set "Tclelectrics(file tail)" " name"
set "Tclelectrics(file type)" " name"
set "Tclelectrics(file writable)" " name"

set Tclelectrics(for) " \{start\} \{test\} \{increment\} \{\r\tbody\r\}\r"
set Tclelectrics(while) " \{test\} \{\r\tbody\r\}\r"
set Tclelectrics(if) " \{test\} \{\r\ttrue body\r\} "
set Tclelectrics(elseif) " \{test\} \{\n\ttrue body\n\} "
set Tclelectrics(else) " \{\n\telse body\n\} "
set Tclelectrics(proc) " name \{args\} \{\n\tbody\n\}"
set Tclelectrics(switch) " \{\} \{\n\"\" \{\n\t\n\}\n\}\n"
set Tclelectrics(lindex) " list element"
set Tclelectrics(lrange) " list first last"
set Tclelectrics(lsearch) " ?switches? list pattern"
set Tclelectrics(regsub) " ?switches? exp string subSpec varName"
set Tclelectrics(regexp) " ?switches? exp string ?matchVars...?"
set Tclelectrics(upvar) " ?level? varName localVar"
set Tclelectrics(lreplace) " list first last ?element element ...?"
set Tclelectrics(linsert) " list index element ?element element ...?"
set Tclelectrics(lappend) " varName value ?value value ...?"
set Tclelectrics(scan) " string format varName ?varName ...?"

set Tclelectrics(body) " \{string\} \{\n\tbody\n\}"
set Tclelectrics(class) " name \{\n\tinherit parent\n\}"

#  ..Tclelectrics --contractions  #
# these make use of indirection
set Tclelectrics(s'c) "string compare"
set Tclelectrics(s'f) "string first"
set Tclelectrics(s'i) "string index"
set Tclelectrics(s'l) "string last"
set Tclelectrics(s'len) "string length"
set Tclelectrics(s'r) "string range"
set Tclelectrics(s'tol) "string tolower"
set Tclelectrics(s'tou) "string toupper"
set Tclelectrics(s't) "string trim"
set Tclelectrics(s'tl) "string trimleft"
set Tclelectrics(s'tr) "string trimright"
set Tclelectrics(f'a) "file atime"
set Tclelectrics(f'd) "file dirname"
set Tclelectrics(f'exe) "file executable"
set Tclelectrics(f'exi) "file exists"
set Tclelectrics(f'ext) "file extension"
set Tclelectrics(f'id) "file isdirectory"
set Tclelectrics(f'if) "file isfile"
set Tclelectrics(f'l) "file lstat"
set Tclelectrics(f'm) "file mtime"
set Tclelectrics(f'o) "file owned"
set Tclelectrics(f'r) "file readable"
set Tclelectrics(f'r) "file readlink"
set Tclelectrics(f'rn) "file rootname"
set Tclelectrics(f'size) "file size"
set Tclelectrics(f'stat) "file stat"
set Tclelectrics(f'tail) "file tail"
set Tclelectrics(f'type) "file type"
set Tclelectrics(f'w) "file writable"



