/* hyphen_show: listing hyphenations                                       */
/*                                                                         */
/* Copyright (C) 1997, 1998, 2000                                          */
/* G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Uni Bremen                    */

/***************************************************************/ 
/*  Plea to the implementator:                                 */
/*                                                             */
/*  If you have to modify the following include instructions   */
/*  (or any other command of this program)                     */
/*  please send your modifications to us:                      */
/*                                                             */
/*       email: weibezahn@iwd.uni-bremen.de                    */
/*                                                             */
/*  See also ifdef's after command                             */
/*       main(n_arg,v_arg) int n_arg; char *v_arg[];           */
/***************************************************************/ 

#include <stdio.h>
#include <string.h>

#define LAENGE_PUF         250
#define LAENGE_NEU        5000 
#define LAENGE_SEITE      5000 
#define LAENGE_HCK       20000
#define MITTE               30

#define FONT_CODE_1      "OT1"
#define FONT_CODE_2       "T1"

#define TRUE               't'
#define FALSE              'f'
#define E_ENDFILE          'f'

#if defined(AIX)  /*  AIX Compiler call:                               */
	 /*  gcc -o hyphen_show hyphen_show.c -DAIX                    */
	 /*  xlc -o hyphen_show hyphen_show.c -DAIX -D_POSIX_SOURCE    */
  #include <fcntl.h>
  #include <unistd.h>
  int open(const char *, int,...);
  int close(int);
  ssize_t read(int,void *,size_t);
  int isalpha(char);

#elif defined(__BORLANDC__)
  #include <io.h>
  #include <stdlib.h>
  #include <ctype.h>
  #include <fcntl.h>

#elif defined(__DECC__)  /*  VMS Compiler call:                        */
	/*  compile:  cc/decc/define=(__DECC__) hyphen_show            */
	/*  link:     link hyphen_show                                 */
	/*  install:  hyphen_show == "$<directory>hyphen_show.exe      */
        /* works with cc/decc on OpenVMS versions >=6.1 Alpha and VAX  */
        /* To install this helpfile in the standard DECUS TeX release  */
        /* use "LIBRARY/INSERT/HELP DECUS[.HLB] HYPHEN_SHOW[.HLP]".    */
#include <stdlib.h>
  #include <file.h>
  int open(const char *, int);
  int close(int);
  int read(int,char *,unsigned);
  int isalpha(char);

#else             /* tested with: SUN-Solaris 2.5 (cc, gcc),
		                  Linux (gcc),
				  SGI IRIS 5.2                              */
  #include <sys/fcntl.h>
  int close(int);
  int read(int,char *,unsigned);
  int isalpha(char);
#endif

int gchar(unsigned char *);
void fehler(void);
unsigned  char e_inbyte(void);
void a_outimage(void);
void a_outchar(char);
void skip(int);
void umlaut(void);
void set_char_k(unsigned char);
char special_char(char,unsigned char);
void set_put(int);
void bop(unsigned char);
void test_neue_seite(void);
char gefunden(char *);
char *wortanfang(char *);
char *wortende(char *);
void f_set_pos(int);
void set_pos(int);
char *strip(char *);
char vergl_test(char *);
char zugelassen(char, unsigned char);
char* text_clear(char *, int *);
void eop(void);
long pow(int,int);
void eingabe(long *, unsigned char);
void right(unsigned char);
void w0(void);
void w(unsigned char);
void x0(void);
void x(unsigned char);
void down(unsigned char);
void y0(void);
void y(unsigned char);
void z0(void);
void z(unsigned char);
void xxx(unsigned char);
void fnt_def(unsigned char);
void pre(void);

 double xfaktor = 1, yfaktor = 1;

/***********************************************************/ 

#define BUFLEN_E 32768
int  filed1;
FILE *a_file,*ver_dat;
int  anzz=0;

int gchar( unsigned char *byt)
{ static char buffer[BUFLEN_E];
  static int cnt=0;
  static char *ptr;

  if (cnt == 0)
  {cnt=read(filed1,buffer,BUFLEN_E);
   ptr=buffer;
  }
  if (cnt > 0)
  {*byt = *ptr; 
   cnt--;  ptr++;  anzz++;
   return (1);
  }
  else if (cnt < 0)
  {printf("\nerror in reading, return code=%d\n",cnt);
   return (cnt);
  }
  else return (cnt);
}

long
     d_r, r_grenze, r_grenze_zeile,
     d_v, v_grenze, v_grenze_zeile,
     d_w, w_grenze, w_grenze_zeile,
     d_x, x_grenze, x_grenze_zeile,
     d_y, y_grenze, y_grenze_zeile,
     d_z, z_grenze, z_grenze_zeile;
int  laenge_hck = LAENGE_HCK,
     laenge_neu = LAENGE_NEU,
     laenge_puf = LAENGE_PUF,
     mitte      = MITTE;

int  s_p,s_max, hck_p,hck_max,neu_max,s_puffer_p,np,pos1, n_t1_ot1;
long gesamt,anzgef;

char
     seite[LAENGE_SEITE][LAENGE_PUF],
    *seitep[LAENGE_SEITE],
     s_puffer[LAENGE_PUF],hh[LAENGE_PUF], hh1[LAENGE_PUF],
     wortanf[LAENGE_PUF],wortend[LAENGE_PUF],stra[LAENGE_PUF],
     hck[LAENGE_HCK][80], neu[LAENGE_NEU+1][80],
     vorschub,enthalten,
     hauptdatei[80],verdatei[80],ausdatei[80],
    *hauptdateip,  *verdateip,  *ausdateip,
    *font_codep, font_code[10];
char tns_alt[80];
char tr_gef;

unsigned char k,zz;

void fehler(void)
{printf("\nError: eof before postamble\n"); exit(0);
}

unsigned  char e_inbyte(void)
  {
   if ( gchar(&zz) != 1) fehler();
   return zz; 
  }

/* Beginn der Umsetzroutinen */

void a_outimage(void)
  { char b;
    if (s_puffer_p > 2) 
   { if (s_puffer[s_puffer_p-2] == '-') { b = TRUE; } else
     if (s_puffer[s_puffer_p-1] == '-') { b = TRUE; } else {b = FALSE;};
     if (s_puffer_p > 3) {if (s_puffer[s_puffer_p-3] == '-') {b = TRUE;} };
     if ((b == TRUE) || (enthalten == TRUE)) 
     { memset(&seite[s_p][0],(char)0,laenge_puf);
       seitep[s_p] = strncpy(&seite[s_p][0],&s_puffer[0],s_puffer_p);  
       s_p++; 
       enthalten = b;
     }
     s_puffer_p = 0;
   }
  }

void a_outchar( char c)
  { s_puffer[s_puffer_p] = c;
    s_puffer_p++; if (s_puffer_p >= laenge_puf-1) a_outimage();
    s_puffer[s_puffer_p] = (char)0;
  }

void skip(int kk)
  { int j;
    for (j=1; j <= kk; j++)
      {e_inbyte();}
  }

void umlaut(void)
  { a_outchar('"'); }

void set_char_k(unsigned char code)
  { a_outchar((char) code); }

char special_char(char opcode,unsigned char k)
  {
/* Sonderzeichen fuer "von" "bis" (--) und Gedankenstrich (---)
   sollen in der Form angezeigt werden.
*/
    if ((char) k == '{') {a_outchar('-'); a_outchar('-'); return TRUE;}
    if ((char) k == '|') {a_outchar('-'); a_outchar('-'); a_outchar('-');
                          return TRUE;}
    if (strcmp(font_code, FONT_CODE_1) == 0)
    {
      if (opcode == FALSE){if (k > 127) { n_t1_ot1 = n_t1_ot1 + 1;
					  return FALSE;}};
      if      (k <= 10) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 11) {a_outchar('f'); a_outchar('f'); return TRUE;}
      else if (k == 12) {a_outchar('f'); a_outchar('i'); return TRUE;}
      else if (k == 13) {a_outchar('f'); a_outchar('l'); return TRUE;}
      else if (k == 14) {a_outchar('f'); a_outchar('f'); a_outchar('i');
                         return TRUE;}
      else if (k == 15) {a_outchar('f'); a_outchar('f'); a_outchar('l');
                         return TRUE;}
      else if (k <= 24) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 25) {a_outchar('"'); a_outchar('s'); return TRUE;}
      else if (k <= 31) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else return FALSE;
    }
    else if (strcmp(font_code,  FONT_CODE_2) == 0)
    { if      (k <= 15) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 16) {a_outchar('"'); return TRUE;}
      else if (k == 17) {a_outchar('"'); return TRUE;}
      else if (k <= 26) {a_outchar('^'); a_outchar('^'); return TRUE;}
      else if (k == 27) {a_outchar('f'); a_outchar('f'); return TRUE;}
      else if (k == 28) {a_outchar('f'); a_outchar('i'); return TRUE;}
      else if (k == 29) {a_outchar('f'); a_outchar('l'); return TRUE;}
      else if (k == 30) {a_outchar('f'); a_outchar('f'); a_outchar('i');
                         return TRUE;}
      else if (k == 31) {a_outchar('f'); a_outchar('f'); a_outchar('l');
                         return TRUE;}
      else if (k == 255) {a_outchar((char)223); return TRUE;}
      else return FALSE;
    }
    else return FALSE;
  }

void set_put(int hj)
  { int hn; unsigned  char hc;
    for (hn = 1; hn<= hj+1; hn++)
    { hc = e_inbyte();
      if (special_char(FALSE,hc)== TRUE){}
      else a_outchar((char) hc);
    }
  }

void bop(unsigned char code)
  { char b;
    long hn,hw; unsigned  char hk;
    a_outimage();
    vorschub = TRUE;
    hw = (int) e_inbyte();
    for (hn=2; hn <= 4; hn++) 
    { hk = e_inbyte();
      hw = hw * 256 + (long) hk;
    }
    skip(40);                               /* skip 9*c[4] und p[1]  */
    sprintf(&s_puffer[0],"%c %d",(char) code, (int) hw);
    s_puffer_p = strlen(&s_puffer[0]);
    b = enthalten; enthalten = TRUE;
    a_outimage();
    enthalten = b;
  }

void test_neue_seite(void)
  { char * pp,tns[80];
    pp = strchr(seitep[s_p], (char) 139);
    if (pp != NULL)
    { if (np >= 15) {printf("\n"); np = 0;}
      strcpy(tns,pp+2);
      if(strcmp(tns,tns_alt) != 0) 
      {
        if (tr_gef == TRUE) {printf("[%s]",tns_alt); np = np+1;};
        tr_gef = FALSE;
        printf("[%s]",tns); np = np+1;
        strcpy(tns_alt, tns);
      };
    };
  }

char gefunden(char *str)
  { int n;
    n = strlen(str);
    if (str[n-1] != '-') {return FALSE;}
    if (n > 1){if (str[n-2] != '-') return TRUE;} 
    return FALSE;
  }

char *wortanfang(char *str)
  { char ht[2] = {(char)0, (char)0};
    int n,k;
    n = strlen(str);

    k = 0;
    while ((str[k] == ' ') && (k <= n)) k++;
    memset(&stra[0], (char)0,laenge_puf);
    strncpy(&stra[0], &str[k],n-k);
    if (k == n) goto fin;
    n = n-k; k = n;
    ht[0] = (char)0;
    if (n <= 2) 
    { if (stra[0] == '-') {goto fin;}
      else {ht[0] = '-';}
    }
/* wenn sich \emph{Textwert}- am Ende einer Zeile ergibt, dann steht 
                >Textwert -< in .dvi-Datei, deshalb:
*/
    if (stra[n-2] == ' ') {stra[n-2] = '}';}

    while ((k>0) && (stra[k-1] != ' '))
    { if (k==0) {goto fin;}
      k--;
    }
fin:
   memset(&wortanf[0], (char)0,laenge_puf);
   return strcat(strncpy(&wortanf[0],&stra[k],n-k),&ht[0]);
  } 

char *wortende(char *str)
  { int n,k,k1;
    n = strlen(str); 
    k1 = 0; k = 0;
    while ((str[k1] == ' ') && (k1 <= n)) k1++;
    if (k1 == n) goto fin;
    k = k1;
    while ((k<n) && (str[k] != ' ')) k++;
fin:
    memset(&wortend[0],(char)0,laenge_puf);
    return strncpy(&wortend[0],&str[k1],k-k1);
  }

void f_set_pos(int k)
  { int k1;
    for (k1=1; k1 <= k; k1++)
    { fprintf(a_file,"%c", ' '); }
  }

void set_pos(int k)
  { int k1;
    for (k1=1; k1 <= k; k1++)
    { printf("%c", ' '); }
  }

char *strip(char *str)
  { int k;
    k = strlen(str); 
    while ((k>0) && (str[k-1] == ' ')){ str[k-1] = (char)0; k--;};
    return str;
  }

char vergl_test(char * tcp)
  { int p1;
    p1 = 0;
    while ( p1 < hck_max)
    { if (strcmp(tcp, &hck[p1][0]) == 0) {anzgef++; return TRUE;}
      p1++;
    }
    p1 = 0;
    while ( p1 <= neu_max)
    {
      if (strcmp(tcp, &neu[p1][0]) == 0) {anzgef++; return TRUE;}
      p1++;
    }
    neu_max++;
    if (neu_max > laenge_neu) { neu_max = laenge_neu; }
    else  strcpy(&neu[neu_max][0],tcp);
    return FALSE;
  }

char zugelassen(char sta, unsigned char c)
  { int rc;
    if ((c == '-') || (isalpha(c)>0)) return TRUE;
    rc = (unsigned char) c;
/*  Nationals nach DIN 66 303, Tab 1; `A bis ''y, ohne \times und \div.*/
    if (strcmp(font_code, FONT_CODE_1) == 0)
       {if ((rc >= 192) && (rc != 215) && (rc != 247)) {return TRUE;};}
     if (strcmp(font_code, FONT_CODE_2) == 0)

/*  Cork-Tabelle, Sept 1990  */
     { if ((rc >= 128) && (rc != 159)
                       && (rc != 189)
                       && (rc != 190)
                       && (rc != 191)) {return TRUE;}
     }
     if (sta == TRUE) { if (c == '"') {return TRUE;}};
     return FALSE;
  }

char* text_clear(char * str, int* p)
  { unsigned n; char cc;
    n = 0; *p = 0;
    while (strlen(str) > 0)
    { cc = (char) str[strlen(str)-1];
      if (zugelassen(FALSE,cc) == FALSE) 
      { str[strlen(str)-1] = (char) 0;}
      else goto trail;
    }
trail:
    while (n < strlen(str))
    { cc = (char) str[n];
      if (zugelassen(TRUE,cc) == FALSE) {n++;}
      else goto fin;
    }
fin:
    *p =  n;
    memset(&hh1[0],(char)0,laenge_puf);
    return strncpy(&hh1[0], &str[n], strlen(&str[n]));
  }

void eop(void)
  { char gef;
    char * ttp, *ttap,*tgesp, *tcp, *terr;
    int ttapl,ntc;
    a_outimage();
    s_max = s_p-1;
    s_p = 0;
    test_neue_seite();
    while  (s_p <= s_max)
    { ttp = strip(seitep[s_p]);
      gef = gefunden(ttp);
      if (gef == TRUE)
      { ttap = wortanfang(ttp);
        ttapl = strlen(ttap);
        if (mitte-ttapl > 1) {pos1 = mitte-ttapl;} else pos1 = 1;
        s_p++; if (s_p > s_max) goto hinter_schl;
	if (ttapl < 2){gef = FALSE; goto schl;};
	if (ttapl == 2){if (ttap[0] == '}'){gef = FALSE; goto schl;};};
        test_neue_seite();
        ttp = strip(seitep[s_p]);
        terr = wortende(ttp);
        tgesp = strcat(ttap,terr);
        gesamt++;
        strcpy(&hh[0],tgesp);
        tcp = text_clear(&hh[0],&ntc);
        if (vergl_test(tcp) == FALSE)
        { if (vorschub == TRUE) {printf("\n"); np = 0; vorschub = FALSE;}
          if (a_file != NULL){f_set_pos(pos1+ntc);fprintf(a_file,"%s\n",tcp);};
          set_pos(pos1+ntc); printf("%s\n",tcp);
          tr_gef = TRUE;
        }
        goto schl;
      }
      s_p++; if (s_p > s_max) goto hinter_schl;
      test_neue_seite();
schl: ;
    }
hinter_schl:
    if (gef == TRUE)
    { if (vergl_test(ttap) == FALSE)
      {
        strcpy(&hh[0],ttap);
        gesamt++;
        tcp = text_clear(&hh[0],&ntc);
        if (vorschub == TRUE) {printf("\n"); np = 0; vorschub = FALSE;};
        if (a_file != NULL){f_set_pos(pos1+ntc); fprintf(a_file,"%s\n",tcp);};
        set_pos(pos1+ntc);  printf("%s\n",tcp);
      }
    }
    s_p = 0;
  }

long pow(int b,int p)
  { long w,k;
    w = b;
    for (k=1; k < p; k++) {w = w *b;};
    return w;
  }

void eingabe(long* dd, unsigned char k)
  { char neg; unsigned char hk;
    long hn,hw; 
    hw = (int) e_inbyte();
    neg = FALSE;
    if (hw > 127) {neg = TRUE;};
    for (hn = 2; hn <= (long) k; hn++) 
    { hk = e_inbyte();
      hw = hw*256+hk;
    };
    if (neg == TRUE) {*dd = -(pow(2,k*8))+hw; } else *dd = hw;
  }

void right(unsigned char code)
  { eingabe(&d_r, code-142);
    if (d_r > r_grenze) a_outchar(' ');
    if (d_r > r_grenze_zeile) a_outimage();
  }

void w0(void)
  { if (d_w > w_grenze) a_outchar(' ');
    if (abs(d_w) > w_grenze_zeile) a_outimage();
  }

void w(unsigned char code)
  { eingabe(&d_w, code-147);
    if (d_w > w_grenze) a_outchar(' ');
    if (d_w > w_grenze_zeile) a_outimage();
  }

void x0(void)
  { if (d_x > x_grenze) a_outchar(' ');
    if (abs(d_x) > x_grenze_zeile) a_outimage();
  }

void x(unsigned char code)
  { eingabe(&d_x, code-152);
    if (d_x > x_grenze) a_outchar(' ');
    if (d_x > x_grenze_zeile) a_outimage();
  }

void down(unsigned char code)
  { eingabe(&d_v, code-156);
    if (d_v > v_grenze_zeile) a_outimage();
  }

void y0(void)
  { if (d_y > y_grenze)  a_outimage();
    if (abs(d_y) > y_grenze_zeile) a_outimage();
  }

void y(unsigned char code)
  { eingabe(&d_y, code-161);
    if (d_y > y_grenze) a_outchar(' ');
    if (d_y > y_grenze_zeile) a_outimage();
  }

void z0(void)
  { if (d_z > z_grenze) a_outimage();
    if (abs(d_z) > z_grenze_zeile) a_outimage();
  }

void z(unsigned char code)
  { eingabe(&d_z, code-166);
    if (d_z > z_grenze) a_outchar(' ');
    if (d_z > z_grenze_zeile) a_outimage();
  }

void xxx(unsigned char code)
  { long hn,hw,hk,hk1;
    hk = (int) code-238;
    hw = (int) e_inbyte();
    for (hn=2; hn <= hk; hn++) 
    { hk1 = (int) e_inbyte();
      hw = hw * 256 + (long) hk1;
    }
    skip(hw);             
  }

void fnt_def(unsigned char code)
  { long hw,hk; 
    skip(code - 230);                       /* skip k[1] bzw k[4]  */
    hw = (int) e_inbyte();                  /* Lesen a[1]          */
    hk = (int) e_inbyte();                  /* Lesen l[1]          */
    skip(2*hw+hk);                          /* skip a + 1          */
  }

void pre(void)
  { long num,den,hn; 
    double frac;

    skip(1);
    num = (long) e_inbyte();
    for (hn = 2; hn <= 4; hn++)
    {
      num = num * 256 + (long) e_inbyte();
    };

    den = (long) e_inbyte();
    for (hn = 2; hn <= 4; hn++)
    {
      den = den * 256 + (long) e_inbyte();
    };
 
    frac = den*10000.0/num;

    r_grenze = xfaktor*0.25*frac+0.5; r_grenze_zeile = yfaktor*  5*frac+0.5;
    v_grenze = xfaktor*1.0 *frac+0.5; v_grenze_zeile = yfaktor*3.2*frac+0.5;
    w_grenze = xfaktor*0.25*frac+0.5; w_grenze_zeile = yfaktor* 25*frac+0.5;
    x_grenze = xfaktor*0.25*frac+0.5; x_grenze_zeile = yfaktor*3.5*frac+0.5;
    y_grenze = xfaktor*0.05*frac+0.5; y_grenze_zeile = yfaktor*0.5*frac+0.5;
    z_grenze = xfaktor*0.05*frac+0.5; z_grenze_zeile = yfaktor*3.5*frac+0.5;

/*
 folgende Werte sollten ungefaehr gesetzt sein:

  r_grenze = 50000;  r_grenze_zeile = 1000000;
  v_grenze = 10000;  v_grenze_zeile =  600000;
  w_grenze = 50000;  w_grenze_zeile = 5000000;
  x_grenze = 50000;  x_grenze_zeile =  700000;
  y_grenze = 10000;  y_grenze_zeile =  100000;
  z_grenze = 10000;  z_grenze_zeile =  700000;
*/
  }


int main(int n_arg, char *v_arg[])
  {

/***********************************************************/ 
#ifdef  __BORLANDC__
    _fmode = O_BINARY;
#endif
/***********************************************************/ 

    font_codep = strcpy(&font_code[0],FONT_CODE_2);
    verdateip = NULL;
    if (setvbuf(stdout,NULL,_IOLBF,0) != 0)
      { perror("setvbuf"); exit(1);}
    printf("\n%s ",v_arg[0]); printf("version 14.8.2000\n");
    if (n_arg >= 3) 
    { if (strcmp(v_arg[1],"-c") == 0)
      { font_codep = strcpy(&font_code[0],v_arg[2]);
        if (n_arg == 3)
        { printf("missing file name; exit\n");
          goto schluss;
        }
        else
        { hauptdateip = strcpy(&hauptdatei[0],v_arg[3]);
          if (n_arg >= 5)
          { verdateip = strcpy(&verdatei[0],v_arg[4]);}
        }
      }
      else
      { hauptdateip = strcpy(&hauptdatei[0],v_arg[1]);
        verdateip = strcpy(&verdatei[0],v_arg[2]);
      }
    }
    else
    if (n_arg == 1)
    { printf("missing file name; exit\n");
      goto schluss;
    }
    else 
    { hauptdateip = strcpy(&hauptdatei[0],v_arg[1]);
      if (n_arg == 3) {verdateip = strcpy(&verdatei[0],v_arg[2]);};
    };

    if ((strlen(hauptdateip) <= 4) || (strstr(hauptdateip,".dvi") == 0))
    { hauptdateip = strcat(hauptdateip,".dvi");
    };

    ausdateip = strncpy(&ausdatei[0],hauptdateip, strlen(hauptdateip)-4); 
    ausdateip = strcat(ausdateip,".hyp"); 

    filed1=open(hauptdateip,O_RDONLY);    
    if ((int)filed1 <= 0) {printf("\ninput file not found\n");goto schluss;}

    a_file=fopen(ausdateip,"w+");    
    if (a_file == NULL)
      {printf("\nwarning: could not open file %s for writing\n",ausdateip);};
    if (verdateip == NULL) {}
    else
    { ver_dat = fopen(verdateip,"r");    
      if (ver_dat == NULL) {printf("\nfile not found: %s\n",verdateip);}
    else
    { hck_p = 0;
      fscanf(ver_dat,"%s", & hck[hck_p][0]);
      while (feof(ver_dat) == 0)
      { hck_p++;
        if (hck_p >= laenge_hck)
        { printf("\nwarning: more than %d lines in file %s\n",
                  laenge_hck,verdateip);
          goto weiter;
        }
        fscanf(ver_dat,"%s", & hck[hck_p][0]);
      }
weiter:
     hck_max = hck_p;
    }
    }

    tr_gef = FALSE;

    printf("coding: %s\n",font_codep); 
    printf("same words are given only once\n\n"); 

    s_puffer_p = 0; s_p = 0; enthalten = FALSE;
    anzgef = 0; neu_max = 0; np = 0;

    k =  e_inbyte();
    while (E_ENDFILE == FALSE)
      {
      if      (k == 0) {;}                         /* set_char_0            */
      else if (special_char(TRUE,k) == TRUE) {;}/* Ligatur, sz -- u. ---    */
      else if (k <= 126) {set_char_k(k);}       /* Ausgabe druckb. Zeichen  */
      else if (k == 127) {umlaut();}            /* Umlautzeichen wird zu "  */
      else if (k <= 131) {set_put(k-128);}      /* set1 bis set4            */
      else if (k == 132) {skip(8);}             /* set_rule                 */
      else if (k <= 136) {set_put(k-133);}      /* put1 bis put4            */
      else if (k == 137) {skip(8);}             /* put_rule                 */
      else if (k == 138) {;}                    /* nop (no operation)       */
      else if (k == 139) {bop(k);}              /* Seiten-Beginn            */
      else if (k == 140) {eop();}               /* Seiten-Ende              */
      else if (k == 141) {;}                    /* push                     */
      else if (k == 142) {;}                    /* pop                      */
      else if (k <= 146) {right(k);}            /* right1 bis right4        */
      else if (k == 147) {w0();}                /* w0                       */
      else if (k <= 151) {w(k);}                /* w1 bis w4                */
      else if (k == 152) {x0();}                /* x0                       */
      else if (k <= 156) {x(k);}                /* x1 bis x4                */
      else if (k <= 160) {down(k);}             /* down1 bis down4          */
      else if (k == 161) {y0();}                /* y0                       */
      else if (k <= 165) {y(k);}                /* y1 bis y4                */
      else if (k == 166) {z0();}                /* z0                       */
      else if (k <= 170) {z(k);}                /* z1 bis z4                */
      else if (k <= 234) {;}                    /* Fontumschaltungen        */
      else if (k <= 238) {skip(k-234);}         /* fnt1 bis fnt4            */
      else if (k <= 242) {xxx(k);}              /* xxx1 bis xxx4            */
      else if (k <= 246) {fnt_def(k);}          /* Font-Definitionen        */
      else if (k == 247) {pre();}               /* Praeambel            */
      else if (k == 248) {break;}               /* Ueberlesen Post,Post_post*/
      ;   
      k =  e_inbyte();
    };

    close(filed1);

    printf("\nnumber of hyphenations:%5ld\n",gesamt);
    printf("already known/multiple:%5ld\n",anzgef);

    if (n_t1_ot1 > 0) 
    { printf("%d\n",n_t1_ot1);
      printf("warning: coding OT1 used, T1 may be correct\n"); 
    };
    if (a_file != NULL) {fclose(a_file);}
    else
      {printf("\nwarning: could not open file %s for writing\n\n",ausdateip);};
    exit(0);
schluss:  exit(1);
  }
