/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.ArrayList;
import net.sourceforge.texlipse.bibeditor.BibColorProvider;
import net.sourceforge.texlipse.bibeditor.BibStringRule;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class BibEntryScanner
extends RuleBasedScanner {
    public BibEntryScanner(BibColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor("key.BibColor")));
        Token type = new Token((Object)new TextAttribute(provider.getColor("typ.BibColor")));
        Token string = new Token((Object)new TextAttribute(provider.getColor("str.BibColor")));
        new Token((Object)new TextAttribute(provider.getColor("slc.BibColor")));
        new Token((Object)new TextAttribute(provider.getColor("def.BibColor")));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new BibSeparatorRule((IToken)keyword));
        rules.add(new BibStringRule((IToken)string));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new BibWordDetector(), (IToken)type);
        rules.add(wordRule);
        rules.add(new NumberRule((IToken)string));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public class BibSeparatorRule
    implements IRule {
        protected IToken fToken;

        public BibSeparatorRule(IToken token) {
            Assert.isNotNull((Object)token);
            this.fToken = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if ((char)c == '=' || (char)c == '#' || (char)c == ',' || (char)c == '{' || (char)c == '}') {
                return this.fToken;
            }
            if ((char)c == '\\') {
                c = scanner.read();
                if ((char)c == '\"') {
                    return this.fToken;
                }
                scanner.unread();
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    public class BibWordDetector
    implements IWordDetector {
        public boolean isWordPart(char character) {
            return Character.isLetterOrDigit(character);
        }

        public boolean isWordStart(char character) {
            return Character.isLetter(character);
        }
    }

    private class WhitespaceDetector
    implements IWhitespaceDetector {
        private WhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

