[INHERIT('UTILITYOPS','SCREENHANDLERS','ARGOPS'), environment('basicfileops')]

MODULE BASICFILEOPS;

CONST

   maxfidchars = 255;
   ndatetimechars = 11;                     
   programversion = 'CVF02B';
   inifilename = 'INIT$RNOTOTEX';
   logfilename = 'RNOTOTEX.LOG';


TYPE

fidtype = VARYING[maxfidchars] of char;

datetimetype = packed array[1..ndatetimechars] of char;

                                    
VAR
   inputcontainstexcommands : [EXTERNAL] boolean;
   totallines, totalchars    : [EXTERNAL] integer;
   LOG	                       : [EXTERNAL] text;




[GLOBAL] PROCEDURE noconversion;
begin
  writeln(log,'[no conversion performed]')
end;




[GLOBAL] PROCEDURE greetuser ( var d, t : datetimetype );
begin
   date( d );
   time( t );
   clearscreen;
   ttywritestring('RNOTOTEX ');
   ttywritestring(programversion);
   ttywritestring('    RUNOFF TO TEX CONVERSION    ');
   ttywritestring( d );
   ttywritestring( t );
   ttywriteln;
   ttywriteln;
   ttywriteln
end;
    




[GLOBAL] PROCEDURE openinputfile( fid : fidtype; var f : text; var openerror : boolean );
begin
   open( file_variable := f,
         file_name := fid,
         history := readonly,
         default := 'INPUT.RNO',
         error := continue );                                     
   if status(f) <> 0 then
      openerror := true
   else                  
   begin 
      reset( f );
      openerror := false      
   end
end;
                       




[GLOBAL] PROCEDURE openoutputfile(fid : fidtype; var f : text; var openerror:boolean);
begin
     open( file_variable := f,
           file_name := fid,
           history := new,
           default := 'OUTPUT.TEX',
           error := continue );
     if status(f) <> 0 then
        openerror := true
     else
     begin
        openerror := false;
        rewrite(f)
     end;
end; 

    

[GLOBAL] PROCEDURE openinifile ( var f : text );
begin
    open( file_variable := f,
          file_name := inifilename,
          history := readonly,
          error := message );
    reset( f );                                            
    ttywriteln;
    ttywritestring('Loading INI file ...')
end;
          
    

                                                    
[GLOBAL] PROCEDURE openlogfile; { global var LOG : text used }
begin
   open( file_variable := log,
	 file_name := logfilename,
	 history := new,
	 error := continue );
   rewrite( log )
end;



[GLOBAL] PROCEDURE closelogfile; 
begin
   close( file_variable := log, error := continue )
end; 
         
[GLOBAL] PROCEDURE closeinifile( var f : text );
begin
    close( file_variable := f, error := continue );
    ttywritestring('complete.');
    ttywriteln;
end;





[GLOBAL] PROCEDURE closefiles( var infile, outfile : text );

begin
   close(file_variable := infile, error := continue);
   close(file_variable := outfile, error := continue);
   ttywritestring('complete.');
   ttywriteln;
   ttywriteln;
   ttywriteln;
   if totallines = 1 then               
      ttywritestring(' RNOTOTEX read only one line from the input file.')
   else
     if totallines = 0 then
       ttywritestring(' No end of line was found in the input file.')
     else                                                  
     begin
       ttywritestring(' RNOTOTEX processed a total of ');
       ttywriteint( totallines );
       ttywritestring(' lines.')
     end;
   ttywriteln;
   if totalchars = 1 then
      ttywritestring(' There was only one character in the file.')
   else
      if totalchars = 0 then
        ttywritestring(' No printable characters were found in the file.')
      else
      begin
         ttywritestring(' A total of ');
         ttywriteint( totalchars );
         ttywritestring(' characters were read.')                           
      end;
   ttywriteln
end;

    




[GLOBAL] PROCEDURE putcommentstooutput( var outfile : text; infid : fidtype;
	                                d, t : datetimetype );
begin
   writeln(outfile,'% document translated from DEC RUNOFF to LaTeX format');
   writeln(outfile,'% by program RNOTOTEX version ',programversion,' at ',d,blank,t);
   writeln(outfile,'% Source file :',infid);
   writeln(log,'[RNOTOTEX.LOG for ',infid,' ]');
   writeln(log,'[Processing at ',d, blank, t,' ]')
end;               


             


[GLOBAL] PROCEDURE userinterface( var inputfid, outputfid : fidtype;
	                           var rno, tex : text );

type
    packedarray = packed array[1..255] of char;

var
   openerror : boolean;
   slashtex : integer;

   procedure getcli( var ifile, ofile : [class_s] packedarray;
                     var slashtex : integer ); fortran;
begin
      getcli( inputfid.body, outputfid.body, slashtex );
      inputfid.length := 75;
      outputfid.length := 75;
      openinputfile( inputfid, rno, openerror);
      if openerror then
        warningmessage('openinputfile','Could not open that input file.');
      openoutputfile( outputfid, TEX, openerror);
      if openerror then
         warningmessage('openoutputfile','Could not open that output file.');
      inputcontainstexcommands := slashtex <> 0
end;


END.
