/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : textdata.cc
--*/

#include <ctype.h>
#include <fstream.h>
#include "textdata.h"
#include "string.h"
#include "quote.h"

/****************************************************************************
  class TextData
--*/

TextData::TextData( istream& i ) :
    cursor( &NOTEXTRECORD ),
    _eof( 0 ),
    is( i )
{
    get();
}

TextData::~TextData()
{
///    if ( *cursor != NOTEXTRECORD )
///        delete cursor;
}

TextData::operator int() const
{ 
    return !_eof; 
}

TextRecord& TextData::operator ++( POSTFIX_INT )
{
    static TextRecord* record;
    if ( !*this ) 
        {
        error( "get from empty data", __FILE__, __LINE__ );
        return NOTEXTRECORD;
        }

//    if ( *record != NOTEXTRECORD )
//        delete record;

    record = cursor;
    get();
    return *record;
}

int TextData::get()
{
    static char buf[ LINE_MAX + 1 ];

    if ( !*this )
        return 1;
    
    char c = is.peek();
    buf [ 0 ] = 0;
 
    while ( ( !*buf || ( *buf == '#' ) ) && ( c != (char)EOF ) )
        {
        is.get( buf, LINE_MAX, '\n' );
        char* p = buf;
        while ( *p )
           {
           if ( *p == '#' )
               break;
           p++;
           }
        *p = 0;
        is.get( c );               // get the \n
        c = is.peek();
        }
    
//    if ( *cursor != NOTEXTRECORD )
//        delete cursor;
    cursor = new TextRecord( buf );
    
    _eof = ( ( c == (char)EOF ) || !*buf || ( *buf == '#' ) );
    return _eof;
}

//-- class TextData //

/****************************************************************************
  class TextDataFile
--*/

TextDataFile::TextDataFile( const char* name ) :
    TextData( *new ifstream( name ) ),
    filename( name )
{
    if ( !is ) 
        {
        error( quoteString( "can't open", filename ), __FILE__, __LINE__ );
        return;
        }
    cout << "(" << name << flush;
//    is.flags( is.flags() & ~ios::skipws );
}

TextDataFile::~TextDataFile()
{
//    delete &(ifstream&)is;
    cout << ") " << flush;
}

//-- class TextDataFile //

/****************************************************************************
  class TextRecord
--*/

TextRecord::TextRecord( const char* s ) :
    cursor( *new String ),
    line( *new String( s ) )
{
    ;// cout << "TextRecord: " << line << endl;
    get();
}

TextRecord::~TextRecord()
{
///    delete &cursor;
///    delete &line;
}

TextRecord::operator int() const
{ 
    return ( line.len() || cursor.len() );
}

const char* TextRecord::operator ++(  POSTFIX_INT )
//String TextRecord::operator ++(  POSTFIX_INT )
{
    if ( !*this ) 
        {
        error( "get from empty record", __FILE__, __LINE__ );
        return 0;
        }
                               // this char[] is never destroyed
    char* s = new char [ cursor.len() + 1 ];
    cursor( s );
//    String s = cursor;
    ;// cout << "`" << s << "\'" << endl;

    if ( *this )
        get();

    return s;
}

int TextRecord::fieldLength( const String& s )
{
    int lastPos = s.pos( ',' ) - 1;
    if ( lastPos < 0 )
        lastPos = s.len();

    while ( ( lastPos > 0 ) && isspace( s[ lastPos - 1 ] ) )
        lastPos--;
    return lastPos;
}

int TextRecord::get()
{
    if ( !*this )
        return 1;
        
    int n = fieldLength( line );
    cursor = line.left( n );
    int i = 0;
    while ( ( i < n ) && isspace( cursor[ i ] ) )
        i++;
    if ( i )    
        cursor = cursor.right( n - i );
#if 1
    line = line.right( line.len() - n - 1 );
    ;// cout << "get: " << cursor << "; " << line << endl;
#else    
    ;// cout << "get (line.left): " << line.left( n ) << endl;
    ;// cout << "get (line.right): " << line.right( line.len() - n - 1 ) << endl;
    String remainder( (const char*)line.right( line.len() - n - 1 ) );
    line = remainder;
    ;// cout << "get: " << cursor << "; " << remainder << " = " << line << endl;
#endif
    return ( *this );
}

void TextRecord::printOn( ostream& os ) const
{
    os << line;
}

//-- class TextRecord //

