/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: /usr/fsys/odin/a/vern/flex/RCS/flex.skel,v 2.16 90/08/03 14:09:36 vern Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif	/* __GNUC__ */

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#define const
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
char *malloc();
int free();
int read();
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, yytext is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
	    YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		YY_FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do \
		{ \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void )) 

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR char
# line 1 "l2x.l"
#define INITIAL 0
# line 2 "l2x.l"
/*
 * l2x.l     --- (flex) lexer for converting a LaTeX file to X 
 *           Written by Peter Wilson (Catholic University and NIST)
 *           Version 0.2, January 1995
 *           Revised July 1996
 *           -- replace myprint(tag) by tag_print(tag)
 *           -- added verb(atim) like capability
 */

/* Development of this software was funded by the United States Government,
 * and is not subject to copyright.
 */

#include <string.h>
#ifndef STRTYPES_H
#include "strtypes.h"
#endif
#ifndef L2XCOM_H
#include "l2xcom.h"
#endif
#include "l2xytab.h"     /* token codes from parser */
#include "l2xlib.h"      /* functions and global variables */
#include "l2xusrlb.h"    /* possibly useful strings and user-defined functions */


extern int opt_param;
extern int all_opt;
extern int opt_coord;
int got_opt_item = FALSE;
int got_a_dollar = FALSE;
int got_opt_param = FALSE;
int got_all_opt = FALSE;
int got_opt_coord = FALSE;


char verb_char;         /* delimeter for \verb command */
int result;
int kind;
int special_kind;
PSENTRY ptr;            /* pointer to sym entry */
int nl_count = 0;       /* number of consecutive new lines */
char a_newline[] = "\n";
char a_space[] = " ";
char vlenv[80];         /* name of verbatim-like environment */
int nopen_vbrace = 0;   /* no of unmatched open braces after verb-like command */

int nopen_noop = 0;     /* no of unmatched openers for no_op argument */
#define NOOPLBRAK 1
#define NOOPRBRAK 1
#define NOOPLBRACE 2
#define NOOPRBRACE 2
int noop_openc;        /* noop argument opening character ( [ or { )*/

#define LDA -1
#define LD0 0
#define LD1 1
#define LD2 2
#define LD3 3
#define LD4 4
#define LD5 5 
#define LD6 6
/*
 * LDEBUG > LDA: error prints:
 *        > LD0:               names not in command table
 *        > LD1:               newlines, returned useful tokens
 *        > LD2:               general tokens
 *        > LD3:               text dealt with in lexer
 *        > LD4:               comments
 *        > LD5:               stuff within verbatims
 *        > LD6:
 *
 */

/* whitespace and comments */
/* TeX comments from % through eol + any following whitespace */
/* general REs */
/* (La)TeX literals */
/* general LaTeX commands */
/* list items */
#define VERBATIM_STATE 1
#define VERB_STATE 2
#define VERBATIM_LIKE 3
#define VERB_LIKE 4
#define NOOP 5
# line 122 "l2x.l"

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = yy_bp; \
	yyleng = yy_cp - yy_bp; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do \
		{ \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;	

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 57
typedef int yy_state_type;
static const short int yy_accept[171] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   57,   55,   52,   53,   38,   39,   44,   40,
       50,   51,   49,   55,   55,   47,   45,   46,   36,   55,
       37,   43,   42,   34,   35,   41,    7,    5,    6,   10,
       11,   18,   17,   18,   15,   14,   12,   13,   24,   23,
       20,   22,   19,   21,   52,   53,   53,    0,    1,    0,
       47,   48,   48,   46,   46,   29,   28,   27,   31,   29,
       31,   31,   31,   31,    7,    0,    0,    1,   48,   31,
        0,   30,   31,   31,   31,   31,    0,    0,   31,   31,
       31,   31,    0,    0,   31,    0,    0,   25,   31,    0,

        0,    0,    0,   31,    0,    0,    0,   25,   26,    9,
        9,    9,    0,    0,    0,    0,    0,    0,    0,    0,
       33,    0,    0,    0,    0,   16,    0,    0,    0,    0,
        0,    0,    0,    0,   32,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    3,    0,
        0,    8,    0,    0,    0,    2,    0,    0,    4,    0
    } ;

static const YY_CHAR yy_ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    1,    5,    6,    7,    8,    1,    9,
       10,   11,    1,   12,   13,   14,    1,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,    1,    1,    1,
        1,    1,    1,   16,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       18,   19,   20,   21,   22,    1,   23,   24,   25,   26,

       27,   17,   28,   17,   29,   17,   17,   17,   30,   31,
       32,   17,   17,   33,   17,   34,   35,   36,   17,   17,
       17,   17,   37,    1,   38,   39,    1
    } ;

static const YY_CHAR yy_meta[40] =
    {   0,
        1,    2,    3,    2,    1,    1,    1,    1,    1,    1,
        4,    1,    1,    1,    1,    1,    5,    1,    3,    1,
        1,    1,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    1,    1,    1
    } ;

static const short int yy_base[183] =
    {   0,
        0,    0,   37,   38,  365,  362,   39,   40,   41,   43,
       45,   48,  364,  438,   50,   43,  438,  438,  360,  438,
      438,  438,  438,   35,  346,   46,  438,  349,  438,   86,
      438,  438,  438,  438,  438,  438,    0,  438,  330,  438,
      438,  438,  438,  329,  438,  438,  438,  438,  438,  438,
      438,  438,  438,  438,   67,   60,   70,  350,   71,  336,
       62,  330,  300,  438,  285,  438,  438,  438,  281,  124,
      116,  118,  119,  120,    0,  258,  257,  130,  259,  438,
      134,  438,   56,  122,  128,  126,  247,  246,  129,  140,
      130,  139,  150,  160,  135,  163,  166,  167,  200,  238,

      241,  242,  170,  245,  177,  246,  239,  171,  438,  438,
      274,  259,  250,  242,  178,  249,  257,  254,  274,  279,
      438,  243,  234,  291,  309,  438,  312,  316,  234,  238,
      229,  239,  317,  320,  438,  237,  222,  211,  176,  163,
      172,  168,  160,  163,  168,  159,  159,  159,  150,  149,
      146,  130,  128,  321,  324,  122,   25,  328,  438,  329,
      332,  438,  335,  338,  339,  438,  342,  348,  438,  438,
      386,  391,  396,  401,  406,  411,  413,  418,  420,  424,
      428,  432
    } ;

static const short int yy_def[183] =
    {   0,
      170,    1,  171,  171,  172,  172,  173,  173,  174,  174,
      175,  175,  170,  170,  170,  170,  170,  170,  176,  170,
      170,  170,  170,  170,  170,  170,  170,  177,  170,  170,
      170,  170,  170,  170,  170,  170,  178,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  176,  170,  170,
      170,  170,  170,  170,  177,  170,  170,  170,  179,  170,
      179,  179,  179,  179,  178,  170,  170,  170,  170,  170,
      170,  170,  179,  179,  179,  179,  170,  170,  179,  179,
      179,  179,  170,  170,  179,  170,  180,  179,  170,  170,

      170,  170,  181,   90,  180,  180,  106,  170,  170,  170,
       99,  179,  170,  170,  181,  181,  170,  182,  170,  170,
      170,  106,  170,  170,  170,  170,  182,  182,  128,  128,
      106,  170,  170,  170,  170,  128,  128,  106,  170,  128,
      128,  106,  170,  128,  128,  106,  170,  128,  128,  106,
      170,  128,  128,  106,  170,  128,  128,  170,  170,  170,
      170,  170,  128,  128,  170,  170,  170,  170,  170,    0,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170
    } ;

static const short int yy_nxt[478] =
    {   0,
       14,   15,   16,   15,   17,   18,   19,   20,   21,   22,
       14,   23,   24,   25,   26,   27,   28,   29,   30,   31,
       32,   33,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   34,   35,   36,   38,
       38,   43,   43,   46,   57,   46,   57,   50,   60,   61,
       50,   55,   56,   55,  164,   39,   39,   44,   44,   63,
       61,   57,   51,   57,   52,   51,   80,   52,   55,   56,
       55,   57,   78,   57,   78,   63,   61,   47,   48,   47,
       48,   53,   54,   89,   53,   54,   66,   66,   67,   68,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,

       66,   66,   69,   66,   70,   66,   66,   66,   69,   71,
       69,   69,   72,   69,   73,   69,   69,   69,   69,   69,
       69,   74,   66,   66,   66,   81,   80,   81,   80,   80,
       80,   78,   80,   78,   82,   81,   80,   81,   80,   80,
       80,   96,   83,   96,   82,   80,   86,   90,   84,   80,
       80,  100,   85,  100,   91,  163,  157,   95,   92,   98,
      156,  102,   99,  102,   96,  104,   96,  105,  108,  105,
      108,  115,  108,  115,  108,  155,   97,   80,  105,  115,
      105,  115,  154,  153,  109,  152,  101,  151,  109,  150,
      149,  107,  148,  147,  146,  145,  103,  144,  143,   97,

      110,  110,  107,  110,  110,  110,  110,  110,  110,  110,
      111,  110,  110,  110,  110,  110,  112,  110,  110,  110,
      110,  110,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  110,  110,  110,  100,
      142,  100,  113,  102,  113,  102,  117,  119,  117,  119,
      124,  113,  124,  113,  141,  127,  120,  127,  117,  125,
      117,  140,  139,  138,  137,  136,  132,  131,  123,   80,
      122,   94,   93,   79,  101,  119,  114,  119,  103,  129,
      119,  118,  119,  121,  110,  114,  126,   88,   87,  130,
      110,   80,  124,  118,  124,   64,  110,  110,  110,  110,

      110,  110,  110,  110,  110,  110,  110,  110,  110,  110,
      124,  121,  124,  127,   79,  127,  121,  133,  133,  133,
      133,  133,  158,  133,  158,  160,  134,  160,  126,  158,
      160,  158,  160,  160,  161,  160,  165,  129,  165,  167,
      165,  167,  165,  167,   62,  167,  126,  130,  168,  167,
       62,  167,   59,  135,  135,   77,   76,  135,  159,   64,
       62,  162,   59,  170,   41,  159,  162,   41,  170,  162,
      170,  170,  166,  170,  170,  169,  166,  170,  170,  169,
      170,  170,  170,  170,  170,  169,   37,   37,   37,   37,
       37,   40,   40,   40,   40,   40,   42,   42,   42,   42,

       42,   45,   45,   45,   45,   45,   49,   49,   49,   49,
       49,   58,   58,   58,   58,   58,   65,   65,   75,   75,
      170,   75,   75,   69,   69,  106,  170,  170,  106,  116,
      170,  170,  116,  128,  170,  170,  128,   13,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170
    } ;

static const short int yy_chk[478] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        4,    7,    8,    9,   16,   10,   16,   11,   24,   24,
       12,   15,   15,   15,  157,    3,    4,    7,    8,   26,
       26,   56,   11,   56,   11,   12,   83,   12,   55,   55,
       55,   57,   59,   57,   59,   61,   61,    9,    9,   10,
       10,   11,   11,   83,   12,   12,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,

       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   70,   71,   70,   72,   73,
       74,   78,   84,   78,   70,   81,   86,   81,   85,   89,
       91,   90,   71,   90,   81,   95,   74,   84,   72,   92,
       90,   93,   73,   93,   85,  156,  153,   89,   86,   91,
      152,   94,   92,   94,   96,   95,   96,   97,   98,   97,
       98,  103,  108,  103,  108,  151,   90,   98,  105,  115,
      105,  115,  150,  149,   98,  148,   93,  147,  108,  146,
      145,   97,  144,  143,  142,  141,   94,  140,  139,   96,

       99,   99,  105,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,  100,
      138,  100,  101,  102,  101,  102,  104,  106,  104,  106,
      116,  113,  116,  113,  137,  118,  106,  118,  117,  116,
      117,  136,  132,  131,  130,  129,  123,  122,  114,  112,
      107,   88,   87,   79,  100,  119,  101,  119,  102,  118,
      120,  104,  120,  106,  111,  113,  116,   77,   76,  118,
      111,   69,  124,  117,  124,   65,  111,  111,  111,  111,

      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      125,  119,  125,  127,   63,  127,  120,  128,  133,  128,
      133,  134,  154,  134,  154,  155,  128,  155,  124,  158,
      160,  158,  160,  161,  155,  161,  163,  127,  163,  164,
      165,  164,  165,  167,   62,  167,  125,  127,  164,  168,
       60,  168,   58,  128,  133,   44,   39,  134,  154,   28,
       25,  155,   19,   13,    6,  158,  160,    5,    0,  161,
        0,    0,  163,    0,    0,  164,  165,    0,    0,  167,
        0,    0,    0,    0,    0,  168,  171,  171,  171,  171,
      171,  172,  172,  172,  172,  172,  173,  173,  173,  173,

      173,  174,  174,  174,  174,  174,  175,  175,  175,  175,
      175,  176,  176,  176,  176,  176,  177,  177,  178,  178,
        0,  178,  178,  179,  179,  180,    0,    0,  180,  181,
        0,    0,  181,  182,    0,    0,  182,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



      /*------------ Comments plus start and end document ---------------*/


    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start;
yy_match:
	do
	    {
	    register YY_CHAR yy_c = yy_ec[*yy_cp];
	    if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = yy_def[yy_current_state];
		if ( yy_current_state >= 171 )
		    yy_c = yy_meta[yy_c];
		}
	    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	    ++yy_cp;
	    }
	while ( yy_current_state != 170 );
	yy_cp = yy_last_accepting_cpos;
	yy_current_state = yy_last_accepting_state;

yy_find_action:
	yy_act = yy_accept[yy_current_state];

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
# line 126 "l2x.l"
{
                 if (LDEBUG > LD4) {
                   print_debug_2s("(tex_comment):", yytext);
                 }
                 catl(yyleng, yytext);
                 do_newline();
                 if (leave_comments) {  /* leave in comments */
                   myprint(yytext);
                 }
               }
	YY_BREAK
                 /* \begin{document} */
case 2:
# line 139 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_BEGIN_DOCUMENT):", yytext);
                  }
                  yylval.pos = get_mode_sym(pos_bdoc);
                  return(BEGIN_DOCUMENT);
                }
	YY_BREAK
                /* end of document \end{document} */
case 3:
# line 149 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_END_DOCUMENT):", yytext);
                  }
                  yylval.pos = get_mode_sym(pos_edoc);
                  return(END_DOCUMENT);
                }
	YY_BREAK
  /*----------------- verbatims -----------------------------------------*/
  /* Do most of the processing in the lexer */
  /* but pass token back to parser anyway */
                 /* \begin{verbatim} */
case 4:
# line 166 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(begin{verbatim}):", yytext);
                  }
                  BEGIN VERBATIM_STATE;
                  yylval.pos = get_mode_sym(pos_bvbm);
                  bverb = TRUE;
                  return(BEGIN_VERBATIM);
                }
	YY_BREAK
                /* newline */
case 5:
# line 177 "l2x.l"
{ catl(yyleng, yytext);
                  do_newline();
                  if (LDEBUG > LD3) {
                    print_debug_2s("(newline in verbatim):", yytext);
                  }
                  verbatim_print(yytext);
                }
	YY_BREAK
                 /* backslash */
case 6:
# line 185 "l2x.l"
{ catl(yyleng, yytext);
                  if (LDEBUG > LD5) {
                    print_to_err(yytext);
                  }
                  verbatim_print(yytext);
                }
	YY_BREAK
                /* any characters other than newline and backslash */
case 7:
# line 192 "l2x.l"
{ catl(yyleng, yytext);
                  if (LDEBUG > LD5) {
                    print_to_err(yytext);
                  }
                  verbatim_print(yytext);
                }
	YY_BREAK
                /* \end{verbatim} */
case 8:
# line 199 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(end{verbatim}):", yytext);
                  }
                  BEGIN 0;
                  yylval.pos = get_mode_sym(pos_evbm);
                  return(END_VERBATIM);
                }
	YY_BREAK
                    /* \verb (and its trailing character) */
case 9:
# line 210 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(verb):", yytext);
                  }
                  BEGIN VERB_STATE;
                  verb_char = yytext[yyleng-1];
                  yylval.pos = get_mode_sym(pos_bv);
                  return(BEGIN_VERB);
                }
	YY_BREAK
                   /* chars inside \verb */
case 10:
# line 222 "l2x.l"
{ catl(yyleng, yytext);
                  if (LDEBUG > LD5) {
                    print_to_err(yytext);
                  }
                  if (verb_char != yytext[0] ) {
                    myprint(yytext);
                  }
                  else {                 /* end of verb environment */
                    BEGIN 0;
                    yylval.pos = get_mode_sym(pos_ev);
                    return(END_VERB);
                  }
                }
	YY_BREAK
                   /* newlines not allowed within verb */
case 11:
# line 237 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count++;
                  if (LDEBUG > LD5) {
                    print_to_err(yytext);
                  }
                  BEGIN 0;
                  yyerror("Error: \"verb\" ended by a newline");
                  do_newline();
                  myprint(a_newline);
                  yylval.pos = get_mode_sym(pos_ev);
                  return(END_VERB);
                }
	YY_BREAK
                /* VERB LIKE command stuff */
                   /* { (open brace) */
case 12:
# line 252 "l2x.l"
{ catl(yyleng, yytext);
                      nopen_vbrace++;
                      if (LDEBUG > LD5) {
                        print_to_err(yytext);
                      }
                      if (nopen_vbrace == 1) {    /* start of argument */
                        yylval.pos = get_mode_sym(pos_lbrace);
                        return(LBRACE);
                      }
                      else {                      /* part of argument */
                        verbatim_print(yytext);
                      }
                    }
	YY_BREAK
                  /* } (close brace) */
case 13:
# line 267 "l2x.l"
{ catl(yyleng, yytext);
                      nopen_vbrace--;
                      if (LDEBUG > LD5) {
                        print_to_err(yytext);
                      }
                      if (nopen_vbrace == 0) {    /* end of argument */
                        BEGIN 0;                  /* change state */
                        yylval.pos = get_mode_sym(pos_rbrace);
                        return(RBRACE);
                      }
                      else {                      /* part of argument */
                        verbatim_print(yytext);
                      }
                    }
	YY_BREAK
                 /* newline  */
case 14:
# line 283 "l2x.l"
{ catl(yyleng, yytext);
                       do_newline();
                       if (LDEBUG > LD3) {
                         print_debug_2s("(newline in verb-like):", yytext);
                       }
                       verbatim_print(yytext);
                     }
	YY_BREAK
                 /* any other character */
case 15:
# line 292 "l2x.l"
{ catl(yyleng, yytext);
                      if (LDEBUG > LD5) {
                        print_to_err(yytext);
                      }
                      verbatim_print(yytext);
                    }
	YY_BREAK
                 /* VERBATIM LIKE environment stuff */
                    /* \end{something} */
case 16:
# line 303 "l2x.l"
{ catl (yyleng, yytext);
                      nl_count = 0;
                      get_env_name(yytext);
                      if (strcmp(vlenv, env_name) == 0) { /* close verbatim like */
                        if (LDEBUG > LD1) {
                          print_debug_2s("(end):", yytext);
                          print_debug_2s("env_name= ", env_name);
                        }
                        result = lookup_entry(env_name, END_VENV);
                        if (result > 0) { /* found it */
                          ptr = get_mode_sym(result);
                          yylval.pos = ptr;
                          kind = command_type(ptr);
                          BEGIN 0;
                          return(kind);
                        }
                        else {           /* got problems, end env name not in table */
   warning_3s("END_VENV",env_name,"not in command table. Expect input/output errors from now on");
                          BEGIN 0;
                          verbatim_print(yytext);
                        }
                      }
                      else {      /* not end of verbatim-like env */
                        verbatim_print(yytext);
                      }
                    }
	YY_BREAK
                /* newline */
case 17:
# line 331 "l2x.l"
{ catl(yyleng, yytext);
                  do_newline();
                  if (LDEBUG > LD3) {
                    print_debug_2s("(newline in verbatim-like):", yytext);
                  }
                  verbatim_print(yytext);
                }
	YY_BREAK
                 /* any other character */
case 18:
# line 340 "l2x.l"
{ catl(yyleng, yytext);
                        if (LDEBUG > LD5) {
                          print_to_err(yytext);
                        }
                        verbatim_print(yytext);
                      }
	YY_BREAK
  /*---------------------------No Op processing---------------------------*/
                  /* open brace */
case 19:
# line 350 "l2x.l"
{ catl(yyleng, yytext);
                   if (LDEBUG > LD5) {
                     print_to_err(yytext);
                   }
                   if (noop_openc == NOOPLBRACE) {
                     nopen_noop++;
                   }
                }
	YY_BREAK
                  /* open bracket */
case 20:
# line 360 "l2x.l"
{ catl(yyleng, yytext);
                   if (LDEBUG > LD5) {
                     print_to_err(yytext);
                   }
                   if (noop_openc == NOOPLBRAK) {
                     nopen_noop++;
                   }
                }
	YY_BREAK
                  /* close brace */
case 21:
# line 370 "l2x.l"
{ catl(yyleng, yytext);
                   if (LDEBUG > LD5) {
                     print_to_err(yytext);
                   }
                   if (noop_openc == NOOPLBRACE) {
                     nopen_noop--;
                     if (nopen_noop <= 0) {
                       if (LDEBUG > LD3) {
                         print_to_err("(Closing NO_OP on brace)");
                       }
                       nopen_noop = 0;
                       in_noop = FALSE;
                       start_noop = FALSE;
                       BEGIN 0;
                       yylval.pos = get_mode_sym(pos_rbrace);
                       return(RBRACE);
                     }
                   }
                }
	YY_BREAK
                  /* close bracket */
case 22:
# line 391 "l2x.l"
{ catl(yyleng, yytext);
                   if (LDEBUG > LD5) {
                     print_to_err(yytext);
                   }
                   if (noop_openc == NOOPLBRAK) {
                     nopen_noop--;
                     if (nopen_noop <= 0) {
                       if (LDEBUG > LD3) {
                         print_to_err("(Closing NO_OP on bracket)");
                       }
                       nopen_noop = 0;
                       in_noop = FALSE;
                       start_noop = FALSE;
                       BEGIN 0;
                       got_opt_param = FALSE;
                       return(END_ANOPT);
                     }
                   }
                }
	YY_BREAK
                /* newline */
case 23:
# line 413 "l2x.l"
{ catl(yyleng, yytext);
                  do_newline();
                  if (LDEBUG > LD3) {
                    print_debug_2s("(newline in a no op):", yytext);
                  }
                }
	YY_BREAK
                 /* any other character */
case 24:
# line 421 "l2x.l"
{ catl(yyleng, yytext);
                        if (LDEBUG > LD5) {
                          print_to_err(yytext);
                        }
                      }
	YY_BREAK
  /*----------------------------Default processing------------------------*/
          /*----------------------- list items ---------------------------*/
                 /* item */
case 25:
# line 432 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_ITEM):", yytext);
                  }
                  return(ITEM);
                }
	YY_BREAK
                     /* item[ */
case 26:
# line 441 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_ITEM_AND_BRAK):", yytext);
                  }
                  got_opt_item = TRUE;
                  return(ITEM_AND_BRAK);
                }
	YY_BREAK
  /*------------------------------ commands ------------------------------*/
                /* (La)TeX backslash followed by a single space */
case 27:
# line 454 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD4) {
                    print_debug_2s("(slashspace):", yytext);
                  }  /* 6/96 change myprint to tag_print */
                  ptr = get_mode_sym(pos_bss);
                  tag_print(get_t(ptr));
                  tag_print(get_et(ptr));
                }
	YY_BREAK
                /* (La)TeX backslash followed by a newline */
case 28:
# line 465 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count++;
                  yylval.string = strsave(yytext);
                  do_newline();
                  if (LDEBUG > LD1) {
                    fprintf(filerr, "\n LD(slashnewline): next line is %d\n", lineno);
                    fflush(filerr);
                  }
                  ptr = get_mode_sym(pos_bss);
                  tag_print(get_t(ptr));
                  tag_print(get_et(ptr));
                  if (!pretty_print) {
                    myprint(a_newline);
                  }
                }
	YY_BREAK
                 /* \one non-alphabetic character */
case 29:
# line 482 "l2x.l"
{catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(char_command):", yytext);
                  }
                  result = lookup_entry(yytext, CHAR_COMMAND);
                  if (result >= 0) {         /* found it */
                    ptr = get_mode_sym(result);
                    kind = command_type(ptr);
                    yylval.pos = ptr;
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER_COMMAND)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as CHAR_COMMAND)");
                    }
                    return(OTHER_COMMAND);
                 }
               }
	YY_BREAK
                   /* special processing for \\* command */
case 30:
# line 507 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(char_command):", yytext);
                  }
                  result = lookup_entry("\\\\", CHAR_COMMAND);
                  if (result >= 0) {         /* found it */
                    ptr = get_mode_sym(result);
                    kind = command_type(ptr);
                    yylval.pos = ptr;
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER_COMMAND)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as CHAR_COMMAND)");
                    }
                    return(OTHER_COMMAND);
                 }
               }
	YY_BREAK
                  /* a command \something or \something* */
case 31:
# line 534 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(command):", yytext);
                  }
                  result = lookup_entry(yytext, DONT_CARE);
                  if (result >= 0) {         /* found it */
                    ptr = get_mode_sym(result);
                    kind = command_type(ptr);
                    yylval.pos = ptr;
                    switch (get_user_type(ptr)) {
                      case SPECIAL_COMMAND: {
                        special_kind = get_special_token(ptr);
                        if (special_kind == COMMAND) {
                          warning_3s("SPECIAL_COMMAND",yytext,"not yet implemented");
                        }
                        if (special_kind >= MIN_CODE_SPECIAL) {
                          return(kind);
                        }
                        else {
                          return(special_kind);
                        }
                        break;
                      }
                      case SPECIAL_SECTIONING: {
                        special_kind = get_special_token(ptr);
                        if (special_kind == COMMAND) {
                          warning_3s("SPECIAL_SECTIONING",yytext,"not yet implemented");
                        }
                        if (special_kind >= MIN_CODE_SPECIAL) {
                          return(kind);
                        }
                        else {
                          return(special_kind);
                        }
                        break;
                      }
                      case VCOMMAND: {               /* verb-like */
                        BEGIN VERB_LIKE;
                        nopen_vbrace = 0;
                        break;
                      }
                    }  /* end switch */
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER_COMMAND)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a command type)");
                    }
                    return(OTHER_COMMAND);
                  }
               }
	YY_BREAK
    /*-------------------- Environments ---------------------------*/
                  /* \begin{something} */
case 32:
# line 595 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(begin):", yytext);
                  }
                  get_env_name(yytext);
                  if (LDEBUG > LD1) {
                    print_debug_2s("env_name= ", env_name);
                  }
                  result = lookup_entry(env_name, BEGIN_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, BEGIN_LIST_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, BEGIN_PICTURE_CC);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, BEGIN_VENV);
                  if (result >= 0) {          /* found it */
                    BEGIN VERBATIM_LIKE;      /* switch into verbatim-like mode */
                    bverb = TRUE;
                    strcpy(vlenv, env_name);     /* remember environment name */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, SPECIAL_BEGIN_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result); 
                    yylval.pos = ptr;
                    special_kind = get_special_token(ptr);
                    if (special_kind == COMMAND) {
                      warning_3s("SPECIAL_BEGIN_ENV",env_name,"not yet implemented"); 
                    }
                    if (special_kind >= MIN_CODE_SPECIAL) {
                      return(command_type(ptr));
                    }
                    else {
                      return(special_kind);
                    }
                  }
                  result = lookup_entry(env_name, SPECIAL_BEGIN_LIST);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    special_kind = get_special_token(ptr);
                    if (special_kind == COMMAND) {
                      warning_3s("SPECIAL_BEGIN_LIST",env_name,"not yet implemented"); 
                    }
                    if (special_kind >= MIN_CODE_SPECIAL) {
                      return(command_type(ptr));
                    }
                    else {
                      return(special_kind);
                    }
                  }
                  yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER_BEGIN)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as begin something)");
                    }
                  return(OTHER_BEGIN);
                }
	YY_BREAK
                  /* \end{something} */
case 33:
# line 676 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(end):", yytext);
                  }
                  get_env_name(yytext);
                  if (LDEBUG > LD1) {
                    print_debug_2s("env_name= ", env_name);
                  }
                  result = lookup_entry(env_name, END_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, END_LIST_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, END_PICTURE);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  result = lookup_entry(env_name, SPECIAL_END_ENV);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    special_kind = get_special_token(ptr);
                    if (special_kind == COMMAND) {
                      warning_3s("SPECIAL_END_ENV",env_name,"not yet implemented"); 
                    }
                    if (special_kind >= MIN_CODE_SPECIAL) {
                      return(command_type(ptr));
                    }
                    else {
                      return(special_kind);
                    }
                  }
                  result = lookup_entry(env_name, SPECIAL_END_LIST);
                  if (result >= 0) {             /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    special_kind = get_special_token(ptr);
                    if (special_kind == COMMAND) {
                      warning_3s("SPECIAL_END_ENV",env_name,"not yet implemented"); 
                    }
                    if (special_kind >= MIN_CODE_SPECIAL) {
                      return(command_type(ptr));
                    }
                    else {
                      return(special_kind);
                    }
                  }
                  yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER_END)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as end something)");
                    }
                  return(OTHER_END);
                }
	YY_BREAK
          /*--------------------- Miscellaneous stuff -----------------------*/
                /* an open brace { */
case 34:
# line 751 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_LBRACE):", yytext);
                  }
                  if (start_noop) {
                       if (LDEBUG > LD3) {
                         print_to_err("(Starting NO_OP on brace)");
                       }
                    start_noop = FALSE;
                    in_noop = TRUE;
                    nopen_noop = 1;
                    noop_openc = NOOPLBRACE;
                    BEGIN NOOP;
                  }
                  yylval.pos = get_mode_sym(pos_lbrace);
                  return(LBRACE);
                }
	YY_BREAK
                /* a close brace } */
case 35:
# line 771 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_RBRACE):", yytext);
                  }
                  yylval.pos = get_mode_sym(pos_rbrace);
                  return(RBRACE);
                }
	YY_BREAK
                /* an open bracket [ */
case 36:
# line 781 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_LBRAK):", yytext);
                  }
                  if (opt_param) {
                    got_opt_param = TRUE;
                    opt_param = FALSE;
                    if (start_noop) {
                       if (LDEBUG > LD3) {
                         print_to_err("(Starting NO_OP on bracket)");
                       }
                      start_noop = FALSE;
                      in_noop = TRUE;
                      noop_openc = NOOPLBRAK;
                      BEGIN NOOP;
                    }
                    return(START_ANOPT);
                  }
                  else if (all_opt) {
                    got_all_opt = TRUE;
                    all_opt = FALSE;
                    return(START_ALLOPT);
                  }
                  else {
                    return(LBRAK);
                  }
                }
	YY_BREAK
                /* a close bracket ] */
case 37:
# line 811 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_RBRAK):", yytext);
                  }
                  if (got_opt_item) {
                    got_opt_item = FALSE;
                    return(END_ITEM_BRAK);
                  }
                  else if (got_opt_param) {
                    got_opt_param = FALSE;
                    return(END_ANOPT);
                  }
                  else if (got_all_opt) {
                    got_all_opt = FALSE;
                    return(END_ALLOPT);
                  }
                  else {
                    return(RBRAK);
                  }
                }
	YY_BREAK
         /*------------------- Special characters ----------------------*/
                 /* a naked hash # */
case 38:
# line 836 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(hash):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    kind = command_type(ptr);
                    yylval.pos = ptr;
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked dollar $ */
case 39:
# line 861 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(dollar):", yytext);
                    if (got_a_dollar) { print_debug_1s("(as t_END_DOLLAR)"); }
                    else { print_debug_1s("(as t_BEGIN_DOLLAR)"); }
                  }
                  if (got_a_dollar) {          /* a 'closing' $ */
                    got_a_dollar = FALSE;
                    yylval.pos = get_mode_sym(pos_edol);
                    return(END_DOLLAR);
                  }
                  else {                       /* an 'opening' $ */
                    got_a_dollar = TRUE;
                    yylval.pos = get_mode_sym(pos_bdol);
                    return(BEGIN_DOLLAR);
                 }
               }
	YY_BREAK
                 /* a naked ampersand & */
case 40:
# line 881 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(ampersand):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    kind = command_type(ptr);
                    yylval.pos = ptr;
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked twiddle ~ */
case 41:
# line 907 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(twiddle):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked underscore _ */
case 42:
# line 932 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(underscore):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked caret ^ */
case 43:
# line 957 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(caret):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked percent % */
case 44:
# line 982 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(percent):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                 /* a naked at @ */
case 45:
# line 1007 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD1) {
                    print_debug_2s("(at):", yytext);
                  }
                  result = lookup_entry(yytext, TEX_CHAR);
                  if (result >= 0) {                 /* found it */
                    ptr = get_mode_sym(result);
                    yylval.pos = ptr;
                    kind = command_type(ptr);
                    return(kind);
                  }
                  else {
                    yylval.string = strsave(yytext);
                    if (LDEBUG > LD1) {
                      print_debug_1s("(as t_OTHER)");
                    }
                    if (LDEBUG > LD0) {
                      print_debug_undef(yylval.string, " (as a special character)");
                    }
                    return(OTHER);
                  }
               }
	YY_BREAK
                     /* name (alphabetic string(*) ) */
case 46:
# line 1034 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  yylval.string = strsave(yytext);
                  if (LDEBUG > LD1) {
                    print_debug_2s("(t_NAME):", yytext);
                  }
                  return(NAME);
                }
	YY_BREAK
                     /* integer (digit string) */
case 47:
# line 1044 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  yylval.string = strsave(yytext);
                  if (LDEBUG > LD2) {
                    print_debug_2s("(t_INTEGER):", yytext);
                  }
                  return(INTEGER);
                }
	YY_BREAK
                     /* real (digits with one period) */
case 48:
# line 1054 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  yylval.string = strsave(yytext);
                  if (LDEBUG > LD2) {
                    print_debug_2s("(t_REAL):", yytext);
                  }
                  return(REAL);
                }
	YY_BREAK
                 /* a comma */
case 49:
# line 1065 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD2) {
                    print_debug_2s("(t_COMMA):", yytext);
                  }
                  return(COMMA);
                }
	YY_BREAK
                 /* left parenthesis */
case 50:
# line 1074 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD2) {
                    print_debug_2s("(t_LPAREN):", yytext);
                  }
                  if (opt_coord) {
                    got_opt_coord = TRUE;
                    opt_coord = FALSE;
                    return(START_COORD);
                  }
                  else {
                    return(LPAREN);
                  }
                }
	YY_BREAK
                 /* right parenthesis */
case 51:
# line 1090 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                  if (LDEBUG > LD2) {
                    print_debug_2s("(t_RPAREN):", yytext);
                  }
                  if (got_opt_coord) {
                    got_opt_coord = FALSE;
                    return(END_COORD);
                  }
                  else {
                    return(RPAREN);
                  }
                }
	YY_BREAK
                /* whitespace (except newline) print it out */
case 52:
# line 1107 "l2x.l"
{ catl(yyleng, yytext);
                  if (LDEBUG > LD4) {
                    print_debug_2s("(ws):", yytext);
                  }
                  if (collapse_ws) {    /* collapse whitespace */
                    myprint(a_space);
                  }
                  else {
                    myprint(yytext);
                  }
                }
	YY_BREAK
                /* newline with leading and trailing spaces */
                /* 7/96  changed to enable paragraphs outside pretty mode */
case 53:
# line 1121 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count++;
                 /* yylval.string = strsave(yytext); */
                  do_newline();
                  if (LDEBUG > LD1) {
                    fprintf(filerr, "\n LD(newline): next line is %d\n", lineno);
                    fflush(filerr);
                  }
                  if (!pretty_print) {       /* not pretty printing */
                    myprint(yytext);
                    if (nl_count == 2) {     /* 6/96 added this */
                      yylval.pos = get_mode_sym(pos_para);
                      return(PARAGRAPH);
                    }
                  }
                  else {
                    if (nl_count == 2) {      /* (6/96 changed from >= 2 to == 2) a paragraph break */
                      yylval.pos = get_mode_sym(pos_para);
                      return(PARAGRAPH);
                    }
                    else {                    /* treat as space */
                      myprint(a_space);
                    }
                  }
                }
	YY_BREAK
          /*----------- WHEN ALL ELSE FAILS --------------------*/
                 /* end of file */
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(VERBATIM_STATE):
case YY_STATE_EOF(VERB_STATE):
case YY_STATE_EOF(VERBATIM_LIKE):
case YY_STATE_EOF(VERB_LIKE):
case YY_STATE_EOF(NOOP):
# line 1152 "l2x.l"
{ catl(yyleng, yytext);
                 if (LDEBUG > LD1) {
                   print_debug_1s("(end of file):\n");
                 }
                 yyerror("Lexer: Unexpected end of file");
                 return(END_OF_FILE);
               }
	YY_BREAK
                /* anything else */
case 55:
# line 1161 "l2x.l"
{ catl(yyleng, yytext);
                  nl_count = 0;
                 result = lookup_entry(yytext, TEX_CHAR);
                 if (result >= 0) {           /* found it */
                   if (LDEBUG > LD1) {
                     print_debug_2s("(tex_char):", yytext);
                   }
                   ptr = get_mode_sym(result);
                   yylval.pos = ptr;
                   kind = command_type(ptr);
                   return(kind);
                 }
                 else {
                   yylval.string = strsave(yytext);
                   if (LDEBUG > LD4) {
                      print_debug_2s("(catch_all):", yytext);
                    }
                    return(OTHER);
                 }
               }
	YY_BREAK
case 56:
# line 1182 "l2x.l"
ECHO;
	YY_BREAK

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			    yy_cp = yy_last_accepting_cpos;
			    yy_current_state = yy_last_accepting_state;
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    yy_current_state = yy_start;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
	if ( yy_accept[yy_current_state] )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	    {
	    yy_current_state = yy_def[yy_current_state];
	    if ( yy_current_state >= 171 )
		yy_c = yy_meta[yy_c];
	    }
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	}

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
	{
	yy_last_accepting_state = yy_current_state;
	yy_last_accepting_cpos = yy_cp;
	}
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	{
	yy_current_state = yy_def[yy_current_state];
	if ( yy_current_state >= 171 )
	    yy_c = yy_meta[yy_c];
	}
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_current_state == 170);

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

#ifdef __cplusplus
		    return ( yyinput() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
		    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }
# line 1182 "l2x.l"



