 /*
 * $Id: funct1.c,v 1.2 1994/06/21 08:14:11 ralf Exp $
 * History:
 * $Log: funct1.c,v $
 *
 * Revision 1.3  1997/10/17  11:26:29  D. Taupin
 * Enhancing enumerate, itemize
 *
 * Revision 1.2  1994/06/21  08:14:11  ralf
 * Corrected Bug in keyword search
 *
 * Revision 1.1  1994/06/17  11:26:29  ralf
 * Initial revision
 */
/***************************************************************************
   name : funct1.c
 author : DORNER Fernando, GRANZER Andreas + TAUPIN Daniel
purpose : includes besides funct2.c all functions which are called from the programm commands.c;
 ****************************************************************************/

/********************************* includes *********************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "main.h"
#include "funct1.h"
#include "funct2.h"
#include "commands.h"
#include "stack.h"
#include "fonts.h"
#ifdef MSDOS
#define CALL "call"
#else
#define CALL "sh"
#endif
/*****************************************************************************/

/**************************** extern variables ******************************/
extern FILE *fRtf;                       /* Rtf-File-Pointer */
extern FILE *fTex;                       /* LaTex-File-Pointer */
extern FILE *fMathTeX;                   /* Maths-LaTex-File-Pointer */
extern FILE *fDat;      	         /* file pointer to LaTeX output data */
extern FILE *fPbm; 		         /* file pointer to input PBM file */
extern BOOL AcceptInputText;             /* becomes FALSE after end{document} */
extern int bPard;                        /* true if \pard-command is necessary */
extern BOOL bInDocument;                 /* true if File-Pointer is in the document */
extern int BracketLevel;                 /* counts open braces */
extern int RecursLevel;                  /* counts returns occured by closing braces */
extern BOOL MathMode[MAXENVIRONS];       /* true at a formula-conversion */
extern int fontsize;                     /* includes the actual fontsize in points */
extern BOOL twocolumn;                   /* true if twocolumn-mode is enabled */
extern BOOL titlepage;                   /* true if titlepage-mode is set */
extern BOOL article;                     /* true if article-mode is set */
extern BOOL report;                      /* true if report-mode is set */
extern BOOL book;                     /* true if book-mode is set */
extern int indent;                       /* includes the left margin e.g. for itemize-commands */
extern int right_indent;                 /* includes the right margin e.g. for quotation */
extern int left_item_indent;  /* DT */   /* the additional left indentation for items */
extern int indent_quantum;    /* DT */   /* indentation quantum */
extern int enum_level;        /* DT */   /* list nesting level (used to index counters) */
extern BOOL AutoNumSections;  /* DT */   /* use Word auto numbering of sections, subsection... */
extern BOOL AutoNumItems;     /* DT */   /* use Word auto numbering of /item's */
extern int parindent[MAXENVIRONS];  /* DT */
extern int DefaultIndent;     /* DT */
extern BOOL ParDone;          /* DT */   /* is the RTF /par already done before */
extern BOOL bNewPar;
extern BOOL TABBING_ON;
extern BOOL TITLE_AUTHOR_ON;
extern char *progname;
extern char *latexname;
extern char alignment[MAXENVIRONS];
extern BOOL GermanMode;
extern BOOL mbox;
extern long linenumber;
extern int iEnvCount;
extern int curr_fontsize[MAXENVIRONS];
extern int curr_fontbold[MAXENVIRONS];
extern int curr_fontital[MAXENVIRONS];
extern int curr_fontscap[MAXENVIRONS];
extern int curr_fontnumb[MAXENVIRONS];
extern int environ_type[MAXENVIRONS];
extern int environ_mode[MAXENVIRONS];
extern int section_fontsize[SECT_MAXLEVEL];
extern int section_sb[SECT_MAXLEVEL];
extern int section_sa[SECT_MAXLEVEL];
extern int title_fontsize;
extern int author_fontsize;
extern int section_style[SECT_MAXLEVEL];
extern char TheFont[MAXPNLEN];
extern BOOL IgnoreSpaces;
extern int FutureSkip;
extern BOOL NextIndent;
extern BOOL InputLineEmpty;
extern BOOL Debug;
extern BOOL MakeEquationsTeX;
extern BOOL MakeMathsTeX;
extern int EqNumber;
extern char LaTeXingCommand[256];
extern char PBMingCommand[256];
extern int pbm_linelength;
extern int pbm_linenumber;
extern char PointSize[10];
extern char *LatexSize[MAXENVIRONS];
extern char TeXoutputName[64];
extern char TeXoutputLog[64];
extern char TeXoutputAux[64];
extern char TeXoutputNone[64];
extern char TeXoutput[64];
extern char PBMname[64];
extern char UsePackageText[256];

extern int NumberColumns;
extern int ColSep;
extern int paperwidth;
extern int paperheight;
extern int textwidth;
extern int textheight;
extern int hoffset;
extern int voffset;

/***************************************************************************/

/***************************  prototypes     ********************************/
void ConvertFormula();
void CmdRestoreFont();
long int StoreBit(int bitvalue);
void ConvertImage(int pbm_linelength, int pbm_linenumber,
     int top, int bottom, int left, int right);
void ScanImage(int pbm_linelength, int pbm_linenumber,
     int *top, int *bottom, int *left, int *right);
void PbmToRtf(char *ImageName, int depth);
void EndLatexEquation(int code_display);
void BeginLatexEquation(int code_display);
void OutVerbatim(FILE **f, char *endstring, BOOL outrtf);
void DeleteFile(char *filename, char *suffix);

/******************************************************************************/
void DoParCmd()
/******************************************************************************
  purpose : make the /par command if not already done
 ******************************************************************************/
{
  if ( ParDone ){  /* fprintf(fRtf,"ZzZ"); */
  }else
  { fprintf(fRtf,"\n\\par\\sb%d ",FutureSkip);
  ParDone = TRUE;
  DoIndent(); IgnoreSpaces = TRUE;
  FutureSkip = 0;
  };
}

/******************************************************************************/
void DoBeginparagraph()
/******************************************************************************
  purpose : insert the optional noindent and skip before paragraph
  if left unexecuted
******************************************************************************/
{
  if (!NextIndent) fprintf(fRtf,"\\fi0 ");
  NextIndent = TRUE;
  if (FutureSkip > 0) fprintf(fRtf,"\\sb%d ",FutureSkip);
  FutureSkip = 0;
}

/******************************************************************************/
void CmdParPlain(int code)
/******************************************************************************
  purpose : make the /par command with all resets and optional first indent
 ******************************************************************************/
{
  DoParCmd();
  fprintf(fRtf,"\\pard\\plain\\q%c ",alignment[iEnvCount]);
  DoIndent(); IgnoreSpaces = TRUE;
  bPard = FALSE;
}

/****************************************************************************/
void CmdCharFormat(int code)
/****************************************************************************
     purpose : sets the characterformat to bold, italic, underlined...
   parameter : code includes the character-format-style
 ****************************************************************************/
{
  if (TABBING_ON == FALSE)
    {
     switch(code)
     {
       case CMD_BOLD: fprintf(fRtf,"\\b ");
        	      break;
       case CMD_ITALIC: fprintf(fRtf,"\\i ");
        		break;
       case CMD_UNDERLINE: fprintf(fRtf,"\\ul ");
        		   break;
       case CMD_CAPS: fprintf(fRtf,"\\scaps ");
        	      break;
     }
     Convert();
   }
}

/******************       helping function for CmdBegin               ***/
/**************************************************************************/
void GetParam(char *string, int size)
/**************************************************************************
     purpose: returns the parameter after the \begin-command
              for instance: \begin{environment}
        	    return: -> string = "environment"
   parameter: string: look at purpose
        	 int: maximal number of characters from string
     returns: success: string
              miss : string = ""
 **************************************************************************/
{
  char cThis;
  int i,PopLevel,PopBrack;
  int bracket=0;
  char errormessage[128];
  char subparam[1024]="";
  int nsubargs=0; /* a single command found has nsubargs expected */

  if ( (fread(&cThis,1,1,fTex) < 1))
    numerror(ERR_EOF_INPUT);
/*  if (cThis == '\n') {linenumber++; InputLineEmpty = TRUE;}; */
  while ((cThis == '\n') || (cThis == ' '))
  { if (cThis == '\n') {linenumber++; InputLineEmpty = TRUE;};
    if ( (fread(&cThis,1,1,fTex) < 1))
    numerror(ERR_EOF_INPUT);
  };

  if ( cThis == '{' )
  {
    bracket++;
    ++BracketLevel;
    Push(RecursLevel,BracketLevel);
  }
  else if ( cThis == '\\' )
  {
    string[0] = cThis;
    for (i = 1; i < size-2 ;i++)   /* get letter from input stream */
    {
       if (fread(&cThis,1,1,fTex) < 1)
         numerror(ERR_EOF_INPUT);
       if (isalpha(cThis))
       { string[i] = cThis; string[i+1] = '\0';}
       else
       { string[i] = '\0';
         fseek(fTex,-1L,SEEK_CUR); /* reread last character */
         if(Debug) fprintf(OUTPUTF,"\n GetParam cmd=|%s|",string);
         if(strcmp(string,"\\textbf") == 0) nsubargs=1;
         if(strcmp(string,"\\textrm") == 0) nsubargs=1;
         if(strcmp(string,"\\textit") == 0) nsubargs=1;
         if(strcmp(string,"\\textsl") == 0) nsubargs=1;
         if(nsubargs > 0)
         { GetParam(subparam,1022);
           strncat(string,"{",size);
           strncat(string,subparam,size);
           strncat(string,"}",size);
           if (Debug) fprintf(OUTPUTF,"\n total params=|%s|",string);
         };  
         return;
       }
    };
    sprintf(errormessage,
      "Control sequence too long at line %d:\n%s",linenumber,string);
    error(errormessage);
  }
  else
  {
    string[0] = cThis;
    string[1] = '\0';
    return;
  }
  /* Variable Bracket is 1 here */
  for (i = 0; ;i++)   /* get param from input stream */
  {
    if (fread(&cThis,1,1,fTex) < 1)
       numerror(ERR_EOF_INPUT);
    if (cThis == '\n') {linenumber++; InputLineEmpty = TRUE;};
    if (cThis == '}')
    {
      bracket--;
      if (bracket == 0)
      {
        --BracketLevel;
        Pop(&PopLevel,&PopBrack);
       break;
      }
    }
    if (cThis == '{')
    {
      bracket++;
    }

    /* \and-command handling routine
    if (cThis == '\\')
       {
       /* command is overread !
        for(;;)
        {
        if (fread(&cThis,1,1,fTex) < 1)
           numerror(ERR_EOF_INPUT);
        if (!isalpha(cThis))
            break;
        }
       fseek(fTex,-1L,SEEK_CUR); /* reread last character
       continue;
       }
     */
    if (cThis == '%')
        {
        IgnoreTo('\n');
        i--;
        continue;
        }

    if (size-- > 0)
      string[i] = cThis;
  }
  string[i] = '\0';
}

/***************************************************************************/
void CmdBeginEnd(int code)
/***************************************************************************
   purpose: reads the parameter after the \begin or \end-command; ( see also GetParam )
            after reading the parameter the CallParamFunc-function calls the
            handling-routine for that special environment
 parameter: code: CMD_BEGIN: start of environment
        	  CMD_END:   end of environment
 ***************************************************************************/
{
  char cParam[50];
  switch(code)
  {
    case CMD_BEGIN:
        	    GetParam(cParam,49);
        	    CallParamFunc(cParam,ON);
        	    break;
    case CMD_END:
        	    GetParam(cParam,49);
        	    CallParamFunc(cParam,OFF);
        	    break;
  }
}

/********************************************************************************/
void Paragraph(int code)
/*****************************************************************************
    purpose : sets the alignment for a paragraph
  parameter : code: alignment centered, justified, left or right
   globals  : bpard: after such a paragraph-mode the default has to be set back
        	     bpard would do this in the function convert in the file main.c
 ********************************************************************************/
{
  switch(code)
  {
    case (PAR_CENTER | ON):
      DoParCmd();
      PushEnvironment(PAR_CENTER);
      alignment[iEnvCount] = CENTERED;
      parindent[iEnvCount] = 0;
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
      break;
    case (PAR_CENTER | OFF):
      DoParCmd();
      PopEnvironment(PAR_CENTER);
      bPard = TRUE;
      IgnoreSpaces = TRUE;
      break;

    case (PAR_RIGHT | ON):
      DoParCmd();
      PushEnvironment(PAR_RIGHT);
      alignment[iEnvCount] = RIGHT;
      parindent[iEnvCount] = 0;
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
      break;
    case (PAR_RIGHT | OFF):
      DoParCmd();
      PopEnvironment(PAR_RIGHT);
      bPard = TRUE;
      IgnoreSpaces = TRUE;
      break;

    case (PAR_LEFT | ON):
      DoParCmd();
      PushEnvironment(PAR_LEFT);
      alignment[iEnvCount] = LEFT;
      parindent[iEnvCount] = 0;
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
      break;
    case (PAR_LEFT | OFF):
      DoParCmd();
      PopEnvironment(PAR_LEFT);
      bPard = TRUE;
      IgnoreSpaces = TRUE;
      break;
  }
}

/******************************************************************************/
void CmdToday(int code)
/******************************************************************************
    purpose: converts the LaTex-date-command into a Rtf-chdate-command which
             prints the current date into an document
 ******************************************************************************/
{
  fprintf(fRtf,"\\chdate ");
}

/******************************************************************************/
void CmdUmlaute(int code)
/******************************************************************************
 purpose : converts german symbols from LaTeX to Rtf
 ******************************************************************************/
{
  static char cHexDigits[16] = {'0', '1', '2' ,'3', '4', '5', '6', '7', '8',
        			'9', 'a', 'b', 'c', 'd', 'e', 'f' };
  char cParam[10];

  GetParam(cParam,9);

  switch(cParam[0])
  {
    case 'A':fprintf(fRtf, "\\'c4");
             break;
    case 'E':fprintf(fRtf, "\\'cb");
             break;
    case 'I':fprintf(fRtf, "\\'cf");
             break;
    case 'O':fprintf(fRtf, "\\'d6");
             break;
    case 'U':fprintf(fRtf, "\\'dc");
             break;
    case 'a':fprintf(fRtf, "\\'e4");
             break;
    case 'e':fprintf(fRtf, "\\'eb");
             break;
    case 'i':fprintf(fRtf, "\\'ef");
             break;
    case 'o':fprintf(fRtf, "\\'f6");
             break;
    case 'u':fprintf(fRtf, "\\'fc");
             break;
    case 'y':fprintf(fRtf, "\\'ff");
             break;
  }
}

/******************************************************************************/
void CmdLApostrophChar(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10];

  GetParam(cParam,9);
  switch(cParam[0])
  {
    case 'A':fprintf(fRtf, "\\'c0");
             break;
    case 'E':fprintf(fRtf, "\\'c8");
             break;
    case 'I':fprintf(fRtf, "\\'cc");
             break;
    case 'O':fprintf(fRtf, "\\'d2");
             break;
    case 'U':fprintf(fRtf, "\\'d9");
             break;
    case 'a':fprintf(fRtf, "\\'e0");
             break;
    case 'e':fprintf(fRtf, "\\'e8");
             break;
    case 'i':fprintf(fRtf, "\\'ec");
             break;
    case 'o':fprintf(fRtf, "\\'f2");
             break;
    case 'u':fprintf(fRtf, "\\'f9");
             break;
  }
}

/******************************************************************************/
void CmdRApostrophChar(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10];

  GetParam(cParam,9);
  switch(cParam[0])
  {
    case 'A':fprintf(fRtf, "\\'c1");
             break;
    case 'E':fprintf(fRtf, "\\'c9");
             break;
    case 'I':fprintf(fRtf, "\\'cd");
             break;
    case 'O':fprintf(fRtf, "\\'d3");
             break;
    case 'U':fprintf(fRtf, "\\'da");
             break;
    case 'a':fprintf(fRtf, "\\'e1");
             break;
    case 'e':fprintf(fRtf, "\\'e9");
             break;
    case 'i':fprintf(fRtf, "\\'ed");
             break;
    case 'o':fprintf(fRtf, "\\'f3");
             break;
    case 'u':fprintf(fRtf, "\\'fa");
             break;
    case 'y':fprintf(fRtf, "\\'fd");
             break;
    case 'Y':fprintf(fRtf, "\\'dd");
             break;
  }
}

/******************************************************************************/
void CmdMacronChar(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char errormessage[128];

  sprintf(errormessage,"macron accent ignored at line %d",linenumber);
  warning(errormessage);
};

/******************************************************************************/
void CmdSpitzeChar(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10];

  GetParam(cParam,9);
  switch(cParam[0])
  {
    case 'A':fprintf(fRtf, "\\'c2");
             break;
    case 'E':fprintf(fRtf, "\\'ca");
             break;
    case 'I':fprintf(fRtf, "\\'ce");
             break;
    case 'O':fprintf(fRtf, "\\'d4");
             break;
    case 'U':fprintf(fRtf, "\\'db");
             break;
    case 'a':fprintf(fRtf, "\\'e2");
             break;
    case 'e':fprintf(fRtf, "\\'ea");
             break;
    case 'i':fprintf(fRtf, "\\'ee");
             break;
    case 'o':fprintf(fRtf, "\\'f4");
             break;
    case 'u':fprintf(fRtf, "\\'fb");
             break;
  }
}

/******************************************************************************/
void CmdCedillaChar(int code)
/******************************************************************************
 purpose: converts cedillas from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10] = "";

  GetParam(cParam,9);

  switch(cParam[0])
  {
    case 'C':fprintf(fRtf, "\\'c7");
             break;
    case 'c':fprintf(fRtf, "\\'e7");
             break;
  }
}

/******************************************************************************/
void CmdSpecials(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10] = "";

  GetParam(cParam,9);

  switch(cParam[0])
  {
    case 'C':fprintf(fRtf, "\\'c7");
             break;
    case 'c':fprintf(fRtf, "\\'e7");
             break;
  }
}

/******************************************************************************/
void CmdTildeChar(int code)
/******************************************************************************
 purpose: converts special symbols from LaTex to Rtf
 ******************************************************************************/
{
  char cParam[10];

  GetParam(cParam,9);
  switch(cParam[0])
  {
    case 'A':fprintf(fRtf, "\\'c3");
             break;
    case 'O':fprintf(fRtf, "\\'d5");
             break;
    case 'N':fprintf(fRtf, "\\'d1");
             break;
    case 'a':fprintf(fRtf, "\\'e3");
             break;
    case 'o':fprintf(fRtf, "\\'f5");
             break;
    case 'n':fprintf(fRtf, "\\'f1");
             break;
  }
}

/******************************************************************************/
void CmdFontSize(int code)
/******************************************************************************
 purpose : sets the fontsize to the point-size given by the LaTex-\fs_size-command
 globals : fontsize : includes the actual fontsize in the document
 ******************************************************************************/
{ int scaled_code = code;
/* pointers to latex size names */
  static char tiny[20] = "\\tiny";
  static char scriptsize[20] = "\\scriptsize";
  static char footnotesize[20] = "\\footnotesize";
  static char small[20] = "\\small";
  static char normalsize[20] = "\\normalsize";
  static char large[20] = "\\large";
  static char Large[20] = "\\Large";
  static char LARGE[20] = "\\LARGE";
  static char huge[20] = "\\huge";
  static char Huge[20] = "\\Huge";
  static char HUGE[20] = "\\HUGE";
  static char giant[20] = "\\giant";
  static char Giant[20] = "\\Giant";
  static char GIANT[20] = "\\GIANT";
  LatexSize[iEnvCount] = tiny;
  if (code >= 10) LatexSize[iEnvCount] = tiny;
  if (code >= 14) LatexSize[iEnvCount] = scriptsize;
  if (code >= 16) LatexSize[iEnvCount] = footnotesize;
  if (code >= 18) LatexSize[iEnvCount] = small;
  if (code >= 20) LatexSize[iEnvCount] = normalsize;
  if (code >= 24) LatexSize[iEnvCount] = large;
  if (code >= 28) LatexSize[iEnvCount] = Large;
  if (code >= 34) LatexSize[iEnvCount] = LARGE;
  if (code >= 40) LatexSize[iEnvCount] = huge;
  if (code >= 50) LatexSize[iEnvCount] = Huge;
  if (code >= 60) LatexSize[iEnvCount] = HUGE;

  scaled_code = (code*fontsize)/20;
  fprintf(fRtf,"\\fs%d ",scaled_code);
  curr_fontsize[iEnvCount] = scaled_code; /* DT */
}

/******************************************************************************/
void TeXlogo()
/******************************************************************************
 purpose : prints the Tex logo in the Rtf-File
 ******************************************************************************/
{
  float DnSize;
  int dnsize;

  DnSize = 0.3*curr_fontsize[iEnvCount]; dnsize = DnSize+0.45;
  fprintf(fRtf,"T{\\dn%d E}X", dnsize);
}

/******************************************************************************/
void LaTeXlogo()
/******************************************************************************
 purpose : prints the LaTex logo in the Rtf-File
 ******************************************************************************/
{
  float UpSize;
  float FloatFsize;
  int upsize, Asize;

      if(curr_fontsize[iEnvCount] > 14)
        { FloatFsize = 0.667*curr_fontsize[iEnvCount];
        } else { FloatFsize = curr_fontsize[iEnvCount];
        }; Asize = FloatFsize+0.45;

  UpSize = 0.25*curr_fontsize[iEnvCount]; upsize = UpSize+0.45;
  fprintf(fRtf,"L{\\up%d\\fs%d A}", upsize, Asize); TeXlogo();
}

/******************************************************************************/
void CmdLogo(int code)
/******************************************************************************
 purpose : prints the LaTex, Tex, SLiTex and BibTex-Logos as an ordinary text
           in the Rtf-File
 ******************************************************************************/
{ int font_num, dnsize;
  float FloatFsize;
  float DnSize;
  switch(code)
  {
/*    case CMD_TEX: fprintf(fRtf, "TeX"); break; */
    case CMD_TEX: TeXlogo(); break;
/*    case CMD_LATEX: fprintf(fRtf, "LaTeX"); break; */
    case CMD_LATEX: LaTeXlogo(); break;
    case CMD_SLITEX: fprintf(fRtf, "SLiTeX"); break;
    case CMD_BIBTEX: fprintf(fRtf, "BibTeX");break;
/*    case CMD_LATEXE: fprintf(fRtf, "LaTeX2e"); break; */
    case CMD_LATEXE: LaTeXlogo();
      if(curr_fontsize[iEnvCount] > 14)
        { FloatFsize = 0.75*curr_fontsize[iEnvCount];
        } else { FloatFsize = curr_fontsize[iEnvCount];
        };
      DnSize = 0.3*curr_fontsize[iEnvCount]; dnsize = DnSize+0.45;
      font_num = GetTexFontNumber("Symbol");
      fprintf(fRtf, "2{\\dn%d\\f%d e}", dnsize,font_num); break;
  }
}

/******************************************************************************/
void CmdFormula(int code)
/******************************************************************************
 purpose: sets the Math-Formula-Mode depending on the code-parameter
 parameter : code: type of braces which include the formula
 ******************************************************************************/
{
  char errormessage[256]="";
  int result_system = 0;
  char BuildLatexEquation[256] = "";
  char call[256]=CALL;
  int i;
  if(Debug) fprintf(OUTPUTF,
    "\n CmdFormula(%d), MathMode=%d, iEnvCount=%d",code,MathMode[iEnvCount],iEnvCount);

  switch(code)
  {
    case FORM_DOLLAR: /* the '$' form of maths */
      if (MathMode[iEnvCount] == TRUE)
      {
        if (MakeMathsTeX)
        {
          EndLatexEquation(FORM_DOLLAR);        	
        };
        MathMode[iEnvCount] = FALSE;
        PopEnvironment(MATH_FORMULA);
      }
      else
      {
        PushEnvironment(MATH_FORMULA);
        MathMode[iEnvCount] = TRUE;
        EqNumber++;
        CmdSetFont(F_ROMAN);
        if (MakeMathsTeX)
        {
          BeginLatexEquation(FORM_DOLLAR);
        };
      };
      break;
    case BEGIN_MATH: /* the /begin{math} form */
      if (MathMode[iEnvCount] == TRUE)
      {
        if (MakeMathsTeX)
        {
          EndLatexEquation(BEGIN_MATH);        	
        };
        MathMode[iEnvCount] = FALSE;
        PopEnvironment(MATH_ENVIR);
      }
      else
      {
        PushEnvironment(MATH_ENVIR);
        MathMode[iEnvCount] = TRUE;
        EqNumber++;
        CmdSetFont(F_ROMAN);
        if (MakeMathsTeX)
        {
          BeginLatexEquation(BEGIN_MATH);
        };
      };
      break;
    case FORM_DISPLAY: /* the '$$' form */
      if (MathMode[iEnvCount] == TRUE)
      {
        if (MakeEquationsTeX)
        {
          EndLatexEquation(FORM_DISPLAY);        	
        };
        MathMode[iEnvCount] = FALSE;
        DoParCmd();
        PopEnvironment(MATH_DISPLAY);
      }
      else
      {
        PushEnvironment(MATH_DISPLAY);
        DoParCmd();
        MathMode[iEnvCount] = TRUE;
        alignment[iEnvCount] = CENTERED;
        parindent[iEnvCount] = 0;
        EqNumber++;
        fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
        CmdSetFont(F_ROMAN); IgnoreSpaces = TRUE;

        if (MakeEquationsTeX)
        {
          BeginLatexEquation(FORM_DISPLAY);
        };
      };
      break;
    case BEGIN_DISPLAY: /* the /begin{displaymath} form */
      if (MathMode[iEnvCount] == TRUE)
      {
        if (MakeEquationsTeX)
        {
          EndLatexEquation(BEGIN_DISPLAY);        	
        };
        MathMode[iEnvCount] = FALSE;
        DoParCmd();
        PopEnvironment(DISPLAY_ENVIR);
      }
      else
      {
        PushEnvironment(DISPLAY_ENVIR);
        DoParCmd();
        MathMode[iEnvCount] = TRUE;
        alignment[iEnvCount] = CENTERED;
        parindent[iEnvCount] = 0;
        EqNumber++;
        fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
        CmdSetFont(F_ROMAN); IgnoreSpaces = TRUE;

        if (MakeEquationsTeX)
        {
          BeginLatexEquation(BEGIN_DISPLAY);
        };
      };
      break;
    case FORM_RND_OPEN:
      fprintf(fRtf," ");
      if (MathMode[iEnvCount] == TRUE)
      {
        sprintf(errormessage,"nested formulas (1) in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
      }
      MathMode[iEnvCount] = TRUE;
      break;
    case FORM_RND_CLOSE:
      fprintf(fRtf," ");
      if (MathMode[iEnvCount] == FALSE)
      {
        sprintf(errormessage,"nested formulas (2) in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
      }
      MathMode[iEnvCount] = FALSE;
      break;
    case FORM_ECK_OPEN:
      if (MathMode[iEnvCount] == TRUE)
      {
        sprintf(errormessage,"nested formulas (3) in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
      }
      PushEnvironment(DISPLAY_ENVIR);
      DoParCmd();
      MathMode[iEnvCount] = TRUE;
      alignment[iEnvCount] = CENTERED;
      parindent[iEnvCount] = 0;
      EqNumber++;
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
      CmdSetFont(F_ROMAN); IgnoreSpaces = TRUE;
      if (MakeEquationsTeX)
        {
          BeginLatexEquation(ECK_DISPLAY);
        };
      break;
    case FORM_ECK_CLOSE:
      if (MathMode[iEnvCount] == FALSE)
      {
        sprintf(errormessage,"nested formulas (4) in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
      }
      if (MakeEquationsTeX)
      {
        EndLatexEquation(ECK_DISPLAY);        	
      };
      MathMode[iEnvCount] = FALSE;
      DoParCmd();
      PopEnvironment(DISPLAY_ENVIR);
      break;
  }
}

/******************************************************************************/
void CmdFigure(int code)
/******************************************************************************
 purpose: inserts figures or pictures or music depending on the code-parameter
 parameter : code: environment
 ******************************************************************************/
{
  char errormessage[256]="";
  int result_system = 0;
  char BuildLatexEquation[256] = "";
  char call[256]=CALL;
  int i;
  if(Debug) fprintf(OUTPUTF,
    "\n CmdFigure(%d), MathMode=%d, iEnvCount=%d",code,MathMode[iEnvCount],iEnvCount);

  switch(code)
  {
    case (BEGIN_PICTURE | OFF): /* the /end{picture} form */
        EndLatexEquation(BEGIN_PICTURE);        	
        PopEnvironment(PICT_ENVIR);
        break;
    case (BEGIN_PICTURE | ON): /* the /begin{picture} form */
        PushEnvironment(PICT_ENVIR);
        EqNumber++;
        CmdSetFont(F_ROMAN);
        BeginLatexEquation(BEGIN_PICTURE);
        break;
    case (BEGIN_MUSIC | OFF): /* the /end{music} form */
        EndLatexEquation(BEGIN_MUSIC);        	
        DoParCmd();
        PopEnvironment(MUSIC_ENVIR);
        break;
    case (BEGIN_MUSIC | ON): /* the /begin{music} form */
        PushEnvironment(MUSIC_ENVIR);
        DoParCmd();
        alignment[iEnvCount] = CENTERED;
        parindent[iEnvCount] = 0;
        EqNumber++;
        fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]);
        CmdSetFont(F_ROMAN); IgnoreSpaces = TRUE;
        BeginLatexEquation(BEGIN_MUSIC);
        break;
  }
}

/******************************************************************************/
void BeginLatexEquation(int code_display)
/******************************************************************************
 purpose: initiates imaging equation
 ******************************************************************************/
{
  char call[256]=CALL;
  char BuildLatexEquation[256] = "";
  char errormessage[256]="";
  int result_system=0;
  int i;

  if(Debug) fprintf(OUTPUTF,"\n BeginLatexEquation(%d), Environt=%d",code_display,environ_mode[iEnvCount]);
  sprintf(TeXoutputName,"%s/eqn-%d.tmp",getenv("TMPDIR"),EqNumber);
  sprintf(TeXoutputLog,"%s/eqn-%d.log",getenv("TMPDIR"),EqNumber);
  sprintf(TeXoutputAux,"%s/eqn-%d.aux",getenv("TMPDIR"),EqNumber);
  sprintf(PBMname,"%s/eqn-%d.pbm",getenv("TMPDIR"),EqNumber);
  sprintf(TeXoutput,"%s/eqn-%d",getenv("TMPDIR"),EqNumber);
  sprintf(TeXoutputNone,"eqn-%d",EqNumber);

#ifdef MSDOS
  /* in MSDOS case, replace baclslashes with slashes in names */
  for (i = 0; i < strlen(TeXoutputName) ; i++)
  { if (TeXoutputName[i] == '\\') TeXoutputName[i] = '/';
  };
  for (i = 0; i < strlen(TeXoutputLog) ; i++)
  { if (TeXoutputLog[i] == '\\') TeXoutputLog[i] = '/';
  };
  for (i = 0; i < strlen(TeXoutputAux) ; i++)
  { if (TeXoutputAux[i] == '\\') TeXoutputAux[i] = '/';
  };
  for (i = 0; i < strlen(PBMname) ; i++)
  { if (PBMname[i] == '\\') PBMname[i] = '/';
  };
  for (i = 0; i < strlen(TeXoutput) ; i++)
  { if (TeXoutput[i] == '\\') TeXoutput[i] = '/';
  };
#endif

/* for safety delete all possible previous files of the same main name */
    DeleteFile(TeXoutputName,"");
    DeleteFile(TeXoutputLog,"");
    DeleteFile(TeXoutputAux,"");
    DeleteFile(TeXoutput,".pcx");
    DeleteFile(TeXoutput,".ps");
    DeleteFile(TeXoutput,".ppm");
    DeleteFile(TeXoutput,".pgm");
    DeleteFile(TeXoutput,".pbm");
    DeleteFile(TeXoutput,".dvi");
    DeleteFile(TeXoutput,".dat");


  OpenMathTeX(TeXoutputName,&fMathTeX);	 /* open file */
  fprintf(fMathTeX,"\\documentclass");
  if (strcmp(PointSize,"11pt") == 0) fprintf(fMathTeX,"[11pt]");
  if (strcmp(PointSize,"12pt") == 0) fprintf(fMathTeX,"[12pt]");
  fprintf(fMathTeX,"{article}");
  if(UsePackageText[0] != '\0') fprintf(fMathTeX,"\n\\usepackage{%s}",UsePackageText);
  fprintf(fMathTeX,"\n\\begin{document}\n\\thispagestyle{empty}");

  if (code_display == FORM_DISPLAY)
    { fprintf(fMathTeX,"\n%s\n$$",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"$$",FALSE);
      fseek(fTex,-2L,SEEK_CUR); /* reread last characters, which was just after the $$ */
    }
  else if (code_display == BEGIN_DISPLAY)
    { fprintf(fMathTeX,"\n%s\n$$",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"\\end{displaymath}",FALSE);
      fseek(fTex,-17L,SEEK_CUR); /* reread ? */
    }
  else if (code_display == BEGIN_MUSIC)
    { fprintf(fMathTeX,"\n%s\n\\begin{music}\n",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"\\end{music}",FALSE);
      fseek(fTex,-11L,SEEK_CUR); /* reread ? */
    }
  else if (code_display == ECK_DISPLAY)
    { fprintf(fMathTeX,"\n%s\n\\[",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"\\]",FALSE);
      fseek(fTex,-2L,SEEK_CUR); /* reread ? */
    }
  else if (code_display == FORM_DOLLAR)
    {
      fprintf(fMathTeX,"\n\\newbox\\uuu");
      fprintf(fMathTeX,"\n\\newwrite\\zzz");
      fprintf(fMathTeX,"\n\\immediate\\openout\\zzz=%s.dat",TeXoutputNone);
      fprintf(fMathTeX,"\n%s\n\\setbox\\uuu=\\hbox{$",LatexSize[iEnvCount]);
      fseek(fTex,-1L,SEEK_CUR); /* reread last character, which was just after the $ */
      OutVerbatim(&fMathTeX,"$",FALSE);
    }
  else if (code_display == BEGIN_MATH)
    {
      fprintf(fMathTeX,"\n\\newbox\\uuu");
      fprintf(fMathTeX,"\n\\newwrite\\zzz");
      fprintf(fMathTeX,"\n\\immediate\\openout\\zzz=%s.dat",TeXoutputNone);
      fprintf(fMathTeX,"\n%s\n\\setbox\\uuu=\\hbox{$",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"\\end{math}",FALSE);
      fseek(fTex,-10L,SEEK_CUR); /* reread ? */
    } /* endif code_display == BEGIN_MATH */
  else if (code_display == BEGIN_PICTURE)
    {
      fprintf(fMathTeX,"\n\\newbox\\uuu");
      fprintf(fMathTeX,"\n\\newwrite\\zzz");
      fprintf(fMathTeX,"\n\\immediate\\openout\\zzz=%s.dat",TeXoutputNone);
      fprintf(fMathTeX,"\n%s\n\\setbox\\uuu=\\vbox{\\begin{picture}",LatexSize[iEnvCount]);
      OutVerbatim(&fMathTeX,"\\end{picture}",FALSE);
      fseek(fTex,-13L,SEEK_CUR); /* reread ? */
    }; /* endif code_display == BEGIN_PICTURE */
 }

/******************************************************************************/
void DeleteFile(char *filename, char *suffix)
/******************************************************************************
 purpose: deletes a file
 ******************************************************************************/
{ int i;
  char errormessage[256]="";
  char DeletingCommand[256]="";

  sprintf(DeletingCommand,"%s%s",filename,suffix);
  remove(DeletingCommand);
/*  free(DeletingCommand);  */
}

/******************************************************************************/
void EndLatexEquation(int code_display)
/******************************************************************************
 purpose: terminates imaging equation
 ******************************************************************************/
{
  char call[256]=CALL;
  char BuildLatexEquation[256] = "";
  char errormessage[256]="";
  char OutputDataName[256]="";
  int result_system=0;
  float formula_depth=0.0;
  int Depth_HalfPt=0;

  switch(code_display)  
  {
    case (FORM_DISPLAY):
      fprintf(fMathTeX,"$$\n\\end{document}\n");
      break;
    case (BEGIN_DISPLAY):
      fprintf(fMathTeX,"$$\n\\end{document}\n");
      break;
    case (ECK_DISPLAY):
      fprintf(fMathTeX,"\\]\n\\end{document}\n");
      break;
    case (BEGIN_MUSIC):
      fprintf(fMathTeX,"\\end{music}\n\\end{document}\n");
      break;
    case (BEGIN_MATH):
      fprintf(fMathTeX,"$}");
      fprintf(fMathTeX,"\\immediate\\write\\zzz{\\the\\dp\\uuu}\\closeout\\zzz");
      fprintf(fMathTeX,"\\box\\uuu\\par\n\\end{document}\n");
      break;
    case (FORM_DOLLAR):      
      fprintf(fMathTeX,"$}");
      fprintf(fMathTeX,"\\immediate\\write\\zzz{\\the\\dp\\uuu}\\closeout\\zzz");
      fprintf(fMathTeX,"\\box\\uuu\\par\n\\end{document}\n");
      break;
    case (BEGIN_PICTURE):
      fprintf(fMathTeX,"\\end{picture}}");
      fprintf(fMathTeX,"\\immediate\\write\\zzz{\\the\\dp\\uuu}\\closeout\\zzz");
      fprintf(fMathTeX,"\\box\\uuu\\par\n\\end{document}\n");
      break;
    default:
      sprintf(errormessage,"Illegal code to EndLatexEquation %d",code_display);
      error(errormessage);
      break;
    }; /* end switch code_display */
    
  CloseMath(&fMathTeX);
  if (Debug) fprintf(OUTPUTF,"\ncall=%s",call);
  sprintf(BuildLatexEquation,"%s %s",LaTeXingCommand,TeXoutputName);
  if (Debug) Message(BuildLatexEquation);
  result_system = system(BuildLatexEquation);
  if (Debug) fprintf(OUTPUTF,"\nresult is %d",result_system);
  if (result_system != 0)
  {
    sprintf(errormessage,
      "LaTeXing procedure\n '%s'\n cannot be executed, result= %d",
      BuildLatexEquation,result_system);
      error(errormessage);
  };

  switch(code_display)
  {
    case (FORM_DISPLAY):
      break;
    case (BEGIN_DISPLAY):
      break;
    case (ECK_DISPLAY):
      break;
    case (BEGIN_MUSIC):
      break;
    default:  /* case begin{math} or $...$ */      
      sprintf (OutputDataName,"%s.dat",TeXoutputNone);
      if ((fDat = fopen(OutputDataName,"r")) == NULL)	 /* open file */
      {
        sprintf(errormessage,"Error opening output LaTeX data file %s",
        OutputDataName);
        error(errormessage);
        exit(1);
      };
      fscanf(fDat,"%f",&formula_depth);
      if(Debug) fprintf(OUTPUTF,"\nLine %d, Depth=%f",linenumber,formula_depth);
      fclose(fDat);
    
      if (formula_depth > 0)
      { Depth_HalfPt=(formula_depth+0.5)*2;
      }
      else Depth_HalfPt=0;
      break;
  }; /* end switch code_display */
#ifdef MSDOS
  RestoreInitialDir();
#endif

  sprintf(BuildLatexEquation,"%s %s",PBMingCommand,TeXoutputNone);
  if (Debug) Message(BuildLatexEquation);
  result_system = system(BuildLatexEquation);
  if (Debug) fprintf(OUTPUTF,"\nresult is %d",result_system);
  if (result_system != 0)
  {
    sprintf(errormessage,
      "Conversion to PBM procedure '%s'\n cannot be executed, result %d",
      BuildLatexEquation,result_system);
      error(errormessage);
  }
#ifdef MSDOS
  RestoreInitialDir();
#endif
  PbmToRtf(PBMname,Depth_HalfPt);
  fprintf(fRtf,"}"); /* close the {\\pict bracket */
  ParDone = FALSE;
  if (!Debug)  /* delete all PBM generation files */
  {
    DeleteFile(TeXoutputName,"");
    DeleteFile(TeXoutputLog,"");
    DeleteFile(TeXoutputAux,"");
    DeleteFile(TeXoutput,".pcx");
    DeleteFile(TeXoutput,".ps");
    DeleteFile(TeXoutput,".ppm");
    DeleteFile(TeXoutput,".pgm");
    DeleteFile(TeXoutput,".pbm");
    DeleteFile(TeXoutput,".dvi");
    DeleteFile(TeXoutput,".dat");
  }
}          

/******************************************************************************/
void PbmToRtf(char *ImageName, int depth)
/******************************************************************************
 purpose: Reads the file <ImageName>.pbm and inserts it into fRtf
 ******************************************************************************/
{
  int c,errflag=0;
  int ImageTop=0; int ImageBottom=0; int ImageLeft=0; int ImageRight=0;
  char errormessage[256]="";
  char letterP=' ';
  char pnmtype=' ';
  int NbytesPerLine;
  char cThis=' ';

/* opening input file */

  PreparePbm(ImageName,&fPbm);
  if(Debug) fprintf(OUTPUTF,"\nInput file  %s",ImageName);

/* reading file header */

  fread(&letterP,1,1,fPbm);
  fread(&pnmtype,1,1,fPbm);
  if(Debug) fprintf(OUTPUTF,"\nFile header=\'%c%c\'",letterP,pnmtype);
  if (letterP != 'P') error("input file is not a PNM file");
  if (pnmtype != '4') error("only PBM one bit/pixel format accepted");

  /* go to end of line */

  while ((fread(&cThis,1,1,fPbm) == 1) && (cThis != '\n')){};
  fread(&cThis,1,1,fPbm);
  if(cThis == '#')
  {
    while ((fread(&cThis,1,1,fPbm) == 1) && (cThis != '\n')){};
  } else { fseek(fPbm,-1L,SEEK_CUR); /* reread last character */
  };

  fscanf(fPbm,"%d%d",&pbm_linelength,&pbm_linenumber);
  if(Debug) fprintf(OUTPUTF,"\nLine length=%d, Line number=%d",pbm_linelength,pbm_linenumber);

/* ignore until \\n and skip it */
  c='\0';
  while (c != '\n')
  {  fread(&c, 1,1,fPbm); };

/* get top, bottom, left, right positions in order to crop the image */
  ScanImage(pbm_linelength,pbm_linenumber,
    &ImageTop,&ImageBottom,&ImageLeft,&ImageRight);

/* Once again, second pass */
  /* re-opening input file */

  PreparePbm(ImageName,&fPbm);
  if(Debug) fprintf(OUTPUTF,"\nRe-opened file  %s",ImageName);
  /* reading file header */
  fread(&letterP,1,1,fPbm);
  fread(&pnmtype,1,1,fPbm);
  if (letterP != 'P') error("input file is not a PNM file");
  if (pnmtype != '4') error("only PBM one bit/pixel format accepted");
  /* go to end of line */
  while ((fread(&cThis,1,1,fPbm) == 1) && (cThis != '\n')){};
  fread(&cThis,1,1,fPbm);
  if(cThis == '#')
  {
    while ((fread(&cThis,1,1,fPbm) == 1) && (cThis != '\n')){};
  } else { fseek(fPbm,-1L,SEEK_CUR); /* reread last character */
  };
  fscanf(fPbm,"%d%d",&pbm_linelength,&pbm_linenumber);
  if(Debug) fprintf(OUTPUTF,"\nLine length=%d, Line number=%d",pbm_linelength,pbm_linenumber);
/* ignore until \\n and skip it */
  c='\0';
  while (c != '\n')
  {  fread(&c, 1,1,fPbm); };

  if(Debug) fprintf(OUTPUTF,"\nImageLeft=%d, ImageRight=%d",ImageLeft,ImageRight);
  if(Debug) fprintf(OUTPUTF,"\nImageTop=%d, ImageBottom=%d",ImageTop,ImageBottom);
  
  NbytesPerLine=WriteImageHeader
                (ImageRight-ImageLeft+1,ImageBottom-ImageTop+1,depth);
  ConvertImage(pbm_linelength,pbm_linenumber,ImageTop,ImageBottom,ImageLeft,ImageRight);
}

/****************************************************************************/
BOOL PreparePbm(char *filename, FILE **f)  /* opens file for reading */
/****************************************************************************
purpose: opens input file.
params: filename - name of inputfile
        f - pointer to filepointer to store file ID
 ****************************************************************************/
{ char errormessage[256];

  if(filename != NULL)
  {
/*      if ((*f = fopen(filename,"r")) == NULL)	 open file */
      if ((*f = fopen(filename,"rb")) == NULL)	/* open file */
      {
      	sprintf(errormessage,"Error opening image file %s",filename);
        error(errormessage);
/*	error("Error opening LATEX-file"); */
        exit(1);
      }
  }
  return TRUE;
}


/****************************************************************************/
int WriteImageHeader(int out_linelength, int out_linenumber, int depth)
/****************************************************************************
purpose: builds the {\\pict and associated characteristics
params:  out_linelength in pixels, out_linenumber
globals: changes inputfile fPbm
 ****************************************************************************/
{
  long int Width=DimenToTwips((out_linelength*1.0)/300.0,"in");
  long int Height=DimenToTwips((out_linenumber*1.0)/300.0,"in");
  int NbytesPerLine=((out_linelength+15)/16)*2;
  int Scale=100;
  fprintf(fRtf,"{");
  if (depth > 0)fprintf(fRtf,"\\dn%d",depth); /* case of in line formulae */
  fprintf(fRtf,"\\pict\\wbitmap0\\picw%d\\pich%d",out_linelength,out_linenumber);
  fprintf(fRtf,"\\wbmbitspixel1\\wbmplanes1\\wbmwidthbytes%d",NbytesPerLine);
  fprintf(fRtf,"\n\\picwgoal%d\\pichgoal%d",Width,Height);
  fprintf(fRtf,"\n\\picscalex%d\\picscaley%d",Scale);
  fprintf(fRtf,"\n");
  return NbytesPerLine;
}

/****************************************************************************/
void ConvertImage(int pbm_linelength, int pbm_linenumber, int top, int bottom, int left, int right)
/****************************************************************************
purpose: converts binary image into hexa
params:  pbm_linelength in pixels, pbm_linenumber, 
   top, bottom, left, right
globals: changes inputfile fPbm
 ****************************************************************************/
{
  long int BitNumberIn = 0;
  long int BitNumberOut = 0;
  long int totalbitnumber = 0;
  long int MaxNumberIn = pbm_linelength*pbm_linenumber;
  int crop_linelength = right-left+1;
  int crop_linenumber = bottom-top+1;
  long int MaxNumberOut = crop_linelength*crop_linenumber;
  int NbytesPerLineOut = ((crop_linelength+15)/16)*2;
  long int NbitsPerLineOut = NbytesPerLineOut*8;
  long int NbitsPerImageOut = NbitsPerLineOut*crop_linenumber;
  char c;
  int TheBit = 0;
  int TheByte = 0;
  int BitsInLineIn = 0; int BitsInLineOut = 0;
  int LinesInImageIn = 0; int LinesInImageOut = 0;
  BOOL InvertBits = TRUE;
  int l,k;

  if(Debug) fprintf(OUTPUTF,"\nConvertImage: NbitsPerLineOut=%d",NbitsPerLineOut);

  if(Debug) fprintf(OUTPUTF,"\nConvertImage: MaxNumberOut=%d",MaxNumberOut);

  if(Debug) fprintf(OUTPUTF,"\nConvertImage: top=%d, bottom=%d, left=%d, right=%d",top,bottom,left,right);

  if(Debug) fprintf(OUTPUTF,"\nConvertImage: crop_linelength=%d, crop_linenumber=%d"
   ,crop_linelength, crop_linenumber);

  totalbitnumber = StoreBit(-1);

  while (fread(&c, 1,1,fPbm) >= 1)
  {
    TheByte = c;
/* output each bit of c */
    for (l = 0; l < 8; l++)
    { TheByte *=2; TheBit = TheByte & 0x100; TheBit = TheBit / 0x100;
      if (InvertBits) TheBit = 1-TheBit;
/* store bit if not cropped */
      if ( (LinesInImageIn >= top) &&
           (LinesInImageIn <= bottom) &&
           (BitsInLineIn >= left) &&
           (BitsInLineIn <= right))
           {
             totalbitnumber = StoreBit(TheBit);
             BitNumberOut +=1; 
             BitsInLineOut +=1; 
           }
      BitsInLineIn +=1;
      BitNumberIn +=1;
      if (BitsInLineIn == pbm_linelength)
      {
        if ( (LinesInImageIn >= top) &&
             (LinesInImageIn <= bottom) )
           {  
             for (k = crop_linelength+1; k <= NbitsPerLineOut ; k++)
                  totalbitnumber = StoreBit(0);
             fprintf(fRtf,"\n");
             LinesInImageOut +=1;
           }
        LinesInImageIn +=1;   
      	BitsInLineIn = 0; BitsInLineOut = 0;
      	break;
      };
    }; /* end for */
/*    if (BitNumberOut >= MaxNumberOut) break; */
    if ((BitNumberOut >= MaxNumberOut) && (BitNumberIn >= MaxNumberIn)) break;
  }; /* end while */
  if(Debug) fprintf(OUTPUTF,"\n BitNumberOut=%d, MaxNumberOut=%d", BitNumberOut, MaxNumberOut);
  if(Debug) fprintf(OUTPUTF,"\n BitNumberIn=%d, MaxNumberIn=%d", BitNumberIn, MaxNumberIn);
/*  if(BitNumberIn < MaxNumberIn)  error("End of input file found"); */

  /* ensure the number of bits meets the NbitsPerImage requirement */
  while ( totalbitnumber < NbitsPerImageOut )
  { totalbitnumber = StoreBit(0); };

  if(Debug) fprintf(OUTPUTF,"\n Number of significant bits written %d",BitNumberOut);
  if(Debug) fprintf(OUTPUTF,"\n Number of total bits written %d",totalbitnumber);
  if(Debug) fprintf(OUTPUTF,"\n Number of total bits expected %d",NbitsPerImageOut);
  fclose(fPbm);
}
  
/****************************************************************************/
void ScanImage(int pbm_linelength, int pbm_linenumber,
  int *top, int *bottom, int *left, int *right)
/****************************************************************************
purpose: examines binary image to find 4 crop positions:
   top, bottom, left, right
params:  pbm_linelength in pixels, pbm_linenumber
globals: changes inputfile fPbm
 ****************************************************************************/
{ char errormessage[256];
  long int bitnumber = 0;
  long int totalbitnumber = 0;
  long int maxnumber = 0;
  long int TotalBytesRead = 0;
  int NbytesPerLine = ((pbm_linelength+15)/16)*2;
  long int NbitsPerLine = NbytesPerLine*8;
  long int NbitsPerImage = NbitsPerLine*pbm_linenumber;
  char c;
  int TheBit = 0;
  int TheByte = 0;
  int BitsInLine = 0;
  int LinesInImage = 0;
  BOOL InvertBits = FALSE; /* no bit inversion when scanning */
  int l,k;

  *top = pbm_linenumber; *left = pbm_linelength;
  *bottom = 0; *right = 0;

  if(Debug) fprintf(OUTPUTF,"\nScanImage: NbitsPerLine=%d",NbitsPerLine);

  maxnumber=pbm_linelength*pbm_linenumber;
  if(Debug) fprintf(OUTPUTF,"\nScanImage: nb. significant bits expected: %d",maxnumber);

  totalbitnumber = 0;

  while (fread(&c, 1,1,fPbm) >= 1)
  {
    TheByte = c;
    TotalBytesRead +=1;
/* output each bit of c */
    for (l = 0; l < 8; l++)
    { TheByte *=2; TheBit = TheByte & 0x100; TheBit = TheBit / 0x100;
      if (InvertBits) TheBit = 1-TheBit;
      if (TheBit > 0)
      {
      	if (BitsInLine < *left) *left = BitsInLine;
      	if (BitsInLine > *right) *right = BitsInLine;
      	if (LinesInImage < *top) *top = LinesInImage;
      	if (LinesInImage > *bottom) *bottom = LinesInImage;
      };
      bitnumber +=1; totalbitnumber +=1;
      BitsInLine +=1;
      if (BitsInLine == pbm_linelength)
      {
      	BitsInLine = 0;
      	LinesInImage +=1;
      	break;
      };
    }; /* end for */
    if (bitnumber >= maxnumber) break;
  }; /* end while */
  if(bitnumber < maxnumber)
  { sprintf(errormessage,"ScanImage: end of input file found %d < %d\n LinesInImage=%d, TotalBytesRead=%d",
      bitnumber,maxnumber,LinesInImage,TotalBytesRead);
    warning(errormessage);
  };
  
  if(Debug) fprintf(OUTPUTF,"\n top of image:    %d",*top);
  if(Debug) fprintf(OUTPUTF,"\n bottom of image: %d",*bottom);
  if(Debug) fprintf(OUTPUTF,"\n left of image:   %d",*left);
  if(Debug) fprintf(OUTPUTF,"\n right of image:  %d",*right);
  fclose(fPbm);
}
  
/******************************************************************************/
long int StoreBit(int bitvalue)
/******************************************************************************
  purpose : stores the requested bit value
 ******************************************************************************/
{
  static long int the_count;
  static int the_character;
  static int the_bit_count;

  char hexa[16]={'\0'};

  if (bitvalue < 0)
    {the_count = 0; the_character = 0; the_bit_count = 0; return 0;}
  else
    { the_count++; the_bit_count++; the_character = 2*the_character + bitvalue;
      if (the_bit_count >= 8)
        {
          sprintf(hexa,"%8x",the_character);
          if(hexa[7] == ' ') hexa[7]='0';
          if(hexa[6] == ' ') hexa[6]='0';
          fprintf(fRtf,"%c%c",hexa[6],hexa[7]);
          the_bit_count = 0; the_character = 0;
        };
    };
  return the_count;
}

/******************************************************************************/
void CmdIgnore(int code)
/******************************************************************************
 purpose: LaTeX-commands which can't be converted in Rtf-commands are overread
          as such
 ******************************************************************************/
{
}

/******************************************************************************/
void CmdLdots(int code)
/******************************************************************************
 purpose: converts the LaTex-\ldots-command into "..." in Rtf
 ******************************************************************************/
{
  fprintf(fRtf, "...");
}

/******************************************************************************/
void CmdEmphasize(int code)
/******************************************************************************
 purpose: turn on/off the emphasized style for characters
 ******************************************************************************/
{
  if (TABBING_ON == FALSE) /* TABBING-environment ignores emphasized-style */
    {
    static Em_on = 0;
    if (!(Em_on))
      fprintf(fRtf,"{\\i ");
    else
      fprintf(fRtf,"{\\plain ");
    Em_on = ~Em_on;
    Convert();
    fprintf(fRtf,"}");
    Em_on = ~Em_on;
    }
}

/******************************************************************************/
void Format(int code)
/******************************************************************************
 purpose: makes the same as the function CmdEmphasize above
          but this is an environment-handling-routine in contrast
          to the function above which converts an ordinary \em-command
 parameter: code: EMPHASIZED with ON at environment start;
        			  OFF at environment end
 ******************************************************************************/
{
  if (TABBING_ON == FALSE) /* TABBING-environment ignores emphasized-style */
    {
    static Em_on = 0;
    switch(code)
    {
      case (EMPHASIZE | ON):
        if (!(Em_on))
          fprintf(fRtf,"{\\i ");
        else
         fprintf(fRtf,"} ");
        Em_on = ~Em_on;
        break;
      case (EMPHASIZE | OFF):
        if ((Em_on))
          fprintf(fRtf,"} ");
        Em_on = 0;
        break;
    }
    }
}

/******************************************************************************/
void Environment(int code)
/******************************************************************************
  purpose: pushes/pops the new environment-commands on/from the stack
parameter: code includes the type of the environment
globals  : bIndocument
 ******************************************************************************/
{
  char errormessage[256]="";
  if (code & ON) /* on switch */
  {
    code &= ~(ON);   /* mask MSB */
    if (code == DOCUMENT)
    {
      ClearEnvironment();
      bInDocument = TRUE;
      if(Debug) fprintf(OUTPUTF,"\n -> Begin{document}");
      parindent[iEnvCount] = DefaultIndent;
    }
    PushEnvironment(code);
  }
  else /* off switch */
  {
    PopEnvironment(code);
    AcceptInputText = FALSE;
    sprintf(errormessage,"end{document} found line %d", linenumber);
    Message(errormessage);
  }
}

/******************************************************************************/
void CmdUsePackage(int code)
/******************************************************************************
  purpose: converts the tite, author and date-information from LaTex to Rtf
parameter: code includes which type of the information listed above will be converted
 ******************************************************************************/
{
  char errormessage[256]="";
	
  GetParam(UsePackageText,255);
    if (Debug) 
    { sprintf(errormessage,"\\usepackage=|%s|",UsePackageText);
      Message(errormessage);
    };
}

/******************************************************************************/
void CmdTitle(int code)
/******************************************************************************
  purpose: converts the tite, author and date-information from LaTex to Rtf
parameter: code includes which type of the information listed above will be converted
 ******************************************************************************/
{
#define TITLE_END ""
#define AUTHOR_END ""
#define DATE_END ""

  char TITLE_BEGIN[10];
  char AUTHOR_BEGIN[10];
  char DATE_BEGIN[10];
  int zz;
  static char title[1000] = "";
  static char author[1000] = "";
  static char date[500] = "";

  switch (code)
  {
    case TITLE_TITLE: GetParam(title,999);
        	      break;
    case TITLE_AUTHOR: TITLE_AUTHOR_ON = TRUE; /* is used for the \and command */
        	       GetParam(author,999);
        	       TITLE_AUTHOR_ON = FALSE;
        	       break;
    case TITLE_DATE: GetParam(date,499);
        	     break;
    case TITLE_MAKE:

/*      sprintf(TITLE_BEGIN,"%s%2d", "\\fs", (30*fontsize)/20); */
/*      sprintf(AUTHOR_BEGIN,"%s%2d", "\\fs", (24*fontsize)/20); */
/*      sprintf(DATE_BEGIN,"%s%2d", "\\fs", (24*fontsize)/20); */

      fprintf(fRtf,"\n\r\\par\\pard\\qc");
      PushEnvironment(TITLE);
      CmdFontSize(title_fontsize);
      ConvertString(title);
      PopEnvironment(TITLE);
      fprintf(fRtf,"%s",TITLE_END);

      fprintf(fRtf,"\n\r\\par\\qc");
      PushEnvironment(AUTHOR);
      CmdFontSize(author_fontsize);
      ConvertString(author);
      PopEnvironment(AUTHOR);
      fprintf(fRtf,"%s",AUTHOR_END);

      CmdFontSize(section_fontsize[SECT_SUBSUB]);
      fprintf(fRtf,"\n\r\\par\\qc {");
      ConvertString(date);
      fprintf(fRtf,"}%s",DATE_END);
      fprintf(fRtf,"\n\r\\par\n\\par\\pard\\fi%d\\q%c ",
        parindent[iEnvCount],alignment[iEnvCount]);
      if (titlepage == TRUE)
        fprintf(fRtf,"\\page ");

      CmdFontSize(20); CmdSetFont(F_ROMAN);        
      break;
  }
}

/****************************************************************************/
void MakeTheFont(int code)  /* writes section title font */
/****************************************************************************
purpose: write the general section font into TheFont
 ****************************************************************************/
{ int scaled_size = (section_fontsize[code] * fontsize)/20;
  sprintf(TheFont,"\\b\\f0\\fs%d\\lang1031 ",scaled_size);
}

/****************************************************************************/
void InitiateRtf()  /* writes RTF header */
/****************************************************************************
purpose: writes RTF-header.
 ****************************************************************************/
{
  int style_number=0; int sectlev; int pagenum_style_number=0;

  section_fontsize[SECT_PART]=(60*fontsize)/20;
  section_fontsize[SECT_CHAPT]=(50*fontsize)/20;
  section_fontsize[SECT_NORM]=(40*fontsize)/20;
  section_fontsize[SECT_SUB]=(30*fontsize)/20;
  section_fontsize[SECT_SUBSUB]=(24*fontsize)/20;
  section_fontsize[SECT_PARA]=(22*fontsize)/20;
  section_fontsize[SECT_SUBPARA]=(20*fontsize)/20;

  section_sb[SECT_PART]=(400*fontsize)/20;
  section_sb[SECT_CHAPT]=(300*fontsize)/20;
  section_sb[SECT_NORM]=(240*fontsize)/20;
  section_sb[SECT_SUB]=(200*fontsize)/20;
  section_sb[SECT_SUBSUB]=(180*fontsize)/20;
  section_sb[SECT_PARA]=(160*fontsize)/20;
  section_sb[SECT_SUBPARA]=(140*fontsize)/20;

  for (sectlev = 0; sectlev < SECT_MAXLEVEL; sectlev++)
    section_sa[sectlev]=(2*section_sb[sectlev])/3;

  title_fontsize=(40*fontsize)/20;
  author_fontsize=(30*fontsize)/20;
  /* write header */
  fprintf(fRtf,"{\\rtf1\\ansi\\fs%d\\deff0\\deflang1024",fontsize);
  fprintf(fRtf,"{\\stylesheet{\\fs%d\\lang1031\\snext0 Normal;}",fontsize);

  if ( book )
  { style_number+=1;
    section_style[SECT_PART] = style_number;
    MakeTheFont(SECT_PART);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_PART]);
    fprintf(fRtf,"\\pnlvl%d\\pnucrm\\pnprev1\\pnstart1\\pnsp144}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_CHAPT] = style_number;
    MakeTheFont(SECT_CHAPT);
    fprintf(fRtf,"\n{\\page\\qc\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_CHAPT]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144{\\pntxtb \\endash}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_NORM] = style_number;
    MakeTheFont(SECT_NORM);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_NORM]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144{\\pntxtb-}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);
  };

  if ( report )
  { style_number+=1;
    section_style[SECT_CHAPT] = style_number;
    MakeTheFont(SECT_CHAPT);
    fprintf(fRtf,"\n{\\qc\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_CHAPT]);
    fprintf(fRtf,"\\pnlvl%d\\pnucrm\\pnprev1\\pnstart1\\pnsp144}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_NORM] = style_number;
    MakeTheFont(SECT_NORM);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_NORM]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144{\\pntxtb \\endash}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);
  };

  if ( article )
  {
    style_number+=1;
    section_style[SECT_NORM] = style_number;
    MakeTheFont(SECT_NORM);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_NORM]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);
  }

  if ( book || report || article)
  {
    style_number+=1;
    section_style[SECT_SUB] = style_number;
    MakeTheFont(SECT_SUB);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_SUB]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144{\\pntxtb.}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_SUBSUB] = style_number;
    MakeTheFont(SECT_SUBSUB);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_SUBSUB]);
    fprintf(fRtf,"\\pnlvl%d\\pndec\\pnprev1\\pnstart1\\pnsp144{\\pntxtb.}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_PARA] = style_number;
    MakeTheFont(SECT_PARA);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_PARA]);
    fprintf(fRtf,"\\pnlvl%d\\pnucltr\\pnprev1\\pnstart1\\pnsp144{\\pntxtb.}}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);

    style_number+=1;
    section_style[SECT_SUBPARA] = style_number;
    MakeTheFont(SECT_SUBPARA);
    fprintf(fRtf,"\n{\\s%d\\sb%d\\keepn{\\*\\pn ",style_number,
      section_sb[SECT_SUBPARA]);
    fprintf(fRtf,"\\pnlvl%d\\pncltr\\pnprev1\\pnstart1\\pnsp144}",style_number);
    fprintf(fRtf,"%s\\sbasedon0\\snext0 heading %d;}",TheFont,style_number);
  };
  /* additional character styles and styles for page numbering */
  style_number +=1 ; pagenum_style_number = style_number;
  fprintf(fRtf,"\n{\\s%d\\tqc\\lang1031\\sbasedon0\\snext%d footer;}",style_number,style_number);
  fprintf(fRtf,"\n{\\*\\cs16 \\additive\\super\\sbasedon10 footnote reference;}");
  fprintf(fRtf,"\n{\\*\\cs18 \\additive\\sbasedon10 page number;}");
  /* end additional character styles and styles for page numbering */
  fprintf(fRtf,"}"); /* end style sheet */
  fprintf(fRtf,"\n{\\info{\\version1}}");
  fprintf(fRtf,"\n{\\widowctrl\\ftnbj\\sectd\\linex0\\endnhere");
  /* test for page numbering 
  fprintf(fRtf,"\n{\\footer\\pard\\plain\\s%d\\pvpara\\phmrg\\posy0", pagenum_style_number);
  fprintf(fRtf,"\n{\\field{\\*\\fldinst {\\cs18 PAGE  }}");
  fprintf(fRtf,"\n{\\fldrslt {\\cs18 2}}");
  fprintf(fRtf,"\n}"); end \\field 
  fprintf(fRtf,"\n}"); end \\footer 
    end test for page numbering */
  fprintf(fRtf,"\\qj ");
  MakeCheck(1);
}

/******************************************************************************/
void MakeCheck(int level)
/******************************************************************************
 purpose: installs {\*\parenrtf <level>} for bracket checking
 ******************************************************************************/
{
  fprintf(fRtf,"\n{\\*\\parenrtf %d}\n",level);
};

/******************************************************************************/
void EndDocumentStyle()
/******************************************************************************
 purpose: installs final results of DocumentStyle into
          Rtf-information and general storage
 ******************************************************************************/
{
 curr_fontsize[iEnvCount]=fontsize;

 /* moved from main.c by DT */
    InitiateRtf();
    WriteFontHeader(fRtf);
/* end move DT */

 fprintf(fRtf,"\\fs%d ",fontsize); /* default or new fontsize */

 if ( twocolumn )
 {   fprintf(fRtf,"\\cols2\\colsx709 "); /* two columns */
        	     /* space between columns */
 }

}

/******************************************************************************/
void CmdDocumentStyle(int code)
/******************************************************************************
 purpose: reads the information from the LaTex-documentsstyle-command and
          converts it to a similar Rtf-information
 ******************************************************************************/
{
  static char style[100] = "";
  char optstring[30] = "";
  int optparam = FALSE;

  char  cThis = ' ';

  article = FALSE;
  book = FALSE;
  report = FALSE;

     while ( cThis == ' ')
     {
        if ( (fread(&cThis,1,1,fTex) < 1))
         numerror(ERR_EOF_INPUT);
     }

     for(;;) /* do forever */
     {
        fseek(fTex,-1L,SEEK_CUR); /* reread last character */

        switch (cThis)
        {
           case '{' : GetParam(style,99);  /* article, report, bookstyle are the same */
        	      if (strcmp(style,"article") == 0)
        		{ article = TRUE; }
        	      else if (strcmp(style,"report") == 0)
        		{ report = TRUE; }
        	      else if (strcmp(style,"book") == 0)
        		{ book = TRUE; };
        	      break;
           case '[' : GetOptParam(style,99);
        	      optparam = TRUE;
        	      break;
           default :  /* last character was read again above.
        		 this character will be written in the rtf-file in the
        		 convert-routine (main.c) */

                      EndDocumentStyle();
        	      return;
        	      break;
        } /* switch */

        if (optparam)
        {
            /* returnstring of GetOptParam will be separated in his components */
            do
            {
        	 strcpy(optstring,(char*)GetSubString(style,','));

        	 if (strcmp(optstring,"11pt") == 0)
                  {fontsize = 22; /* fontsize 11-TEX -> 22-RTF */
                   curr_fontsize[iEnvCount]=fontsize;
                   curr_fontsize[0]=fontsize;
                   curr_fontsize[1]=fontsize;
                   sprintf(PointSize,"%s",optstring);
                  }

        	 else if (strcmp(optstring,"12pt") == 0)
        	  {fontsize = 24; /* fontsize 12-TEX -> 24-RTF */
                   curr_fontsize[iEnvCount]=fontsize;
                   curr_fontsize[0]=fontsize;
                   curr_fontsize[1]=fontsize;
                   sprintf(PointSize,"%s",optstring);
                  }

        	 else if (strcmp(optstring,"german") == 0)
        	    { GermanMode = TRUE; PushEnvironment(GERMANMODE); }

        	 else if (strcmp(optstring,"twoside") == 0)
        	     /* default */;

        	 else if (strcmp(optstring,"twocolumn") == 0)
        	    {
        	    twocolumn = TRUE;
        	    }
        	else if (strcmp(optstring,"titlepage") == 0)
        	    {
        	    titlepage = TRUE;
        	    }

            }
             while (strcmp(optstring,"") != 0);
      }; /* if */

      if ( (fread(&cThis,1,1,fTex) < 1)) /* read next character */
           numerror(ERR_EOF_INPUT);

    }; /* for */
}

/******************************************************************************/
void CmdSection(int code)
/******************************************************************************
  purpose: converts the LaTex-section-commands into similar Rtf-styles
parameter: code: type of section-recursion-level, set numbering
 ******************************************************************************/
{
 CmdAllSection(code,TRUE);
};

/******************************************************************************/
void CmdAllSection(int code, BOOL numbering)
/******************************************************************************
  purpose: converts the LaTex-section-commands into similar Rtf-styles
parameter: code: type of section-recursion-level
 ******************************************************************************/
{
#define PART_END "}"
#define CHAPTER_END "}"
#define SECTNORM_END "}"
#define SECTSUB_END "}"
#define SECTSUBSUB_END "}"
#define SECTPARA_END "}"
#define SECTSUBPARA_END "}"
#define THE_ANY_SECT_LEN 32

  static char thepart[THE_ANY_SECT_LEN]="";
  static char thechapter[THE_ANY_SECT_LEN]="";
  static char thesection[THE_ANY_SECT_LEN]="";
  static char thesubsection[THE_ANY_SECT_LEN]="";
  static char thesubsubsection[THE_ANY_SECT_LEN]="";

  char PART_BEGIN[MAXPNLEN];
  char CHAPTER_BEGIN[MAXPNLEN];
  char SECTNORM_BEGIN[MAXPNLEN];
  char SECTSUB_BEGIN[MAXPNLEN];
  char SECTSUBSUB_BEGIN[MAXPNLEN];
  char SECTPARA_BEGIN[MAXPNLEN];
  char SECTSUBPARA_BEGIN[MAXPNLEN];

  char thepntext[MAXPNLEN]="";
  char thepnprops[MAXPNLEN]="";

  BOOL Numbering = numbering;

  char optparam[100] = "";
  char cNext = ' ';
  static int section_number[SECT_MAXLEVEL] = {0};
  int kkk;

  if ( (fread(&cNext,1,1,fTex) < 1))
         numerror(ERR_EOF_INPUT);
  if (cNext == '*')
  { Numbering=FALSE;
  }else{
    fseek(fTex,-1L,SEEK_CUR); /* reread last character */
  }
  if (cNext == '[')
     GetOptParam(optparam,99);

  if ( Numbering )
  {
    section_number[code]+=1;
    for (kkk=code+1; kkk<SECT_MAXLEVEL ; kkk++)
    {
    	section_number[kkk]=0;
    }

  };

  MakeCheck(1);

  MakeTheFont(code);

  switch (code)
  {
  case SECT_PART:
    sprintf(thepart,"%d",section_number[code]);
    sprintf(thepntext,
      "{\\pntext\\pard\\plain\\qc %s%s\\tab}",TheFont,thepart);
    sprintf(PART_BEGIN, "%s%2d%s", "{\\fs", section_fontsize[code], "\\b\\i0");
    
    fprintf(fRtf,"\n\r\\page");
    DoParCmd();
    if ( Numbering )
    {
        fprintf(fRtf,"\n\r%s%s ",thepntext,PART_BEGIN);
    }else{
        fprintf(fRtf,"\n\r%s",PART_BEGIN);
    };
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    fprintf(fRtf,"\n\r");
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip += section_sa[code];
    break;
  case SECT_CHAPT:
    if ( book )
      { sprintf(thechapter,"%s-%d",thepart,section_number[code]); }
    else
      { sprintf(thechapter,"%d",section_number[code]); }
    ;
    sprintf(thepntext,
      "{\\pntext\\pard\\plain\\qc %s%s.\\tab}",TheFont,thechapter);
    sprintf(thepnprops,
      "\\pard\\plain\\qc\\s%d\\sb%d%s\\keepn{\\*\\pn \\pnlvl%d\\pnprev1}",
      section_style[code],section_sb[code],TheFont,section_style[code]);
    sprintf(CHAPTER_BEGIN, "\\qc");
    fprintf(fRtf,"\n\r\\page");
    if ( Numbering )
    {
        fprintf(fRtf,"\n\r\\par\\pard\\plain\\qc %s%s. %s ",thepntext,thepnprops,CHAPTER_BEGIN);
    }else{
        fprintf(fRtf,"\n\r\\par\\sb%d\\sa%d %s",section_sb[SECT_CHAPT],section_sa[SECT_CHAPT],CHAPTER_BEGIN);
    };
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    fprintf(fRtf,"\n\r");
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip += section_sa[code];
    break;
  case SECT_NORM:
    if ( book )
      {
       sprintf(thesection,"%s.%d",thechapter,section_number[code]);
      }
    else if ( report )
      {
       sprintf(thesection,"%s.%d",thechapter,section_number[code]);
      }
    else
      {
       sprintf(thesection,"%d",section_number[code]);
      }
    ;
    sprintf(thepntext,
      "{\\pntext\\pard\\plain%s%s\\tab}",TheFont,thesection);
    sprintf(thepnprops,
      "\\pard\\plain\\s%d\\sb%d%s\\keepn{\\*\\pn \\pnlvl%d\\pnprev1}",
      section_style[code],section_sb[code],TheFont,section_style[code]);
    DoParCmd();
    if ( Numbering )
    {
        fprintf(fRtf,"\n\r%s%s",thepntext,thepnprops);
    }else{
        fprintf(fRtf,"\n\r\\fi0\\sb%d",section_sb[code]);
    };
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip = section_sa[code];
    break;
  case SECT_SUB:
    sprintf(thesubsection,"%s.%d",thesection,section_number[code]);
    sprintf(thepntext,
      "{\\pntext\\pard\\plain%s%s\\tab}",TheFont,thesubsection);
    sprintf(thepnprops,
      "\\pard\\plain\\s%d\\sb%d%s\\keepn{\\*\\pn \\pnlvl%d\\pnprev1}",
      section_style[code],section_sb[code],TheFont,section_style[code]);
    DoParCmd();  
    if ( Numbering )
    {
        fprintf(fRtf,"\n\r%s%s",thepntext,thepnprops);
    }else{
        fprintf(fRtf,"\n\r\\fi0\\sb%d",section_sb[code]);
    };
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip = section_sa[code];
    break;
  case SECT_SUBSUB:
    sprintf(thesubsubsection,"%s.%d",thesubsection,section_number[code]);
    sprintf(thepntext,
      "{\\pntext\\pard\\plain%s%s\\tab}",TheFont,thesubsubsection);
    sprintf(thepnprops,
      "\\pard\\plain\\s%d\\sb%d%s\\keepn{\\*\\pn \\pnlvl%d\\pnprev1}",
      section_style[code],section_sb[code],TheFont,section_style[code]);
    DoParCmd();
    if ( Numbering )
    {
        fprintf(fRtf,"\n\r%s%s",thepntext,thepnprops);
    }else{
        fprintf(fRtf,"\n\r\\fi0\\sb%d",section_sb[code]);
    };
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip = section_sa[code];
    break;
  case SECT_PARA:
    DoParCmd();
    fprintf(fRtf,"\n\r\\fi0\\sb%d",section_sb[code]);
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip = section_sa[code];
    break;
  case SECT_SUBPARA:
    DoParCmd();
    fprintf(fRtf,"\n\r\\fi0\\sb%d",section_sb[code]);
    PushEnvironment(GROUP);
    CmdFontSize(section_fontsize[code]); CmdSetFont(F_BOLD);
    Convert();
    PopEnvironment(GROUP);
    CmdParPlain(0); CmdRestoreFont();
    bNewPar = TRUE;
    FutureSkip = section_sa[code];
    break;
  };
  DoIndent(); IgnoreSpaces = TRUE;
};

/******************************************************************************/
void DoIndent()
/******************************************************************************
 purpose: outputs the paragraph indenting specifications
 ******************************************************************************/
{
  if (environ_mode[iEnvCount] == ITEMIZE)
  {
    fprintf(fRtf,"\\tx%d\\fi0\\li%d\\ri%d ",
    left_item_indent,indent,right_indent);
  }
  else if (environ_mode[iEnvCount] == DESCRIPTION)
  {
    fprintf(fRtf,"\\tx%d\\fi0\\li%d\\ri%d ",
    left_item_indent,indent,right_indent);
  }
  else if (environ_mode[iEnvCount] == ENUMERATE)
  {
    fprintf(fRtf,"\\tx%d\\fi0\\li%d\\ri%d ",
    left_item_indent,indent,right_indent);
  }
  else if (NextIndent)
  {
    fprintf(fRtf,"\\fi%d ",parindent[iEnvCount]);
  }else{
    fprintf(fRtf,"\\fi0 ");
  };
}

/******************************************************************************/
void CmdFootNote(int code)
/******************************************************************************
 purpose: converts footnotes from LaTex to Rtf
 ******************************************************************************/
{
  char cText[1000] = "";
  char number[255];
  char cNext;
  int text_ref_upsize, foot_ref_upsize;
  char footnote_mark[256];

  if ( (fread(&cNext,1,1,fTex) < 1))
         numerror(ERR_EOF_INPUT);
  fseek(fTex,-1L,SEEK_CUR); /* reread last character */

  if (cNext == '[')
      GetOptParam(number,254); /* is ignored because of the automatic footnumber-generation */

/*  GetParam(cText,999); */
  text_ref_upsize = (6*curr_fontsize[iEnvCount])/20;
  foot_ref_upsize = (6*fontsize)/20;

  if (environ_mode[iEnvCount] == TITLE)
    { sprintf (footnote_mark, "*");
    } else if (environ_mode[iEnvCount] == AUTHOR)
    { sprintf (footnote_mark, "*");
    } else { sprintf(footnote_mark,"\\chftn");
    };

  PushEnvironment(FOOTNOTE);
  fprintf(fRtf,"\\up%d", text_ref_upsize); CmdSetFont(F_ROMAN);
  CmdFontSize(curr_fontsize[iEnvCount]);
  fprintf(fRtf,"%s",footnote_mark);
  PushEnvironment(FOOTNOTE);
  fprintf(fRtf,"\\footnote \\pard\\plain\\qj \\lang1031");
  fprintf(fRtf,"{\\up%d",foot_ref_upsize);
  CmdSetFont(F_ROMAN); CmdFontSize(14);
  fprintf(fRtf,"%s}{", footnote_mark);
  CmdSetFont(F_ROMAN);
  CmdFontSize(16);
  Convert(); fprintf(fRtf,"}");
  PopEnvironment(FOOTNOTE);
  PopEnvironment(FOOTNOTE);
}

/******************************************************************************/
void CmdQuote(int code)
/******************************************************************************
  purpose: converts the LaTex-Quote-commands into similar Rtf-commands
parameter: code: QUOTE and QUOTATION On/Off
        	 specifies the recursion-level of these commands
 globals : indent : includes the left-indent-position
 ******************************************************************************/
{ int quote_skip = 3;
  switch(code)
  {
    case (QUOTE | ON):
      PushEnvironment(QUOTE);
      indent += indent_quantum;
      right_indent += indent_quantum;
      CmdSkip(quote_skip);
      DoParCmd();
      fprintf(fRtf,"\\li%d\\ri%d",indent,right_indent);
      if(FutureSkip > 0) fprintf(fRtf,"\\sb%d", FutureSkip);
      break;
    case (QUOTE | OFF):
      PopEnvironment(QUOTE);
      CmdSkip(quote_skip);
      DoParCmd();
      indent -= indent_quantum;
      right_indent -= indent_quantum;
      break;
    case (QUOTATION | ON):
      PushEnvironment(QUOTATION);
      indent += indent_quantum;
      right_indent += indent_quantum;
      CmdSkip(quote_skip); 
      DoParCmd();
      fprintf(fRtf,"\\li%d\\ri%d",indent,right_indent);
      if(FutureSkip > 0) fprintf(fRtf,"\\sb%d", FutureSkip);
      break;
    case (QUOTATION | OFF):
      DoParCmd();
      PopEnvironment(QUOTATION);
      CmdSkip(quote_skip);
      indent -= indent_quantum;
      right_indent -= indent_quantum;
      break;
  }
}

/******************************************************************************/
void CmdMulticols(int code)
/******************************************************************************
  purpose: put to multicolumn and off. Gets number of cols
 ******************************************************************************/
{ char text[500];
  switch(code)
  {
    case (MULTICOLS | ON):
      GetParam(text,499);
      if (NumberColumns != 1) error ("Embedded multicols not implemented");
      sscanf(text,"%d",&NumberColumns);
      PushEnvironment(MULTICOLS);
      DoParCmd();
      fprintf(fRtf,"\n{\\sbknone\\sect}\\cols%d\\colsx%d",NumberColumns,ColSep);
      break;
    case (MULTICOLS | OFF):
      DoParCmd();
      fprintf(fRtf,"\n\\sbknone\\sect");
      PopEnvironment(MULTICOLS);
      NumberColumns = 1;
      fprintf(fRtf,"\\sectd");
      break;
  }
}

/******************************************************************************/
void CmdUnknownEnvir(int code)
/******************************************************************************
  purpose: performs unknown environment as a grup
 ******************************************************************************/
{
  switch(code)
  {
    case (UNKNOWN_ENVIR | ON):
      PushEnvironment(UNKNOWN_ENVIR);
      DoParCmd();
      break;
    case (UNKNOWN_ENVIR | OFF):
      DoParCmd();
      PopEnvironment(UNKNOWN_ENVIR);
      break;
  }
}

/******************************************************************************/
void Enum_Level_Plus()
/******************************************************************************
 Adds one level to enum_level and checks bounds.
 ******************************************************************************/
{
      enum_level += 1;
      if ( enum_level > MAXENVIRONS -1 )
        { fprintf(stderr,"\n%s: Fatal error: more than %d enum levels.",progname, MAXENVIRONS );
          exit(1);
        };
}

/******************************************************************************/
void Enum_Level_Minus()
/******************************************************************************
Subtracts one level to enum_level and checks bounds.
 ******************************************************************************/
{
      enum_level -= 1;
      if ( enum_level < 0 )
        { fprintf(stderr,"\n%s: Fatal error: too many close enum levels.",progname);
          exit(1);
        };
}

/******************************************************************************/
void CmdNoindent(int code)
/******************************************************************************
  purpose : stores the requested noindent
 ******************************************************************************/
{ char text[100] = "";
  float size=0.0;
  char unit[3]={'\0'};

  if (Debug) fprintf(OUTPUTF,"\nCmdNoindent code %d",code);

  switch (code)

  {
    case 0:  NextIndent = FALSE;
             if (ParDone) fprintf(fRtf,"\\fi0 ");
             break;
    case 1: /* parindent */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             parindent[iEnvCount] = DimenToTwips(size,unit);
             if (ParDone) { DoIndent(); IgnoreSpaces = TRUE; }
             if (Debug) fprintf(OUTPUTF,
               "\nCmdNoindent parindent= %d",parindent[iEnvCount]);

             break;
    default: error("Illegal param to CmdNoindent");
  }
}

/******************************************************************************/
void CmdPaper(int code)
/******************************************************************************
  purpose : stores paper width, height, margin commands
 ******************************************************************************/
{ char text[100] = "";
  float size=0.0;
  char unit[3]={'\0'};

  if (Debug) fprintf(OUTPUTF,"\nCmdPaper code %d",code);

  switch (code)

  {
    case 0: /* initialize sizes for A4 paper */
             paperwidth = DimenToTwips(210.0,"mm");
             paperheight = DimenToTwips(297.0,"mm");
             textwidth = paperwidth - 2*DimenToTwips(1,"in");
             textheight = paperheight - 2*DimenToTwips(1,"in");
             hoffset = 0;
             voffset = 0;
             break;
    case 1: /* paperwidth */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             paperwidth = DimenToTwips(size,unit);
             fprintf(fRtf,"\n\\paperw%d",paperwidth);
             break;
    case 2: /* paperheight */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             paperheight = DimenToTwips(size,unit);
             fprintf(fRtf,"\n\\paperh%d",paperheight);
             break;
    case 3: /* textwidth */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             textwidth = DimenToTwips(size,unit);
             fprintf(fRtf,"\n\\margl%d\\margr%d",
               (paperwidth-textwidth)/2,(paperwidth-textwidth)/2);
             break;
    case 4: /* textheight */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             textheight = DimenToTwips(size,unit);
             fprintf(fRtf,"\n\\margt%d\\margb%d",
               (paperheight-textheight)/2,(paperheight-textheight)/2);
             break;
    case 5: /* hoffset */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             hoffset = DimenToTwips(size,unit);
             break;
    case 6: /* voffset */
             fscanf(fTex,"%f%c%c",&size,&unit[0],&unit[1]);
             unit[2]='\0';
             voffset = DimenToTwips(size,unit);
             break;
    default: error("Illegal param to CmdPaper");
  }
}

/******************************************************************************/
void CmdSkip(int codeskip)
/******************************************************************************
  purpose : stores the requested smallskip, medskip, etc.
 ******************************************************************************/
{
  FutureSkip += (codeskip*fontsize);
}
/******************************************************************************/
int DimenToTwips(float size, char *unit)
/******************************************************************************
  purpose : stores the requested vspace value
 ******************************************************************************/
{
  char errormessage[256];
  int SizeTwips=0;

  if(Debug) fprintf(OUTPUTF,"\n>DimenToTwips %f, %s", size,unit);

  if (strcmp(unit,"pt") == 0)
  { SizeTwips = 20*size;
  }
  else if (strcmp(unit,"pc") == 0)
  { SizeTwips = 12*20*size;
  }
  else if (strcmp(unit,"in") == 0)
  { SizeTwips = 72.27*20*size;
  }
  else if (strcmp(unit,"bp") == 0)
  { SizeTwips = (72.27*20*size)/72.0;
  }
  else if (strcmp(unit,"cm") == 0)
  { SizeTwips = (72.27*20*size)/2.54;
  }
  else if (strcmp(unit,"mm") == 0)
  { SizeTwips = (72.27*20*size)/25.4;
  }
  else if (strcmp(unit,"dd") == 0)
  { SizeTwips = (1238.0*20*size)/1157.0;
  }
  else if (strcmp(unit,"cc") == 0)
  { SizeTwips = 12*(1238.0*20*size)/1157.0;
  }
  else if (strcmp(unit,"sp") == 0)
  { SizeTwips = (20*size)/65536.;
  }
  else
  {
    sprintf(errormessage,"Illegal dimension unit %s at line %d",unit,pbm_linenumber);
    error(errormessage);
  };

  if(Debug) fprintf(OUTPUTF,"\n<DimenToTwips %d", SizeTwips);

  return SizeTwips;
}
/******************************************************************************/
void CmdVspace(int codeskip)
/******************************************************************************
  purpose : stores the requested vspace value
 ******************************************************************************/
{
  char text[500];
  char errormessage[256];
  float size=0.0;
  char unit[3]={'\0'};

  GetParam(text,499);
  sscanf(text,"%f%c%c",&size,&unit[0],&unit[1]);
  unit[2]='\0';

/*  if (strcmp(unit,"pt") == 0)
  { SizeTwips = 20*size;
  }
  else if (strcmp(unit,"pc") == 0)
  { SizeTwips = 12*20*size;
  }
  else if (strcmp(unit,"in") == 0)
  { SizeTwips = 72.27*20*size;
  }
  else if (strcmp(unit,"bp") == 0)
  { SizeTwips = (72.27*20*size)/72.0;
  }
  else if (strcmp(unit,"cm") == 0)
  { SizeTwips = (72.27*20*size)/2.54;
  }
  else if (strcmp(unit,"mm") == 0)
  { SizeTwips = (72.27*20*size)/25.4;
  }
  else if (strcmp(unit,"dd") == 0)
  { SizeTwips = (1238.0*20*size)/1157.0;
  }
  else if (strcmp(unit,"cc") == 0)
  { SizeTwips = 12*(1238.0*20*size)/1157.0;
  }
  else if (strcmp(unit,"sp") == 0)
  { SizeTwips = (20*size)/65536.;
  }
  else
  {
    sprintf(errormessage,"Illegal dimension unit %s at line %d",unit,linenumber);
    error(errormessage);
  }; */

  FutureSkip += DimenToTwips(size,unit);
}

/******************************************************************************/
void CmdPar(int code)
/******************************************************************************
  purpose : make the /par command with optional first indent
 ******************************************************************************/
{
  DoParCmd();
  if (bPard)
  {
    fprintf(fRtf,"\\pard\\q%c ",alignment[iEnvCount]);
    DoIndent(); IgnoreSpaces = TRUE;
    bPard = FALSE;
  }
};

/******************************************************************************/
void CmdList(int code)
/******************************************************************************
  purpose : converts the LaTeX-environments itemize, description and enumerate
            to similar Rtf-styles
            (only the begin/end-commands and not the commands inside the environment
             see also function CmdItem)
parameter : code : type of environment and on/off-state
 globals  : nonewline, indent: look at function CmdQuote
 ******************************************************************************/
{
  switch (code)
  {
    case (ITEMIZE | ON):
      DoParCmd();
      PushEnvironment(ITEMIZE);
      indent += indent_quantum;
      alignment[iEnvCount] = JUSTIFIED; /* essai */
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]); /* essai */
      fprintf(fRtf,"\\li%d\\ri%d\\sb%d\\sa%d",indent,right_indent,fontsize/4,fontsize/4);
      bNewPar = FALSE;
      IgnoreSpaces = TRUE;
      break;
    case (ITEMIZE | OFF):
      DoParCmd();
      PopEnvironment(ITEMIZE);
      indent -= indent_quantum;
      IgnoreSpaces = TRUE; /* ??? */
      bNewPar = TRUE;
      break;
    case (ENUMERATE | ON):
      DoParCmd();
      PushEnvironment(ENUMERATE);
      CmdItem(RESET);
      indent += indent_quantum;
      alignment[iEnvCount] = JUSTIFIED; /* essai */
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]); /* essai */
      fprintf(fRtf,"\\li%d\\ri%d\\sb%d\\sa%d",indent,right_indent,fontsize/4,fontsize/4);
      Enum_Level_Plus();
      bNewPar = FALSE;
      IgnoreSpaces = TRUE;
      break;
    case (ENUMERATE | OFF):
      DoParCmd();
      PopEnvironment(ENUMERATE);
      indent -= indent_quantum;
      Enum_Level_Minus();
      IgnoreSpaces = TRUE; /* ??? */
      bNewPar = TRUE;
      break;
    case (DESCRIPTION | ON):
      DoParCmd();
      PushEnvironment(DESCRIPTION);
      indent += indent_quantum;
      alignment[iEnvCount] = JUSTIFIED; /* essai */
      fprintf(fRtf,"\\pard \\q%c ",alignment[iEnvCount]); /* essai */
      fprintf(fRtf,"\\li%d\\ri%d\\sb%d\\sa%d",indent,right_indent,fontsize/4,fontsize/4);
      bNewPar = FALSE;
      IgnoreSpaces = TRUE;
      break;
    case (DESCRIPTION | OFF):
      DoParCmd();
      PopEnvironment(DESCRIPTION);
      indent -= indent_quantum;
      IgnoreSpaces = TRUE; /* ??? */
      bNewPar = TRUE;
      break;
  }
}

/******************************************************************************/
void CmdItem(int code)
/******************************************************************************
 purpose : makes the same as the function CmdList except that
           here are only \-commands are handled and in the function
           CmdList only the \begin or \end{environment}-command is handled
parameter : code : type of environment and on/off-state
 globals  : nonewline, indent: look at funtction CmdQuote
 ******************************************************************************/
{ char labeltext[100];
  char cNext;
  static int enum_number[MAXENVIRONS] = {0};
  int left_enum_indent = (3*left_item_indent)/2;
  char enum_letter[10];
  enum_letter[1]='\0';
  switch (code)
  {
    case RESET:
      enum_number[iEnvCount] = 0;
      break;
    case ITEMIZE:
      DoParCmd();
      if ( (fread(&cNext,1,1,fTex) < 1))
              numerror(ERR_EOF_INPUT);
      fseek(fTex,-1L,SEEK_CUR); /* reread last character */

      labeltext[0] = '\0';
      if (cNext == '[')
           GetOptParam(labeltext,99);
      if ( AutoNumItems )
      {
        fprintf(fRtf,"{\\pntext\\pard\\plain\\f1\\fs20}");
        fprintf(fRtf,"\\pard \\qj\\fi-%d\\li%d\\ri%d",left_item_indent,indent,right_indent);
        fprintf(fRtf,"{\\*\\pn \\pnlvlblt\\pnf1\\pnstart1\\pnindent%d",left_item_indent);
        fprintf(fRtf,"\\pnhang{\\pntxtb \\bullet}}");
      }else{
        fprintf(fRtf,"\\tx%d\\fi%d\\li%d\\ri%d{\\b ",
          left_item_indent,-left_item_indent,indent,right_indent);
        if (labeltext[0] == '\0')
          { fprintf(fRtf,"\\endash\\tab}");
          } else
          { ConvertString(labeltext); 
            fprintf(fRtf,"\\tab}"); IgnoreSpaces = TRUE;
          }
      };
       labeltext[0] = '\0';
/*      fprintf(fRtf,"}\\~"); */
      bNewPar = TRUE;
      ParDone = FALSE;
      break;
    case ENUMERATE:
      DoParCmd();
      enum_number[iEnvCount] +=1;

      if ( (fread(&cNext,1,1,fTex) < 1))
              numerror(ERR_EOF_INPUT);
      fseek(fTex,-1L,SEEK_CUR); /* reread last character */
      labeltext[0] = '\0';
      if (cNext == '[')
           GetOptParam(labeltext,99);

      if ( AutoNumItems )
      {
        fprintf(fRtf," {\\pntext\\pard\\plain\\f1\\fs20}");
        fprintf(fRtf,"\\pard \\qj\\fi-%d\\li%d\\ri%d",2*left_item_indent,indent,right_indent);
        fprintf(fRtf,"{\\*\\pn \\pnlvlbody\\pndec\\pnqr\\pnsp%d\\pnf1\\pnstart%d\\pnindent%d",
        left_item_indent,enum_number[iEnvCount],2*left_item_indent);
/*      fprintf(fRtf,"\\pnhang{\\pntxta\\emspace}"); */
        fprintf(fRtf,"\\pnhang");
        fprintf(fRtf,"}");
      }else if (labeltext[0] == '\0')
      {
      	left_enum_indent = ((3*left_item_indent)/2)+4*curr_fontsize[iEnvCount];
      	switch (enum_level)
      	{ case 2:
            enum_letter[0] = 'a'-1+enum_number[iEnvCount];
            fprintf(fRtf,"\\tx%d\\fi%d\\li%d\\ri%d{\\b (%s)\\tab}",
            left_enum_indent,-left_enum_indent,indent,right_indent,enum_letter);
            break;
          default:
            if ( enum_number[iEnvCount] > 9 )
            {
              fprintf(fRtf,"\\tx%d\\fi%d\\li%d\\ri%d{\\b %d.\\tab}",
              left_enum_indent,-left_enum_indent,indent,right_indent,enum_number[iEnvCount]);
            }else{ 
              fprintf(fRtf,"\\tx%d\\fi%d\\li%d\\ri%d{\\b \\~\\~%d.\\tab}",
              left_enum_indent,-left_enum_indent,indent,right_indent,enum_number[iEnvCount]);
            }; break;
        }
      }else
      {  fprintf(fRtf,"\\fi-340\\li%d\\ri%d{\\b ",indent,right_indent);
         ConvertString(labeltext);
         fprintf(fRtf,"}\\~");
      };
      bNewPar = TRUE;
      ParDone = FALSE;
      break;
    case DESCRIPTION:
      DoParCmd();
      if ( (fread(&cNext,1,1,fTex) < 1))
              numerror(ERR_EOF_INPUT);
      fseek(fTex,-1L,SEEK_CUR); /* reread last character */
      labeltext[0] = '\0';
      if (cNext == '[')
           GetOptParam(labeltext,99);
      fprintf(fRtf,"\\fi-340\\li%d\\ri%d ",indent,right_indent);
      PushEnvironment(GROUP);
      CmdSetFont(F_BFSERIES);
      ConvertString(labeltext);
      PopEnvironment(GROUP);
      fprintf(fRtf,"\\~");
      bNewPar = TRUE;
      ParDone = FALSE;
      break;
  }
}

/******************************************************************************/
void CmdMbox(int code)
/******************************************************************************
  purpose: converts the LaTeX \mbox-command into  an similar Rtf-style
  globals: mbox
 ******************************************************************************/
{
  mbox = TRUE;
  Convert();
  mbox = FALSE;
}

/******************************************************************************/
void ConvertFormula()
/******************************************************************************
 purpose : necessary commands for the formula-environment are pushed onto a stack
 globals : MathMode
 ******************************************************************************/
{
  Push(RecursLevel,BracketLevel);
  ++BracketLevel;    /* Math End char is treated as } math begin as { */
  Push(RecursLevel,BracketLevel);
  MathMode[iEnvCount] = TRUE;
  Convert();
  MathMode[iEnvCount] = FALSE;
}

/******************************************************************************/
void CmdSetFont(int code)
/******************************************************************************
  purpose: sets a font for the actual character-style
parameter: code: includes the font-type
 ******************************************************************************/
{
  int num;

  switch(code)
  {
    case F_ROMAN: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_SLANTED: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 1;
        	  break;
    case F_SLSHAPE:
                  curr_fontital[iEnvCount] = 1;
        	  break;
    case F_UPSHAPE:
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_ITALIC: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 1;
        	  break;
    case F_BOLD: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 1;
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_BFSERIES:
                  curr_fontbold[iEnvCount] = 1;
        	  break;
    case F_MDSERIES:
                  curr_fontbold[iEnvCount] = 0;
        	  break;
    case F_SANSSERIF: num = GetTexFontNumber("Sans Serif");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_TYPEWRITER: num = GetTexFontNumber("Typewriter");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_RMFAMILY: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
        	  break;
    case F_SFFAMILY: num = GetTexFontNumber("Sans Serif");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
        	  break;
    case F_TTFAMILY: num = GetTexFontNumber("Typewriter");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
        	  break;
    case F_SCFAMILY: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 1;
        	  break;
    case F_SMALLCAPS: num = GetTexFontNumber("Roman");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 1;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 0;
        	  break;
    case F_SYMBOL: num = GetTexFontNumber("Dummy");
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
        	  break;
    default: num = 0;
                  curr_fontnumb[iEnvCount] = num;
                  curr_fontscap[iEnvCount] = 0;
                  curr_fontbold[iEnvCount] = 0;
                  curr_fontital[iEnvCount] = 0;
  };
fprintf(fRtf,"\\f%d\\b%d\\i%d\\scaps%d ",
  curr_fontnumb[iEnvCount],
  curr_fontbold[iEnvCount],
  curr_fontital[iEnvCount],
  curr_fontscap[iEnvCount]);
}

/******************************************************************************/
void CmdRestoreFont()
/******************************************************************************
  purpose: resets all font characteristics for that iEnvCount
                      (environment/group level)
 ******************************************************************************/
{
fprintf(fRtf,"\\fs%d\\f%d\\b%d\\i%d\\scaps%d ",
  curr_fontsize[iEnvCount],
  curr_fontnumb[iEnvCount],
  curr_fontbold[iEnvCount],
  curr_fontital[iEnvCount],
  curr_fontscap[iEnvCount]);
}

/******************************************************************************/
void CmdTextSetFont(int code)
/******************************************************************************
  purpose: sets a font for \\textxx{...}
parameter: code: includes the font-type
 ******************************************************************************/
{
  int num;
  char textsetfontparm[1024]="";
  char TextSetFontParm[1024]="";

/*  return; */

  PushEnvironment(GROUP);
  MathMode[iEnvCount] = FALSE; 
  environ_mode[iEnvCount] = GROUP; 

  GetParam(textsetfontparm,1022);
  sprintf(TextSetFontParm,"%s ",LatexSize[iEnvCount]);
  strncat(TextSetFontParm,textsetfontparm,1022);

  switch(code)
  {
    case F_ROMAN: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps0\\i0\\b0 ",num);
        	  break;
    case F_SLANTED: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps0\\b0\\i ",num);
        	  break;
    case F_ITALIC: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps0\\b0\\i ",num);
        	  break;
    case F_BOLD: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps0\\i0\\b ",num);
        	  break;
    case F_SANSSERIF: num = GetTexFontNumber("Sans Serif");
  fprintf(fRtf,"\\f%d\\scaps0\\b0\\i0 ",num);
        	  break;
    case F_TYPEWRITER: num = GetTexFontNumber("Typewriter");
  fprintf(fRtf,"\\f%d\\scaps0\\b0\\i0 ",num);
        	  break;
    case F_RMFAMILY: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps0 ",num);
        	  break;
    case F_SFFAMILY: num = GetTexFontNumber("Sans Serif");
  fprintf(fRtf,"\\f%d\\scaps0 ",num);
        	  break;
    case F_TTFAMILY: num = GetTexFontNumber("Typewriter");
  fprintf(fRtf,"\\f%d\\scaps0 ",num);
        	  break;
    case F_SCFAMILY: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\scaps ",num);
        	  break;
    case F_SMALLCAPS: num = GetTexFontNumber("Roman");
  fprintf(fRtf,"\\f%d\\b0\\i0\\scaps ",num);
        	  break;
    default: num = 0;
  fprintf(fRtf,"\\f%d ",num);
  };

  ConvertString(TextSetFontParm);
  PopEnvironment(GROUP);
}

/******************************************************************************/
void CmdFrenchAbbrev(int code)
/******************************************************************************
  purpose: makes \\ier, \\ieme, etc
parameter: code: 
 ******************************************************************************/
{
  float FloatFsize;
  float UpSize;
  int upsize;
  char fuptext[128]="";

  if (code == NUMERO) fprintf(fRtf,"n");
  if (code == NUMEROS) fprintf(fRtf,"n");
  if (code == CNUMERO) fprintf(fRtf,"N");
  if (code == CNUMEROS) fprintf(fRtf,"N");
  if (code == PRIMO) fprintf(fRtf,"1");
  if (code == SECUNDO) fprintf(fRtf,"2");
  if (code == TERTIO) fprintf(fRtf,"3");
  if (code == QUARTO) fprintf(fRtf,"4");
  PushEnvironment(GROUP);
  if(curr_fontsize[iEnvCount] > 14)
    { FloatFsize = 0.75*curr_fontsize[iEnvCount];
      curr_fontsize[iEnvCount] = FloatFsize;
    };
  UpSize = 0.3*curr_fontsize[iEnvCount]; upsize = UpSize+0.45;
  fprintf(fRtf,"\\fs%d\\up%d ",curr_fontsize[iEnvCount],upsize);
  switch(code)
  {
    case DEGREE : fprintf(fRtf,"o"); break;  	
    case NUMERO : fprintf(fRtf,"o"); break;  	
    case CNUMERO : fprintf(fRtf,"o"); break;  	
    case NUMEROS : fprintf(fRtf,"os"); break;  	
    case CNUMEROS : fprintf(fRtf,"os"); break;  	
    case PRIMO : fprintf(fRtf,"o"); break;  	
    case SECUNDO : fprintf(fRtf,"o"); break;  	
    case TERTIO : fprintf(fRtf,"o"); break;  	
    case QUARTO : fprintf(fRtf,"o"); break;  	
    case IERF: fprintf(fRtf,"er"); break;  	
    case IERSF: fprintf(fRtf,"ers"); break;  	
    case IEMEF: fprintf(fRtf,"e"); break;  	
    case IEMESF: fprintf(fRtf,"es"); break;  	
    case IEREF: fprintf(fRtf,"re"); break;  	
    case IERESF: fprintf(fRtf,"res"); break;  	
    case FUP: GetParam(fuptext,127);
        ConvertString(fuptext); break;  	
  };
  PopEnvironment(GROUP);
};

/******************************************************************************/
void CmdSuperscript(int code)
/******************************************************************************
  purpose: makes \\textsuperscript{...}
parameter: code: (ignored)
 ******************************************************************************/
{
  char superscript[1024]="";
  float FloatFsize;
  float UpSize;
  int upsize;
  
  GetParam(superscript,1022);
  PushEnvironment(GROUP);
  if(curr_fontsize[iEnvCount] > 14)
    { FloatFsize = 0.75*curr_fontsize[iEnvCount];
      curr_fontsize[iEnvCount] = FloatFsize;
    };
  UpSize = 0.3*curr_fontsize[iEnvCount]; upsize = UpSize+0.45;
  fprintf(fRtf,"\\fs%d\\up%d ",curr_fontsize[iEnvCount],upsize);
  ConvertString(superscript);
  PopEnvironment(GROUP);
}

/******************************************************************************/
void CmdInclude(int code)
/******************************************************************************
 purpose: reads an extern-LaTex-File from the into the actual document and converts it to
          an similar Rtf-style
 globals: GermanMode: is set if germanstyles are included
 ******************************************************************************/
{
  char errormessage[256]="";
  char filename[255] = "";
  FILE *fp,*LatexFile;
  /*fpos_t aktpos;*/
  char oldlatexfilename[PATHMAX];
  long oldlinenumber;

/*  fgetpos(fTex,&aktpos);
  if ( (n=(fread(filename,99,1,fTex)) < 1))
    numerror(ERR_EOF_INPUT);
  filename[n+1] = '\0';

  if (strstr(filename,"german.sty")!=NULL)
  {
    GermanMode = TRUE;
    Message("GermanMode = TRUE - 1");
    PushEnvironment(GERMANMODE);
    return;
  }
  fsetpos(fTex,&aktpos);*/

  GetInputParam(filename,99);
  if (strstr(filename,"german.sty")!=NULL)
  {
    GermanMode = TRUE;
    Message("GermanMode = TRUE - 2");
    PushEnvironment(GERMANMODE);
    return;
  }

  if (strcmp(filename,"") == 0)
     {
     sprintf(errormessage,"Invalid filename after \\include: %s",filename);
     error(errormessage);
     }

  /* extension .tex is appended automaticly */
  if(strchr(filename,'.')==NULL)
    strcat(filename,".tex");
  if ( (fp=(fopen(filename,"r")))==NULL )
  {
    sprintf(errormessage,"Cannot open include file: %s",filename);
    error(errormessage);
  }

  LatexFile = fTex;
  fTex = fp;
  oldlinenumber = linenumber;
  linenumber = 1;
  strcpy(oldlatexfilename,latexname);
  strcpy(latexname,filename);
  BracketLevel++;
  fprintf(fRtf,"{");
  Convert();
  fprintf(fRtf,"}");
  BracketLevel--;

  fTex = LatexFile;
  strcpy(latexname,oldlatexfilename);
  linenumber = oldlinenumber;
  fclose(fp);
}

/******************************************************************************/
void OutVerbatim(FILE **f, char *endstring, BOOL outrtf)
                                /* write anything to f till endstring */
/******************************************************************************
 purpose: each character is converted 1:1 from LaTex
          to file f without converting any LaTex-commands
 ******************************************************************************/
{
  int i=0,j=0;
  char cThis;

  if(Debug) fprintf(OUTPUTF,"\nOutVerbatim /%s/",endstring);

  for(;;)
  {
    if (fread(&cThis, 1,1,fTex) != 1)
      numerror(ERR_EOF_INPUT);
    if ( (cThis != endstring[i]) || ( (i>0) && (cThis == ' ') ) )
    {
      if (i > 0)
      {
        for(j=0;j<i;j++)
        {
          if (outrtf)
          { if (endstring[j] == '\\')
            { fprintf(*f,"\\");}
            else if (endstring[j] == '{')
            { fprintf(*f,"\\");}
            else if (endstring[j] == '}')
            { fprintf(*f,"\\");};
          };
          fprintf(*f,"%c",endstring[j]);
        }
        i = 0;
      };

      if (cThis == '\n') linenumber++;
      if (outrtf)
      { if (cThis == '\\')    /* care for \\ */
          { fprintf(*f,"\\");}
        else if (cThis == '{')    /* care for { */
          { fprintf(*f,"\\");}
        else if (cThis == '}')    /* care for } */
          { fprintf(fRtf,"\\");}
        else if (cThis == '\n')
          { fprintf(*f,"\\par");}
        ;
      };       
      fprintf(*f,"%c",cThis);
    }
    else
    {
      if(Debug) fprintf(OUTPUTF,"\nOutVerbatim i=%d, cThis='%c', endstring[i]=%c",i,cThis,endstring[i]);
      if (cThis != ' ')
        ++i;
      if ((int)i >=(int)strlen(endstring))
        return;
    }
  } /* for */
}

/******************************************************************************/
void CmdVerb(int code)
/******************************************************************************
 purpose: converts the LaTex-verb-environment to a similar Rtf-style
 ******************************************************************************/
{
  char cThis;
  char markingchar='|';   /* Verb-Text is between | or " */
  char endstring[2];
  char errormessage[1024];

  endstring[0] = markingchar;
  endstring[1] = '\0';
  PushEnvironment(GROUP);
  CmdSetFont(F_TYPEWRITER);        
  while (fread(&cThis, 1,1,fTex) == 1)
  {
    if ((cThis == '\"') || (cThis == '|'))
    {
      markingchar = cThis;
      break;
    }
    else
    { sprintf(errormessage,"\\verb%c illegal",cThis);
      error(errormessage);
    }
    
  }
  if (cThis != markingchar)
    numerror(ERR_EOF_INPUT);
  endstring[0] = markingchar;    
  OutVerbatim(&fRtf,endstring,TRUE);
  PopEnvironment(GROUP);
}

/******************************************************************************/
void CmdVerbatim(int code)  /* write anything till \end{verbatim} */
/******************************************************************************
 purpose: in this verb-environment each character is converted 1:1 from LaTex
          to Rtf without converting any LaTex-commands
 ******************************************************************************/
{
  PushEnvironment(GROUP);
  CmdSetFont(F_TYPEWRITER);
  OutVerbatim(&fRtf,"\\end{verbatim}",TRUE);
  PopEnvironment(GROUP);
}

/******************************************************************************/
void CmdVerse(int code)
/******************************************************************************
  purpose: converts the LaTex-Verse-environment to a similar Rtf-style
parameter: code: turns on/off handling routine
 ******************************************************************************/
{
  switch (code)
  {
    case ON :
              fprintf(fRtf,"\n\\par\\pard\\q%c\\fi-567\\li1134\\ri1134\\keep ",alignment[iEnvCount]);
              bNewPar = TRUE;
              break;
    case OFF: fprintf(fRtf,"\n\\par\\pard\\q%c ",alignment[iEnvCount]);
              bNewPar = TRUE;
              break;
  }
}

/******************************************************************************/
void CmdIgnoreDef(int code)
/*****************************************************************************
 purpose: newenvironments or newcommands which are defined by the user can't
          be converted into Rtf and so they've to be ignored
 ******************************************************************************/
{
  char cThis;
  int bracket;

  warning("\\def not interpreted by ltx2rtf\n    use program 'exp-macr' to expand (some] in-line macros");
  /* ignore till '{'  */
  while (fread(&cThis, 1,1,fTex) == 1)
  {
    if (cThis == '{')
      break;
  }
  if (cThis != '{')
    numerror(ERR_EOF_INPUT);
  bracket = 1;
  while (fread(&cThis, 1,1,fTex) == 1)
  {
    if (cThis == '{')
      bracket++;
    if (cThis == '}')
      bracket--;
    if (cThis == '\n')
       { linenumber++; InputLineEmpty = TRUE; };
    if (bracket == 0)
      return;
   /* if (cThis == '%')
    {  in file latex.tex '%' in def means `%` no comment
      IgnoreTo('\n');
    }*/
  }
  if (cThis != '}')
    numerror(ERR_EOF_INPUT);
}

/******************************************************************************/
void TranslateGerman(void)
/***************************************************************************
purpose: called on active german-mode and " character in input file to
         handle " as an active (meta-)character.
globals: reads from fTex and writes to fRtf
 ***************************************************************************/
{
  char cThis;
  while (fread(&cThis, 1,1,fTex) != 1)
  {
    numerror(ERR_EOF_INPUT);
  }
  switch(cThis)
  {
    case 'a': fprintf(fRtf, "\\'e4");
              break;
    case 'o': fprintf(fRtf, "\\'f6");
              break;
    case 'u': fprintf(fRtf, "\\'fc");
              break;
    case 's': fprintf(fRtf, "\\'df");
              break;
    case '|': break;  /* ignore */
    case '-': break;  /* ignore */
    case '"': break;  /* ignore */
    case '\'':fprintf(fRtf, "\\ldblquote ");
              break;
    case '`': fprintf(fRtf, "\\rdblquote ");
              break;
    case '<': break;
    case '>': break;
    default:  fprintf(fRtf,"%c",cThis);
  }
}

/******************************************************************************/
void CmdPrintRtf(int code)
/***************************************************************************
purpose: writes string to RTF file
globals: writes to fRtf
 ***************************************************************************/
{
  fprintf(fRtf,(char*)code);
}

void GermanPrint(int code)
{
  switch(code)
  {
    case GP_CK:fprintf(fRtf,"ck");
        	break;
    case GP_LDBL: fprintf(fRtf,"\\ldblquote");
        	  break;
    case GP_L: fprintf(fRtf,"\\lquote");
               break;
    case GP_R: fprintf(fRtf,"\\rquote");
               break;
    case GP_RDBL: fprintf(fRtf,"\\rdblquote");
  }
}

void CmdIgnoreLet(int code)
{
  char cThis;
  int count=0;
  /* Format: \let\XXXXX = \YYYYYY or \let\XXXXX\YYYYYY
  /* ignore till 2x '\' */

  while (fread(&cThis, 1,1,fTex) == 1)
  {
    if (cThis == '\\')
      count++;
    if (count == 2)
        break;
    if (cThis == '\n')
      {linenumber++; InputLineEmpty = TRUE;};
  }
  if (cThis != '\\')
    numerror(ERR_EOF_INPUT);
  /* ignore all following spaces */
 while (fread(&cThis, 1,1,fTex) == 1)
  {
    if (cThis != ' ')
      break;
  }
  if (cThis == ' ')
    numerror(ERR_EOF_INPUT);
  /* ignore till next space */
  while (fread(&cThis, 1,1,fTex) == 1)
  {
    if (cThis == ' ')
      break;
    if (cThis == '\n')
    {
      linenumber++; InputLineEmpty = TRUE;
      break;
    }
  }
  if ((cThis != ' ') && (cThis != '\n'))
    numerror(ERR_EOF_INPUT);
  /* seek back 1 */
  fseek(fTex,-1L,SEEK_CUR); /* reread last character */
}

void IgnoreNewCmd(int code)
{
  char cThis;
  /* ignore till '{' */
  if (fread(&cThis, 1,1,fTex) != 1)
    numerror(ERR_EOF_INPUT);
  fseek(fTex,-1L,SEEK_CUR); /* reread last character */
  if (cThis == '\\')
    CmdIgnoreDef(0);
  else
    CmdIgnoreParameter(No_Opt_Two_NormParam );
}

#define LABEL 1
#define REF 2
#define PAGEREF 3
void CmdLabel(int code)
{
  char text[500];
  char errormessage[1024];
  char cThis;
  switch (code)
  {
   case LABEL: GetParam(text,499);
               fprintf(fRtf,"{\\*\\bkmkstart %s}",text);
               fprintf(fRtf,"{\\*\\bkmkend %s}",text);
               break;
   case REF:GetParam(text,499);
                sprintf(errormessage,"\\ref{%s} unpredictable at line %d",text,linenumber);
                warning(errormessage);
        	fprintf(fRtf,
                "{\\field{\\*\\fldinst {\\f0\\lang1024  REF %s }}",text);
                fprintf(fRtf,
                "{\\fldrslt {\\f0\\lang1024  REF[%s]}}}",text);
        	break;
   case PAGEREF:GetParam(text,499);
                sprintf(errormessage,"\\pageref{%s} unpredictable at line %d",text,linenumber);
                warning(errormessage);
        	fprintf(fRtf,
                "{\\field{\\*\\fldinst {\\f0\\lang1024  PAGEREF %s \\\\* MERGEFORMAT }}",text);
                fprintf(fRtf,
                "{\\fldrslt {\\f0\\lang1024  PAGEREF[%s]}}}",text);
        	break;
  }
  if ( (fread(&cThis,1,1,fTex) < 1))
    numerror(ERR_EOF_INPUT);
  while (cThis == ' ')
  {
    if ( (fread(&cThis,1,1,fTex) < 1))
      numerror(ERR_EOF_INPUT);
  }
  if (cThis != '\n')
  {  fseek(fTex,-1L,SEEK_CUR); }
  else
  {  ++linenumber; InputLineEmpty = TRUE ;};
};

/******************************************************************************/
void ConvertString(char *string)
/******************************************************************************
purpose: converts a previously stored string substituting the ref-file
 ******************************************************************************/
{
  char tmpname[256]="";
  char errormessage[256]="";
  FILE *fp, *LatexFile;
  long oldlinenumber;

  sprintf(tmpname,"%s",tempnam(getenv("TMPDIR"), "l2r"));
  if (Debug)
  {  sprintf(errormessage,"Opening temp. file: %s",tmpname);
     Message(errormessage);
  };
  if ((fp = fopen(tmpname,"w+")) == NULL)
  {
    sprintf(errormessage,"cannot create temporary file %s", tmpname);
    error(errormessage);
    exit(1);
  };
/*  fwrite(string,strlen(string),1,fp); */
  fprintf(fp,"{%s}\4",string); /* essai */
  fseek(fp,0L,SEEK_SET);

  LatexFile = fTex;
  fTex = fp;
  oldlinenumber = linenumber;
  linenumber = 1;
  BracketLevel++;
  Convert();
  BracketLevel--;

  fTex = LatexFile;
  linenumber = oldlinenumber;
  fclose(fp);
  if (Debug) fprintf(OUTPUTF,"\nRemoving |%s|",tmpname);
  remove(tmpname);
/*  free(tmpname); */
}
