{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbiblist;

Interface

uses
  WinDos, wbibdisp, wbibgui, wbibslct, wobjects, rc_id, rc_strng,
  WinTypes, WinProcs, strings, win31,
  bibstrg, bibreadb, bibvars, bibfile, bibutil, bibreach, wc_help,
  bibtmplt, bibcache;


procedure ShowEntryList(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        Var Chosen,found: boolean);
procedure ShowOverview(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       Var FromBeginning,chosen,found: Boolean);

implementation

const
  ListKbHook_PgUp = 1;
  ListKbHook_PgDn = 2;
  ListKbHook_Home = 3;
  ListKbHook_End  = 4;
  ListKbHook_Space= 5;

type

  PEntlist = ^TEntList;
  TEntList = object(TObject)
    enum,rnum: word;
    place: longint;
    constructor init(en,rn: word; pl: longint);
  end;

  PEntryListDlg = ^TEntryListDlg;
  TEntryListDlg = object(TResizableDialog)
    PgUp,PgDn,FromBeginning,FirstTime,AmWaiting:  boolean;
    FirstDisplay,UseTheIndex,MultiColumn,FullEnt: boolean;
    OPlace,ntime: longint;
    n,nabs,OldRealNum,OEntry,Initial,OnScreen: Word;
    ColumnWidth,LineHeight,LastReal: word;
    Coords: TCollection;
    LBoxTL,LBoxBR: TPoint;

    constructor init(AParent: PWindowsObject; AName: PChar;
                     APosRec: InitialSizePtr;
                     AFullEnt,From1,MultiCol: boolean);
    procedure   FixControlPos;                virtual;
    procedure   SetupWindow;                  virtual;
    procedure   wmSize(var Msg: TMessage);    virtual wm_First+wm_Size;
    procedure   NextScreen(var o_k: boolean;
                var FirstEnt,LastEnt: word);  virtual;
    procedure   FillUpLBox(ChooseLast: boolean); virtual;

    procedure   HandleLBox(var Msg:TMessage); virtual id_first+dl_EntryListLBox;
    procedure   PgUpBtn(var Msg: TMessage);   virtual id_First+dl_EntryListPgUp;
    procedure   PgDnBtn(var Msg: TMessage);   virtual id_First+dl_EntryListPgDn;
    procedure   FirstBtn(var Msg: TMessage);  virtual id_First+dl_EntryListFirst;
    procedure   LastBtn(var Msg: TMessage);   virtual id_First+dl_EntryListLast;
    procedure   SpaceBtn;  virtual;

    procedure   KbHook(var Msg: TMessage);    virtual wm_First+bib_KbHook;

    procedure   Cancel(var Msg: TMessage);    virtual id_first+id_cancel;
    procedure   Ok(var Msg: TMessage);        virtual id_first+id_Ok;
    destructor  Done; virtual;
  end;

  POverviewDlg = ^TOverviewDlg;
  TOverviewDlg = object(TEntryListDlg)
    widths: array[0..MaxOverview] of integer;
    ListFont: HFont;
    TabStops: array[1..MaxOverview+1] of integer;
    AnyTagged: boolean;
    TagHeight: integer;
    constructor init(AParent: PWindowsObject; From1: boolean);
    procedure   NextScreen(var o_k: boolean;
                var FirstEnt,LastEnt: word);      virtual;
    procedure   FillUpLBox(ChooseLast: boolean);  virtual;
    procedure   SpaceBtn;      virtual;
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    destructor  Done; virtual;
  end;

Var
  ListEditWindow: HWnd;
  ghKbrdHook: HHook;
  KbdHookInst: TFarProc;
  AccelKeys: TCollection;


{ The following routine is a keyboard hook designed to trap PgUp, etc. key presses
  inside the dialog and send an appropriate message - Poor-man's accelerators }

{$F+}
function TrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send,ScanCode: word;
  i: integer;
  CtrlPressed,ShftPressed: boolean;
begin
  Send:=0;
  if (Code<0) or (Code<>HC_ACTION) or
     (lParam and (wmChar_BeingReleased or  wmChar_KeyWasDown
                  or wmChar_AltPressed) <> 0)  or
     (CurrentWindow^.HWindow<>ListEditWindow) or AmWaiting then
       { Repeats, key releases and the like - ignore }
  else begin
    if wParam=vk_Next       then Send:=ListKbHook_PgDn
    else if wParam=vk_Prior then Send:=ListKbHook_PgUp
    else if wParam=vk_Space then Send:=ListKbHook_Space
    else if (GetKeyState(vk_Control)<0) or (GetKeyState(vk_Shift)<0) then
    begin
      if wParam=vk_Home     then Send:=ListKbHook_Home
      else if wParam=vk_End then Send:=ListKbHook_End;
    end else
    begin 
      ScanCode:=LoByte(HiWord(lParam));
      for i:=0 to AccelKeys.Count-1 do
        with PAccelKey(AccelKeys.at(i))^ do
          if (SCode=ScanCode) then Send:=id;
    end;
  end;

  if Send<>0 then
  begin
    PostMessage(CurrentWindow^.HWindow,bib_KbHook,Send,0);
    TrapKbHook:=1
  end else
      TrapKbHook:=CallNextHookEx(ghKbrdHook,Code,wparam,lparam);
end;                           { TrapKbHook }
{$F-}

constructor TEntList.init(en,rn: word; pl: longint);
begin
  TObject.init;
  enum:=en; rnum:=rn; place:=pl;
end;

{ TEntryListDlg methods }

procedure TEntryListDlg.KbHook(Var msg: TMessage); { Traps PgUp, etc. presses }
begin
  case Msg.wParam of
    ListKbHook_PgUp: PgUpBtn(Msg);
    ListKbHook_PgDn: PgDnBtn(Msg);
    ListKbHook_Home: FirstBtn(Msg);
    ListKbHook_End:  LastBtn(Msg);
    ListKbHook_Space:SpaceBtn;
  end;
end;

constructor TEntryListDlg.init(AParent: PWindowsObject; AName: PChar;
                               APosRec: InitialSizePtr;
                               AFullEnt,From1,MultiCol: boolean);
begin
  TResizableDialog.init(AParent,AName,APosRec);
  FirstTime:=true;
  MultiColumn:=MultiCol;
  PosRec:=APosRec;
  FromBeginning:=From1;
  FullEnt:=AFullEnt;
  HelpContext:=hc_GotoMenu;
  LineHeight:=0;
  AccelKeys.init(10,10);
end;                           { TEntryListDlg.init }

procedure TEntryListDlg.FixControlPos;
begin
  NewControl(dl_EntryListPgUp, RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EntryListPgDn, RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EntryListFirst,RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EntryListLast, RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_Cancel,        RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,            RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(dl_EntryListLBox, RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Bottom);
end;

procedure TEntryListDlg.SetupWindow;
var
  ns,icode,i: integer;
  o_k: boolean;

begin                    { TEntryListDlg.SetupWindow }
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;

  if LineHeight=0 then
    LineHeight:=SendDlgItemMsg(dl_EntryListLBox,lb_GetItemHeight,0,0);
  if MultiColumn then
  begin
    ColumnWidth:=GetTextLength(GetItemHandle(dl_EntryListLBox),EListColWidthStr^);
    SendDlgItemMsg(dl_EntryListLBox,lb_SetColumnWidth,ColumnWidth,0);
  end;

  Coords.Init(100,100);
  Oldrealnum:=entry^.realnum; OEntry:=entry^.entrynum;
  OPlace:=entry^.beginning;
  if FromBeginning then Initial:=0
  else begin
    DeSuspend;
    if entry^.entrynum>0 then Initial:=entry^.entrynum-1
    else Initial:=0;
  end;
  FromBeginning:=false;
  n:=1; nabs:=Initial+1; ntime:=-1;
  if Pattern^.on then SearchingMessage;
  if (Initial=0) or (Initial+1<entry^.entrynum) then
  begin
    ResetBib(Entry);
    GetEntry(Entry,Nil,Initial+1,FullEnt,Pattern,o_k);
  end else if initial+1>entry^.entrynum then
    GetEntry(Entry,Nil,Initial+1,FullEnt,Pattern,o_k)
  else o_k:=true;
  if Pattern^.on then WaitingOff;
  if entry^.realnum=0 then
  begin
    o_k:=false;
  end;
  if not o_k then
  begin
    EndDlg(id_Abort);
    Exit;
  end;
  PgUp:=false; PgDn:=false;
  FirstTime:=false;

  AccelKeys.Insert(New(PAccelKey,init('f',ListKbHook_Home,false)));
  AccelKeys.Insert(New(PAccelKey,init('a',ListKbHook_End, false)));
  AccelKeys.Insert(New(PAccelKey,init('u',ListKbHook_PgUp,false)));
  AccelKeys.Insert(New(PAccelKey,init('d',ListKbHook_PgDn,false)));

  KbdHookInst:=MakeProcInstance(@TrapKbHook,HInstance);
  ghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(KbdHookInst),
                               Hinstance,GetCurrentTask);
  ListEditWindow:=HWindow;
  Show(sw_Show);
  InvalidateRect(HWindow,Nil,true); UpdateWindow(HWindow);

  FillUpLBox(false);
end;                       { TEntryListDlg.SetupWindow }

procedure TEntryListDlg.WmSize(var Msg: TMessage);
begin
  TResizableDialog.wmSize(Msg);
  SendDlgItemMsg(dl_EntryListLBox,lb_ResetContent,0,0);
  if not FirstTime then FillUpLBox(false);
end;                          { TEntryListDlg.wmSize }

procedure TEntryListDlg.NextScreen(var o_k: boolean;
          var FirstEnt,LastEnt: word);
var
  F: array[0..255] of char;
begin
  n:=1;  o_k:=true; FirstEnt:=0; LastEnt:=0; LastReal:=0;
  Coords.FreeAll;
  SendDlgItemMsg(dl_EntryListLBox,lb_ResetContent,0,0);
  AbortFlag:=false;
  while o_k and (n<=onscreen) and (entry^.entrynum=nabs) do
  begin
    WinYield;
    StrPCopy(F,entry^.name);
    SendDlgItemMsg(dl_EntryListLBox,lb_AddString,0,Longint(@F));
    Coords.Insert(New(PEntList,init(entry^.entrynum,entry^.realnum,
                                    entry^.beginning)));
    inc(n); inc(nabs);
    if FirstEnt=0 then FirstEnt:=entry^.entrynum;
    LastEnt:=Entry^.entrynum; LastReal:=Entry^.realnum;
    GetEntry(Entry,Nil,nabs,false,Pattern,o_k);
  end;
  if (LastEnt>0) and (Entry^.EntryNum<>Nabs) and not AbortFlag then
    EntryCache^.SetLast(LastEnt,Pattern);
  PgDn:=(entry^.entrynum=nabs) and (n=onscreen+1);
  PgUp:=(FirstEnt>1);
  LastReal:=entry^.realnum;
  dec(n);
end;             { NextScreen }

procedure TEntryListDlg.FillUpLBox(ChooseLast: boolean);
var
  o_k: boolean;
  In2: integer;
  SRec: SortRecType;
  FirstEnt,LastEnt: word;
  F: array[0..255] of char;
  Rect: TRect;
begin
  ntime:=ntime+1; UseTheIndex:=false;
  SearchingMessage;
  GetClientRect(GetItemHandle(dl_EntryListLBox),Rect);
  if MultiColumn then
    OnScreen:=(Rect.right div ColumnWidth)*(Rect.bottom div LineHeight)
  else
    OnScreen:=Rect.bottom div LineHeight;

  WinYield;
  if ChooseLast and EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1) then
  begin
    Initial:=(EntryCache^.Last div OnScreen)*OnScreen;
    if Initial=EntryCache^.Last then Initial:=Initial-OnScreen;
    nabs:=Initial+1;
    GetEntry(Entry,Nil,nabs,true,Pattern,o_k);
    NextScreen(o_k,FirstEnt,LastEnt);
  end else
  begin
    if (n=0) or (initial<>LastReal) then
    begin
      nabs:=Initial+1;
      ResetBib(Entry);
      GetEntry(Entry,Nil,nabs,true,Pattern,o_k);
    end;
    NextScreen(o_k,FirstEnt,LastEnt);
    while (ChooseLast) and PgDn do
    begin
      Initial:=Initial+OnScreen;
      NextScreen(o_k,FirstEnt,LastEnt);
    end;
  end;
  WaitingOff;
  if EditOnlyStrings then
    StrPCopy(F,'Strings '+num2str(FirstEnt)+' to '+num2str(LastEnt))
  else
    StrPCopy(F,'Entries '+num2str(FirstEnt)+' to '+num2str(LastEnt));
  SetWindowText(HWindow,F);
  EnableWindow(GetItemHandle(dl_EntryListPgUp),PgUp);
  EnableWindow(GetItemHandle(dl_EntryListPgDn),PgDn);
  EnableWindow(GetItemHandle(dl_EntryListFirst),PgUp);
  EnableWindow(GetItemHandle(dl_EntryListLast),PgDn);
  SendDlgItemMsg(dl_EntryListLBox,lb_SetCurSel,0,0);
  SetFocus(GetItemHandle(dl_EntryListLBox));
end;                      { TEntryListDlg.FillUpLBox }

procedure TEntryListDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamhi=lbn_DblClk then ok(Msg)
  else DefWndProc(Msg);
end;

procedure TEntryListDlg.PgUpBtn(var Msg: TMessage);
begin
  if not PgUp then Exit;
  if Initial<=OnScreen then Initial:=0
  else Initial:=Initial-onscreen;
  FillUpLBox(false);
end;

procedure TEntryListDlg.PgDnBtn(var Msg: TMessage);
begin
  if not PgDn then Exit;
  Initial:=Initial+OnScreen;
  FillUpLBox(false);
end;

procedure TEntryListDlg.FirstBtn(var Msg: TMessage);
begin
  if not PgUp then Exit;
  Initial:=0;
  FillUpLBox(false);
end;

procedure TEntryListDlg.LastBtn(var Msg: TMessage);
begin
  if not PgDn then Exit;
  Initial:=Initial+OnScreen;
  FillUpLBox(true);
end;

procedure TEntryListDlg.SpaceBtn;
begin end;

procedure TEntryListDlg.Cancel(var Msg: TMessage);
begin
  ReachEntry(Entry,OldRealNum,OEntry,OPlace,false);
  EndDlg(id_cancel);
end;

procedure TEntryListDlg.ok(var Msg: TMessage);
var
  ind: integer;
  P: PEntList;
begin
  ind:=SendDlgItemMsg(dl_EntryListLBox,lb_GetCurSel,0,0);
  if ind<>lb_Err then
  begin
    P:=PEntList(Coords.at(ind));
    ReachEntry(Entry,P^.rnum,P^.Enum,P^.Place,true);
    EndDlg(id_ok);
  end else EndDlg(id_Cancel);
end;

destructor TEntryListDlg.Done;
begin
  Coords.FreeAll; Coords.Done;
  UnhookWindowsHookEx(ghKbrdHook);
  FreeProcInstance(KbdHookInst);
  AccelKeys.Done;
  TResizableDialog.Done;
end;

{ TOverviewDlg methods }

constructor TOverviewDlg.init(AParent: PWindowsObject; From1: boolean);
var
  DC: HDC;
  Metrics: TTextMetric;
begin
  TEntryListDlg.init(AParent,PChar(rc_OverviewDlg),@OverviewSize,true,From1,false);
  ListFont:=CreateHelvFont(true,@LineHeight);
  FillChar(TabStops,sizeof(TabStops),0);
  AnyTagged:=false;

  DC:=GetDC(GetDesktopWindow);
  GetTextMetrics(DC,Metrics);
  TagHeight:=Metrics.tmAscent-Metrics.tmInternalLeading;
  ReleaseDC(GetDesktopWindow,DC);
end;                       { TOverviewDlg.init }

procedure TOverviewDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=0;
    ItemHeight:=LineHeight;
  end;
end;
             
procedure TOverviewDlg.wmDrawItem(var Msg: TMessage);
begin
  DrawTabbedLBoxItem(PDrawItemStruct(Msg.lParam),ListFont,AnyTagged,
                     TabStops,NOverview+1,false);
end;                          { TOverviewDlg.wmDrawItem }

procedure TOverviewDlg.NextScreen(var o_k: boolean;
          var FirstEnt,LastEnt: word);
const
  MaxLineLen=990;
var
  F: array[0..260] of char;
  line: Pchar;
  i: integer;
  len: word;
  tmp: string;
  OldFont: HFont;
  DC: HDC;
  H: HWnd;

procedure GetWidth(Ind: integer; S: string);
const
  MaxLen = 0;
var
  len: integer;
begin
  len:=0;
  if length(S)<=MaxLen then FillChar(S[1],length(S),'O');
  len:=LoWord(GetTextExtent(DC,@S[1],length(S)));
  if Widths[ind]<len then Widths[ind]:=len;
end;

begin
  n:=1;  o_k:=true; FirstEnt:=0; LastEnt:=0; LastReal:=0;
  Coords.FreeAll;
  SendDlgItemMsg(dl_EntryListLBox,lb_ResetContent,0,0);
  AnyTagged:=false;
  GetMem(line,MaxLineLen+10);

  H:=GetDesktopWindow;
  DC:=GetDC(H);
  OldFont:=SelectObject(DC,ListFont);

  for i:=0 to Noverview do Widths[i]:=0;
  AbortFlag:=false;
  while o_k and (n<=onscreen) and (entry^.entrynum=nabs) do
  begin
    StrPCopy(line,entry^.name); StrPCopy(F,'');
    GetWidth(0,entry^.name);
    Coords.Insert(New(PEntList,init(entry^.entrynum,entry^.realnum,
                                    entry^.beginning)));
    if EditOnlyStrings then
    begin
      tmp:=entry^.content[1]; ChrDelL(tmp,' '); ChrDelR(tmp,' ');
      tmp:=' = '+tmp;
      GetWidth(1,tmp);
      StrPCopy(F,#9+tmp); StrLCat(line,F,MaxLineLen);
    end else
    begin
      for i:=1 to Noverview do
      begin
        tmp:='';
        if Overview[i]=Nil then tmp:=''
        else FillTemplate(entry,tmp,Overview[i]^,VerbatimFormat,true,true);
        ChrDelL(tmp,' '); ChrDelR(tmp,' '); tmp:=' '+tmp;
        GetWidth(i,tmp);
        StrPCopy(F,#9+tmp); StrLCat(line,F,MaxLineLen);
      end;
    end;
    SendDlgItemMsg(dl_EntryListLBox,lb_AddString,0,longint(line));
    if IsTagged(Entry^.RealNum,Tags) then
    begin
      AnyTagged:=true;
      SendDlgItemMsg(dl_EntryListLBox,lb_SetItemData,n-1,1);
    end;

    inc(n); inc(nabs);
    if FirstEnt=0 then FirstEnt:=entry^.entrynum;
    LastEnt:=Entry^.entrynum; LastReal:=Entry^.realnum;
    GetEntry(Entry,Nil,nabs,true,Pattern,o_k);
  end;
  FreeMem(line,MaxLineLen+10);
  SelectObject(DC,OldFont);
  ReleaseDC(H,DC);
  if (LastEnt>0) and (Entry^.EntryNum<>Nabs) and not AbortFlag then
    EntryCache^.SetLast(LastEnt,Pattern);
  PgDn:=(entry^.entrynum=nabs) and (n=onscreen+1);
  PgUp:=(FirstEnt>1);
  LastReal:=entry^.realnum;
  dec(n);
end;             { TOverviewDlg.NextScreen }

procedure TOverviewDlg.FillUpLBox(ChooseLast: Boolean);
const
  AddedLen = 4;
var
  i: integer;
  du: word;
begin
  TEntryListDlg.FillUpLbox(ChooseLast);
  du:=LoWord(GetDialogBaseUnits) div 4;

  TabStops[1]:=Widths[0]+AddedLen*du;
  for i:=1 to NOverview-1 do TabStops[i+1]:=TabStops[i]+Widths[i]+AddedLen*du;
  for i:=1 to NOverview do TabStops[i]:=TabStops[i]+TabbedLBox_XShift;
  i:=0;
  if AnyTagged then
  begin
    {
    for i:=1 to NOverView do
      TabStops[i]:=TabStops[i]+TagHeight+TabbedLBox_TagShift;
    }
    i:=TagHeight+TabbedLBox_TagShift;
  end;
  SendDlgItemMsg(dl_EntryListLBox,lb_SetHorizontalExtent,
    TabStops[NOverview]+Widths[NOverview]+AddedLen*du+i,0);
  InvalidateRect(GetItemHandle(dl_EntryListLBox),Nil,true);
end;                              { TOverviewDlg.FillUpLBox }

procedure TOverviewDlg.SpaceBtn;
var
  i,Rnum: longint;
  OldTagged: boolean;
  change,HExt: integer;
begin
  i:=SendDlgItemMsg(dl_EntryListLBox,lb_GetCurSel,0,0);
  if i=lb_Err then
  begin
    Messagebeep(0); Exit;
  end;
  RNum:=PEntList(Coords.at(i))^.Rnum;
  Tag(RNum,TagToggle,Tags);
  if IsTagged(RNum,Tags) then SendDlgItemMsg(dl_EntryListLBox,lb_SetItemData,i,1)
  else SendDlgItemMsg(dl_EntryListLBox,lb_SetItemData,i,0);
  OldTagged:=AnyTagged; AnyTagged:=false;
  for i:=0 to Coords.Count-1 do
    if IsTagged(PEntList(Coords.at(i))^.RNum,Tags) then AnyTagged:=true;

  if AnyTagged<>OldTagged then
  begin
    HExt:=SendDlgItemMsg(dl_EntryListLBox,lb_GetHorizontalExtent,0,0);
    Change:=TagHeight+TabbedLBox_TagShift;
    if not AnyTagged then Change:=-Change;
{    for i:=1 to NOverView do TabStops[i]:=TabStops[i]+change;}
    SendDlgItemMsg(dl_EntryListLBox,lb_SetHorizontalExtent,HExt+Change,0);
  end;
  InvalidateRect(GetItemHandle(dl_EntryListLBox),Nil,true);
end;                { TOverviewDlg.SpaceBtn }

destructor TOverViewDlg.Done;
begin
  if ListFont<>0 then DeleteObject(ListFont);
  TEntryListDlg.Done;
end;


{ Interface procedures }

procedure ShowEntryList(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        Var Chosen,found: boolean);
var
  i: integer;
begin
  chosen:=false; found:=false;
  i:=Application^.ExecDialog(New(PEntryListDlg,
        Init(MainW,PChar(rc_EntryListDlg),@EntryListSize,
             false,not Stickylist,true)));
  Chosen:=(i=id_ok); found:=(i<>id_Abort);
end;

procedure ShowOverview(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       Var FromBeginning,Chosen,found: Boolean);
var
  i: integer;
begin
  chosen:=false; found:=false;
  i:=Application^.ExecDialog(New(POverviewDlg,init(MainW,FromBeginning)));
  Chosen:=(i=id_ok); found:=(i<>id_Abort);
end;




end.
