{$N-,E-,V-,F+,O+}

Unit bibbrows;

Interface

Uses
  bibwindo, Dos, bibCrt, bibstrg, BibMouse, bibvars, bibfile, bibdisp,
  bibutil, bibshow, bibedent, bibreadB, bibfilch, bibmain, rc_strng,
  bibgoto, bibinout, bibmisc;

procedure browse(var Pattern: PatRecPtr);


Implementation


procedure browse(var Pattern: PatRecPtr);
var
  il,Scroll,LastY: LongInt;
  i,j: integer;
  xfirst,att: Byte;
  selected: SelectionType;
  ok,outside,FromFirst,DoWait,leave,NameOnly,First: boolean;
  tmp : string;
  Entry: EntryRecPtr;
  ScrBar: ScrBarPtr;

procedure ClearScreen;
begin
  MakeBox(2,1,ScrLen-1,ScrWidth,EntryNorm,EntryNorm,2,0,0,0);
  LastY:=0;
end;                 { ClearScreen }

procedure DisplayStatus;
var
  line: string;
begin
  Tpwfill(ScrLen,3,1,31,#205,EntryNorm);

  line:=TruncateFilename(bibname^,30);
  if Linked then line:=Concat('+',line)
  else if BibReadOnly then line:=Concat('*',line);
  TitleWindow(4,EntryNorm,line);

  line:='';
  if BibReadOnly then line:=line+'/R';
  if MakeUseOfIndex(Pattern) then line:=line+'/I';
  if UnixBib then line:=line+'/U'
  else line:=line+'/D';
  ChrDelL(line,'/'); if line<>'' then line:='['+line+']'+#205;
  if Linked then line:=line + '[link]'+#205
  else line:=line + '[no lnk]'+#205;
  if Pattern^.on then line:=line + '[patt]'+#205
  else line:=line + '[no pat]'+#205;
  if EditOnlyStrings then line:=line + '[str]'+#205
  else line:=line + '[ent]'+#205;
  if EditOnlyStrings then
  begin
    if (not Linked) and (CurrentSortMode^.StringNameSort<>StrSortOff) then
      line:=line + '[sort]'
    else line:=line + '[unsrt]';
  end else
  begin
    if (not Linked) and CurrentSortMode^.SortingOn then
      line:=line + '[sort]'
    else line:=line + '[unsrt]';
  end;
  TitleWindow(6,EntryNorm,line);
end;                                { DisplayStatus }

procedure PrepareMain(Pattern: PatRecPtr);
var
  NameOnly: boolean;
  i,j: byte;
  tmp: string;
  iform: byte;
begin
  NameOnly:=false;
  if SaveOptsOnExit then SaveOnExitCheck^:=MenuCheckChar
  else SaveOnExitCheck^:=' ';
  if FirstShowBuf then ViewAllCheck^:=' '
  else ViewAllCheck^:=MenuCheckChar;
  if not TagNewEntries then TagNewCheck^:=' '
  else TagNewCheck^:=MenuCheckChar;
  if EditOnlyStrings then
  begin
    StringsCheck^:=MenuCheckChar;
    if (DumpFileExists) and (ExportSortMode^.StringNameSort=StrSortOff) then
      for i:=1 to 5 do ChooseExpPosition[i]^:=true
    else
      for i:=1 to 5 do ChooseExpPosition[i]^:=false;
  end else
  begin
    StringsCheck^:=' ';
    NameOnly:=true;
    for i:=1 to maxfield do if DumpFields[i] then nameonly:=false;
    if (DumpFileExists) and (not ExportSortMode^.SortingOn)
       and not (nameonly or (ExportFormat<>BibTeXFormat))  then
      for i:=1 to 5 do ChooseExpPosition[i]^:=true
    else
      for i:=1 to 5 do ChooseExpPosition[i]^:=false;
  end;

  for iform:=1 to LastFileFormat do ExpFormatCheck[iform]^:=' ';
  ExpFormatCheck[ExportFormat]^:=MenuCheckChar;

  for iform:=1 to LastImportFormat do ImpFormatCheck[iform]^:=' ';
  ImpFormatCheck[ImportFormat]^:=MenuCheckChar;

  for i:=1 to MaxBibFiles do
  begin
    tmp:=BibFiles^[i].name;
    ChrDelL(tmp,' '); ChrDelR(tmp,' ');
    tmp:=TruncateFilename(tmp,50);
    MenuOfCurrentFiles[i]^ :=Chr(Ord('0')+i)+': '+tmp;
    MenuOfCurrentFiles2[i]^:=MenuOfCurrentFiles[i]^;
  end;
  if bibname^<>'' then MenuOfCurrentFiles[CurrentBibFile]^[2]:='>';

  if EditOnlyStrings then
    AddMenuOn^:=(CurrentSortMode^.StringNameSort=StrSortOff)
  else
    AddMenuOn^:=not CurrentSortMode^.SortingOn;
  if AddMenuOn^ then ImpSubMenu^:=ImpMenu
  else ImpSubMenu^:=ImpSortedMenu;
end;                     { PrepareMain }

begin                    { Browse }
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  ok:=true; FromFirst:=false;
  Scroll:=0; ScrBar:=Nil;
  Entry:=Nil; NewEntry(Entry);
  entry^.nentry:=0;
  ClearScreen;
  ResetBib(Entry);
  if AutoBuildIndex and BibFileExists and (not Linked) and (IndexFileName^='')
     and UseIndexFile then
  begin
    FillChar(Selected,sizeof(SelectionType),0);
    Selected[1]:=CFile_AutoIndex;
    DealWithFiles(Entry,Pattern,Selected);
  end;
  if TexAuxFile^<>'' then
  begin
    TagFromAuxFile(Entry,Nil,TexAuxFile^,false);
    ResetBib(Entry);
  end;
  First:=true;
  DisplayStatus;
  MaxMemAvail;
  MainMenu.currentpos:=1; 
  repeat
    DoWait:=False;
    ok:=true; outside:=false; Leave:=false;
    TimeOutOn:=(DispTimeOut>0);

    PrepareMain(Pattern);

    TopLine(MainMenu, selected, First, outside, Scroll, LastY, ScrBar);
    if First then
    begin
      selected[0]:=CMainGoto; selected[2]:=0;
      if SearchString^<>'' then
      begin
        selected[1]:=CGoto_Search; selected[2]:=1;
      end else if LabelSearchString^<>'' then
      begin
        selected[1]:=CGoto_Label; selected[2]:=1;
      end else selected[1]:=CGoto_Next;
      New(ScrBar); ScrBar^.Color:=CScrBarEntry; ScrBar^.HeldDown:=false;
    end;
    if selected[0]=CTop_Tab then selected[0]:=CMainNext
    else if selected[0]=CTop_SCTab then selected[0]:=CMainBack
    else if selected[0]=CTop_BS then selected[0]:=CMainBack
    else if selected[0]=CTop_Outside then
    begin
      if Event.y=2 then
      begin
        if (Event.x=1) or (Event.x=ScrWidth) or
           (PixelChar(Event.x,Event.y)=#205) then selected[0]:=0
        else if Event.x>ScrWidth-16 then   { Goto Number }
        begin
          ReadScrStr(tmp,Event.x,Event.y,xfirst,att,['0'..'9']);
          if tmp<>'' then
          begin
            selected[0]:=CMainGoto; selected[1]:=CGoto_Number;
          end;
        end;
      end else if Event.y=ScrLen then
      begin
        ReadScrStr(tmp,Event.x,Event.y,xfirst,att,['a'..'z',' ']);
        StrLwr(tmp);
        if (tmp='patt') or (tmp='no pat') then
        begin
          selected[0]:=CMainPatt; selected[1]:=1; outside:=false;
        end else if (tmp='link') or (tmp='no lnk') then
        begin
          selected[0]:=CMainFile; selected[1]:=CFile_Link; outside:=false;
        end else if (tmp='str') or (tmp='ent') then
        begin
          selected[0]:=CMainMisc; selected[1]:=CMisc_Strings;
        end else if (not Linked) and ((tmp='sort') or (tmp='unsrt')) then
        begin
          selected[0]:=CMainMisc; selected[1]:=CMisc_Soptions;
          selected[2]:=CSortMode_Current; outside:=false;
        end else selected[0]:=255;
      end else if (Event.x=1) or (Event.x=ScrWidth) then selected[0]:=0;
    end;
    if selected[0] in [20..29] then outside:=false;
    if selected[0]=Ord('p') then  { Pattern on/off }
    begin
      selected[0]:=CMainPatt; selected[1]:=1; outside:=false;
    end else if selected[0]=Ord('b') then  { Mark }
    begin
      selected[0]:=CMainEdit; selected[1]:=CEdit_Bookmark;
    end else if (not linked) and (selected[0] in [Ord('1')..Ord('8')]) then
    begin
      selected[1]:=selected[0]-Ord('1')+CFile_List;
      selected[0]:=CMainFile;
      selected[2]:=1;
    end else if (selected[0]=Ord('V')) or (selected[0]=Ord('v')) then { Alt-V }
    begin
      selected[0]:=CMainMisc; selected[1]:=CMisc_View;
    end else if selected[0]=CMainNext then                        { Next }
    begin
      selected[0]:=CMainGoto; selected[1]:=CGoto_Next;
    end else if selected[0]=CMainBack then                        { Back }
    begin
      selected[0]:=CMainGoto; selected[1]:=CGoto_Back;
    end else if selected[0]=CTop_CHome then
    begin
      selected[0]:=CMainGoto; selected[1]:=CGoto_First;
    end else if selected[0]=CTop_CEnd then
    begin
      selected[0]:=CMainGoto; selected[1]:=CGoto_Last;
    end else if selected[0]=Ord('n') then                        { Number }
    begin
      selected[0]:=CMainGoto; selected[1]:=CGoto_Number;
    end else if Pos(UpCase(chr(selected[0])),GotoMenu^.fchars)>0 then  { Goto items }
    begin
      selected[1]:=GotoMenu^.retrn[Pos(UpCase(Chr(selected[0])),GotoMenu^.fchars)];
      selected[0]:=CMainGoto;
    end else if selected[0]=CTop_Space then                      { Space }
    begin
      selected[0]:=CMainEdit; selected[1]:=CEdit_Tag;
    end;
                                  { Perform the actions }
    if selected[0]=CTop_F1 then                      { Help }
    begin
      ContextHelp('Browse');
    end else if selected[0]=CMainFile then               { Files }
    begin
      if selected[1]=CFile_Exit then
        Leave:=(not LeaveConfirm) or YesNo(' Really leave? ')
      else DealWithFiles(Entry,Pattern,selected);
    end else if (selected[0]=CMainEdit) or
       ((selected[0]=CTop_Outside) and (entry^.entrynum>0)) then
    begin                                                      { Edit Menu }
      if selected[0]=CTop_Outside then selected[1]:=CEdit_Entry;
      if selected[1]=CEdit_DelAll then
        DeleteEntries(Entry,Pattern,true,true)
      else if selected[1]=CEdit_DelTagged then
        DeleteEntries(Entry,Pattern,false,true)
      else DealWithEdit(Entry,Pattern,scroll,selected[0]=CTop_Outside,
                        selected[1]);
    end else if selected[0]=CMainGoto then                        { Goto }
    begin
      DealWithGoto(Entry,Pattern,scroll,FromFirst or First,selected[2]=0,
                   First,selected[1]);
    end else if selected[0]=CMainAdd then                         { Add }
    begin
      DealWithAdd(Entry,Pattern,selected);
      DoWait:=false;
    end else if selected[0]=CMainImp then                         { Import }
    begin
      DealWithImport(Entry,Pattern,selected);
      DoWait:=false;
    end else if selected[0]=CMainExp then                         { Export }
    begin
      DealWithExport(Entry,Pattern,selected);
    end else if selected[0]=CMainPAtt then                        { Pattern }
    begin
      DealWithPattern(Entry,Pattern,Scroll,FromFirst,selected[1]);
    end else if selected[0]=CMainMisc then                        { Misc }
    begin
      DealWithMisc(Entry,Pattern,selected);
    end else if selected[0]=CMainQuit then                        { Leave }
    begin
      leave:=(not LeaveConfirm) or YesNoRC(Str_ReallyQuit,'');
    end;
    if not leave then
    begin
      if entry^.entrynum=0 then ClearScreen
      else ShowEntry(Entry,Scroll,LastY,false,Pattern^.on,true);
      DisplayStatus;
    end;
    if DoWait and UseMouse then WaitForRelease(255);
    First:=false;
  until leave;
end;                                    { Browse }

end.
