/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.parallel;

import de.nm.ant.parallel.AbstractParallelTask;
import de.nm.file.XFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.FileSet;

public class IfDiffTask
extends AbstractParallelTask
implements TaskContainer {
    private File destdir;
    private final LinkedList<File> destfilelist = new LinkedList();
    private final List<FileSet> fileset = new ArrayList<FileSet>();
    private final Vector<Task> nestedTasks = new Vector();
    private String regexpfile;
    private File srcdir;

    public void addFileset(FileSet set) {
        this.fileset.add(set);
    }

    public void addTask(Task task) {
        this.nestedTasks.add(task);
    }

    public void execute() {
        File[] files;
        if (this.srcdir == null) {
            throw new BuildException("No srcdir set.");
        }
        if (this.destdir == null) {
            throw new BuildException("No destdir set.");
        }
        this.checkInit();
        this.logStatus();
        LinkedList<File> todofiles = new LinkedList<File>();
        for (FileSet fs : this.fileset) {
            String[] files2;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String f : files2 = ds.getIncludedFiles()) {
                todofiles.add(this.createFile(this.srcdir, f));
            }
        }
        if (this.regexpfile != null && (files = this.srcdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches(IfDiffTask.this.regexpfile);
            }
        })) != null) {
            for (File f : files) {
                todofiles.add(f);
            }
        }
        while (!todofiles.isEmpty()) {
            File sf = (File)todofiles.removeFirst();
            if (!sf.exists()) {
                this.log("File " + sf.getAbsoluteFile() + " not exists!", 0);
            }
            File df = new File(this.destdir + File.separator + sf.getName());
            try {
                if (!XFile.copyisnewer((File)sf, (File)df)) continue;
                if (this.verboseheader) {
                    this.log("<" + sf.getName() + ">", 2);
                }
                this.destfilelist.add(df);
                if (this.verbose) {
                    this.log("copy " + sf.getAbsolutePath() + " to " + df.getAbsolutePath());
                }
                this.runTasks();
            }
            catch (IOException e) {
                this.log(((Object)((Object)this)).getClass().getName() + e.getMessage(), 0);
            }
        }
        if (!this.parallelQueue && this.isThread()) {
            this.waitForFinish();
        }
    }

    private void runTasks() {
        if (!this.destfilelist.isEmpty()) {
            File file = this.destfilelist.removeFirst();
            if (!this.isThread()) {
                List<Task> copytask = this.copyTask(this.nestedTasks);
                for (Task task : copytask) {
                    task = this.checkTask(task);
                    this.checkMethod(task, "setDestdir", this.destdir);
                    this.checkMethod(task, "setWorkdir", this.destdir);
                    this.checkMethod(task, "setBasename", this.createBasename(file));
                    this.checkMethod(task, "setExtname", this.createExtname(file));
                    task.perform();
                }
            } else {
                List<Task> copytask = this.copyTask(this.nestedTasks);
                for (Task task : copytask) {
                    task = this.checkTask(task);
                    this.checkMethod(task, "setDestdir", this.destdir);
                    this.checkMethod(task, "setWorkdir", this.destdir);
                    this.checkMethod(task, "setBasename", this.createBasename(file));
                    this.checkMethod(task, "setExtname", this.createExtname(file));
                }
                this.addRunnerTasks(copytask);
            }
        }
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setRegExpFile(String file) {
        this.regexpfile = file;
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }
}

