#!/bin/sh

# A script to install LH fonts in X2, T2A, T2B, T2C, T2D encodings
# and optionally also LCY and OT2 encodings
# for web2c-based TeX systems (and teTeX is among them)

# stop on any error
set -e

# Uncomment the following line to install ALL *.mf header files
# (see the `INSTALL' file for explanation):
#perl -p -i -e 's/\\MakeFileHeadsfalse/\\MakeFileHeadstrue/' tex/setter.tex

if test -z "$1"; then
	TEXMF=`kpsewhich -expand-var='$TEXMFMAIN'`
	FONTS=$TEXMF/fonts/source/lh
else
	FONTS=$1
fi

inst_lh_fonts() {
	echo "Installing LH fonts for the `echo $2 | tr a-z A-Z` encoding..."
	tex $1.tex > /dev/null
	mkdir -p $FONTS/lh-$2
	cp wrk/*.mf $FONTS/lh-$2	# ??{codes,liker,begin}.mf
	rm -f $1.dvi $1.log wrk/*
}

abort() {
  echo Aborting. Please, remove old versions of LH fonts manually
  echo and re-run this script.
  exit 1
}

# Remove old version(s) of LH fonts
(
kpsewhich -expand-path="`kpsewhich -show-path=tfm`"
kpsewhich -expand-path="`kpsewhich -show-path=mf`"
kpsewhich -expand-path="`kpsewhich -show-path=vf`"
kpsewhich -expand-path="`kpsewhich -show-path=pk`"
) | tr ':' '\n' | grep '/lh$' | sort -u > .tmp
test -s .tmp && (
echo "The following directories found which contain old version of LH fonts:"
echo
cat .tmp
echo
/bin/echo "Remove them? [y/n] \c"
read reply
if test "$reply" = y; then
  rm -rf `cat .tmp`
else
  ABORT=y
fi
)
rm -f .tmp
kpsewhich ldcsc.mf >/dev/null && ABORT=y
test "$ABORT" = y && abort

if test -d $FONTS; then
	echo Installation directory $FONTS already exists.
	/bin/echo "Execute command \"rm -rf $FONTS\"? [y/n] \c"
	read reply
	if test "$reply" = y; then
		rm -rf $FONTS
	else
		abort
	fi
fi

echo Installing main METAFONT files...
mkdir -p $FONTS
(cd mf; tar cf - .) | (cd $FONTS; tar xf -)
# cp -r mf/* $FONTS

cd tex
test -d wrk || mkdir wrk
rm -f wrk/*

# Generate and install METAFONT headers for LH fonts in X2 encoding
# and T2A, T2B, T2C, T2D encodings.
# Font header files for SliTeX are also generated.
inst_lh_fonts 12ex-la t2a
inst_lh_fonts 13ex-lb t2b
inst_lh_fonts 14ex-lc t2c
inst_lh_fonts 15ex-ld t2d
inst_lh_fonts 11ex-rx x2

inst_lh_fonts 03cm-wn ot2	# OT2 7-bit encoding (as in AMS wncy fonts)
inst_lh_fonts 01cm-lh lcy	# similar to `New Alternative Variant' of cp866

# Other non-standard encodings (matching input encodings).
# These encodings are incompatible with the LaTeX standards.
# IT IS NOT RECOMMENDED TO INSTALL ANY OF THE FOLLOWING FONTS.
# It is better to use T2* encodings with the inputenc package instead.
#inst_lh_fonts 20cm-ct lct	# Tatarian variant of cp866
#inst_lh_fonts 21cm-ic lci	# ISO-8859-5
#inst_lh_fonts 22cm-wc lcw	# cp1251
#inst_lh_fonts 23cm-mc lcm	# Macintosh Ukrainian
#inst_lh_fonts 24cm-kc lck	# koi8-r

#inst_lh_fonts 30cm-lx llh	# extended cp866
#inst_lh_fonts 31cm-ix llh	# extended ISO-8859-5
#inst_lh_fonts 32cm-wx llh	# extended cp1251
#inst_lh_fonts 33cm-mx llh	# extended Macintosh Ukrainian
#inst_lh_fonts 34cm-kx llh	# extended koi8-r

#inst_lh_fonts 11ex-rs llh	# Old Slav Cyrillic not covered by T2D
#inst_lh_fonts 25cm-uc llh	# Cyrillic Unicode page
#inst_lh_fonts 04cm-vf llh	# 7-bit encoding (for virtual fonts)
#inst_lh_fonts 46cm-ly llh	# OT2u
#inst_lh_fonts 46cm-lz llh	# OT2l
#inst_lh_fonts 47ex-tx llh	# All non-X2 letters & signs

# Update TeX hash
#mktexlsr
