%% 
%% This is file `exam.cls', generated 
%% on <1995/4/7> with the docstrip utility (2.2i).
%% 
%% The original source files were:
%% 
%% exam.dtx  (with options: `package')
%% 
%% Copyright (C) 1994 by LaTeX3 project. All rights reserved. 
%% For additional copyright information see further down in this file. 
%% 
%% This file is part of the LaTeX2e system (PRELIMINARY TEST RELEASE). 
%% ------------------------------------------------------------------- 
%% 
%% This system is distributed in the hope that it will be useful, 
%% but WITHOUT ANY WARRANTY; without even the implied warranty of 
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%% 
%% 
%% IMPORTANT NOTICE: 
%% 
%% For error reports in case of UNCHANGED versions see readme files. 
%% 
%% Please do not request updates from us directly. Distribution is 
%% done through Mail-Servers and TeX organizations. 
%% 
%% You are not allowed to change this file. 
%% 
%% You are allowed to distribute this file under the condition that 
%% it is distributed together with all files mentioned in 00readme.l2e. 
%% 
%% If you receive only some of these files from someone, complain! 
%% 
%% You are NOT ALLOWED to distribute this file alone. You are NOT 
%% ALLOWED to take money for the distribution or use of either this 
%% file or a changed version, except for a nominal charge for copying 
%% etc. 
\def\fileversion{3.13}
\def\filedate{1994/11/10}
%% File: exam.dtx Copyright (C) 1993-1994 Hans van der Meer
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1993/12/01]
\ProvidesClass{exam}[\filedate\space vs\fileversion\space Exam package]
\newcommand\examerror[2]{\ClassError{exam}{!!!! #1}{#2}}
\newcommand\examwarning[1]{\ClassWarning{exam}{!!!! #1}}
\DeclareOption{help}{%
    \ClassWarningNoLine{exam}{available options are:\MessageBreak
    answers:\space show questions with answers;\MessageBreak
    series:\space\space typeset a catalogue of problems}}
\newif\ifanswers
\DeclareOption{answers}{\answerstrue}
\AtBeginDocument{\ifanswers\ClassWarningNoLine{exam}{Repeat typesetting for %
    good table of contents}\fi}
\newif\ifseries
\DeclareOption{series}{\seriestrue\answerstrue}
\providecommand\parentclass{article}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{\parentclass}}
\PassOptionsToClass{titlepage}{\parentclass}
\ProcessOptions
\LoadClass{\parentclass}
\newcounter{examnum}
\newenvironment{exam}[2][0]{%
  \stepcounter{examnum}%
  \@ifemptyarg{#2}{}{\date{#2}}%
  \ifseries\else\ifanswers
    \addcontentsline{toc}{section}{\Exam~\theexamnum~---~\@date}%
  \fi\fi
    \ifanswers
        \pagenumbering{roman}%
        \maketitle\tableofcontents\cleardoublepage
    \fi
    \pagenumbering{arabic}%
    \ifseries\SRset{0}\else
        \SRset{#1}%
        \addcontentsline{toc}{subsection}{Start value random generator = #1}%
    \fi
  \setcounter{page}{1}}%
  {\ifseries\else
    \typeout{Total value scores = \thetotalscore}%
    \ifanswers
      \addcontentsline{toc}{subsection}{Total value scores = \thetotalscore}%
    \else\maketitle\fi\fi}
\newcounter{problemnum}[examnum]
\newtoks\problemid
\newcommand\question[3][]{%
  \@ifemptyarg{#1}{}{\renewcommand\parameter{#1}}%
  \ifseries
    \uppercase{\def\@namesection{#2}}%
    \ifx\namesection\@namesection
    \else
      \newpage
      \global\let\namesection=\@namesection
      \addcontentsline{toc}{subsection}{\namesection}%
      \setcounter{problemnum}{0}%
    \fi
  \fi
  \problemid={\uppercase{#3}}%
  \ifseries
    \noindent\underbar{\emph{File\,:}~\texttt{\the\problemid}}\par
    \nopagebreak\medskip\nopagebreak
  \fi
  \stepcounter{problemnum}%
  \IfFileExists{\mainfolder#2:#3}{\@@input \mainfolder#2:#3}%
    {\examwarning{File \mainfolder#2:#3 not found}}%
  \ifseries\else
    \addtocounter{totalscore}{\value{scorecounter}}%
    \typeout{\Problem\space\theproblemnum: score=\thescorecounter}%
  \fi
  \ifanswers
    \addcontentsline{toc}{subsubsection}%
      {\hbox to1cm{\theproblemnum:\hss}%
      \hbox{#3~~[score = \thescorecounter]}}%
  \fi}
\newcommand\namesection{}
\newcommand\reset@parameter{\gdef\parameter{}}
\reset@parameter
\newcommand\parameterproblem[2][1 ]{%
  \ifx\parameter\@empty
    \ifseries\else\examwarning{\string\parameter\space undefined,
    value `#1' taken}\fi
    \renewcommand\parameter{#1}%
  \fi
  \remark[Parameter \Problem]{#2}}

\newtoks\everyproblem
\newenvironment{problem}[1][]{%
  \@tagsforbidfalse\compact\the\everyproblem#1\@tagsforbidtrue
  \@boxing\bgroup\noindent\problemstart\ignorespaces}%
  {\par\nopagebreak\smallskip\nopagebreak
  \hbox to\linewidth{\hrulefill
    \ifseries\emph{\footnotesize\thinspace\the\@problemdate}\fi}%
  \egroup\par\bigskip\reset@problemdate\reset@parameter}
\newcommand\compact{\@chktag\compact\def\@boxing{\noindent\vbox}\fi}
\newcommand\split{\@chktag\split\def\@boxing{\@empty}\fi}
\newif\if@tagsforbid \@tagsforbidtrue
\providecommand\@chktag[1]{%
  \if@tagsforbid\@warning{tag \string#1\space ignored here}\else}
\newcommand\@problemstart{%
  \textbo{\Problem\,\ifnum\value{problemnum}<10 \phantom{0}\fi
  \theproblemnum}.\enskip}
\newcommand\problemstart{%
  \hangafter-2\settowidth\hangindent{\@problemstart}%
  \noindent\llap{\@problemstart}}
\newtoks\@problemdate
\newcommand\problemdate[1]{\global\@problemdate={#1}\ignorespaces}
\newcommand\reset@problemdate{\global\@problemdate={}}
\reset@problemdate
\newcounter{totalscore}[examnum]
\newcounter{scorecounter}[problemnum]
\newcommand\scoreboxsize{6mm}
\newcommand\scorebox[1]{%
  \fbox{\vbox to\scoreboxsize{\vss\hbox to\scoreboxsize{\hss#1\hss}\vss}}}
\newcommand\score[1]{%
  \addtocounter{scorecounter}{#1}%
  \rightnote[-\normalbaselineskip]{\scorebox{\ifanswers#1\fi}}%
  \ignorespaces}
\providecommand\leftnote[1][\z@skip]{\@rlnote l{#1}}
\providecommand\rightnote[1][\z@skip]{\@rlnote r{#1}}
\providecommand\@rlnote[3]{%
  \noindent\vadjust{\vbox to\z@{%
    \vskip#2\leftskip\z@skip\rightskip\z@skip\noindent
    \if#1l\llap{#3\hskip\marginparsep}%
    \else\hfill\rlap{\hskip\marginparsep#3}\fi
    \vss\vskip\z@skip}}}
\newcommand\remark[2][]{%
    \ifseries
        \begin{center}%
        \fbox{\parbox{.9\linewidth}{%
            \sloppy\hangafter\@ne
            \setbox\z@=\hbox{\emph{#1}\@ifemptyarg{#1}{}{:~}}%
            \hangindent=\wd\z@
            \strut\box\z@ #2}}%
        \end{center}\nopagebreak
        \addvspace{5mm}\nopagebreak
    \fi}
\newcommand\longwhite{25mm}
\newcommand\shortwhite{8mm}
\newcommand\answerstart{\emph{\Answer}:\enspace}

\newcommand\answer[2][]{\altanswer[#1]{}{#2}}
\newcommand\altanswer[3][]{%
  \@ifemptyarg{#1}%
    {\mbox{\ifanswers#3\fi}}%
    {\makebox[#1]{\ifanswers#3\else#2\fi}}%
  }
\newcommand\shortanswer[2][.75\linewidth]{\par
  \ifanswers
    \addvspace{\smallskipamount}%
    \noindent\answerstart\parbox[t]{#1}{\noindent #2}%
  \else
    \addvspace{\shortwhite}%
    \noindent\answerstart\makebox[#1]{\dotfill}\fi
  \par}
\newenvironment{longanswer}[1][\longwhite]{
  \par\addvspace{\medskipamount}%
  \noindent\answerstart\par\nopagebreak
  \ifanswers\noindent\else
    \hrule\@height#1\@width\z@\par
    \setbox\z@\vbox\bgroup
       \leavevmode
   \fi}
      {\ifanswers\else\egroup\setbox\z@\hbox{}\fi}
\newcount\loadcounter
\newcommand\resetloadcounter{\global\loadcounter\z@}
\newcommand\incloadcounter{\global\advance\loadcounter\@ne}
\newcommand\decloadcounter{\global\advance\loadcounter\m@ne}
\newcommand\@listk{%
  \settowidth{\leftmargin}{\@problemstart}%
  \topsep\medskipamount
  \partopsep\z@
  \itemsep\smallskipamount
  \parsep\z@}
\newenvironment{choice}[1][]{%
  \@tagsforbidfalse\ifseries\ordered\else\random\fi#1\@tagsforbidtrue
  \resetloadcounter
  \ifnum\@itemdepth>3 \@toodeep \else
  \advance\@itemdepth\@ne
  \expandafter\let
    \csname @list\romannumeral\the\@itemdepth\endcsname=\@listk
  \list{\badmark}{\def\makelabel##1{\hss\llap{##1}}}%
  \fi}%
  {\@dumpitems\endlist}
\newcommand\random{\@chktag\random
    \def\@loaditem{\loaditem}%
    \def\@dumpitems{\shuffle\dumpitems}%
  \fi}
\newcommand\ordered{\@chktag\ordered
    \def\@loaditem{}%
    \def\@dumpitems{}%
  \fi}
\providecommand\square{\bigcirc}
\providecommand\checksquare{\surd}
\newcommand\badmark{$\square$}
\newcommand\goodmark{\ifanswers$\checksquare$\else\badmark\fi}
\newcommand\baditem[1]{\@loaditem{\item[\badmark]#1}}
\newcommand\gooditem[1]{\@loaditem{\item[\goodmark]#1}}
\newtoks\@itemA
\newtoks\@itemB
\newtoks\@itemC
\newtoks\@itemD
\newtoks\@itemE
\newcommand\@itemstore{5}
\newcommand\loaditem[1]{%
  \ifcase\loadcounter
    \@itemA={#1}%
    \or\@itemB={#1}%
    \or\@itemC={#1}%
    \or\@itemD={#1}%
    \or\@itemE={#1}%
  \fi
  \ifnum\loadcounter<\@itemstore \incloadcounter
  \else\examwarning{\string\loaditem\space ignored, too many}\fi}
\newcommand\dumpitemno[1]{%
  \ifnum#1>\loadcounter
    \examwarning{\string\dumpitemno[#1] ignored, out range}%
  \else\ifcase#1\relax
    \or\the\@itemA
    \or\the\@itemB
    \or\the\@itemC
    \or\the\@itemD
    \or\the\@itemE
  \fi\fi}
\newcommand\dumpitem{\dumpitemno{\loadcounter}\decloadcounter}
\newcommand\dumpitems{\@whilenum\loadcounter>\z@\do{\dumpitem}}
\newcommand\shuffle{%
  \ifcase\loadcounter
    \or
    \or\shuffle@ii
    \or\shuffle@\@itemA\@itemC \shuffle@ii \shuffle@\@itemB\@itemC
    \or\shuffle@iv
    \or\shuffle@\@itemD\@itemE \shuffle@iv \shuffle@\@itemD\@itemE
    \fi
  }
\newtoks\@item@
\newcommand\shuffle@[2]{\SRtest{}{\@item@=#1 #1=#2 #2=\@item@}}
\newcommand\shuffle@ii{\shuffle@\@itemA\@itemB}
\newcommand\shuffle@iv{%
  \SRtest{\shuffle@\@itemA\@itemB}{\shuffle@\@itemC\@itemD}%
  \SRtest{\shuffle@\@itemA\@itemC}{\shuffle@\@itemB\@itemD}}
\ifx\@SR\undefined\newcount\@SR\fi
\providecommand\@SRconst{2097152}
\providecommand\SRset[1]{\global\@SR#1 \ignorespaces}
\providecommand\@SRadvance{%
  \begingroup
  \ifnum\@SR<\@SRconst\relax\count@\z@\else\count@\@ne\fi
  \ifodd\@SR\advance\count@\@ne\fi
  \global\divide\@SR\tw@
  \ifodd\count@\global\advance\@SR\@SRconst\relax\fi
  \endgroup}
\providecommand\SRbit{\@SRadvance\ifodd\@SR1\else0\fi}
\providecommand\SRtest[2]{\@SRadvance\ifodd\@SR#2\else#1\fi\ignorespaces}
\providecommand\SRvalue{\number\@SR }
\SRset{0}
\newcommand\thehead{%
  \slshape\@title\enspace\upshape:\enspace
  \ifseries\namesection\else\@date\fi}
\newcommand\ps@examheadings{%
  \let\@oddfoot\@empty
  \let\@evenfoot\@empty
  \renewcommand\@oddhead{%
    \vbox{%
    \hbox to\textwidth{\headerfont\thehead\hfil\upshape\thepage}%
    \vskip1.5\p@
    \hrule\@height.5\p@\@width\textwidth
    }}%
  \let\@evenhead\@oddhead}
\newcommand\target[1]{\gdef\@target{#1}}\def\@target{}
\newcommand\Copyright{\mbox{}}
\renewcommand\maketitle{%
\if@titlepage\begin{titlepage}
  \begin{center}\titlefont
    \vspace*{1cm}%
    \mbox{}\rule{2cm}{0.4pt}\mbox{}\par
    \addvspace{1cm}%
    \begin{Large}
      \textbf{\ifseries\Collection\else\Exam\fi}\\[10mm]
    \end{Large}
    \begin{large}
      \@title\\[5mm]
      \ifseries\@author\else\@target\fi\\[5mm]
      \@date\\[10mm]
    \end{large}
    \mbox{}\rule{2cm}{0.4pt}\mbox{}\par
    \addvspace{2cm}%
  \ifseries
    \vfill\vfill
    \begin{flushleft}%
      \Copyright
    \end{flushleft}%
  \else\ifanswers
      \begin{huge}\Answers\end{huge}\par
    \else
      \begin{minipage}{.75\textwidth}%
      \raggedright\parindent\medskipamount
        Naam:\enspace\dotfill\strut\par
        Adres:\enspace\dotfill\strut\par
        Plaats:\enspace\dotfill\strut\par
        Collegekaart:\enspace\dotfill\strut\par
        \vspace{1cm}%
        \begin{itemize}%
        \item Zonder geldige collegekaart wordt geen
          tentamenbriefje uitgereikt.
        \item U wordt met nadruk verzocht om een
          \emph{leesbaar} schrift; wat niet leesbaar
          is, wordt fout gerekend.
        \item Denk erom losse vellen tentamenpapier
          van Uw naam en collegekaartnummer te voorzien;
          gebruik blokletters voor de leesbaarheid.
        \item Dit tentamen telt \theproblemnum\ opgaven
        \end{itemize}%
      \end{minipage}\\[10mm]
      \GoodLuck\par
    \fi
  \fi
  \end{center}%
\end{titlepage}\fi}
\newcommand\onlanguage[4]{% {language}{current}{existing}{not existing}
  \expandafter\ifx\csname l@#1\endcsname\relax
  #4\else\ifnum\csname l@#1\endcsname=\language #2\else#3\fi\fi}
\newcommand\englishExamNames{%
  \newcommand\Answers{ANSWERS}%
  \newcommand\Answer{Answer}%
  \newcommand\GoodLuck{Good luck!}%
  \newcommand\Exam{EXAM}%
  \newcommand\Collection{COLLECTION OF EXAMS}%
  \newcommand\Problem{Problem}%
  }
\AtBeginDocument{\onlanguage{english}{\englishExamNames}{}{}}
\AtBeginDocument{\onlanguage{american}{\englishExamNames}{}{}}
\newcommand\dutchExamNames{%
  \newcommand\Answers{ANTWOORDEN}%
  \newcommand\Answer{Antwoord}%
  \newcommand\GoodLuck{Veel succes!}%
  \newcommand\Exam{TENTAMEN}%
  \newcommand\Collection{TENTAMENBUNDEL}%
  \newcommand\Problem{Opgave}%
  }
\AtBeginDocument{\onlanguage{dutch}{\dutchExamNames}{}{}}
\newcommand\fullanswer{Geef de volledige afleiding; %
  slechts het antwoord vermelden wordt \emph{niet} goed gerekend.}
\providecommand\textbo{\textbf}
\providecommand\@ifemptyarg[1]{% {absence}{presence}
  \ifx\@empty#1\@empty
  \expandafter\@firstoftwo\else\expandafter\@secondoftwo\fi}
\newcommand\headerfont{\rmfamily\small}
\newcommand\bodyfont{\sffamily}
\newcommand\titlefont{\rmfamily\upshape}
\bodyfont
\newcommand\Mainfolder[1]{\def\mainfolder{#1}}
\newcommand\Commonfolder[1]{\def\commonfolder{#1}}
\newcommand\Figuresfolder[1]{\def\figuresfolder{#1}}
\Mainfolder{\@currdir}
\Commonfolder{\@currdir}
\Figuresfolder{\@currdir}
\InputIfFileExists{exam.cfg}{}{}
\endinput
%% 
%% End of file `exam.cls'.
