{$A+,B-,D-,E-,F-,G-,I+,L-,N-,O-,R-,S-,V+,X-}
{$M 4000,0,655360}
program InMouse; { Turbo Pascal 6.0 }

{
get a character typed at the keyboard or
the character from the screen file at the mouse cursor position
}

uses
  DOS,
  OPMOUSE,
  OPCRT,
  OPDATE;


const
  gc_MaxX   = 80;
  gc_MaxY   = 25;
var
  gv_Screen : array [1..gc_MaxX, 1..gc_MaxY] of char;
  gv_Show   : boolean;


procedure ReadScreenMapping;
var
  lv_File  : text;
  x, y,
  x1, x2,
  y1, y2   : byte;
  lv_Code,
  lv_Intro : char;
begin
FillChar (gv_Screen, SizeOf (gv_Screen), #0);
if ParamStr (1) = '/s' then
  gv_Show := true
else
  begin
  gv_Show := false;
  Assign (lv_File, ParamStr (1));
  {$I+}
  Reset (lv_File); { abort on error }
  ReadLn (lv_File); { skip first line }
  lv_Intro := ':';
  while lv_Intro = ':' do
    begin
    Read (lv_File, lv_Intro);
    if lv_Intro = ':' then
      begin
      ReadLn (lv_File, x1, x2, y1, y2, lv_Code { ignored }, lv_Code);
      for x := x1 to x2 do
        for y := y1 to y2 do
          gv_Screen [x, y] := char (lv_Code)
      end
    end;
  Close (lv_File)
  end
end;


function gf_AltKey (pc_Key : char) : word;
const
  lc_AltCodes : array [1..26] of byte = { high byte scan codes }
                  ($1E, $30, $2E, $20, $12, $21, $22, $23, $17, $24,
                   $25, $26, $32, $31, $18, $19, $10, $13, $1F, $14,
                   $16, $2F, $11, $2D, $15, $2C);
begin
gf_AltKey := Swap (word (lc_AltCodes [Ord (UpCase (pc_Key)) - 64]));
end;


procedure HandleLeftButton (x, y : byte);
begin
if (x <= gc_MaxX) and (y <= gc_MaxY) then
  begin
  if gv_Show then
    begin
    GotoXY (73, 1);
    Write (x:3, ',', y:3)
    end;
  if gv_Screen [x, y] <> #0 then
    begin
    case gv_Screen [x, y] of
    'a'..'z' :
      StuffKey (Ord (gv_Screen [x, y]));
    'A'..'Z' :
      begin
      StuffKey (Ord (gv_Screen [x, y]));
      StuffKey (13) { emulate Carriage Return }
      end;
    '<' :
      StuffKey ($4900); { PgUp }
    '>' :
      StuffKey ($5100)  { PgDn }
    end { case }
    end
  end
end;


procedure HandleRightButton (x, y : byte);
const
  lc_F1 = $3B00; { scan code F1 }
begin
if (x <= gc_MaxX) and (y <= gc_MaxY) then
  begin
  if not (gv_Screen [x, y] in [#0, '?']) then
    StuffKey (gf_AltKey (gv_Screen [x, y]))
  else
    StuffKey (lc_F1)
  end
end;

function gf_TestTimeOut (pc_Timer : Time) : boolean;
var
  dx, dy     : integer;
  lv_NewTime : Time;
  h,m,s      : byte;
  lv_Diff    : Time;
const
  ls_CurTime : Time = -1;
begin
if ls_CurTime = -1 then
  ls_CurTime := CurrentTime;
GetMickeyCount (dx, dy);
if (dx <> 0) or (dy <> 0) then  { mouse has been moved }
  begin
  ls_CurTime := CurrentTime; { reset timer }
  gf_TestTimeOut := false
  end
else
  begin
  TimeDiff (ls_CurTime, CurrentTime, h,m,s);
  lv_Diff := (h * 3600) + (m * 60) + s;
  if lv_Diff >= pc_Timer then
    gf_TestTimeOut := true
  else
    gf_TestTimeOut := false
  end
end;


procedure GetTheKey;
var
  lv_Count   : word;
  x, y       : byte;
  lv_TimeOut : boolean;
  lv_TimeStr : string [8];
  lv_Timer   : Time;
  lv_Check   : integer;
begin
lv_TimeOut := false;
lv_TimeStr := GetEnv ('WTIME');
if lv_TimeStr <> '' then
  Val (Copy (lv_TimeStr, 3,4), lv_Timer, lv_Check);
repeat
  if lv_TimeStr <> '' then
    lv_TimeOut := gf_TestTimeOut (lv_Timer);
  if MouseButtonReleased (LeftButton, lv_Count, x, y) then
    HandleLeftButton (x, y)
  else
    if MouseButtonReleased (RightButton, lv_Count, x, y) then
      HandleRightButton (x, y)
    else
      if lv_TimeOut then
        StuffKey ($FF)
until (KeyPressed) or (lv_TimeOut)
end;


procedure ShowTheMouse;
var
  x, y : byte;
  i    : integer;
begin
Val (ParamStr (2), x, i);
Val (ParamStr (3), y, i);
SoftMouseCursor ($FFFF, $7700);
ShowMouse;
MouseGotoXY (x, y)
end;


begin
if MouseInstalled then
  begin
  ShowTheMouse;
  ReadScreenMapping;
  GetTheKey;
  HideMouse
  end
end.
