/*
Copyright (C) 2016, 2017 Siep Kroonenberg

This file is part of TLaunch.

TLaunch is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

TLaunch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with TLaunch.  If not, see <http://www.gnu.org/licenses/>.
*/

/////////////////////////////////////////////////////
// GUI globals

HINSTANCE hInst;
HWND hMain;

// font variables
HFONT hfnt, hfntbig;
int cx, cy; // average width; height plus leading
int cxb, cyb; // same for hfntbig

// measurement for icons and buttons with icons
int iconsize;

// range of menu item IDs
// ID_FIRST_CONTROL set in resource.h
UINT_PTR id_next_control;
// range of ids for other child items
// ID_FIRST_CHILD set in resource.h
UINT_PTR id_next_child;

/////////////////////////////////////////////////
// other globals, mostly set by get_config
// launcher and uninstaller
wchar_t * tl_name;
wchar_t * version;
wchar_t * configdir;

// pre|post [un]install
wchar_t * pre_config, * post_config, * pre_forget;

// announcement text string
wchar_t * tl_announce;

// tex live itself; all implicitly initialized to NULL by compiler
wchar_t * tlroot; // root of the TeX Live installation
wchar_t * tlbin; // directory of TL binaries
wchar_t * tlperl; // built-in perl binary
wchar_t * tlwperl; // built-in wperl binary
wchar_t * new_searchpath; // process searchpath for the launcher
wchar_t * tlp_searchpath; // with tlperl dir prepended
wchar_t * texmfvar; // generated files for user
wchar_t * texmfconfig; // various configuration and support files
wchar_t * tl_menu; // TL submenu of Start/All Programs

// ini general section, corresponding to installer options
// filetype policy (0: do nothing; 1: do not overwrite; 2: always):
int assoc_mode;
// deal with non-roaming file associations:
int create_rememberer;
int do_searchpath;

// prototype for functions invoked by some controls
typedef void TL_builtin( HWND );
TL_builtin quit_tl, init_tl, clear_tl, ed_sel_tl,
    about_tl, uninst_tl, uninst_all_tl;

/////////////////////////////////////////////////
// Data structures

#define MAX_KEYNAME 255 // max length registry key name according to MSDN site
// The limits below are pretty arbitrary.
#define MAX_CONFIG 100000 // max size ini file, in wide characters
// menu items and buttons
#define MAX_CONTROLS 200
// filetypes / progids
#define MAX_PGIDS 50
#define MAX_MENUS 20
// utility scripts
#define MAX_SC 50
// saved environment variables, for entries in Strings
#define MAX_ENV 50

// filetypes / progids. Ini prefix: FT
typedef struct {
  wchar_t * progid;
  wchar_t * command;
  wchar_t * basename; // needed for application [un]registration
  wchar_t * shell_cmd; // with arguments template, for shellopen
  wchar_t * extensions; // space-concatenated list of extensions
  wchar_t * name; // optional
  wchar_t * iconspec; // optional
  BOOL primary;
  BOOL path_prefix;
} Pgid;
Pgid * pgids[MAX_PGIDS + 1]; // spare for custom editor
short nprogs;

// external utility scripts. Ini prefix: SC:
typedef struct {
  wchar_t * name;
  wchar_t * command;
  wchar_t * splashtext;
} Script;
Script * scripts[MAX_SC];
short nsc;

// A control is either a menu item or a button to start a program.
// There are no ini file sections for individual controls,
// only menu sections and a buttons section with controls
typedef struct {
  UINT_PTR id; // pointer-sized unsigned integer; NOT a pointer
  HWND hw;
  wchar_t * display; // name to be displayed
  HICON hicon; // retrieved programmatically as needed
  BOOL icon_from_resource; // if true, do not call DestroyIcon
  wchar_t type;
  // S (utility script) or D (data / shell object)
  // or P (pgid) or E (default editor) or C (command) or F (function)
  Pgid * pgid;
  wchar_t * action;
  Script * script;
  TL_builtin * fun; // exactly one of the above three should be non-null
  BOOL uses_tlperl;
  BOOL enabled;
} Control;
Control * controls[MAX_CONTROLS];
short ncontrols;

// menus. Ini prefix: MN:
typedef struct {
UINT_PTR id;
wchar_t * name;
// indices into controls array; NOT Windows resource IDs:
int first_item;
int nitems;
} SubMenu;
SubMenu * menus[MAX_MENUS];
short nmenus;

// buttons
int first_button, nbuttons; // first_button: index into controls array

// perl-related environment variables;
typedef struct { wchar_t * name; wchar_t * val; } PerlEnv;
PerlEnv * perl_envs;
int nperl_envs;

// calculate basename from command
// whether or not command refers to a filename
wchar_t * get_basename( wchar_t * command );

void parse_ini( wchar_t * config );

/////////////////////////////////////////////////////////
// default editor

#define MAX_EDITORS 10
// progid for name below can be overridden by value set in tlaunch.ini
#define CUSTOMED_PROGID L"TL.customed"

Pgid * ed_pgid, * cust_pgid, * first_ed;
#define NEXTS 3
wchar_t * latex_exts[NEXTS], * lx_exts;
BOOL ed_initdone;
void set_icon( Control * ctrl );
void initialize_editors();
void register_eds_wnd_class( );
void update_mainwin_ed_control( );
void run_options_dialog( HWND hwnd );

/////////////////////////////////////////////////////////
// splash screen

HWND splash( HWND h, wchar_t * splash_text );

void register_splash( );
