/*
NUM_RELATIONS: 8
*/

/*
Query 59
--------
*/

#include "../optgen/opt_defs.h"
#include "dbi_gen.h"
#include "dbi.h"
#include "../optgen/opt.h"
#include "../optgen/global.h"
#include <stdlib.h>

#define NUM_RELATIONS   8
#define NUM_SUBQUERIES  2*NUM_RELATIONS
extern  COST  infinite_cost ;
extern  int   indent_value ;

main ()
{
int              error, i ;
PROPERTY_VECTOR  pv, excl_pv ;
PLAN             *plan ;
QUERY            *query, *subquery[NUM_SUBQUERIES] ;
COST             cost_limit ;
extern char      *error_text (STATUS);
extern void      init_operator_tree (QUERY *);
extern STATUS    print_plan (PLAN *) ;
extern STATUS    volcano_optimizer (QUERY *query, PROPERTY_VECTOR *prop_vec, 
                                    PV_COMPARE pv_compare_value,
                                    PROPERTY_VECTOR *excl_prop_vec, 
                                    PV_EXCL_COMPARE pv_excl_compare_value,
                                    COST *cost_limit, PLAN **plan) ;

for (i = NUM_SUBQUERIES; --i >= 0; )
{
    allocate_query (subquery[i]) ;
    allocate (subquery[i]->argument.log_prop, LOG_PROP) ;
    allocate (subquery[i]->argument.prop_vec, PROPERTY_VECTOR) ;
    allocate (subquery[i]->argument.al_arg, AL_ARG) ;
}
subquery[1] -> my_operator = RET ;
subquery[1] -> argument.__prel.__prel_arity = 1 ;
subquery[1] -> argument.__prel.__prelation[0] = SET_H ;

subquery[2] -> my_operator = RET ;
subquery[2] -> argument.__prel.__prel_arity = 1 ;
subquery[2] -> argument.__prel.__prelation[0] = SET_C ;

subquery[3] -> my_operator = RET ;
subquery[3] -> argument.__prel.__prel_arity = 1 ;
subquery[3] -> argument.__prel.__prelation[0] = SET_F ;

subquery[4] -> my_operator = RET ;
subquery[4] -> argument.__prel.__prel_arity = 1 ;
subquery[4] -> argument.__prel.__prelation[0] = SET_G ;

subquery[5] -> my_operator = RET ;
subquery[5] -> argument.__prel.__prel_arity = 1 ;
subquery[5] -> argument.__prel.__prelation[0] = SET_D ;

subquery[6] -> my_operator = RET ;
subquery[6] -> argument.__prel.__prel_arity = 1 ;
subquery[6] -> argument.__prel.__prelation[0] = SET_B ;

subquery[7] -> my_operator = RET ;
subquery[7] -> argument.__prel.__prel_arity = 1 ;
subquery[7] -> argument.__prel.__prelation[0] = SET_E ;

subquery[8] -> my_operator = RET ;
subquery[8] -> argument.__prel.__prel_arity = 1 ;
subquery[8] -> argument.__prel.__prelation[0] = SET_A ;

subquery[9] -> my_operator = JOIN ;
subquery[9] -> argument.op_arg.predicate.operand1 = hh2 ;
subquery[9] -> argument.op_arg.predicate.operand2 = cc2 ;
subquery[9] -> argument.op_arg.predicate.equal = '=' ;
subquery[9] -> input[0] = subquery[1] ;
subquery[9] -> input[1] = subquery[2] ;

subquery[10] -> my_operator = JOIN ;
subquery[10] -> argument.op_arg.predicate.operand1 = hh1 ;
subquery[10] -> argument.op_arg.predicate.operand2 = ff3 ;
subquery[10] -> argument.op_arg.predicate.equal = '=' ;
subquery[10] -> input[0] = subquery[9] ;
subquery[10] -> input[1] = subquery[3] ;

subquery[11] -> my_operator = JOIN ;
subquery[11] -> argument.op_arg.predicate.operand1 = ff3 ;
subquery[11] -> argument.op_arg.predicate.operand2 = gg1 ;
subquery[11] -> argument.op_arg.predicate.equal = '=' ;
subquery[11] -> input[0] = subquery[10] ;
subquery[11] -> input[1] = subquery[4] ;

subquery[12] -> my_operator = JOIN ;
subquery[12] -> argument.op_arg.predicate.operand1 = hh2 ;
subquery[12] -> argument.op_arg.predicate.operand2 = dd1 ;
subquery[12] -> argument.op_arg.predicate.equal = '=' ;
subquery[12] -> input[0] = subquery[11] ;
subquery[12] -> input[1] = subquery[5] ;

subquery[13] -> my_operator = JOIN ;
subquery[13] -> argument.op_arg.predicate.operand1 = hh1 ;
subquery[13] -> argument.op_arg.predicate.operand2 = bb1 ;
subquery[13] -> argument.op_arg.predicate.equal = '=' ;
subquery[13] -> input[0] = subquery[12] ;
subquery[13] -> input[1] = subquery[6] ;

subquery[14] -> my_operator = JOIN ;
subquery[14] -> argument.op_arg.predicate.operand1 = cc1 ;
subquery[14] -> argument.op_arg.predicate.operand2 = ee1 ;
subquery[14] -> argument.op_arg.predicate.equal = '=' ;
subquery[14] -> input[0] = subquery[13] ;
subquery[14] -> input[1] = subquery[7] ;

subquery[15] -> my_operator = JOIN ;
subquery[15] -> argument.op_arg.predicate.operand1 = ff1 ;
subquery[15] -> argument.op_arg.predicate.operand2 = aa1 ;
subquery[15] -> argument.op_arg.predicate.equal = '=' ;
subquery[15] -> input[0] = subquery[14] ;
subquery[15] -> input[1] = subquery[8] ;

init_property_vec (&pv) ;
init_property_vec (&excl_pv) ;

pv.sort.sort_arity = 1 ;
pv.sort.sort_attr[0] = hh1 ;

init_operator_tree (subquery[13]) ;

copy_cost (&cost_limit, &infinite_cost) ;
error = volcano_optimizer (subquery[13],
                           &pv,
                           PV_EQUAL,
                           &excl_pv,
                           PV_EXCL_TRUE,
                           &cost_limit,
                           &plan) ;

if (error != OKAY)
  printf ("Optimizer returned error code = %s\n", error_text (error)) ;
else
{
  printf ("Optimizer returned successfully.\n") ;
#ifdef PRINT
printf ("Plan returned by optimizer:\n") ;
printf ("Plan cost: ") ;
print_cost (&(plan->cost)) ;
print_plan (plan) ;
#endif
}
/*
CHECK( dump_storage(2));
*/
exit (0) ;
}
