/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.IOException;

public class AtGlsAtAtLink
extends AbstractGlsCommand {
    protected boolean checkModifier;
    protected boolean doUnset;
    protected CaseChange caseChange;
    private KeyValList defaultOptions;

    public AtGlsAtAtLink(GlossariesSty glossariesSty) {
        this("@gls@@link", glossariesSty, false, false);
    }

    public AtGlsAtAtLink(String string, GlossariesSty glossariesSty, boolean bl) {
        this(string, glossariesSty, bl, false);
    }

    public AtGlsAtAtLink(String string, GlossariesSty glossariesSty, boolean bl, boolean bl2) {
        this(string, glossariesSty, bl, bl2, CaseChange.NO_CHANGE);
    }

    public AtGlsAtAtLink(String string, GlossariesSty glossariesSty, boolean bl, boolean bl2, CaseChange caseChange) {
        super(string, glossariesSty);
        this.checkModifier = bl;
        this.doUnset = bl2;
        this.caseChange = caseChange;
    }

    @Override
    public Object clone() {
        AtGlsAtAtLink atGlsAtAtLink = new AtGlsAtAtLink(this.getName(), this.getSty(), this.checkModifier, this.doUnset, this.caseChange);
        atGlsAtAtLink.setEntryLabelPrefix(this.getEntryLabelPrefix());
        atGlsAtAtLink.setDefaultOptions(this.defaultOptions);
        return atGlsAtAtLink;
    }

    public void setDefaultOptions(KeyValList keyValList) {
        this.defaultOptions = keyValList;
    }

    public KeyValList getDefaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    protected TeXObject getLinkText(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.popArg(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        KeyValList keyValList;
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        KeyValList keyValList2 = null;
        if (this.defaultOptions != null) {
            keyValList2 = (KeyValList)this.defaultOptions.clone();
        }
        if ((keyValList = this.popOptKeyValList(teXObjectList, true)) != null) {
            if (keyValList2 == null) {
                keyValList2 = keyValList;
            } else {
                keyValList2.putAll(keyValList);
            }
        }
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        TeXObject teXObject = this.getLinkText(glsLabel, teXParser, teXObjectList);
        switch (this.caseChange) {
            case SENTENCE: {
                teXObjectList2 = laTeXParserListener.createStack();
                teXObjectList2.add(laTeXParserListener.getControlSequence("glssentencecase"));
                teXObjectList2.add(TeXParserUtils.createGroup(laTeXParserListener, teXObject));
                teXObject = teXObjectList2;
                break;
            }
            case TO_UPPER: {
                teXObjectList2 = laTeXParserListener.createStack();
                teXObjectList2.add(laTeXParserListener.getControlSequence("mfirstucMakeUppercase"));
                teXObjectList2.add(TeXParserUtils.createGroup(laTeXParserListener, teXObject));
                teXObject = teXObjectList2;
            }
        }
        teXObjectList2 = laTeXParserListener.createStack();
        if (glsLabel.getEntry() == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            this.preGlsHook(glsLabel, teXParser, teXObjectList);
            teXParser.putControlSequence(true, new AssignedControlSequence("do@gls@link@checkfirsthyper", new Relax()));
            if (this.sty.isExtra()) {
                teXParser.putControlSequence(true, new GenericCommand(true, "glscustomtext", null, (TeXObject)teXObject.clone()));
                teXObjectList2.add(laTeXParserListener.getControlSequence("@glsxtr@field@linkdefs"));
            }
            teXObjectList2.add(laTeXParserListener.getControlSequence("@gls@link"));
            if (keyValList2 != null) {
                teXObjectList2.add(laTeXParserListener.getOther(91));
                teXObjectList2.add(keyValList2);
                teXObjectList2.add(laTeXParserListener.getOther(93));
            }
            teXObjectList2.add(glsLabel);
            Group group = laTeXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(teXObject);
            if (this.doUnset) {
                teXObjectList2.add(laTeXParserListener.getControlSequence("glsunset"));
                teXObjectList2.add(glsLabel);
            }
        }
        teXObjectList2.add(new TeXCsRef("glspostlinkhook"));
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    protected void preGlsHook(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
    }
}

