/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.io.IOException;
import korlibs.io.async.RunBlockingNoJsJvmKt;
import korlibs.io.file.std.LocalVfsJvmKt;
import korlibs.io.util.checksum.CRC32;
import korlibs.io.util.checksum.SimpleChecksum;
import korlibs.io.util.checksum.SimpleChecksumKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.core.files.Database;
import org.islandoftex.arara.core.localization.LanguageController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"Lorg/islandoftex/arara/core/files/FileHandling;", "", "<init>", "()V", "changeExtension", "Lorg/islandoftex/arara/api/files/MPPPath;", "path", "extension", "", "isSubDirectory", "", "child", "parent", "calculateHash", "", "hasChanged", "file", "databaseFile", "core"})
public final class FileHandling {
    @NotNull
    public static final FileHandling INSTANCE = new FileHandling();

    private FileHandling() {
    }

    @NotNull
    public final MPPPath changeExtension(@NotNull MPPPath path2, @NotNull String extension) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(extension, "extension");
        String name = StringsKt.substringBeforeLast$default(path2.getFileName(), '.', null, 2, null) + "." + extension;
        return path2.resolveSibling(name).normalize();
    }

    public final boolean isSubDirectory(@NotNull MPPPath child, @NotNull MPPPath parent) throws AraraException {
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(parent, "parent");
        return child.isDirectory() && parent.isDirectory() ? child.normalize().startsWith(parent.normalize()) : false;
    }

    public final long calculateHash(@NotNull MPPPath path2) throws AraraException {
        long l;
        Intrinsics.checkNotNullParameter(path2, "path");
        try {
            l = (long)UInt.constructor-impl(SimpleChecksumKt.checksum((byte[])RunBlockingNoJsJvmKt.runBlockingNoJs$default(null, new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(path2, null){
                int label;
                final /* synthetic */ MPPPath $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.label = 1;
                            Object object2 = LocalVfsJvmKt.localVfs$default(this.$path.normalize().toString(), false, 2, null).readBytes(this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null), (SimpleChecksum)CRC32.INSTANCE)) & 0xFFFFFFFFL;
        }
        catch (IOException exception) {
            throw new AraraException(LanguageController.getMessages().getERROR_CALCULATEHASH_IO_EXCEPTION(), exception);
        }
        return l;
    }

    public final boolean hasChanged(@NotNull MPPPath file, @NotNull MPPPath databaseFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(databaseFile, "databaseFile");
        org.islandoftex.arara.api.files.Database database = Database.Companion.load(databaseFile);
        MPPPath path2 = file.normalize();
        if (!path2.getExists()) {
            if (database.contains(path2)) {
                database.remove(path2);
                database.save(databaseFile);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            long hash = this.calculateHash(path2);
            if (database.contains(path2)) {
                Long value = database.get(path2);
                Long l = value;
                if (l != null && hash == l) {
                    bl = false;
                } else {
                    database.set(path2, hash);
                    database.save(databaseFile);
                    bl = true;
                }
            } else {
                database.set(path2, hash);
                database.save(databaseFile);
                bl = true;
            }
        }
        return bl;
    }
}

