/* al_file.c 2.9.0 92/07/06 -- split-off part of argloop.c
 *
-----------------------------------------------------------------------
    This software module copyright (c) 1990, 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
    See argloop(3) for more information on this software module.
-----------------------------------------------------------------------
 */

#include "config.h"
#include "xstdio.h"		/* <stdio.h> plus prototypes */
#include "strmisc.h"		/* inludes <string(s).h> */
#include "argloop.h"

struct file
{
  FILE *fp;
  char buf[1024];		/* maximum sized word this allows */
};

static const char *
file_word(st)
     struct file *st;
{
  return fgetword(st->buf, st->fp);
}

void
file_free(st)
     struct file *st;
{
  fclose(st->fp);
  xfree(st);
}

Argloop_context *
al_file(fp)
     FILE *fp;
{
  struct file *st = (struct file *)xmalloc(sizeof (struct file));
  Argloop_context *cxt = (Argloop_context *)xmalloc(sizeof (Argloop_context));
  
  st->fp = fp;
  cxt->data = (char *)st;
  cxt->word = file_word;
  cxt->free = file_free;
  cxt->first = (char *)0;
  return cxt;
}
