{$N-,W-,V-,G+}

Unit wbibdisp;

Interface

Uses
  strings,Wobjects,WinTypes,WinProcs,rc_strng,rc_id,bibstrg,bibvars;

Const
  MaxMenuStack     = 4;   { Max submenu depth                 }

Type
  CharSet = set of char;
  SelectionType = array[0..MaxMenuStack] of byte;
  CapStrType = string[30];

  ButtonRec = record
    Name: CapStrType;
    id,H,Y: integer;
  end;

  PAskIfDlg = ^TAskIfDlg;
  TAskIfDlg = object(TDialog)
    NButtons:   integer;
    Cap:        array[0..20] of ButtonRec;
    Prompt:     string;
    Heading:    array[0..255] of char;
    constructor init(AParent: PWindowsObject; AName: PChar;
                     APrompt,AHeading: string; C1,C2,C3,C4: CapStrType);
    procedure   SetupWindow; virtual;
    procedure   Btn1(var Msg: TMessage); virtual id_first+dl_AskIfBtn1;
    procedure   Btn2(var Msg: TMessage); virtual id_first+dl_AskIfBtn2;
    procedure   Btn3(var Msg: TMessage); virtual id_first+dl_AskIfBtn3;
    procedure   Btn4(var Msg: TMessage); virtual id_first+dl_AskIfBtn4;
  end;

Var
  DispTimeOut: word;
  TimeOutOn,suspended,AbortFlag: boolean;
  SuspendedPos: LongInt;
  PSuspendFile: ^text;
  MessageParent: Hwnd;

procedure TrapAbort;
function  GetTextLength(H: HWnd; S: string): word;
procedure Message(S: string);
procedure DebugMessage(S: string);
procedure ErrorMessage(S: String);
procedure FatalError(S: String);
procedure MessageRC(id: word; S: string);
procedure ErrorMessageRC(id: word; S: string);
procedure FatalErrorRC(id: word; S: string);
procedure UnImplemented;
procedure FreeMemDeficit(s: string; MemoryFree: longint);
function  AskIf(line,title: string; YesStr,NoStr: CapStrType) : boolean;
function  AskIfRC(id: integer; S,title: string; YesStr,NoStr: CapStrType): boolean;
function  AskIf3(line: string; Str1,Str2,Str3: CapStrType) : integer;
function  AskIf4(line: string; Str1,Str2,Str3,Str4: CapStrType) : integer;
function  YesNo(line: string) : boolean;
function  YesNoRC(id: Word; S: string) : boolean;

Implementation


function GetTextLength(H: HWnd; S: string): word;
var
  Font,OldFont: HFont;
  DC: HDC;
  Ext: word;
  T: array[1..2] of TPoint;
begin
  Font:=HFont(SendMessage(H,wm_GetFont,0,0));
  DC:=GetDC(H);
  OldFont:=SelectObject(DC,Font);
  Ext:=LoWord(GetTextExtent(DC,@S[1],length(S)));
  T[1].X:=0; T[1].Y:=0; T[2].X:=Ext; T[2].Y:=0;
  LpToDp(DC,T,2);
  GetTextLength:=T[2].X-T[1].X;
  SelectObject(DC,OldFont);
  ReleaseDC(H,DC);
end;

{ TAskIfDlg methods }

constructor TAskIfDlg.Init(AParent: PWindowsObject; AName: PChar;
            APrompt,AHeading: string; C1,C2,C3,C4: CapStrType);
begin
  TDialog.Init(AParent,AName);
  Prompt:=APrompt; StrPCopy(Heading,AHeading);
  with Cap[1] do
  begin
    Name:=C1; id:=dl_AskIfBtn1;
  end;
  with Cap[2] do
  begin
    Name:=C2; id:=dl_AskIfBtn2;
  end;
  with Cap[3] do
  begin
    Name:=C3; id:=dl_AskIfBtn3;
  end;
  with Cap[4] do
  begin
    Name:=C4; id:=dl_AskIfBtn4;
  end;
  NButtons:=1; if C2='' then Exit;
  NButtons:=2; if C3='' then Exit;
  NButtons:=3; if C4='' then Exit;
  NButtons:=4;
end;

procedure TAskIfDlg.SetupWindow;
var
  Rect: Trect;
  i,len,MaxBtnTextLen,Spacing,Padding,PromptLength: integer;
  Width,Height,MidX,RelMidX,TextH,TextY,BtnWidth,BtnsWidth: integer;
  Point: TPoint;
  HText: Hwnd;
  F: array[0..255] of char;

begin
  TDialog.SetupWindow;
  if UseCtl3d and Win95 and Win95_3d then
    SetWindowLong(HWindow,gwl_Style,
       GetWindowLong(HWindow,gwl_Style) or DS_3DLOOK);

  HText:=GetItemHandle(dl_AskIfText);
{  SendDlgItemMsg(dl_AskIfText,wm_SetFont,0,1);}
  Spacing:=GetTextLength(GetItemHandle(dl_AskIfBtn1),'Ak');
  Padding:=GetTextLength(GetItemHandle(dl_AskIfBtn1),'Ak');
  MaxBtnTextLen:=0; BtnWidth:=0;

  for i:=1 to NButtons do
  with Cap[i] do
  begin
    len:=GetTextLength(GetItemHandle(id),name);
    if len>MaxBtnTextLen then MaxBtnTextLen:=len;
    GetWindowRect(GetItemHandle(id),Rect);
    H:=Rect.bottom-Rect.top;
    Point.X:=Rect.left; Point.Y:=Rect.top;
    ScreenToClient(HWindow,Point);
    Y:=Point.Y;
    if BtnWidth=0 then BtnWidth:=Rect.right-Rect.left;
  end;
  if BtnWidth<MaxBtnTextLen+Padding then
            BtnWidth:=MaxBtnTextLen+Padding;
  BtnsWidth:=BtnWidth*NButtons + Spacing*(NButtons-1);
  for i:=NButtons+1 to 4 do
  with Cap[i] do
  begin
    EnableWindow(GetItemHandle(id),false);
    ShowWindow(GetItemHandle(id),sw_hide);
  end;

  PromptLength:=GetTextLength(GetItemHandle(dl_AskIfText),Prompt)+4;
  GetWindowRect(HText,Rect);
  Point.X:=Rect.left; Point.Y:=Rect.top;
  ScreenToClient(HWindow,Point);
  TextY:=Point.Y; TextH:=Rect.bottom-Rect.top;

  GetWindowRect(HWindow,Rect);
  MidX:=(Rect.right+Rect.Left) div 2; Height:=Rect.bottom-Rect.top;
  Width:=BtnsWidth; if PromptLength>Width then Width:=PromptLength;
  Width:=Width+2*Spacing; RelMidX:=Width div 2;

  i:=MidX-(Width div 2); if i<1 then i:=1;
  MoveWindow(HWindow,i,Rect.top,Width,Height,true);
  GetClientRect(HWindow,Rect); RelMidX:=Rect.right div 2; 
  MoveWindow(HText,RelMidX-(PromptLength div 2),TextY,PromptLength,TextH,true);
  StrPCopy(F,Prompt); SetWindowText(HText,F);
  for i:=1 to NButtons do
  with Cap[i] do
  begin
    MoveWindow(GetItemHandle(id),
               RelMidX-(BtnsWidth div 2)+(I-1)*(BtnWidth+Spacing),
               Y,BtnWidth,H,true);
    StrPCopy(F,name); SetWindowText(GetItemHandle(id),F);
  end;
  if StrLen(Heading)>0 then SetWindowText(HWindow,Heading);
end;                    { TAskIfDlg.SetupWindow }

procedure TAskIfDlg.Btn1(var Msg: TMessage);
begin EndDlg(1); end;

procedure TAskIfDlg.Btn2(var Msg: TMessage);
begin EndDlg(2); end;

procedure TAskIfDlg.Btn3(var Msg: TMessage);
begin EndDlg(3); end;

procedure TAskIfDlg.Btn4(var Msg: TMessage);
begin EndDlg(4); end;


{----------------------------}

procedure TrapAbort;
begin end;

procedure Message(S: string);
var
  S2: array[0..255] of char;
begin
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  if IsWindow(MessageParent)=bool(0) then MessageParent:=0;
  StrPCopy(S2,S);
  MessageBox(MessageParent,S2,'message',mb_ok or mb_TaskModal);
end;

procedure DebugMessage(S: string);
var
  S2: array[0..255] of char;
begin
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  if IsWindow(MessageParent)=bool(0) then MessageParent:=0;
  StrPCopy(S2,S);
  if MessageBox(MessageParent,S2,'message',mb_okCancel or mb_TaskModal)=id_cancel
    then Halt(255);
end;

procedure ErrorMessage(S: string);
var
  S2: array[0..255] of char;
begin
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  StrPCopy(S2,S);
  MessageBox(MessageParent,S2,Nil,mb_ok or mb_IconExclamation or mb_TaskModal );
end;

procedure FatalError(S: String);
var
  S2: array[0..255] of char;
begin                       { FatalError }
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  StrPCopy(S2,S);
  MessageBox(MessageParent,S2,'Fatal error',mb_ok or mb_IconStop or mb_TaskModal);
  Halt(255);
end;                         { FatalError }

function CallMBox(id: word; var S: string; Prmpt: PChar; Mode: word): integer;
var
  F: Pchar;
  S2: Pstring;
begin
  GetMem(F,256); New(S2);
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  if LoadString(Hinstance,id,F,256)=0 then
    CallMBox:=MessageBox(MessageParent,'Unknown',Prmpt,Mode)
  else begin
    if S<>'' then
    begin
      S2^:=StrPas(F); StrRepl(S2^,'%s',S,1,1,255); StrPCopy(F,S2^);
      {                   Doesn't work for some reason
      StrPCopy(Arg,S);
      wvsprintf(F2,F,Arg);
      }
      CallMBox:=MessageBox(MessageParent,F,Prmpt,Mode);
    end else CallMBox:=MessageBox(MessageParent,F,Prmpt,Mode);
  end;
  Dispose(S2); FreeMem(F,256);
end;

procedure MessageRC(id: word; S: string);
begin
  CallMBox(id,S,'Message',mb_ok or mb_TaskModal);
end;

procedure ErrorMessageRC(id: word; S: string);
begin
  CallMBox(id,S,'Error',mb_ok or mb_TaskModal or mb_IconExclamation);
end;

procedure FatalErrorRC(id: word; S: string);
begin
  CallMBox(id,S,'Fatal error',mb_ok or mb_TaskModal or mb_IconStop);
  Halt(255);
end;

procedure UnImplemented;
begin
  MessageRC(str_UnImplemented,'');
end;

procedure FreeMemDeficit(s: string; MemoryFree: LongInt);
var
  m: longint;
  tmp: string[10];
begin
  m:=MaxAvail;
  if m<>MemoryFree then
    message(s+' - deficit of '+num2str(MemoryFree-m)+' bytes. ');
end;

function  AskIf(line,title: string; YesStr,NoStr: CapStrType) : boolean;
begin
  if title='' then title:='BibDB';
  AskIf:=Application^.ExecDialog(New(PAskIfDlg,
    Init(CurrentWindow,PChar(rc_AskIf4Dlg),line,title,YesStr,NoStr,'','')))=1;
end;

function AskIfRC(id: integer; S,title: string; YesStr,NoStr: CapStrType): boolean;
var
  F: Pchar;
  S2: Pstring;
begin
  GetMem(F,256); New(S2);
  if title='' then title:='BibDB';
  if IsWindow(MessageParent)=bool(0) then MessageParent:=HMainW;
  S2^:='';
  if LoadString(Hinstance,id,F,256)=0 then S:='???'
  else begin
    S2^:=StrPas(F); StrRepl(S2^,'%s',S,1,1,255);
  end;
  AskIfRC:=Application^.ExecDialog(New(PAskIfDlg,Init(
      CurrentWindow,PChar(rc_AskIf4Dlg),S2^,title,YesStr,NoStr,'','')))=1;
  Dispose(S2); Freemem(F,256);
end;

function  AskIf3(line: string; Str1,Str2,Str3: CapStrType) : integer;
begin
  AskIf3:=Application^.ExecDialog(New(PAskIfDlg,
    Init(CurrentWindow,PChar(rc_AskIf4Dlg),line,'BibDB',Str1,Str2,Str3,'')));
end;

function  AskIf4(line: string; Str1,Str2,Str3,Str4: CapStrType) : integer;
begin
  AskIf4:=Application^.ExecDialog(New(PAskIfDlg,
    Init(CurrentWindow,PChar(rc_AskIf4Dlg),line,'BiBDB',Str1,Str2,Str3,Str4)));
end;

function  YesNo(line: string) : boolean;  {Yes or No box }
var
  S2: Pchar;
begin
  GetMem(S2,256);
  if IsWindow(MessageParent)=Bool(0) then MessageParent:=HMainW;
  StrPCopy(S2,line);
  YesNo:=MessageBox(MessageParent,S2,'BibDB',
         mb_YesNo or mb_IconQuestion or mb_TaskModal)=IdYes;
  FreeMem(S2,256);
end;

function  YesNoRC(id: Word; s: string) : boolean;  {Yes or No box }
begin
  YesNoRC:=CallMBox(id,S,'BibDB',mb_YesNo or mb_TaskModal) = idYes;
end;


begin
  Suspended:=false; SuspendedPos:=-1; DispTimeOut:=0;
  TimeoutOn:=false; AbortFlag:=false;
  MessageParent:=0;
end.
